/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrollau;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import com.xero.models.payrollau.ManualTaxType;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;

public class TaxLine {
    StringUtil util = new StringUtil();
    @JsonProperty(value="PayslipTaxLineID")
    private UUID payslipTaxLineID;
    @JsonProperty(value="Amount")
    private Double amount;
    @JsonProperty(value="TaxTypeName")
    private String taxTypeName;
    @JsonProperty(value="Description")
    private String description;
    @JsonProperty(value="ManualTaxType")
    private ManualTaxType manualTaxType;
    @JsonProperty(value="LiabilityAccount")
    private String liabilityAccount;

    public TaxLine payslipTaxLineID(UUID payslipTaxLineID) {
        this.payslipTaxLineID = payslipTaxLineID;
        return this;
    }

    @ApiModelProperty(example="e0eb6747-7c17-4075-b804-989f8d4e5d39", value="Xero identifier for payslip tax line ID.")
    public UUID getPayslipTaxLineID() {
        return this.payslipTaxLineID;
    }

    public void setPayslipTaxLineID(UUID payslipTaxLineID) {
        this.payslipTaxLineID = payslipTaxLineID;
    }

    public TaxLine amount(Double amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(example="50.0", value="The tax line amount")
    public Double getAmount() {
        return this.amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public TaxLine taxTypeName(String taxTypeName) {
        this.taxTypeName = taxTypeName;
        return this;
    }

    @ApiModelProperty(example="Manual Adjustment", value="Name of the tax type.")
    public String getTaxTypeName() {
        return this.taxTypeName;
    }

    public void setTaxTypeName(String taxTypeName) {
        this.taxTypeName = taxTypeName;
    }

    public TaxLine description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Description of the tax line.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TaxLine manualTaxType(ManualTaxType manualTaxType) {
        this.manualTaxType = manualTaxType;
        return this;
    }

    @ApiModelProperty(value="")
    public ManualTaxType getManualTaxType() {
        return this.manualTaxType;
    }

    public void setManualTaxType(ManualTaxType manualTaxType) {
        this.manualTaxType = manualTaxType;
    }

    public TaxLine liabilityAccount(String liabilityAccount) {
        this.liabilityAccount = liabilityAccount;
        return this;
    }

    @ApiModelProperty(example="620", value="The tax line liability account code. For posted pay run you should be able to see liability account code")
    public String getLiabilityAccount() {
        return this.liabilityAccount;
    }

    public void setLiabilityAccount(String liabilityAccount) {
        this.liabilityAccount = liabilityAccount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaxLine taxLine = (TaxLine)o;
        return Objects.equals(this.payslipTaxLineID, taxLine.payslipTaxLineID) && Objects.equals(this.amount, taxLine.amount) && Objects.equals(this.taxTypeName, taxLine.taxTypeName) && Objects.equals(this.description, taxLine.description) && Objects.equals((Object)this.manualTaxType, (Object)taxLine.manualTaxType) && Objects.equals(this.liabilityAccount, taxLine.liabilityAccount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.payslipTaxLineID, this.amount, this.taxTypeName, this.description, this.manualTaxType, this.liabilityAccount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaxLine {\n");
        sb.append("    payslipTaxLineID: ").append(this.toIndentedString(this.payslipTaxLineID)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    taxTypeName: ").append(this.toIndentedString(this.taxTypeName)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    manualTaxType: ").append(this.toIndentedString((Object)this.manualTaxType)).append("\n");
        sb.append("    liabilityAccount: ").append(this.toIndentedString(this.liabilityAccount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

