/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrollau;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import com.xero.models.payrollau.TimesheetLine;
import com.xero.models.payrollau.TimesheetStatus;
import com.xero.models.payrollau.ValidationError;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.ZoneId;

public class Timesheet {
    StringUtil util = new StringUtil();
    @JsonProperty(value="EmployeeID")
    private UUID employeeID;
    @JsonProperty(value="StartDate")
    private String startDate;
    @JsonProperty(value="EndDate")
    private String endDate;
    @JsonProperty(value="Status")
    private TimesheetStatus status;
    @JsonProperty(value="Hours")
    private Double hours;
    @JsonProperty(value="TimesheetID")
    private UUID timesheetID;
    @JsonProperty(value="TimesheetLines")
    private List<TimesheetLine> timesheetLines = new ArrayList<TimesheetLine>();
    @JsonProperty(value="UpdatedDateUTC")
    private String updatedDateUTC;
    @JsonProperty(value="ValidationErrors")
    private List<ValidationError> validationErrors = new ArrayList<ValidationError>();

    public Timesheet employeeID(UUID employeeID) {
        this.employeeID = employeeID;
        return this;
    }

    @ApiModelProperty(example="72a0d0c2-0cf8-4f0b-ade1-33231f47b41b", required=true, value="The Xero identifier for an employee")
    public UUID getEmployeeID() {
        return this.employeeID;
    }

    public void setEmployeeID(UUID employeeID) {
        this.employeeID = employeeID;
    }

    public Timesheet startDate(String startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(example="/Date(322560000000+0000)/", required=true, value="Period start date (YYYY-MM-DD)")
    public String getStartDate() {
        return this.startDate;
    }

    public LocalDate getStartDateAsDate() {
        if (this.startDate != null) {
            try {
                return this.util.convertStringToDate(this.startDate);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public void setStartDate(LocalDate startDate) {
        Instant instant = startDate.atStartOfDay(ZoneId.of((String)"UTC").normalized()).toInstant();
        long timeInMillis = instant.toEpochMilli();
        this.startDate = "/Date(" + Long.toString(timeInMillis) + "+0000)/";
    }

    public Timesheet endDate(String endDate) {
        this.endDate = endDate;
        return this;
    }

    @ApiModelProperty(example="/Date(322560000000+0000)/", required=true, value="Period end date (YYYY-MM-DD)")
    public String getEndDate() {
        return this.endDate;
    }

    public LocalDate getEndDateAsDate() {
        if (this.endDate != null) {
            try {
                return this.util.convertStringToDate(this.endDate);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public void setEndDate(LocalDate endDate) {
        Instant instant = endDate.atStartOfDay(ZoneId.of((String)"UTC").normalized()).toInstant();
        long timeInMillis = instant.toEpochMilli();
        this.endDate = "/Date(" + Long.toString(timeInMillis) + "+0000)/";
    }

    public Timesheet status(TimesheetStatus status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="")
    public TimesheetStatus getStatus() {
        return this.status;
    }

    public void setStatus(TimesheetStatus status) {
        this.status = status;
    }

    public Timesheet hours(Double hours) {
        this.hours = hours;
        return this;
    }

    @ApiModelProperty(example="31.0", value="Timesheet total hours")
    public Double getHours() {
        return this.hours;
    }

    public void setHours(Double hours) {
        this.hours = hours;
    }

    public Timesheet timesheetID(UUID timesheetID) {
        this.timesheetID = timesheetID;
        return this;
    }

    @ApiModelProperty(example="049765fc-4506-48fb-bf88-3578dec0ec47", value="The Xero identifier for a Payroll Timesheet")
    public UUID getTimesheetID() {
        return this.timesheetID;
    }

    public void setTimesheetID(UUID timesheetID) {
        this.timesheetID = timesheetID;
    }

    public Timesheet timesheetLines(List<TimesheetLine> timesheetLines) {
        this.timesheetLines = timesheetLines;
        return this;
    }

    public Timesheet addTimesheetLinesItem(TimesheetLine timesheetLinesItem) {
        if (this.timesheetLines == null) {
            this.timesheetLines = new ArrayList<TimesheetLine>();
        }
        this.timesheetLines.add(timesheetLinesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<TimesheetLine> getTimesheetLines() {
        return this.timesheetLines;
    }

    public void setTimesheetLines(List<TimesheetLine> timesheetLines) {
        this.timesheetLines = timesheetLines;
    }

    @ApiModelProperty(example="/Date(1583967733054+0000)/", value="Last modified timestamp")
    public String getUpdatedDateUTC() {
        return this.updatedDateUTC;
    }

    public OffsetDateTime getUpdatedDateUTCAsDate() {
        if (this.updatedDateUTC != null) {
            try {
                return this.util.convertStringToOffsetDateTime(this.updatedDateUTC);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Timesheet validationErrors(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
        return this;
    }

    public Timesheet addValidationErrorsItem(ValidationError validationErrorsItem) {
        if (this.validationErrors == null) {
            this.validationErrors = new ArrayList<ValidationError>();
        }
        this.validationErrors.add(validationErrorsItem);
        return this;
    }

    @ApiModelProperty(value="Displays array of validation error messages from the API")
    public List<ValidationError> getValidationErrors() {
        return this.validationErrors;
    }

    public void setValidationErrors(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Timesheet timesheet = (Timesheet)o;
        return Objects.equals(this.employeeID, timesheet.employeeID) && Objects.equals(this.startDate, timesheet.startDate) && Objects.equals(this.endDate, timesheet.endDate) && Objects.equals((Object)this.status, (Object)timesheet.status) && Objects.equals(this.hours, timesheet.hours) && Objects.equals(this.timesheetID, timesheet.timesheetID) && Objects.equals(this.timesheetLines, timesheet.timesheetLines) && Objects.equals(this.updatedDateUTC, timesheet.updatedDateUTC) && Objects.equals(this.validationErrors, timesheet.validationErrors);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.employeeID, this.startDate, this.endDate, this.status, this.hours, this.timesheetID, this.timesheetLines, this.updatedDateUTC, this.validationErrors});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Timesheet {\n");
        sb.append("    employeeID: ").append(this.toIndentedString(this.employeeID)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    hours: ").append(this.toIndentedString(this.hours)).append("\n");
        sb.append("    timesheetID: ").append(this.toIndentedString(this.timesheetID)).append("\n");
        sb.append("    timesheetLines: ").append(this.toIndentedString(this.timesheetLines)).append("\n");
        sb.append("    updatedDateUTC: ").append(this.toIndentedString(this.updatedDateUTC)).append("\n");
        sb.append("    validationErrors: ").append(this.toIndentedString(this.validationErrors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

