/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrollnz;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;

public class Deduction {
    StringUtil util = new StringUtil();
    @JsonProperty(value="deductionId")
    private UUID deductionId;
    @JsonProperty(value="deductionName")
    private String deductionName;
    @JsonProperty(value="deductionCategory")
    private DeductionCategoryEnum deductionCategory;
    @JsonProperty(value="liabilityAccountId")
    private UUID liabilityAccountId;
    @JsonProperty(value="currentRecord")
    private Boolean currentRecord;
    @JsonProperty(value="standardAmount")
    private Double standardAmount;

    public Deduction deductionId(UUID deductionId) {
        this.deductionId = deductionId;
        return this;
    }

    @ApiModelProperty(value="The Xero identifier for Deduction")
    public UUID getDeductionId() {
        return this.deductionId;
    }

    public void setDeductionId(UUID deductionId) {
        this.deductionId = deductionId;
    }

    public Deduction deductionName(String deductionName) {
        this.deductionName = deductionName;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of the deduction")
    public String getDeductionName() {
        return this.deductionName;
    }

    public void setDeductionName(String deductionName) {
        this.deductionName = deductionName;
    }

    public Deduction deductionCategory(DeductionCategoryEnum deductionCategory) {
        this.deductionCategory = deductionCategory;
        return this;
    }

    @ApiModelProperty(required=true, value="Deduction Category type")
    public DeductionCategoryEnum getDeductionCategory() {
        return this.deductionCategory;
    }

    public void setDeductionCategory(DeductionCategoryEnum deductionCategory) {
        this.deductionCategory = deductionCategory;
    }

    public Deduction liabilityAccountId(UUID liabilityAccountId) {
        this.liabilityAccountId = liabilityAccountId;
        return this;
    }

    @ApiModelProperty(required=true, value="Xero identifier for Liability Account")
    public UUID getLiabilityAccountId() {
        return this.liabilityAccountId;
    }

    public void setLiabilityAccountId(UUID liabilityAccountId) {
        this.liabilityAccountId = liabilityAccountId;
    }

    public Deduction currentRecord(Boolean currentRecord) {
        this.currentRecord = currentRecord;
        return this;
    }

    @ApiModelProperty(value="Identifier of a record is active or not.")
    public Boolean getCurrentRecord() {
        return this.currentRecord;
    }

    public void setCurrentRecord(Boolean currentRecord) {
        this.currentRecord = currentRecord;
    }

    public Deduction standardAmount(Double standardAmount) {
        this.standardAmount = standardAmount;
        return this;
    }

    @ApiModelProperty(value="Standard amount of the deduction.")
    public Double getStandardAmount() {
        return this.standardAmount;
    }

    public void setStandardAmount(Double standardAmount) {
        this.standardAmount = standardAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Deduction deduction = (Deduction)o;
        return Objects.equals(this.deductionId, deduction.deductionId) && Objects.equals(this.deductionName, deduction.deductionName) && Objects.equals((Object)this.deductionCategory, (Object)deduction.deductionCategory) && Objects.equals(this.liabilityAccountId, deduction.liabilityAccountId) && Objects.equals(this.currentRecord, deduction.currentRecord) && Objects.equals(this.standardAmount, deduction.standardAmount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.deductionId, this.deductionName, this.deductionCategory, this.liabilityAccountId, this.currentRecord, this.standardAmount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Deduction {\n");
        sb.append("    deductionId: ").append(this.toIndentedString(this.deductionId)).append("\n");
        sb.append("    deductionName: ").append(this.toIndentedString(this.deductionName)).append("\n");
        sb.append("    deductionCategory: ").append(this.toIndentedString((Object)this.deductionCategory)).append("\n");
        sb.append("    liabilityAccountId: ").append(this.toIndentedString(this.liabilityAccountId)).append("\n");
        sb.append("    currentRecord: ").append(this.toIndentedString(this.currentRecord)).append("\n");
        sb.append("    standardAmount: ").append(this.toIndentedString(this.standardAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum DeductionCategoryEnum {
        PAYROLLGIVING("PayrollGiving"),
        KIWISAVERVOLUNTARYCONTRIBUTIONS("KiwiSaverVoluntaryContributions"),
        SUPERANNUATION("Superannuation"),
        NZOTHER("NzOther");

        private String value;

        private DeductionCategoryEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DeductionCategoryEnum fromValue(String value) {
            for (DeductionCategoryEnum b : DeductionCategoryEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

