/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrollnz;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;

public class EarningsRate {
    StringUtil util = new StringUtil();
    @JsonProperty(value="earningsRateID")
    private UUID earningsRateID;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="earningsType")
    private EarningsTypeEnum earningsType;
    @JsonProperty(value="rateType")
    private RateTypeEnum rateType;
    @JsonProperty(value="typeOfUnits")
    private String typeOfUnits;
    @JsonProperty(value="currentRecord")
    private Boolean currentRecord;
    @JsonProperty(value="expenseAccountID")
    private UUID expenseAccountID;
    @JsonProperty(value="ratePerUnit")
    private Double ratePerUnit;
    @JsonProperty(value="multipleOfOrdinaryEarningsRate")
    private Double multipleOfOrdinaryEarningsRate;
    @JsonProperty(value="fixedAmount")
    private Double fixedAmount;

    public EarningsRate earningsRateID(UUID earningsRateID) {
        this.earningsRateID = earningsRateID;
        return this;
    }

    @ApiModelProperty(value="Xero unique identifier for an earning rate")
    public UUID getEarningsRateID() {
        return this.earningsRateID;
    }

    public void setEarningsRateID(UUID earningsRateID) {
        this.earningsRateID = earningsRateID;
    }

    public EarningsRate name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of the earning rate")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public EarningsRate earningsType(EarningsTypeEnum earningsType) {
        this.earningsType = earningsType;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates how an employee will be paid when taking this type of earning")
    public EarningsTypeEnum getEarningsType() {
        return this.earningsType;
    }

    public void setEarningsType(EarningsTypeEnum earningsType) {
        this.earningsType = earningsType;
    }

    public EarningsRate rateType(RateTypeEnum rateType) {
        this.rateType = rateType;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates the type of the earning rate")
    public RateTypeEnum getRateType() {
        return this.rateType;
    }

    public void setRateType(RateTypeEnum rateType) {
        this.rateType = rateType;
    }

    public EarningsRate typeOfUnits(String typeOfUnits) {
        this.typeOfUnits = typeOfUnits;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of units used to record earnings")
    public String getTypeOfUnits() {
        return this.typeOfUnits;
    }

    public void setTypeOfUnits(String typeOfUnits) {
        this.typeOfUnits = typeOfUnits;
    }

    public EarningsRate currentRecord(Boolean currentRecord) {
        this.currentRecord = currentRecord;
        return this;
    }

    @ApiModelProperty(value="Indicates whether an earning type is active")
    public Boolean getCurrentRecord() {
        return this.currentRecord;
    }

    public void setCurrentRecord(Boolean currentRecord) {
        this.currentRecord = currentRecord;
    }

    public EarningsRate expenseAccountID(UUID expenseAccountID) {
        this.expenseAccountID = expenseAccountID;
        return this;
    }

    @ApiModelProperty(required=true, value="The account that will be used for the earnings rate")
    public UUID getExpenseAccountID() {
        return this.expenseAccountID;
    }

    public void setExpenseAccountID(UUID expenseAccountID) {
        this.expenseAccountID = expenseAccountID;
    }

    public EarningsRate ratePerUnit(Double ratePerUnit) {
        this.ratePerUnit = ratePerUnit;
        return this;
    }

    @ApiModelProperty(value="Default rate per unit (optional). Only applicable if RateType is RatePerUnit")
    public Double getRatePerUnit() {
        return this.ratePerUnit;
    }

    public void setRatePerUnit(Double ratePerUnit) {
        this.ratePerUnit = ratePerUnit;
    }

    public EarningsRate multipleOfOrdinaryEarningsRate(Double multipleOfOrdinaryEarningsRate) {
        this.multipleOfOrdinaryEarningsRate = multipleOfOrdinaryEarningsRate;
        return this;
    }

    @ApiModelProperty(value="This is the multiplier used to calculate the rate per unit, based on the employee\u2019s ordinary earnings rate. For example, for time and a half enter 1.5. Only applicable if RateType is MultipleOfOrdinaryEarningsRate")
    public Double getMultipleOfOrdinaryEarningsRate() {
        return this.multipleOfOrdinaryEarningsRate;
    }

    public void setMultipleOfOrdinaryEarningsRate(Double multipleOfOrdinaryEarningsRate) {
        this.multipleOfOrdinaryEarningsRate = multipleOfOrdinaryEarningsRate;
    }

    public EarningsRate fixedAmount(Double fixedAmount) {
        this.fixedAmount = fixedAmount;
        return this;
    }

    @ApiModelProperty(value="Optional Fixed Rate Amount. Applicable for FixedAmount Rate")
    public Double getFixedAmount() {
        return this.fixedAmount;
    }

    public void setFixedAmount(Double fixedAmount) {
        this.fixedAmount = fixedAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EarningsRate earningsRate = (EarningsRate)o;
        return Objects.equals(this.earningsRateID, earningsRate.earningsRateID) && Objects.equals(this.name, earningsRate.name) && Objects.equals((Object)this.earningsType, (Object)earningsRate.earningsType) && Objects.equals((Object)this.rateType, (Object)earningsRate.rateType) && Objects.equals(this.typeOfUnits, earningsRate.typeOfUnits) && Objects.equals(this.currentRecord, earningsRate.currentRecord) && Objects.equals(this.expenseAccountID, earningsRate.expenseAccountID) && Objects.equals(this.ratePerUnit, earningsRate.ratePerUnit) && Objects.equals(this.multipleOfOrdinaryEarningsRate, earningsRate.multipleOfOrdinaryEarningsRate) && Objects.equals(this.fixedAmount, earningsRate.fixedAmount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.earningsRateID, this.name, this.earningsType, this.rateType, this.typeOfUnits, this.currentRecord, this.expenseAccountID, this.ratePerUnit, this.multipleOfOrdinaryEarningsRate, this.fixedAmount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EarningsRate {\n");
        sb.append("    earningsRateID: ").append(this.toIndentedString(this.earningsRateID)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    earningsType: ").append(this.toIndentedString((Object)this.earningsType)).append("\n");
        sb.append("    rateType: ").append(this.toIndentedString((Object)this.rateType)).append("\n");
        sb.append("    typeOfUnits: ").append(this.toIndentedString(this.typeOfUnits)).append("\n");
        sb.append("    currentRecord: ").append(this.toIndentedString(this.currentRecord)).append("\n");
        sb.append("    expenseAccountID: ").append(this.toIndentedString(this.expenseAccountID)).append("\n");
        sb.append("    ratePerUnit: ").append(this.toIndentedString(this.ratePerUnit)).append("\n");
        sb.append("    multipleOfOrdinaryEarningsRate: ").append(this.toIndentedString(this.multipleOfOrdinaryEarningsRate)).append("\n");
        sb.append("    fixedAmount: ").append(this.toIndentedString(this.fixedAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum RateTypeEnum {
        RATEPERUNIT("RatePerUnit"),
        MULTIPLEOFORDINARYEARNINGSRATE("MultipleOfOrdinaryEarningsRate"),
        FIXEDAMOUNT("FixedAmount");

        private String value;

        private RateTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RateTypeEnum fromValue(String value) {
            for (RateTypeEnum b : RateTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum EarningsTypeEnum {
        ALLOWANCE("Allowance"),
        BACKPAY("Backpay"),
        BONUS("Bonus"),
        COMMISSION("Commission"),
        DISCRETIONARYPAYMENTS("DiscretionaryPayments"),
        HOLIDAYPAY("HolidayPay"),
        LUMPSUM("LumpSum"),
        OTHEREARNINGS("OtherEarnings"),
        OTHERGROSSEARNINGS("OtherGrossEarnings"),
        OVERTIMEEARNINGS("OvertimeEarnings"),
        REGULAREARNINGS("RegularEarnings"),
        SALARYSACRIFICEFORKIWISAVER("SalarySacrificeForKiwiSaver"),
        TIPS_DIRECT_("Tips(Direct)"),
        TIPS_NON_DIRECT_("Tips(Non-Direct)"),
        WITHHOLDINGINCOME("WithholdingIncome");

        private String value;

        private EarningsTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EarningsTypeEnum fromValue(String value) {
            for (EarningsTypeEnum b : EarningsTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

