/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrollnz;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import com.xero.models.payrollnz.LeavePeriod;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.LocalDate;
import org.threeten.bp.LocalDateTime;

public class EmployeeLeave {
    StringUtil util = new StringUtil();
    @JsonProperty(value="leaveID")
    private UUID leaveID;
    @JsonProperty(value="leaveTypeID")
    private UUID leaveTypeID;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="startDate")
    private LocalDate startDate;
    @JsonProperty(value="endDate")
    private LocalDate endDate;
    @JsonProperty(value="periods")
    private List<LeavePeriod> periods = new ArrayList<LeavePeriod>();
    @JsonProperty(value="updatedDateUTC")
    private LocalDateTime updatedDateUTC;

    public EmployeeLeave leaveID(UUID leaveID) {
        this.leaveID = leaveID;
        return this;
    }

    @ApiModelProperty(value="The Xero identifier for LeaveType")
    public UUID getLeaveID() {
        return this.leaveID;
    }

    public void setLeaveID(UUID leaveID) {
        this.leaveID = leaveID;
    }

    public EmployeeLeave leaveTypeID(UUID leaveTypeID) {
        this.leaveTypeID = leaveTypeID;
        return this;
    }

    @ApiModelProperty(required=true, value="The Xero identifier for LeaveType")
    public UUID getLeaveTypeID() {
        return this.leaveTypeID;
    }

    public void setLeaveTypeID(UUID leaveTypeID) {
        this.leaveTypeID = leaveTypeID;
    }

    public EmployeeLeave description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(required=true, value="The description of the leave  (max length = 50)")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public EmployeeLeave startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(required=true, value="Start date of the leave (YYYY-MM-DD)")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public EmployeeLeave endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @ApiModelProperty(required=true, value="End date of the leave (YYYY-MM-DD)")
    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public EmployeeLeave periods(List<LeavePeriod> periods) {
        this.periods = periods;
        return this;
    }

    public EmployeeLeave addPeriodsItem(LeavePeriod periodsItem) {
        if (this.periods == null) {
            this.periods = new ArrayList<LeavePeriod>();
        }
        this.periods.add(periodsItem);
        return this;
    }

    @ApiModelProperty(value="The leave period information. The StartDate, EndDate and NumberOfUnits needs to be specified when you do not want to calculate NumberOfUnits automatically. Using incorrect period StartDate and EndDate will result in automatic computation of the NumberOfUnits.")
    public List<LeavePeriod> getPeriods() {
        return this.periods;
    }

    public void setPeriods(List<LeavePeriod> periods) {
        this.periods = periods;
    }

    public EmployeeLeave updatedDateUTC(LocalDateTime updatedDateUTC) {
        this.updatedDateUTC = updatedDateUTC;
        return this;
    }

    @ApiModelProperty(value="UTC timestamp of last update to the leave type note")
    public LocalDateTime getUpdatedDateUTC() {
        return this.updatedDateUTC;
    }

    public void setUpdatedDateUTC(LocalDateTime updatedDateUTC) {
        this.updatedDateUTC = updatedDateUTC;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmployeeLeave employeeLeave = (EmployeeLeave)o;
        return Objects.equals(this.leaveID, employeeLeave.leaveID) && Objects.equals(this.leaveTypeID, employeeLeave.leaveTypeID) && Objects.equals(this.description, employeeLeave.description) && Objects.equals(this.startDate, employeeLeave.startDate) && Objects.equals(this.endDate, employeeLeave.endDate) && Objects.equals(this.periods, employeeLeave.periods) && Objects.equals(this.updatedDateUTC, employeeLeave.updatedDateUTC);
    }

    public int hashCode() {
        return Objects.hash(this.leaveID, this.leaveTypeID, this.description, this.startDate, this.endDate, this.periods, this.updatedDateUTC);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmployeeLeave {\n");
        sb.append("    leaveID: ").append(this.toIndentedString(this.leaveID)).append("\n");
        sb.append("    leaveTypeID: ").append(this.toIndentedString(this.leaveTypeID)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    periods: ").append(this.toIndentedString(this.periods)).append("\n");
        sb.append("    updatedDateUTC: ").append(this.toIndentedString(this.updatedDateUTC)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

