/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrollnz;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import com.xero.models.payrollnz.DeductionLine;
import com.xero.models.payrollnz.EarningsLine;
import com.xero.models.payrollnz.GrossEarningsHistory;
import com.xero.models.payrollnz.LeaveAccrualLine;
import com.xero.models.payrollnz.LeaveEarningsLine;
import com.xero.models.payrollnz.PaymentLine;
import com.xero.models.payrollnz.ReimbursementLine;
import com.xero.models.payrollnz.StatutoryDeductionLine;
import com.xero.models.payrollnz.SuperannuationLine;
import com.xero.models.payrollnz.TaxLine;
import com.xero.models.payrollnz.TaxSettings;
import com.xero.models.payrollnz.TimesheetEarningsLine;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.LocalDateTime;

public class PaySlip {
    StringUtil util = new StringUtil();
    @JsonProperty(value="paySlipID")
    private UUID paySlipID;
    @JsonProperty(value="employeeID")
    private UUID employeeID;
    @JsonProperty(value="payRunID")
    private UUID payRunID;
    @JsonProperty(value="lastEdited")
    private LocalDateTime lastEdited;
    @JsonProperty(value="firstName")
    private String firstName;
    @JsonProperty(value="lastName")
    private String lastName;
    @JsonProperty(value="totalEarnings")
    private Double totalEarnings;
    @JsonProperty(value="grossEarnings")
    private Double grossEarnings;
    @JsonProperty(value="totalPay")
    private Double totalPay;
    @JsonProperty(value="totalEmployerTaxes")
    private Double totalEmployerTaxes;
    @JsonProperty(value="totalEmployeeTaxes")
    private Double totalEmployeeTaxes;
    @JsonProperty(value="totalDeductions")
    private Double totalDeductions;
    @JsonProperty(value="totalReimbursements")
    private Double totalReimbursements;
    @JsonProperty(value="totalStatutoryDeductions")
    private Double totalStatutoryDeductions;
    @JsonProperty(value="totalSuperannuation")
    private Double totalSuperannuation;
    @JsonProperty(value="bacsHash")
    private String bacsHash;
    @JsonProperty(value="paymentMethod")
    private PaymentMethodEnum paymentMethod;
    @JsonProperty(value="earningsLines")
    private List<EarningsLine> earningsLines = new ArrayList<EarningsLine>();
    @JsonProperty(value="leaveEarningsLines")
    private List<LeaveEarningsLine> leaveEarningsLines = new ArrayList<LeaveEarningsLine>();
    @JsonProperty(value="timesheetEarningsLines")
    private List<TimesheetEarningsLine> timesheetEarningsLines = new ArrayList<TimesheetEarningsLine>();
    @JsonProperty(value="deductionLines")
    private List<DeductionLine> deductionLines = new ArrayList<DeductionLine>();
    @JsonProperty(value="reimbursementLines")
    private List<ReimbursementLine> reimbursementLines = new ArrayList<ReimbursementLine>();
    @JsonProperty(value="leaveAccrualLines")
    private List<LeaveAccrualLine> leaveAccrualLines = new ArrayList<LeaveAccrualLine>();
    @JsonProperty(value="superannuationLines")
    private List<SuperannuationLine> superannuationLines = new ArrayList<SuperannuationLine>();
    @JsonProperty(value="paymentLines")
    private List<PaymentLine> paymentLines = new ArrayList<PaymentLine>();
    @JsonProperty(value="employeeTaxLines")
    private List<TaxLine> employeeTaxLines = new ArrayList<TaxLine>();
    @JsonProperty(value="employerTaxLines")
    private List<TaxLine> employerTaxLines = new ArrayList<TaxLine>();
    @JsonProperty(value="statutoryDeductionLines")
    private List<StatutoryDeductionLine> statutoryDeductionLines = new ArrayList<StatutoryDeductionLine>();
    @JsonProperty(value="taxSettings")
    private TaxSettings taxSettings;
    @JsonProperty(value="grossEarningsHistory")
    private GrossEarningsHistory grossEarningsHistory;

    public PaySlip paySlipID(UUID paySlipID) {
        this.paySlipID = paySlipID;
        return this;
    }

    @ApiModelProperty(value="The Xero identifier for a PaySlip")
    public UUID getPaySlipID() {
        return this.paySlipID;
    }

    public void setPaySlipID(UUID paySlipID) {
        this.paySlipID = paySlipID;
    }

    public PaySlip employeeID(UUID employeeID) {
        this.employeeID = employeeID;
        return this;
    }

    @ApiModelProperty(value="The Xero identifier for payroll employee")
    public UUID getEmployeeID() {
        return this.employeeID;
    }

    public void setEmployeeID(UUID employeeID) {
        this.employeeID = employeeID;
    }

    public PaySlip payRunID(UUID payRunID) {
        this.payRunID = payRunID;
        return this;
    }

    @ApiModelProperty(value="The Xero identifier for the associated payrun")
    public UUID getPayRunID() {
        return this.payRunID;
    }

    public void setPayRunID(UUID payRunID) {
        this.payRunID = payRunID;
    }

    public PaySlip lastEdited(LocalDateTime lastEdited) {
        this.lastEdited = lastEdited;
        return this;
    }

    @ApiModelProperty(value="The date payslip was last updated")
    public LocalDateTime getLastEdited() {
        return this.lastEdited;
    }

    public void setLastEdited(LocalDateTime lastEdited) {
        this.lastEdited = lastEdited;
    }

    public PaySlip firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @ApiModelProperty(value="Employee first name")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public PaySlip lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @ApiModelProperty(value="Employee last name")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public PaySlip totalEarnings(Double totalEarnings) {
        this.totalEarnings = totalEarnings;
        return this;
    }

    @ApiModelProperty(value="Total earnings before any deductions. Same as gross earnings for NZ.")
    public Double getTotalEarnings() {
        return this.totalEarnings;
    }

    public void setTotalEarnings(Double totalEarnings) {
        this.totalEarnings = totalEarnings;
    }

    public PaySlip grossEarnings(Double grossEarnings) {
        this.grossEarnings = grossEarnings;
        return this;
    }

    @ApiModelProperty(value="Total earnings before any deductions. Same as total earnings for NZ.")
    public Double getGrossEarnings() {
        return this.grossEarnings;
    }

    public void setGrossEarnings(Double grossEarnings) {
        this.grossEarnings = grossEarnings;
    }

    public PaySlip totalPay(Double totalPay) {
        this.totalPay = totalPay;
        return this;
    }

    @ApiModelProperty(value="The employee net pay")
    public Double getTotalPay() {
        return this.totalPay;
    }

    public void setTotalPay(Double totalPay) {
        this.totalPay = totalPay;
    }

    public PaySlip totalEmployerTaxes(Double totalEmployerTaxes) {
        this.totalEmployerTaxes = totalEmployerTaxes;
        return this;
    }

    @ApiModelProperty(value="The employer's tax obligation")
    public Double getTotalEmployerTaxes() {
        return this.totalEmployerTaxes;
    }

    public void setTotalEmployerTaxes(Double totalEmployerTaxes) {
        this.totalEmployerTaxes = totalEmployerTaxes;
    }

    public PaySlip totalEmployeeTaxes(Double totalEmployeeTaxes) {
        this.totalEmployeeTaxes = totalEmployeeTaxes;
        return this;
    }

    @ApiModelProperty(value="The part of an employee's earnings that is deducted for tax purposes")
    public Double getTotalEmployeeTaxes() {
        return this.totalEmployeeTaxes;
    }

    public void setTotalEmployeeTaxes(Double totalEmployeeTaxes) {
        this.totalEmployeeTaxes = totalEmployeeTaxes;
    }

    public PaySlip totalDeductions(Double totalDeductions) {
        this.totalDeductions = totalDeductions;
        return this;
    }

    @ApiModelProperty(value="Total amount subtracted from an employee's earnings to reach total pay")
    public Double getTotalDeductions() {
        return this.totalDeductions;
    }

    public void setTotalDeductions(Double totalDeductions) {
        this.totalDeductions = totalDeductions;
    }

    public PaySlip totalReimbursements(Double totalReimbursements) {
        this.totalReimbursements = totalReimbursements;
        return this;
    }

    @ApiModelProperty(value="Total reimbursements are nontaxable payments to an employee used to repay out-of-pocket expenses when the person incurs those expenses through employment")
    public Double getTotalReimbursements() {
        return this.totalReimbursements;
    }

    public void setTotalReimbursements(Double totalReimbursements) {
        this.totalReimbursements = totalReimbursements;
    }

    public PaySlip totalStatutoryDeductions(Double totalStatutoryDeductions) {
        this.totalStatutoryDeductions = totalStatutoryDeductions;
        return this;
    }

    @ApiModelProperty(value="Total amounts required by law to subtract from the employee's earnings")
    public Double getTotalStatutoryDeductions() {
        return this.totalStatutoryDeductions;
    }

    public void setTotalStatutoryDeductions(Double totalStatutoryDeductions) {
        this.totalStatutoryDeductions = totalStatutoryDeductions;
    }

    public PaySlip totalSuperannuation(Double totalSuperannuation) {
        this.totalSuperannuation = totalSuperannuation;
        return this;
    }

    @ApiModelProperty(value="Benefits (also called fringe benefits, perquisites or perks) are various non-earnings compensations provided to employees in addition to their normal earnings or salaries")
    public Double getTotalSuperannuation() {
        return this.totalSuperannuation;
    }

    public void setTotalSuperannuation(Double totalSuperannuation) {
        this.totalSuperannuation = totalSuperannuation;
    }

    public PaySlip bacsHash(String bacsHash) {
        this.bacsHash = bacsHash;
        return this;
    }

    @ApiModelProperty(value="BACS Service User Number")
    public String getBacsHash() {
        return this.bacsHash;
    }

    public void setBacsHash(String bacsHash) {
        this.bacsHash = bacsHash;
    }

    public PaySlip paymentMethod(PaymentMethodEnum paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    @ApiModelProperty(value="The payment method code")
    public PaymentMethodEnum getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(PaymentMethodEnum paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public PaySlip earningsLines(List<EarningsLine> earningsLines) {
        this.earningsLines = earningsLines;
        return this;
    }

    public PaySlip addEarningsLinesItem(EarningsLine earningsLinesItem) {
        if (this.earningsLines == null) {
            this.earningsLines = new ArrayList<EarningsLine>();
        }
        this.earningsLines.add(earningsLinesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<EarningsLine> getEarningsLines() {
        return this.earningsLines;
    }

    public void setEarningsLines(List<EarningsLine> earningsLines) {
        this.earningsLines = earningsLines;
    }

    public PaySlip leaveEarningsLines(List<LeaveEarningsLine> leaveEarningsLines) {
        this.leaveEarningsLines = leaveEarningsLines;
        return this;
    }

    public PaySlip addLeaveEarningsLinesItem(LeaveEarningsLine leaveEarningsLinesItem) {
        if (this.leaveEarningsLines == null) {
            this.leaveEarningsLines = new ArrayList<LeaveEarningsLine>();
        }
        this.leaveEarningsLines.add(leaveEarningsLinesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<LeaveEarningsLine> getLeaveEarningsLines() {
        return this.leaveEarningsLines;
    }

    public void setLeaveEarningsLines(List<LeaveEarningsLine> leaveEarningsLines) {
        this.leaveEarningsLines = leaveEarningsLines;
    }

    public PaySlip timesheetEarningsLines(List<TimesheetEarningsLine> timesheetEarningsLines) {
        this.timesheetEarningsLines = timesheetEarningsLines;
        return this;
    }

    public PaySlip addTimesheetEarningsLinesItem(TimesheetEarningsLine timesheetEarningsLinesItem) {
        if (this.timesheetEarningsLines == null) {
            this.timesheetEarningsLines = new ArrayList<TimesheetEarningsLine>();
        }
        this.timesheetEarningsLines.add(timesheetEarningsLinesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<TimesheetEarningsLine> getTimesheetEarningsLines() {
        return this.timesheetEarningsLines;
    }

    public void setTimesheetEarningsLines(List<TimesheetEarningsLine> timesheetEarningsLines) {
        this.timesheetEarningsLines = timesheetEarningsLines;
    }

    public PaySlip deductionLines(List<DeductionLine> deductionLines) {
        this.deductionLines = deductionLines;
        return this;
    }

    public PaySlip addDeductionLinesItem(DeductionLine deductionLinesItem) {
        if (this.deductionLines == null) {
            this.deductionLines = new ArrayList<DeductionLine>();
        }
        this.deductionLines.add(deductionLinesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<DeductionLine> getDeductionLines() {
        return this.deductionLines;
    }

    public void setDeductionLines(List<DeductionLine> deductionLines) {
        this.deductionLines = deductionLines;
    }

    public PaySlip reimbursementLines(List<ReimbursementLine> reimbursementLines) {
        this.reimbursementLines = reimbursementLines;
        return this;
    }

    public PaySlip addReimbursementLinesItem(ReimbursementLine reimbursementLinesItem) {
        if (this.reimbursementLines == null) {
            this.reimbursementLines = new ArrayList<ReimbursementLine>();
        }
        this.reimbursementLines.add(reimbursementLinesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<ReimbursementLine> getReimbursementLines() {
        return this.reimbursementLines;
    }

    public void setReimbursementLines(List<ReimbursementLine> reimbursementLines) {
        this.reimbursementLines = reimbursementLines;
    }

    public PaySlip leaveAccrualLines(List<LeaveAccrualLine> leaveAccrualLines) {
        this.leaveAccrualLines = leaveAccrualLines;
        return this;
    }

    public PaySlip addLeaveAccrualLinesItem(LeaveAccrualLine leaveAccrualLinesItem) {
        if (this.leaveAccrualLines == null) {
            this.leaveAccrualLines = new ArrayList<LeaveAccrualLine>();
        }
        this.leaveAccrualLines.add(leaveAccrualLinesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<LeaveAccrualLine> getLeaveAccrualLines() {
        return this.leaveAccrualLines;
    }

    public void setLeaveAccrualLines(List<LeaveAccrualLine> leaveAccrualLines) {
        this.leaveAccrualLines = leaveAccrualLines;
    }

    public PaySlip superannuationLines(List<SuperannuationLine> superannuationLines) {
        this.superannuationLines = superannuationLines;
        return this;
    }

    public PaySlip addSuperannuationLinesItem(SuperannuationLine superannuationLinesItem) {
        if (this.superannuationLines == null) {
            this.superannuationLines = new ArrayList<SuperannuationLine>();
        }
        this.superannuationLines.add(superannuationLinesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<SuperannuationLine> getSuperannuationLines() {
        return this.superannuationLines;
    }

    public void setSuperannuationLines(List<SuperannuationLine> superannuationLines) {
        this.superannuationLines = superannuationLines;
    }

    public PaySlip paymentLines(List<PaymentLine> paymentLines) {
        this.paymentLines = paymentLines;
        return this;
    }

    public PaySlip addPaymentLinesItem(PaymentLine paymentLinesItem) {
        if (this.paymentLines == null) {
            this.paymentLines = new ArrayList<PaymentLine>();
        }
        this.paymentLines.add(paymentLinesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<PaymentLine> getPaymentLines() {
        return this.paymentLines;
    }

    public void setPaymentLines(List<PaymentLine> paymentLines) {
        this.paymentLines = paymentLines;
    }

    public PaySlip employeeTaxLines(List<TaxLine> employeeTaxLines) {
        this.employeeTaxLines = employeeTaxLines;
        return this;
    }

    public PaySlip addEmployeeTaxLinesItem(TaxLine employeeTaxLinesItem) {
        if (this.employeeTaxLines == null) {
            this.employeeTaxLines = new ArrayList<TaxLine>();
        }
        this.employeeTaxLines.add(employeeTaxLinesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<TaxLine> getEmployeeTaxLines() {
        return this.employeeTaxLines;
    }

    public void setEmployeeTaxLines(List<TaxLine> employeeTaxLines) {
        this.employeeTaxLines = employeeTaxLines;
    }

    public PaySlip employerTaxLines(List<TaxLine> employerTaxLines) {
        this.employerTaxLines = employerTaxLines;
        return this;
    }

    public PaySlip addEmployerTaxLinesItem(TaxLine employerTaxLinesItem) {
        if (this.employerTaxLines == null) {
            this.employerTaxLines = new ArrayList<TaxLine>();
        }
        this.employerTaxLines.add(employerTaxLinesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<TaxLine> getEmployerTaxLines() {
        return this.employerTaxLines;
    }

    public void setEmployerTaxLines(List<TaxLine> employerTaxLines) {
        this.employerTaxLines = employerTaxLines;
    }

    public PaySlip statutoryDeductionLines(List<StatutoryDeductionLine> statutoryDeductionLines) {
        this.statutoryDeductionLines = statutoryDeductionLines;
        return this;
    }

    public PaySlip addStatutoryDeductionLinesItem(StatutoryDeductionLine statutoryDeductionLinesItem) {
        if (this.statutoryDeductionLines == null) {
            this.statutoryDeductionLines = new ArrayList<StatutoryDeductionLine>();
        }
        this.statutoryDeductionLines.add(statutoryDeductionLinesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<StatutoryDeductionLine> getStatutoryDeductionLines() {
        return this.statutoryDeductionLines;
    }

    public void setStatutoryDeductionLines(List<StatutoryDeductionLine> statutoryDeductionLines) {
        this.statutoryDeductionLines = statutoryDeductionLines;
    }

    public PaySlip taxSettings(TaxSettings taxSettings) {
        this.taxSettings = taxSettings;
        return this;
    }

    @ApiModelProperty(value="")
    public TaxSettings getTaxSettings() {
        return this.taxSettings;
    }

    public void setTaxSettings(TaxSettings taxSettings) {
        this.taxSettings = taxSettings;
    }

    public PaySlip grossEarningsHistory(GrossEarningsHistory grossEarningsHistory) {
        this.grossEarningsHistory = grossEarningsHistory;
        return this;
    }

    @ApiModelProperty(value="")
    public GrossEarningsHistory getGrossEarningsHistory() {
        return this.grossEarningsHistory;
    }

    public void setGrossEarningsHistory(GrossEarningsHistory grossEarningsHistory) {
        this.grossEarningsHistory = grossEarningsHistory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaySlip paySlip = (PaySlip)o;
        return Objects.equals(this.paySlipID, paySlip.paySlipID) && Objects.equals(this.employeeID, paySlip.employeeID) && Objects.equals(this.payRunID, paySlip.payRunID) && Objects.equals(this.lastEdited, paySlip.lastEdited) && Objects.equals(this.firstName, paySlip.firstName) && Objects.equals(this.lastName, paySlip.lastName) && Objects.equals(this.totalEarnings, paySlip.totalEarnings) && Objects.equals(this.grossEarnings, paySlip.grossEarnings) && Objects.equals(this.totalPay, paySlip.totalPay) && Objects.equals(this.totalEmployerTaxes, paySlip.totalEmployerTaxes) && Objects.equals(this.totalEmployeeTaxes, paySlip.totalEmployeeTaxes) && Objects.equals(this.totalDeductions, paySlip.totalDeductions) && Objects.equals(this.totalReimbursements, paySlip.totalReimbursements) && Objects.equals(this.totalStatutoryDeductions, paySlip.totalStatutoryDeductions) && Objects.equals(this.totalSuperannuation, paySlip.totalSuperannuation) && Objects.equals(this.bacsHash, paySlip.bacsHash) && Objects.equals((Object)this.paymentMethod, (Object)paySlip.paymentMethod) && Objects.equals(this.earningsLines, paySlip.earningsLines) && Objects.equals(this.leaveEarningsLines, paySlip.leaveEarningsLines) && Objects.equals(this.timesheetEarningsLines, paySlip.timesheetEarningsLines) && Objects.equals(this.deductionLines, paySlip.deductionLines) && Objects.equals(this.reimbursementLines, paySlip.reimbursementLines) && Objects.equals(this.leaveAccrualLines, paySlip.leaveAccrualLines) && Objects.equals(this.superannuationLines, paySlip.superannuationLines) && Objects.equals(this.paymentLines, paySlip.paymentLines) && Objects.equals(this.employeeTaxLines, paySlip.employeeTaxLines) && Objects.equals(this.employerTaxLines, paySlip.employerTaxLines) && Objects.equals(this.statutoryDeductionLines, paySlip.statutoryDeductionLines) && Objects.equals(this.taxSettings, paySlip.taxSettings) && Objects.equals(this.grossEarningsHistory, paySlip.grossEarningsHistory);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.paySlipID, this.employeeID, this.payRunID, this.lastEdited, this.firstName, this.lastName, this.totalEarnings, this.grossEarnings, this.totalPay, this.totalEmployerTaxes, this.totalEmployeeTaxes, this.totalDeductions, this.totalReimbursements, this.totalStatutoryDeductions, this.totalSuperannuation, this.bacsHash, this.paymentMethod, this.earningsLines, this.leaveEarningsLines, this.timesheetEarningsLines, this.deductionLines, this.reimbursementLines, this.leaveAccrualLines, this.superannuationLines, this.paymentLines, this.employeeTaxLines, this.employerTaxLines, this.statutoryDeductionLines, this.taxSettings, this.grossEarningsHistory});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaySlip {\n");
        sb.append("    paySlipID: ").append(this.toIndentedString(this.paySlipID)).append("\n");
        sb.append("    employeeID: ").append(this.toIndentedString(this.employeeID)).append("\n");
        sb.append("    payRunID: ").append(this.toIndentedString(this.payRunID)).append("\n");
        sb.append("    lastEdited: ").append(this.toIndentedString(this.lastEdited)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    totalEarnings: ").append(this.toIndentedString(this.totalEarnings)).append("\n");
        sb.append("    grossEarnings: ").append(this.toIndentedString(this.grossEarnings)).append("\n");
        sb.append("    totalPay: ").append(this.toIndentedString(this.totalPay)).append("\n");
        sb.append("    totalEmployerTaxes: ").append(this.toIndentedString(this.totalEmployerTaxes)).append("\n");
        sb.append("    totalEmployeeTaxes: ").append(this.toIndentedString(this.totalEmployeeTaxes)).append("\n");
        sb.append("    totalDeductions: ").append(this.toIndentedString(this.totalDeductions)).append("\n");
        sb.append("    totalReimbursements: ").append(this.toIndentedString(this.totalReimbursements)).append("\n");
        sb.append("    totalStatutoryDeductions: ").append(this.toIndentedString(this.totalStatutoryDeductions)).append("\n");
        sb.append("    totalSuperannuation: ").append(this.toIndentedString(this.totalSuperannuation)).append("\n");
        sb.append("    bacsHash: ").append(this.toIndentedString(this.bacsHash)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString((Object)this.paymentMethod)).append("\n");
        sb.append("    earningsLines: ").append(this.toIndentedString(this.earningsLines)).append("\n");
        sb.append("    leaveEarningsLines: ").append(this.toIndentedString(this.leaveEarningsLines)).append("\n");
        sb.append("    timesheetEarningsLines: ").append(this.toIndentedString(this.timesheetEarningsLines)).append("\n");
        sb.append("    deductionLines: ").append(this.toIndentedString(this.deductionLines)).append("\n");
        sb.append("    reimbursementLines: ").append(this.toIndentedString(this.reimbursementLines)).append("\n");
        sb.append("    leaveAccrualLines: ").append(this.toIndentedString(this.leaveAccrualLines)).append("\n");
        sb.append("    superannuationLines: ").append(this.toIndentedString(this.superannuationLines)).append("\n");
        sb.append("    paymentLines: ").append(this.toIndentedString(this.paymentLines)).append("\n");
        sb.append("    employeeTaxLines: ").append(this.toIndentedString(this.employeeTaxLines)).append("\n");
        sb.append("    employerTaxLines: ").append(this.toIndentedString(this.employerTaxLines)).append("\n");
        sb.append("    statutoryDeductionLines: ").append(this.toIndentedString(this.statutoryDeductionLines)).append("\n");
        sb.append("    taxSettings: ").append(this.toIndentedString(this.taxSettings)).append("\n");
        sb.append("    grossEarningsHistory: ").append(this.toIndentedString(this.grossEarningsHistory)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PaymentMethodEnum {
        CHEQUE("Cheque"),
        ELECTRONICALLY("Electronically"),
        MANUAL("Manual");

        private String value;

        private PaymentMethodEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PaymentMethodEnum fromValue(String value) {
            for (PaymentMethodEnum b : PaymentMethodEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

