/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrolluk;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;

public class Benefit {
    StringUtil util = new StringUtil();
    @JsonProperty(value="id")
    private UUID id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="category")
    private CategoryEnum category;
    @JsonProperty(value="liabilityAccountId")
    private UUID liabilityAccountId;
    @JsonProperty(value="expenseAccountId")
    private UUID expenseAccountId;
    @JsonProperty(value="standardAmount")
    private Double standardAmount;
    @JsonProperty(value="percentage")
    private Double percentage;
    @JsonProperty(value="calculationType")
    private CalculationTypeEnum calculationType;
    @JsonProperty(value="currentRecord")
    private Boolean currentRecord;
    @JsonProperty(value="subjectToNIC")
    private Boolean subjectToNIC;
    @JsonProperty(value="subjectToPension")
    private Boolean subjectToPension;
    @JsonProperty(value="subjectToTax")
    private Boolean subjectToTax;
    @JsonProperty(value="isCalculatingOnQualifyingEarnings")
    private Boolean isCalculatingOnQualifyingEarnings;
    @JsonProperty(value="showBalanceToEmployee")
    private Boolean showBalanceToEmployee;

    public Benefit id(UUID id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="unique identifier in Xero")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public Benefit name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of the employer pension")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Benefit category(CategoryEnum category) {
        this.category = category;
        return this;
    }

    @ApiModelProperty(required=true, value="Category type of the employer pension")
    public CategoryEnum getCategory() {
        return this.category;
    }

    public void setCategory(CategoryEnum category) {
        this.category = category;
    }

    public Benefit liabilityAccountId(UUID liabilityAccountId) {
        this.liabilityAccountId = liabilityAccountId;
        return this;
    }

    @ApiModelProperty(required=true, value="Xero identifier for Liability Account")
    public UUID getLiabilityAccountId() {
        return this.liabilityAccountId;
    }

    public void setLiabilityAccountId(UUID liabilityAccountId) {
        this.liabilityAccountId = liabilityAccountId;
    }

    public Benefit expenseAccountId(UUID expenseAccountId) {
        this.expenseAccountId = expenseAccountId;
        return this;
    }

    @ApiModelProperty(required=true, value="Xero identifier for Expense Account")
    public UUID getExpenseAccountId() {
        return this.expenseAccountId;
    }

    public void setExpenseAccountId(UUID expenseAccountId) {
        this.expenseAccountId = expenseAccountId;
    }

    public Benefit standardAmount(Double standardAmount) {
        this.standardAmount = standardAmount;
        return this;
    }

    @ApiModelProperty(value="Standard amount of the employer pension")
    public Double getStandardAmount() {
        return this.standardAmount;
    }

    public void setStandardAmount(Double standardAmount) {
        this.standardAmount = standardAmount;
    }

    public Benefit percentage(Double percentage) {
        this.percentage = percentage;
        return this;
    }

    @ApiModelProperty(required=true, value="Percentage of gross of the employer pension")
    public Double getPercentage() {
        return this.percentage;
    }

    public void setPercentage(Double percentage) {
        this.percentage = percentage;
    }

    public Benefit calculationType(CalculationTypeEnum calculationType) {
        this.calculationType = calculationType;
        return this;
    }

    @ApiModelProperty(required=true, value="Calculation Type of the employer pension (FixedAmount or PercentageOfGross).")
    public CalculationTypeEnum getCalculationType() {
        return this.calculationType;
    }

    public void setCalculationType(CalculationTypeEnum calculationType) {
        this.calculationType = calculationType;
    }

    public Benefit currentRecord(Boolean currentRecord) {
        this.currentRecord = currentRecord;
        return this;
    }

    @ApiModelProperty(value="Identifier of a record is active or not.")
    public Boolean getCurrentRecord() {
        return this.currentRecord;
    }

    public void setCurrentRecord(Boolean currentRecord) {
        this.currentRecord = currentRecord;
    }

    public Benefit subjectToNIC(Boolean subjectToNIC) {
        this.subjectToNIC = subjectToNIC;
        return this;
    }

    @ApiModelProperty(value="Identifier of subject To NIC")
    public Boolean getSubjectToNIC() {
        return this.subjectToNIC;
    }

    public void setSubjectToNIC(Boolean subjectToNIC) {
        this.subjectToNIC = subjectToNIC;
    }

    public Benefit subjectToPension(Boolean subjectToPension) {
        this.subjectToPension = subjectToPension;
        return this;
    }

    @ApiModelProperty(value="Identifier of subject To pension")
    public Boolean getSubjectToPension() {
        return this.subjectToPension;
    }

    public void setSubjectToPension(Boolean subjectToPension) {
        this.subjectToPension = subjectToPension;
    }

    public Benefit subjectToTax(Boolean subjectToTax) {
        this.subjectToTax = subjectToTax;
        return this;
    }

    @ApiModelProperty(value="Identifier of subject To Tax")
    public Boolean getSubjectToTax() {
        return this.subjectToTax;
    }

    public void setSubjectToTax(Boolean subjectToTax) {
        this.subjectToTax = subjectToTax;
    }

    public Benefit isCalculatingOnQualifyingEarnings(Boolean isCalculatingOnQualifyingEarnings) {
        this.isCalculatingOnQualifyingEarnings = isCalculatingOnQualifyingEarnings;
        return this;
    }

    @ApiModelProperty(value="Identifier of calculating on qualifying earnings")
    public Boolean getIsCalculatingOnQualifyingEarnings() {
        return this.isCalculatingOnQualifyingEarnings;
    }

    public void setIsCalculatingOnQualifyingEarnings(Boolean isCalculatingOnQualifyingEarnings) {
        this.isCalculatingOnQualifyingEarnings = isCalculatingOnQualifyingEarnings;
    }

    public Benefit showBalanceToEmployee(Boolean showBalanceToEmployee) {
        this.showBalanceToEmployee = showBalanceToEmployee;
        return this;
    }

    @ApiModelProperty(value="display the balance to employee")
    public Boolean getShowBalanceToEmployee() {
        return this.showBalanceToEmployee;
    }

    public void setShowBalanceToEmployee(Boolean showBalanceToEmployee) {
        this.showBalanceToEmployee = showBalanceToEmployee;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Benefit benefit = (Benefit)o;
        return Objects.equals(this.id, benefit.id) && Objects.equals(this.name, benefit.name) && Objects.equals((Object)this.category, (Object)benefit.category) && Objects.equals(this.liabilityAccountId, benefit.liabilityAccountId) && Objects.equals(this.expenseAccountId, benefit.expenseAccountId) && Objects.equals(this.standardAmount, benefit.standardAmount) && Objects.equals(this.percentage, benefit.percentage) && Objects.equals((Object)this.calculationType, (Object)benefit.calculationType) && Objects.equals(this.currentRecord, benefit.currentRecord) && Objects.equals(this.subjectToNIC, benefit.subjectToNIC) && Objects.equals(this.subjectToPension, benefit.subjectToPension) && Objects.equals(this.subjectToTax, benefit.subjectToTax) && Objects.equals(this.isCalculatingOnQualifyingEarnings, benefit.isCalculatingOnQualifyingEarnings) && Objects.equals(this.showBalanceToEmployee, benefit.showBalanceToEmployee);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.category, this.liabilityAccountId, this.expenseAccountId, this.standardAmount, this.percentage, this.calculationType, this.currentRecord, this.subjectToNIC, this.subjectToPension, this.subjectToTax, this.isCalculatingOnQualifyingEarnings, this.showBalanceToEmployee});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Benefit {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    liabilityAccountId: ").append(this.toIndentedString(this.liabilityAccountId)).append("\n");
        sb.append("    expenseAccountId: ").append(this.toIndentedString(this.expenseAccountId)).append("\n");
        sb.append("    standardAmount: ").append(this.toIndentedString(this.standardAmount)).append("\n");
        sb.append("    percentage: ").append(this.toIndentedString(this.percentage)).append("\n");
        sb.append("    calculationType: ").append(this.toIndentedString((Object)this.calculationType)).append("\n");
        sb.append("    currentRecord: ").append(this.toIndentedString(this.currentRecord)).append("\n");
        sb.append("    subjectToNIC: ").append(this.toIndentedString(this.subjectToNIC)).append("\n");
        sb.append("    subjectToPension: ").append(this.toIndentedString(this.subjectToPension)).append("\n");
        sb.append("    subjectToTax: ").append(this.toIndentedString(this.subjectToTax)).append("\n");
        sb.append("    isCalculatingOnQualifyingEarnings: ").append(this.toIndentedString(this.isCalculatingOnQualifyingEarnings)).append("\n");
        sb.append("    showBalanceToEmployee: ").append(this.toIndentedString(this.showBalanceToEmployee)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CalculationTypeEnum {
        FIXEDAMOUNT("FixedAmount"),
        PERCENTAGEOFGROSS("PercentageOfGross");

        private String value;

        private CalculationTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CalculationTypeEnum fromValue(String value) {
            for (CalculationTypeEnum b : CalculationTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum CategoryEnum {
        STAKEHOLDERPENSION("StakeholderPension"),
        OTHER("Other");

        private String value;

        private CategoryEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CategoryEnum fromValue(String value) {
            for (CategoryEnum b : CategoryEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

