/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrolluk;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;

public class Deduction {
    StringUtil util = new StringUtil();
    @JsonProperty(value="deductionId")
    private UUID deductionId;
    @JsonProperty(value="deductionName")
    private String deductionName;
    @JsonProperty(value="deductionCategory")
    private DeductionCategoryEnum deductionCategory;
    @JsonProperty(value="liabilityAccountId")
    private UUID liabilityAccountId;
    @JsonProperty(value="currentRecord")
    private Boolean currentRecord;
    @JsonProperty(value="standardAmount")
    private Double standardAmount;
    @JsonProperty(value="reducesSuperLiability")
    private Boolean reducesSuperLiability;
    @JsonProperty(value="reducesTaxLiability")
    private Boolean reducesTaxLiability;
    @JsonProperty(value="calculationType")
    private CalculationTypeEnum calculationType;
    @JsonProperty(value="percentage")
    private Double percentage;
    @JsonProperty(value="subjectToNIC")
    private Boolean subjectToNIC;
    @JsonProperty(value="subjectToTax")
    private Boolean subjectToTax;
    @JsonProperty(value="isReducedByBasicRate")
    private Boolean isReducedByBasicRate;
    @JsonProperty(value="applyToPensionCalculations")
    private Boolean applyToPensionCalculations;
    @JsonProperty(value="isCalculatingOnQualifyingEarnings")
    private Boolean isCalculatingOnQualifyingEarnings;
    @JsonProperty(value="isPension")
    private Boolean isPension;

    public Deduction deductionId(UUID deductionId) {
        this.deductionId = deductionId;
        return this;
    }

    @ApiModelProperty(value="The Xero identifier for Deduction")
    public UUID getDeductionId() {
        return this.deductionId;
    }

    public void setDeductionId(UUID deductionId) {
        this.deductionId = deductionId;
    }

    public Deduction deductionName(String deductionName) {
        this.deductionName = deductionName;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of the deduction")
    public String getDeductionName() {
        return this.deductionName;
    }

    public void setDeductionName(String deductionName) {
        this.deductionName = deductionName;
    }

    public Deduction deductionCategory(DeductionCategoryEnum deductionCategory) {
        this.deductionCategory = deductionCategory;
        return this;
    }

    @ApiModelProperty(value="Deduction Category type")
    public DeductionCategoryEnum getDeductionCategory() {
        return this.deductionCategory;
    }

    public void setDeductionCategory(DeductionCategoryEnum deductionCategory) {
        this.deductionCategory = deductionCategory;
    }

    public Deduction liabilityAccountId(UUID liabilityAccountId) {
        this.liabilityAccountId = liabilityAccountId;
        return this;
    }

    @ApiModelProperty(required=true, value="Xero identifier for Liability Account")
    public UUID getLiabilityAccountId() {
        return this.liabilityAccountId;
    }

    public void setLiabilityAccountId(UUID liabilityAccountId) {
        this.liabilityAccountId = liabilityAccountId;
    }

    public Deduction currentRecord(Boolean currentRecord) {
        this.currentRecord = currentRecord;
        return this;
    }

    @ApiModelProperty(value="Identifier of a record is active or not.")
    public Boolean getCurrentRecord() {
        return this.currentRecord;
    }

    public void setCurrentRecord(Boolean currentRecord) {
        this.currentRecord = currentRecord;
    }

    public Deduction standardAmount(Double standardAmount) {
        this.standardAmount = standardAmount;
        return this;
    }

    @ApiModelProperty(value="Standard amount of the deduction")
    public Double getStandardAmount() {
        return this.standardAmount;
    }

    public void setStandardAmount(Double standardAmount) {
        this.standardAmount = standardAmount;
    }

    public Deduction reducesSuperLiability(Boolean reducesSuperLiability) {
        this.reducesSuperLiability = reducesSuperLiability;
        return this;
    }

    @ApiModelProperty(value="Identifier of reduces super liability")
    public Boolean getReducesSuperLiability() {
        return this.reducesSuperLiability;
    }

    public void setReducesSuperLiability(Boolean reducesSuperLiability) {
        this.reducesSuperLiability = reducesSuperLiability;
    }

    public Deduction reducesTaxLiability(Boolean reducesTaxLiability) {
        this.reducesTaxLiability = reducesTaxLiability;
        return this;
    }

    @ApiModelProperty(value="Identifier of reduces tax liability")
    public Boolean getReducesTaxLiability() {
        return this.reducesTaxLiability;
    }

    public void setReducesTaxLiability(Boolean reducesTaxLiability) {
        this.reducesTaxLiability = reducesTaxLiability;
    }

    public Deduction calculationType(CalculationTypeEnum calculationType) {
        this.calculationType = calculationType;
        return this;
    }

    @ApiModelProperty(value="determine the calculation type whether fixed amount or percentage of gross")
    public CalculationTypeEnum getCalculationType() {
        return this.calculationType;
    }

    public void setCalculationType(CalculationTypeEnum calculationType) {
        this.calculationType = calculationType;
    }

    public Deduction percentage(Double percentage) {
        this.percentage = percentage;
        return this;
    }

    @ApiModelProperty(value="Percentage of gross")
    public Double getPercentage() {
        return this.percentage;
    }

    public void setPercentage(Double percentage) {
        this.percentage = percentage;
    }

    public Deduction subjectToNIC(Boolean subjectToNIC) {
        this.subjectToNIC = subjectToNIC;
        return this;
    }

    @ApiModelProperty(value="Identifier of subject To NIC")
    public Boolean getSubjectToNIC() {
        return this.subjectToNIC;
    }

    public void setSubjectToNIC(Boolean subjectToNIC) {
        this.subjectToNIC = subjectToNIC;
    }

    public Deduction subjectToTax(Boolean subjectToTax) {
        this.subjectToTax = subjectToTax;
        return this;
    }

    @ApiModelProperty(value="Identifier of subject To Tax")
    public Boolean getSubjectToTax() {
        return this.subjectToTax;
    }

    public void setSubjectToTax(Boolean subjectToTax) {
        this.subjectToTax = subjectToTax;
    }

    public Deduction isReducedByBasicRate(Boolean isReducedByBasicRate) {
        this.isReducedByBasicRate = isReducedByBasicRate;
        return this;
    }

    @ApiModelProperty(value="Identifier of reduced by basic rate applicable or not")
    public Boolean getIsReducedByBasicRate() {
        return this.isReducedByBasicRate;
    }

    public void setIsReducedByBasicRate(Boolean isReducedByBasicRate) {
        this.isReducedByBasicRate = isReducedByBasicRate;
    }

    public Deduction applyToPensionCalculations(Boolean applyToPensionCalculations) {
        this.applyToPensionCalculations = applyToPensionCalculations;
        return this;
    }

    @ApiModelProperty(value="Identifier for apply to pension calculations")
    public Boolean getApplyToPensionCalculations() {
        return this.applyToPensionCalculations;
    }

    public void setApplyToPensionCalculations(Boolean applyToPensionCalculations) {
        this.applyToPensionCalculations = applyToPensionCalculations;
    }

    public Deduction isCalculatingOnQualifyingEarnings(Boolean isCalculatingOnQualifyingEarnings) {
        this.isCalculatingOnQualifyingEarnings = isCalculatingOnQualifyingEarnings;
        return this;
    }

    @ApiModelProperty(value="Identifier of calculating on qualifying earnings")
    public Boolean getIsCalculatingOnQualifyingEarnings() {
        return this.isCalculatingOnQualifyingEarnings;
    }

    public void setIsCalculatingOnQualifyingEarnings(Boolean isCalculatingOnQualifyingEarnings) {
        this.isCalculatingOnQualifyingEarnings = isCalculatingOnQualifyingEarnings;
    }

    public Deduction isPension(Boolean isPension) {
        this.isPension = isPension;
        return this;
    }

    @ApiModelProperty(value="Identifier of applicable for pension or not")
    public Boolean getIsPension() {
        return this.isPension;
    }

    public void setIsPension(Boolean isPension) {
        this.isPension = isPension;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Deduction deduction = (Deduction)o;
        return Objects.equals(this.deductionId, deduction.deductionId) && Objects.equals(this.deductionName, deduction.deductionName) && Objects.equals((Object)this.deductionCategory, (Object)deduction.deductionCategory) && Objects.equals(this.liabilityAccountId, deduction.liabilityAccountId) && Objects.equals(this.currentRecord, deduction.currentRecord) && Objects.equals(this.standardAmount, deduction.standardAmount) && Objects.equals(this.reducesSuperLiability, deduction.reducesSuperLiability) && Objects.equals(this.reducesTaxLiability, deduction.reducesTaxLiability) && Objects.equals((Object)this.calculationType, (Object)deduction.calculationType) && Objects.equals(this.percentage, deduction.percentage) && Objects.equals(this.subjectToNIC, deduction.subjectToNIC) && Objects.equals(this.subjectToTax, deduction.subjectToTax) && Objects.equals(this.isReducedByBasicRate, deduction.isReducedByBasicRate) && Objects.equals(this.applyToPensionCalculations, deduction.applyToPensionCalculations) && Objects.equals(this.isCalculatingOnQualifyingEarnings, deduction.isCalculatingOnQualifyingEarnings) && Objects.equals(this.isPension, deduction.isPension);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.deductionId, this.deductionName, this.deductionCategory, this.liabilityAccountId, this.currentRecord, this.standardAmount, this.reducesSuperLiability, this.reducesTaxLiability, this.calculationType, this.percentage, this.subjectToNIC, this.subjectToTax, this.isReducedByBasicRate, this.applyToPensionCalculations, this.isCalculatingOnQualifyingEarnings, this.isPension});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Deduction {\n");
        sb.append("    deductionId: ").append(this.toIndentedString(this.deductionId)).append("\n");
        sb.append("    deductionName: ").append(this.toIndentedString(this.deductionName)).append("\n");
        sb.append("    deductionCategory: ").append(this.toIndentedString((Object)this.deductionCategory)).append("\n");
        sb.append("    liabilityAccountId: ").append(this.toIndentedString(this.liabilityAccountId)).append("\n");
        sb.append("    currentRecord: ").append(this.toIndentedString(this.currentRecord)).append("\n");
        sb.append("    standardAmount: ").append(this.toIndentedString(this.standardAmount)).append("\n");
        sb.append("    reducesSuperLiability: ").append(this.toIndentedString(this.reducesSuperLiability)).append("\n");
        sb.append("    reducesTaxLiability: ").append(this.toIndentedString(this.reducesTaxLiability)).append("\n");
        sb.append("    calculationType: ").append(this.toIndentedString((Object)this.calculationType)).append("\n");
        sb.append("    percentage: ").append(this.toIndentedString(this.percentage)).append("\n");
        sb.append("    subjectToNIC: ").append(this.toIndentedString(this.subjectToNIC)).append("\n");
        sb.append("    subjectToTax: ").append(this.toIndentedString(this.subjectToTax)).append("\n");
        sb.append("    isReducedByBasicRate: ").append(this.toIndentedString(this.isReducedByBasicRate)).append("\n");
        sb.append("    applyToPensionCalculations: ").append(this.toIndentedString(this.applyToPensionCalculations)).append("\n");
        sb.append("    isCalculatingOnQualifyingEarnings: ").append(this.toIndentedString(this.isCalculatingOnQualifyingEarnings)).append("\n");
        sb.append("    isPension: ").append(this.toIndentedString(this.isPension)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CalculationTypeEnum {
        FIXEDAMOUNT("FixedAmount"),
        PERCENTAGEOFGROSS("PercentageOfGross");

        private String value;

        private CalculationTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CalculationTypeEnum fromValue(String value) {
            for (CalculationTypeEnum b : CalculationTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum DeductionCategoryEnum {
        CAPITALCONTRIBUTIONS("CapitalContributions"),
        CHILDCAREVOUCHER("ChildCareVoucher"),
        MAKINGGOOD("MakingGood"),
        POSTGRADUATELOANDEDUCTIONS("PostgraduateLoanDeductions"),
        PRIVATEUSEPAYMENTS("PrivateUsePayments"),
        SALARYSACRIFICE("SalarySacrifice"),
        STAKEHOLDERPENSION("StakeholderPension"),
        STAKEHOLDERPENSIONPOSTTAX("StakeholderPensionPostTax"),
        STUDENTLOANDEDUCTIONS("StudentLoanDeductions"),
        UKOTHER("UkOther");

        private String value;

        private DeductionCategoryEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DeductionCategoryEnum fromValue(String value) {
            for (DeductionCategoryEnum b : DeductionCategoryEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

