/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrolluk;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;

public class EmployeeLeaveType {
    StringUtil util = new StringUtil();
    @JsonProperty(value="leaveTypeID")
    private UUID leaveTypeID;
    @JsonProperty(value="scheduleOfAccrual")
    private ScheduleOfAccrualEnum scheduleOfAccrual;
    @JsonProperty(value="hoursAccruedAnnually")
    private Double hoursAccruedAnnually;
    @JsonProperty(value="maximumToAccrue")
    private Double maximumToAccrue;
    @JsonProperty(value="openingBalance")
    private Double openingBalance;
    @JsonProperty(value="rateAccruedHourly")
    private Double rateAccruedHourly;

    public EmployeeLeaveType leaveTypeID(UUID leaveTypeID) {
        this.leaveTypeID = leaveTypeID;
        return this;
    }

    @ApiModelProperty(required=true, value="The Xero identifier for leave type")
    public UUID getLeaveTypeID() {
        return this.leaveTypeID;
    }

    public void setLeaveTypeID(UUID leaveTypeID) {
        this.leaveTypeID = leaveTypeID;
    }

    public EmployeeLeaveType scheduleOfAccrual(ScheduleOfAccrualEnum scheduleOfAccrual) {
        this.scheduleOfAccrual = scheduleOfAccrual;
        return this;
    }

    @ApiModelProperty(required=true, value="The schedule of accrual")
    public ScheduleOfAccrualEnum getScheduleOfAccrual() {
        return this.scheduleOfAccrual;
    }

    public void setScheduleOfAccrual(ScheduleOfAccrualEnum scheduleOfAccrual) {
        this.scheduleOfAccrual = scheduleOfAccrual;
    }

    public EmployeeLeaveType hoursAccruedAnnually(Double hoursAccruedAnnually) {
        this.hoursAccruedAnnually = hoursAccruedAnnually;
        return this;
    }

    @ApiModelProperty(value="The number of hours accrued for the leave annually. This is 0 when the scheduleOfAccrual chosen is \"OnHourWorked\"")
    public Double getHoursAccruedAnnually() {
        return this.hoursAccruedAnnually;
    }

    public void setHoursAccruedAnnually(Double hoursAccruedAnnually) {
        this.hoursAccruedAnnually = hoursAccruedAnnually;
    }

    public EmployeeLeaveType maximumToAccrue(Double maximumToAccrue) {
        this.maximumToAccrue = maximumToAccrue;
        return this;
    }

    @ApiModelProperty(value="The maximum number of hours that can be accrued for the leave")
    public Double getMaximumToAccrue() {
        return this.maximumToAccrue;
    }

    public void setMaximumToAccrue(Double maximumToAccrue) {
        this.maximumToAccrue = maximumToAccrue;
    }

    public EmployeeLeaveType openingBalance(Double openingBalance) {
        this.openingBalance = openingBalance;
        return this;
    }

    @ApiModelProperty(value="The initial number of hours assigned when the leave was added to the employee")
    public Double getOpeningBalance() {
        return this.openingBalance;
    }

    public void setOpeningBalance(Double openingBalance) {
        this.openingBalance = openingBalance;
    }

    public EmployeeLeaveType rateAccruedHourly(Double rateAccruedHourly) {
        this.rateAccruedHourly = rateAccruedHourly;
        return this;
    }

    @ApiModelProperty(value="The number of hours added to the leave balance for every hour worked by the employee. This is normally 0, unless the scheduleOfAccrual chosen is \"OnHourWorked\"")
    public Double getRateAccruedHourly() {
        return this.rateAccruedHourly;
    }

    public void setRateAccruedHourly(Double rateAccruedHourly) {
        this.rateAccruedHourly = rateAccruedHourly;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmployeeLeaveType employeeLeaveType = (EmployeeLeaveType)o;
        return Objects.equals(this.leaveTypeID, employeeLeaveType.leaveTypeID) && Objects.equals((Object)this.scheduleOfAccrual, (Object)employeeLeaveType.scheduleOfAccrual) && Objects.equals(this.hoursAccruedAnnually, employeeLeaveType.hoursAccruedAnnually) && Objects.equals(this.maximumToAccrue, employeeLeaveType.maximumToAccrue) && Objects.equals(this.openingBalance, employeeLeaveType.openingBalance) && Objects.equals(this.rateAccruedHourly, employeeLeaveType.rateAccruedHourly);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.leaveTypeID, this.scheduleOfAccrual, this.hoursAccruedAnnually, this.maximumToAccrue, this.openingBalance, this.rateAccruedHourly});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmployeeLeaveType {\n");
        sb.append("    leaveTypeID: ").append(this.toIndentedString(this.leaveTypeID)).append("\n");
        sb.append("    scheduleOfAccrual: ").append(this.toIndentedString((Object)this.scheduleOfAccrual)).append("\n");
        sb.append("    hoursAccruedAnnually: ").append(this.toIndentedString(this.hoursAccruedAnnually)).append("\n");
        sb.append("    maximumToAccrue: ").append(this.toIndentedString(this.maximumToAccrue)).append("\n");
        sb.append("    openingBalance: ").append(this.toIndentedString(this.openingBalance)).append("\n");
        sb.append("    rateAccruedHourly: ").append(this.toIndentedString(this.rateAccruedHourly)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ScheduleOfAccrualEnum {
        BEGINNINGOFCALENDARYEAR("BeginningOfCalendarYear"),
        ONANNIVERSARYDATE("OnAnniversaryDate"),
        EACHPAYPERIOD("EachPayPeriod"),
        ONHOURWORKED("OnHourWorked");

        private String value;

        private ScheduleOfAccrualEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ScheduleOfAccrualEnum fromValue(String value) {
            for (ScheduleOfAccrualEnum b : ScheduleOfAccrualEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

