/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrolluk;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.LocalDate;

public class Employment {
    StringUtil util = new StringUtil();
    @JsonProperty(value="payrollCalendarID")
    private UUID payrollCalendarID;
    @JsonProperty(value="startDate")
    private LocalDate startDate;
    @JsonProperty(value="employeeNumber")
    private String employeeNumber;
    @JsonProperty(value="niCategory")
    private NiCategoryEnum niCategory;

    public Employment payrollCalendarID(UUID payrollCalendarID) {
        this.payrollCalendarID = payrollCalendarID;
        return this;
    }

    @ApiModelProperty(value="Xero unique identifier for the payroll calendar of the employee")
    public UUID getPayrollCalendarID() {
        return this.payrollCalendarID;
    }

    public void setPayrollCalendarID(UUID payrollCalendarID) {
        this.payrollCalendarID = payrollCalendarID;
    }

    public Employment startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(value="Start date of the employment (YYYY-MM-DD)")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public Employment employeeNumber(String employeeNumber) {
        this.employeeNumber = employeeNumber;
        return this;
    }

    @ApiModelProperty(example="7", value="The employment number of the employee")
    public String getEmployeeNumber() {
        return this.employeeNumber;
    }

    public void setEmployeeNumber(String employeeNumber) {
        this.employeeNumber = employeeNumber;
    }

    public Employment niCategory(NiCategoryEnum niCategory) {
        this.niCategory = niCategory;
        return this;
    }

    @ApiModelProperty(example="A", value="The NI Category of the employee")
    public NiCategoryEnum getNiCategory() {
        return this.niCategory;
    }

    public void setNiCategory(NiCategoryEnum niCategory) {
        this.niCategory = niCategory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Employment employment = (Employment)o;
        return Objects.equals(this.payrollCalendarID, employment.payrollCalendarID) && Objects.equals(this.startDate, employment.startDate) && Objects.equals(this.employeeNumber, employment.employeeNumber) && Objects.equals((Object)this.niCategory, (Object)employment.niCategory);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.payrollCalendarID, this.startDate, this.employeeNumber, this.niCategory});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Employment {\n");
        sb.append("    payrollCalendarID: ").append(this.toIndentedString(this.payrollCalendarID)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    employeeNumber: ").append(this.toIndentedString(this.employeeNumber)).append("\n");
        sb.append("    niCategory: ").append(this.toIndentedString((Object)this.niCategory)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum NiCategoryEnum {
        A("A"),
        B("B"),
        C("C"),
        F("F"),
        H("H"),
        I("I"),
        J("J"),
        L("L"),
        M("M"),
        S("S"),
        V("V"),
        X("X"),
        Z("Z");

        private String value;

        private NiCategoryEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static NiCategoryEnum fromValue(String value) {
            for (NiCategoryEnum b : NiCategoryEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

