/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrolluk;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import com.xero.models.payrolluk.BenefitLine;
import com.xero.models.payrolluk.CourtOrderLine;
import com.xero.models.payrolluk.DeductionLine;
import com.xero.models.payrolluk.EarningsLine;
import com.xero.models.payrolluk.LeaveAccrualLine;
import com.xero.models.payrolluk.LeaveEarningsLine;
import com.xero.models.payrolluk.PaymentLine;
import com.xero.models.payrolluk.ReimbursementLine;
import com.xero.models.payrolluk.TaxLine;
import com.xero.models.payrolluk.TimesheetEarningsLine;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.LocalDateTime;

public class Payslip {
    StringUtil util = new StringUtil();
    @JsonProperty(value="paySlipID")
    private UUID paySlipID;
    @JsonProperty(value="employeeID")
    private UUID employeeID;
    @JsonProperty(value="payRunID")
    private UUID payRunID;
    @JsonProperty(value="lastEdited")
    private LocalDateTime lastEdited;
    @JsonProperty(value="firstName")
    private String firstName;
    @JsonProperty(value="lastName")
    private String lastName;
    @JsonProperty(value="totalEarnings")
    private Double totalEarnings;
    @JsonProperty(value="grossEarnings")
    private Double grossEarnings;
    @JsonProperty(value="totalPay")
    private Double totalPay;
    @JsonProperty(value="totalEmployerTaxes")
    private Double totalEmployerTaxes;
    @JsonProperty(value="totalEmployeeTaxes")
    private Double totalEmployeeTaxes;
    @JsonProperty(value="totalDeductions")
    private Double totalDeductions;
    @JsonProperty(value="totalReimbursements")
    private Double totalReimbursements;
    @JsonProperty(value="totalCourtOrders")
    private Double totalCourtOrders;
    @JsonProperty(value="totalBenefits")
    private Double totalBenefits;
    @JsonProperty(value="bacsHash")
    private String bacsHash;
    @JsonProperty(value="paymentMethod")
    private PaymentMethodEnum paymentMethod;
    @JsonProperty(value="earningsLines")
    private List<EarningsLine> earningsLines = new ArrayList<EarningsLine>();
    @JsonProperty(value="leaveEarningsLines")
    private List<LeaveEarningsLine> leaveEarningsLines = new ArrayList<LeaveEarningsLine>();
    @JsonProperty(value="timesheetEarningsLines")
    private List<TimesheetEarningsLine> timesheetEarningsLines = new ArrayList<TimesheetEarningsLine>();
    @JsonProperty(value="deductionLines")
    private List<DeductionLine> deductionLines = new ArrayList<DeductionLine>();
    @JsonProperty(value="reimbursementLines")
    private List<ReimbursementLine> reimbursementLines = new ArrayList<ReimbursementLine>();
    @JsonProperty(value="leaveAccrualLines")
    private List<LeaveAccrualLine> leaveAccrualLines = new ArrayList<LeaveAccrualLine>();
    @JsonProperty(value="benefitLines")
    private List<BenefitLine> benefitLines = new ArrayList<BenefitLine>();
    @JsonProperty(value="paymentLines")
    private List<PaymentLine> paymentLines = new ArrayList<PaymentLine>();
    @JsonProperty(value="employeeTaxLines")
    private List<TaxLine> employeeTaxLines = new ArrayList<TaxLine>();
    @JsonProperty(value="employerTaxLines")
    private List<TaxLine> employerTaxLines = new ArrayList<TaxLine>();
    @JsonProperty(value="courtOrderLines")
    private List<CourtOrderLine> courtOrderLines = new ArrayList<CourtOrderLine>();

    public Payslip paySlipID(UUID paySlipID) {
        this.paySlipID = paySlipID;
        return this;
    }

    @ApiModelProperty(value="The Xero identifier for a Payslip")
    public UUID getPaySlipID() {
        return this.paySlipID;
    }

    public void setPaySlipID(UUID paySlipID) {
        this.paySlipID = paySlipID;
    }

    public Payslip employeeID(UUID employeeID) {
        this.employeeID = employeeID;
        return this;
    }

    @ApiModelProperty(value="The Xero identifier for payroll employee")
    public UUID getEmployeeID() {
        return this.employeeID;
    }

    public void setEmployeeID(UUID employeeID) {
        this.employeeID = employeeID;
    }

    public Payslip payRunID(UUID payRunID) {
        this.payRunID = payRunID;
        return this;
    }

    @ApiModelProperty(value="The Xero identifier for the associated payrun")
    public UUID getPayRunID() {
        return this.payRunID;
    }

    public void setPayRunID(UUID payRunID) {
        this.payRunID = payRunID;
    }

    public Payslip lastEdited(LocalDateTime lastEdited) {
        this.lastEdited = lastEdited;
        return this;
    }

    @ApiModelProperty(value="The date payslip was last updated")
    public LocalDateTime getLastEdited() {
        return this.lastEdited;
    }

    public void setLastEdited(LocalDateTime lastEdited) {
        this.lastEdited = lastEdited;
    }

    public Payslip firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @ApiModelProperty(value="Employee first name")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public Payslip lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @ApiModelProperty(value="Employee last name")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public Payslip totalEarnings(Double totalEarnings) {
        this.totalEarnings = totalEarnings;
        return this;
    }

    @ApiModelProperty(value="Total earnings before any deductions. Same as gross earnings for UK.")
    public Double getTotalEarnings() {
        return this.totalEarnings;
    }

    public void setTotalEarnings(Double totalEarnings) {
        this.totalEarnings = totalEarnings;
    }

    public Payslip grossEarnings(Double grossEarnings) {
        this.grossEarnings = grossEarnings;
        return this;
    }

    @ApiModelProperty(value="Total earnings before any deductions. Same as total earnings for UK.")
    public Double getGrossEarnings() {
        return this.grossEarnings;
    }

    public void setGrossEarnings(Double grossEarnings) {
        this.grossEarnings = grossEarnings;
    }

    public Payslip totalPay(Double totalPay) {
        this.totalPay = totalPay;
        return this;
    }

    @ApiModelProperty(value="The employee net pay")
    public Double getTotalPay() {
        return this.totalPay;
    }

    public void setTotalPay(Double totalPay) {
        this.totalPay = totalPay;
    }

    public Payslip totalEmployerTaxes(Double totalEmployerTaxes) {
        this.totalEmployerTaxes = totalEmployerTaxes;
        return this;
    }

    @ApiModelProperty(value="The employer's tax obligation")
    public Double getTotalEmployerTaxes() {
        return this.totalEmployerTaxes;
    }

    public void setTotalEmployerTaxes(Double totalEmployerTaxes) {
        this.totalEmployerTaxes = totalEmployerTaxes;
    }

    public Payslip totalEmployeeTaxes(Double totalEmployeeTaxes) {
        this.totalEmployeeTaxes = totalEmployeeTaxes;
        return this;
    }

    @ApiModelProperty(value="The part of an employee's earnings that is deducted for tax purposes")
    public Double getTotalEmployeeTaxes() {
        return this.totalEmployeeTaxes;
    }

    public void setTotalEmployeeTaxes(Double totalEmployeeTaxes) {
        this.totalEmployeeTaxes = totalEmployeeTaxes;
    }

    public Payslip totalDeductions(Double totalDeductions) {
        this.totalDeductions = totalDeductions;
        return this;
    }

    @ApiModelProperty(value="Total amount subtracted from an employee's earnings to reach total pay")
    public Double getTotalDeductions() {
        return this.totalDeductions;
    }

    public void setTotalDeductions(Double totalDeductions) {
        this.totalDeductions = totalDeductions;
    }

    public Payslip totalReimbursements(Double totalReimbursements) {
        this.totalReimbursements = totalReimbursements;
        return this;
    }

    @ApiModelProperty(value="Total reimbursements are nontaxable payments to an employee used to repay out-of-pocket expenses when the person incurs those expenses through employment")
    public Double getTotalReimbursements() {
        return this.totalReimbursements;
    }

    public void setTotalReimbursements(Double totalReimbursements) {
        this.totalReimbursements = totalReimbursements;
    }

    public Payslip totalCourtOrders(Double totalCourtOrders) {
        this.totalCourtOrders = totalCourtOrders;
        return this;
    }

    @ApiModelProperty(value="Total amounts required by law to subtract from the employee's earnings")
    public Double getTotalCourtOrders() {
        return this.totalCourtOrders;
    }

    public void setTotalCourtOrders(Double totalCourtOrders) {
        this.totalCourtOrders = totalCourtOrders;
    }

    public Payslip totalBenefits(Double totalBenefits) {
        this.totalBenefits = totalBenefits;
        return this;
    }

    @ApiModelProperty(value="Benefits (also called fringe benefits, perquisites or perks) are various non-earnings compensations provided to employees in addition to their normal earnings or salaries")
    public Double getTotalBenefits() {
        return this.totalBenefits;
    }

    public void setTotalBenefits(Double totalBenefits) {
        this.totalBenefits = totalBenefits;
    }

    public Payslip bacsHash(String bacsHash) {
        this.bacsHash = bacsHash;
        return this;
    }

    @ApiModelProperty(value="BACS Service User Number")
    public String getBacsHash() {
        return this.bacsHash;
    }

    public void setBacsHash(String bacsHash) {
        this.bacsHash = bacsHash;
    }

    public Payslip paymentMethod(PaymentMethodEnum paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    @ApiModelProperty(value="The payment method code")
    public PaymentMethodEnum getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(PaymentMethodEnum paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public Payslip earningsLines(List<EarningsLine> earningsLines) {
        this.earningsLines = earningsLines;
        return this;
    }

    public Payslip addEarningsLinesItem(EarningsLine earningsLinesItem) {
        if (this.earningsLines == null) {
            this.earningsLines = new ArrayList<EarningsLine>();
        }
        this.earningsLines.add(earningsLinesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<EarningsLine> getEarningsLines() {
        return this.earningsLines;
    }

    public void setEarningsLines(List<EarningsLine> earningsLines) {
        this.earningsLines = earningsLines;
    }

    public Payslip leaveEarningsLines(List<LeaveEarningsLine> leaveEarningsLines) {
        this.leaveEarningsLines = leaveEarningsLines;
        return this;
    }

    public Payslip addLeaveEarningsLinesItem(LeaveEarningsLine leaveEarningsLinesItem) {
        if (this.leaveEarningsLines == null) {
            this.leaveEarningsLines = new ArrayList<LeaveEarningsLine>();
        }
        this.leaveEarningsLines.add(leaveEarningsLinesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<LeaveEarningsLine> getLeaveEarningsLines() {
        return this.leaveEarningsLines;
    }

    public void setLeaveEarningsLines(List<LeaveEarningsLine> leaveEarningsLines) {
        this.leaveEarningsLines = leaveEarningsLines;
    }

    public Payslip timesheetEarningsLines(List<TimesheetEarningsLine> timesheetEarningsLines) {
        this.timesheetEarningsLines = timesheetEarningsLines;
        return this;
    }

    public Payslip addTimesheetEarningsLinesItem(TimesheetEarningsLine timesheetEarningsLinesItem) {
        if (this.timesheetEarningsLines == null) {
            this.timesheetEarningsLines = new ArrayList<TimesheetEarningsLine>();
        }
        this.timesheetEarningsLines.add(timesheetEarningsLinesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<TimesheetEarningsLine> getTimesheetEarningsLines() {
        return this.timesheetEarningsLines;
    }

    public void setTimesheetEarningsLines(List<TimesheetEarningsLine> timesheetEarningsLines) {
        this.timesheetEarningsLines = timesheetEarningsLines;
    }

    public Payslip deductionLines(List<DeductionLine> deductionLines) {
        this.deductionLines = deductionLines;
        return this;
    }

    public Payslip addDeductionLinesItem(DeductionLine deductionLinesItem) {
        if (this.deductionLines == null) {
            this.deductionLines = new ArrayList<DeductionLine>();
        }
        this.deductionLines.add(deductionLinesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<DeductionLine> getDeductionLines() {
        return this.deductionLines;
    }

    public void setDeductionLines(List<DeductionLine> deductionLines) {
        this.deductionLines = deductionLines;
    }

    public Payslip reimbursementLines(List<ReimbursementLine> reimbursementLines) {
        this.reimbursementLines = reimbursementLines;
        return this;
    }

    public Payslip addReimbursementLinesItem(ReimbursementLine reimbursementLinesItem) {
        if (this.reimbursementLines == null) {
            this.reimbursementLines = new ArrayList<ReimbursementLine>();
        }
        this.reimbursementLines.add(reimbursementLinesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<ReimbursementLine> getReimbursementLines() {
        return this.reimbursementLines;
    }

    public void setReimbursementLines(List<ReimbursementLine> reimbursementLines) {
        this.reimbursementLines = reimbursementLines;
    }

    public Payslip leaveAccrualLines(List<LeaveAccrualLine> leaveAccrualLines) {
        this.leaveAccrualLines = leaveAccrualLines;
        return this;
    }

    public Payslip addLeaveAccrualLinesItem(LeaveAccrualLine leaveAccrualLinesItem) {
        if (this.leaveAccrualLines == null) {
            this.leaveAccrualLines = new ArrayList<LeaveAccrualLine>();
        }
        this.leaveAccrualLines.add(leaveAccrualLinesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<LeaveAccrualLine> getLeaveAccrualLines() {
        return this.leaveAccrualLines;
    }

    public void setLeaveAccrualLines(List<LeaveAccrualLine> leaveAccrualLines) {
        this.leaveAccrualLines = leaveAccrualLines;
    }

    public Payslip benefitLines(List<BenefitLine> benefitLines) {
        this.benefitLines = benefitLines;
        return this;
    }

    public Payslip addBenefitLinesItem(BenefitLine benefitLinesItem) {
        if (this.benefitLines == null) {
            this.benefitLines = new ArrayList<BenefitLine>();
        }
        this.benefitLines.add(benefitLinesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<BenefitLine> getBenefitLines() {
        return this.benefitLines;
    }

    public void setBenefitLines(List<BenefitLine> benefitLines) {
        this.benefitLines = benefitLines;
    }

    public Payslip paymentLines(List<PaymentLine> paymentLines) {
        this.paymentLines = paymentLines;
        return this;
    }

    public Payslip addPaymentLinesItem(PaymentLine paymentLinesItem) {
        if (this.paymentLines == null) {
            this.paymentLines = new ArrayList<PaymentLine>();
        }
        this.paymentLines.add(paymentLinesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<PaymentLine> getPaymentLines() {
        return this.paymentLines;
    }

    public void setPaymentLines(List<PaymentLine> paymentLines) {
        this.paymentLines = paymentLines;
    }

    public Payslip employeeTaxLines(List<TaxLine> employeeTaxLines) {
        this.employeeTaxLines = employeeTaxLines;
        return this;
    }

    public Payslip addEmployeeTaxLinesItem(TaxLine employeeTaxLinesItem) {
        if (this.employeeTaxLines == null) {
            this.employeeTaxLines = new ArrayList<TaxLine>();
        }
        this.employeeTaxLines.add(employeeTaxLinesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<TaxLine> getEmployeeTaxLines() {
        return this.employeeTaxLines;
    }

    public void setEmployeeTaxLines(List<TaxLine> employeeTaxLines) {
        this.employeeTaxLines = employeeTaxLines;
    }

    public Payslip employerTaxLines(List<TaxLine> employerTaxLines) {
        this.employerTaxLines = employerTaxLines;
        return this;
    }

    public Payslip addEmployerTaxLinesItem(TaxLine employerTaxLinesItem) {
        if (this.employerTaxLines == null) {
            this.employerTaxLines = new ArrayList<TaxLine>();
        }
        this.employerTaxLines.add(employerTaxLinesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<TaxLine> getEmployerTaxLines() {
        return this.employerTaxLines;
    }

    public void setEmployerTaxLines(List<TaxLine> employerTaxLines) {
        this.employerTaxLines = employerTaxLines;
    }

    public Payslip courtOrderLines(List<CourtOrderLine> courtOrderLines) {
        this.courtOrderLines = courtOrderLines;
        return this;
    }

    public Payslip addCourtOrderLinesItem(CourtOrderLine courtOrderLinesItem) {
        if (this.courtOrderLines == null) {
            this.courtOrderLines = new ArrayList<CourtOrderLine>();
        }
        this.courtOrderLines.add(courtOrderLinesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<CourtOrderLine> getCourtOrderLines() {
        return this.courtOrderLines;
    }

    public void setCourtOrderLines(List<CourtOrderLine> courtOrderLines) {
        this.courtOrderLines = courtOrderLines;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Payslip payslip = (Payslip)o;
        return Objects.equals(this.paySlipID, payslip.paySlipID) && Objects.equals(this.employeeID, payslip.employeeID) && Objects.equals(this.payRunID, payslip.payRunID) && Objects.equals(this.lastEdited, payslip.lastEdited) && Objects.equals(this.firstName, payslip.firstName) && Objects.equals(this.lastName, payslip.lastName) && Objects.equals(this.totalEarnings, payslip.totalEarnings) && Objects.equals(this.grossEarnings, payslip.grossEarnings) && Objects.equals(this.totalPay, payslip.totalPay) && Objects.equals(this.totalEmployerTaxes, payslip.totalEmployerTaxes) && Objects.equals(this.totalEmployeeTaxes, payslip.totalEmployeeTaxes) && Objects.equals(this.totalDeductions, payslip.totalDeductions) && Objects.equals(this.totalReimbursements, payslip.totalReimbursements) && Objects.equals(this.totalCourtOrders, payslip.totalCourtOrders) && Objects.equals(this.totalBenefits, payslip.totalBenefits) && Objects.equals(this.bacsHash, payslip.bacsHash) && Objects.equals((Object)this.paymentMethod, (Object)payslip.paymentMethod) && Objects.equals(this.earningsLines, payslip.earningsLines) && Objects.equals(this.leaveEarningsLines, payslip.leaveEarningsLines) && Objects.equals(this.timesheetEarningsLines, payslip.timesheetEarningsLines) && Objects.equals(this.deductionLines, payslip.deductionLines) && Objects.equals(this.reimbursementLines, payslip.reimbursementLines) && Objects.equals(this.leaveAccrualLines, payslip.leaveAccrualLines) && Objects.equals(this.benefitLines, payslip.benefitLines) && Objects.equals(this.paymentLines, payslip.paymentLines) && Objects.equals(this.employeeTaxLines, payslip.employeeTaxLines) && Objects.equals(this.employerTaxLines, payslip.employerTaxLines) && Objects.equals(this.courtOrderLines, payslip.courtOrderLines);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.paySlipID, this.employeeID, this.payRunID, this.lastEdited, this.firstName, this.lastName, this.totalEarnings, this.grossEarnings, this.totalPay, this.totalEmployerTaxes, this.totalEmployeeTaxes, this.totalDeductions, this.totalReimbursements, this.totalCourtOrders, this.totalBenefits, this.bacsHash, this.paymentMethod, this.earningsLines, this.leaveEarningsLines, this.timesheetEarningsLines, this.deductionLines, this.reimbursementLines, this.leaveAccrualLines, this.benefitLines, this.paymentLines, this.employeeTaxLines, this.employerTaxLines, this.courtOrderLines});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Payslip {\n");
        sb.append("    paySlipID: ").append(this.toIndentedString(this.paySlipID)).append("\n");
        sb.append("    employeeID: ").append(this.toIndentedString(this.employeeID)).append("\n");
        sb.append("    payRunID: ").append(this.toIndentedString(this.payRunID)).append("\n");
        sb.append("    lastEdited: ").append(this.toIndentedString(this.lastEdited)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    totalEarnings: ").append(this.toIndentedString(this.totalEarnings)).append("\n");
        sb.append("    grossEarnings: ").append(this.toIndentedString(this.grossEarnings)).append("\n");
        sb.append("    totalPay: ").append(this.toIndentedString(this.totalPay)).append("\n");
        sb.append("    totalEmployerTaxes: ").append(this.toIndentedString(this.totalEmployerTaxes)).append("\n");
        sb.append("    totalEmployeeTaxes: ").append(this.toIndentedString(this.totalEmployeeTaxes)).append("\n");
        sb.append("    totalDeductions: ").append(this.toIndentedString(this.totalDeductions)).append("\n");
        sb.append("    totalReimbursements: ").append(this.toIndentedString(this.totalReimbursements)).append("\n");
        sb.append("    totalCourtOrders: ").append(this.toIndentedString(this.totalCourtOrders)).append("\n");
        sb.append("    totalBenefits: ").append(this.toIndentedString(this.totalBenefits)).append("\n");
        sb.append("    bacsHash: ").append(this.toIndentedString(this.bacsHash)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString((Object)this.paymentMethod)).append("\n");
        sb.append("    earningsLines: ").append(this.toIndentedString(this.earningsLines)).append("\n");
        sb.append("    leaveEarningsLines: ").append(this.toIndentedString(this.leaveEarningsLines)).append("\n");
        sb.append("    timesheetEarningsLines: ").append(this.toIndentedString(this.timesheetEarningsLines)).append("\n");
        sb.append("    deductionLines: ").append(this.toIndentedString(this.deductionLines)).append("\n");
        sb.append("    reimbursementLines: ").append(this.toIndentedString(this.reimbursementLines)).append("\n");
        sb.append("    leaveAccrualLines: ").append(this.toIndentedString(this.leaveAccrualLines)).append("\n");
        sb.append("    benefitLines: ").append(this.toIndentedString(this.benefitLines)).append("\n");
        sb.append("    paymentLines: ").append(this.toIndentedString(this.paymentLines)).append("\n");
        sb.append("    employeeTaxLines: ").append(this.toIndentedString(this.employeeTaxLines)).append("\n");
        sb.append("    employerTaxLines: ").append(this.toIndentedString(this.employerTaxLines)).append("\n");
        sb.append("    courtOrderLines: ").append(this.toIndentedString(this.courtOrderLines)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PaymentMethodEnum {
        CHEQUE("Cheque"),
        ELECTRONICALLY("Electronically"),
        MANUAL("Manual");

        private String value;

        private PaymentMethodEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PaymentMethodEnum fromValue(String value) {
            for (PaymentMethodEnum b : PaymentMethodEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

