/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrolluk;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;

public class TimesheetEarningsLine {
    StringUtil util = new StringUtil();
    @JsonProperty(value="earningsRateID")
    private UUID earningsRateID;
    @JsonProperty(value="ratePerUnit")
    private Double ratePerUnit;
    @JsonProperty(value="numberOfUnits")
    private Double numberOfUnits;
    @JsonProperty(value="fixedAmount")
    private Double fixedAmount;
    @JsonProperty(value="amount")
    private Double amount;
    @JsonProperty(value="isLinkedToTimesheet")
    private Boolean isLinkedToTimesheet;

    public TimesheetEarningsLine earningsRateID(UUID earningsRateID) {
        this.earningsRateID = earningsRateID;
        return this;
    }

    @ApiModelProperty(value="Xero identifier for payroll timesheet earnings rate")
    public UUID getEarningsRateID() {
        return this.earningsRateID;
    }

    public void setEarningsRateID(UUID earningsRateID) {
        this.earningsRateID = earningsRateID;
    }

    public TimesheetEarningsLine ratePerUnit(Double ratePerUnit) {
        this.ratePerUnit = ratePerUnit;
        return this;
    }

    @ApiModelProperty(value="Rate per unit for timesheet earnings line")
    public Double getRatePerUnit() {
        return this.ratePerUnit;
    }

    public void setRatePerUnit(Double ratePerUnit) {
        this.ratePerUnit = ratePerUnit;
    }

    public TimesheetEarningsLine numberOfUnits(Double numberOfUnits) {
        this.numberOfUnits = numberOfUnits;
        return this;
    }

    @ApiModelProperty(value="Timesheet earnings number of units")
    public Double getNumberOfUnits() {
        return this.numberOfUnits;
    }

    public void setNumberOfUnits(Double numberOfUnits) {
        this.numberOfUnits = numberOfUnits;
    }

    public TimesheetEarningsLine fixedAmount(Double fixedAmount) {
        this.fixedAmount = fixedAmount;
        return this;
    }

    @ApiModelProperty(value="Timesheet earnings fixed amount. Only applicable if the EarningsRate RateType is Fixed")
    public Double getFixedAmount() {
        return this.fixedAmount;
    }

    public void setFixedAmount(Double fixedAmount) {
        this.fixedAmount = fixedAmount;
    }

    public TimesheetEarningsLine amount(Double amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="The amount of the timesheet earnings line.")
    public Double getAmount() {
        return this.amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public TimesheetEarningsLine isLinkedToTimesheet(Boolean isLinkedToTimesheet) {
        this.isLinkedToTimesheet = isLinkedToTimesheet;
        return this;
    }

    @ApiModelProperty(value="Identifies if the timesheet earnings is taken from the timesheet. False for leave earnings line")
    public Boolean getIsLinkedToTimesheet() {
        return this.isLinkedToTimesheet;
    }

    public void setIsLinkedToTimesheet(Boolean isLinkedToTimesheet) {
        this.isLinkedToTimesheet = isLinkedToTimesheet;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimesheetEarningsLine timesheetEarningsLine = (TimesheetEarningsLine)o;
        return Objects.equals(this.earningsRateID, timesheetEarningsLine.earningsRateID) && Objects.equals(this.ratePerUnit, timesheetEarningsLine.ratePerUnit) && Objects.equals(this.numberOfUnits, timesheetEarningsLine.numberOfUnits) && Objects.equals(this.fixedAmount, timesheetEarningsLine.fixedAmount) && Objects.equals(this.amount, timesheetEarningsLine.amount) && Objects.equals(this.isLinkedToTimesheet, timesheetEarningsLine.isLinkedToTimesheet);
    }

    public int hashCode() {
        return Objects.hash(this.earningsRateID, this.ratePerUnit, this.numberOfUnits, this.fixedAmount, this.amount, this.isLinkedToTimesheet);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TimesheetEarningsLine {\n");
        sb.append("    earningsRateID: ").append(this.toIndentedString(this.earningsRateID)).append("\n");
        sb.append("    ratePerUnit: ").append(this.toIndentedString(this.ratePerUnit)).append("\n");
        sb.append("    numberOfUnits: ").append(this.toIndentedString(this.numberOfUnits)).append("\n");
        sb.append("    fixedAmount: ").append(this.toIndentedString(this.fixedAmount)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    isLinkedToTimesheet: ").append(this.toIndentedString(this.isLinkedToTimesheet)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

