/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.project;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import com.xero.models.project.Amount;
import com.xero.models.project.ChargeType;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;

public class Task {
    StringUtil util = new StringUtil();
    @JsonProperty(value="taskId")
    private UUID taskId;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="rate")
    private Amount rate;
    @JsonProperty(value="chargeType")
    private ChargeType chargeType;
    @JsonProperty(value="estimateMinutes")
    private Integer estimateMinutes;
    @JsonProperty(value="projectId")
    private UUID projectId;
    @JsonProperty(value="totalMinutes")
    private Integer totalMinutes;
    @JsonProperty(value="totalAmount")
    private Amount totalAmount;
    @JsonProperty(value="minutesInvoiced")
    private Integer minutesInvoiced;
    @JsonProperty(value="minutesToBeInvoiced")
    private Integer minutesToBeInvoiced;
    @JsonProperty(value="fixedMinutes")
    private Integer fixedMinutes;
    @JsonProperty(value="nonChargeableMinutes")
    private Integer nonChargeableMinutes;
    @JsonProperty(value="amountToBeInvoiced")
    private Amount amountToBeInvoiced;
    @JsonProperty(value="amountInvoiced")
    private Amount amountInvoiced;
    @JsonProperty(value="status")
    private StatusEnum status;

    public Task taskId(UUID taskId) {
        this.taskId = taskId;
        return this;
    }

    @ApiModelProperty(example="00000000-0000-0000-0000-000000000000", value="Identifier of the task.")
    public UUID getTaskId() {
        return this.taskId;
    }

    public void setTaskId(UUID taskId) {
        this.taskId = taskId;
    }

    public Task name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Name of the task.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Task rate(Amount rate) {
        this.rate = rate;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getRate() {
        return this.rate;
    }

    public void setRate(Amount rate) {
        this.rate = rate;
    }

    public Task chargeType(ChargeType chargeType) {
        this.chargeType = chargeType;
        return this;
    }

    @ApiModelProperty(value="")
    public ChargeType getChargeType() {
        return this.chargeType;
    }

    public void setChargeType(ChargeType chargeType) {
        this.chargeType = chargeType;
    }

    public Task estimateMinutes(Integer estimateMinutes) {
        this.estimateMinutes = estimateMinutes;
        return this;
    }

    @ApiModelProperty(value="An estimated time to perform the task")
    public Integer getEstimateMinutes() {
        return this.estimateMinutes;
    }

    public void setEstimateMinutes(Integer estimateMinutes) {
        this.estimateMinutes = estimateMinutes;
    }

    public Task projectId(UUID projectId) {
        this.projectId = projectId;
        return this;
    }

    @ApiModelProperty(example="00000000-0000-0000-0000-000000000000", value="Identifier of the project task belongs to.")
    public UUID getProjectId() {
        return this.projectId;
    }

    public void setProjectId(UUID projectId) {
        this.projectId = projectId;
    }

    public Task totalMinutes(Integer totalMinutes) {
        this.totalMinutes = totalMinutes;
        return this;
    }

    @ApiModelProperty(value="Total minutes which have been logged against the task. Logged by assigning a time entry to a task")
    public Integer getTotalMinutes() {
        return this.totalMinutes;
    }

    public void setTotalMinutes(Integer totalMinutes) {
        this.totalMinutes = totalMinutes;
    }

    public Task totalAmount(Amount totalAmount) {
        this.totalAmount = totalAmount;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(Amount totalAmount) {
        this.totalAmount = totalAmount;
    }

    public Task minutesInvoiced(Integer minutesInvoiced) {
        this.minutesInvoiced = minutesInvoiced;
        return this;
    }

    @ApiModelProperty(value="Minutes on this task which have been invoiced.")
    public Integer getMinutesInvoiced() {
        return this.minutesInvoiced;
    }

    public void setMinutesInvoiced(Integer minutesInvoiced) {
        this.minutesInvoiced = minutesInvoiced;
    }

    public Task minutesToBeInvoiced(Integer minutesToBeInvoiced) {
        this.minutesToBeInvoiced = minutesToBeInvoiced;
        return this;
    }

    @ApiModelProperty(value="Minutes on this task which have not been invoiced.")
    public Integer getMinutesToBeInvoiced() {
        return this.minutesToBeInvoiced;
    }

    public void setMinutesToBeInvoiced(Integer minutesToBeInvoiced) {
        this.minutesToBeInvoiced = minutesToBeInvoiced;
    }

    public Task fixedMinutes(Integer fixedMinutes) {
        this.fixedMinutes = fixedMinutes;
        return this;
    }

    @ApiModelProperty(value="Minutes logged against this task if its charge type is `FIXED`.")
    public Integer getFixedMinutes() {
        return this.fixedMinutes;
    }

    public void setFixedMinutes(Integer fixedMinutes) {
        this.fixedMinutes = fixedMinutes;
    }

    public Task nonChargeableMinutes(Integer nonChargeableMinutes) {
        this.nonChargeableMinutes = nonChargeableMinutes;
        return this;
    }

    @ApiModelProperty(value="Minutes logged against this task if its charge type is `NON_CHARGEABLE`.")
    public Integer getNonChargeableMinutes() {
        return this.nonChargeableMinutes;
    }

    public void setNonChargeableMinutes(Integer nonChargeableMinutes) {
        this.nonChargeableMinutes = nonChargeableMinutes;
    }

    public Task amountToBeInvoiced(Amount amountToBeInvoiced) {
        this.amountToBeInvoiced = amountToBeInvoiced;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getAmountToBeInvoiced() {
        return this.amountToBeInvoiced;
    }

    public void setAmountToBeInvoiced(Amount amountToBeInvoiced) {
        this.amountToBeInvoiced = amountToBeInvoiced;
    }

    public Task amountInvoiced(Amount amountInvoiced) {
        this.amountInvoiced = amountInvoiced;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getAmountInvoiced() {
        return this.amountInvoiced;
    }

    public void setAmountInvoiced(Amount amountInvoiced) {
        this.amountInvoiced = amountInvoiced;
    }

    public Task status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="Status of the task. When a task of ChargeType is `FIXED` and the rate amount is invoiced the status will be set to `INVOICED` and can't be modified. A task with ChargeType of `TIME` or `NON_CHARGEABLE` cannot have a status of `INVOICED`. A `LOCKED` state indicates that the task is currently changing state (for example being invoiced) and can't be modified.")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Task task = (Task)o;
        return Objects.equals(this.taskId, task.taskId) && Objects.equals(this.name, task.name) && Objects.equals(this.rate, task.rate) && Objects.equals((Object)this.chargeType, (Object)task.chargeType) && Objects.equals(this.estimateMinutes, task.estimateMinutes) && Objects.equals(this.projectId, task.projectId) && Objects.equals(this.totalMinutes, task.totalMinutes) && Objects.equals(this.totalAmount, task.totalAmount) && Objects.equals(this.minutesInvoiced, task.minutesInvoiced) && Objects.equals(this.minutesToBeInvoiced, task.minutesToBeInvoiced) && Objects.equals(this.fixedMinutes, task.fixedMinutes) && Objects.equals(this.nonChargeableMinutes, task.nonChargeableMinutes) && Objects.equals(this.amountToBeInvoiced, task.amountToBeInvoiced) && Objects.equals(this.amountInvoiced, task.amountInvoiced) && Objects.equals((Object)this.status, (Object)task.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.taskId, this.name, this.rate, this.chargeType, this.estimateMinutes, this.projectId, this.totalMinutes, this.totalAmount, this.minutesInvoiced, this.minutesToBeInvoiced, this.fixedMinutes, this.nonChargeableMinutes, this.amountToBeInvoiced, this.amountInvoiced, this.status});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Task {\n");
        sb.append("    taskId: ").append(this.toIndentedString(this.taskId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    rate: ").append(this.toIndentedString(this.rate)).append("\n");
        sb.append("    chargeType: ").append(this.toIndentedString((Object)this.chargeType)).append("\n");
        sb.append("    estimateMinutes: ").append(this.toIndentedString(this.estimateMinutes)).append("\n");
        sb.append("    projectId: ").append(this.toIndentedString(this.projectId)).append("\n");
        sb.append("    totalMinutes: ").append(this.toIndentedString(this.totalMinutes)).append("\n");
        sb.append("    totalAmount: ").append(this.toIndentedString(this.totalAmount)).append("\n");
        sb.append("    minutesInvoiced: ").append(this.toIndentedString(this.minutesInvoiced)).append("\n");
        sb.append("    minutesToBeInvoiced: ").append(this.toIndentedString(this.minutesToBeInvoiced)).append("\n");
        sb.append("    fixedMinutes: ").append(this.toIndentedString(this.fixedMinutes)).append("\n");
        sb.append("    nonChargeableMinutes: ").append(this.toIndentedString(this.nonChargeableMinutes)).append("\n");
        sb.append("    amountToBeInvoiced: ").append(this.toIndentedString(this.amountToBeInvoiced)).append("\n");
        sb.append("    amountInvoiced: ").append(this.toIndentedString(this.amountInvoiced)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        ACTIVE("ACTIVE"),
        INVOICED("INVOICED"),
        LOCKED("LOCKED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

