/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.project;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.OffsetDateTime;

public class TimeEntryCreateOrUpdate {
    StringUtil util = new StringUtil();
    @JsonProperty(value="userId")
    private UUID userId;
    @JsonProperty(value="taskId")
    private UUID taskId;
    @JsonProperty(value="dateUtc")
    private OffsetDateTime dateUtc;
    @JsonProperty(value="duration")
    private Integer duration;
    @JsonProperty(value="description")
    private String description;

    public TimeEntryCreateOrUpdate userId(UUID userId) {
        this.userId = userId;
        return this;
    }

    @ApiModelProperty(example="00000000-0000-0000-0000-000000000000", required=true, value="The xero user identifier of the person logging the time.")
    public UUID getUserId() {
        return this.userId;
    }

    public void setUserId(UUID userId) {
        this.userId = userId;
    }

    public TimeEntryCreateOrUpdate taskId(UUID taskId) {
        this.taskId = taskId;
        return this;
    }

    @ApiModelProperty(example="00000000-0000-0000-0000-000000000000", required=true, value="Identifier of the task that time entry is logged against.")
    public UUID getTaskId() {
        return this.taskId;
    }

    public void setTaskId(UUID taskId) {
        this.taskId = taskId;
    }

    public TimeEntryCreateOrUpdate dateUtc(OffsetDateTime dateUtc) {
        this.dateUtc = dateUtc;
        return this;
    }

    @ApiModelProperty(required=true, value="Date time entry is logged on. UTC Date Time in ISO-8601 format.")
    public OffsetDateTime getDateUtc() {
        return this.dateUtc;
    }

    public void setDateUtc(OffsetDateTime dateUtc) {
        this.dateUtc = dateUtc;
    }

    public TimeEntryCreateOrUpdate duration(Integer duration) {
        this.duration = duration;
        return this;
    }

    @ApiModelProperty(required=true, value="Number of minutes to be logged. Duration is between 1 and 59940 inclusively.")
    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public TimeEntryCreateOrUpdate description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="An optional description of the time entry, will be set to null if not provided during update.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeEntryCreateOrUpdate timeEntryCreateOrUpdate = (TimeEntryCreateOrUpdate)o;
        return Objects.equals(this.userId, timeEntryCreateOrUpdate.userId) && Objects.equals(this.taskId, timeEntryCreateOrUpdate.taskId) && Objects.equals(this.dateUtc, timeEntryCreateOrUpdate.dateUtc) && Objects.equals(this.duration, timeEntryCreateOrUpdate.duration) && Objects.equals(this.description, timeEntryCreateOrUpdate.description);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.taskId, this.dateUtc, this.duration, this.description);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TimeEntryCreateOrUpdate {\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    taskId: ").append(this.toIndentedString(this.taskId)).append("\n");
        sb.append("    dateUtc: ").append(this.toIndentedString(this.dateUtc)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

