/*
 * Xero Accounting API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

/** ExpenseClaim */
public class ExpenseClaim {
  StringUtil util = new StringUtil();

  @JsonProperty("ExpenseClaimID")
  private UUID expenseClaimID;
  /** Current status of an expense claim – see status types */
  public enum StatusEnum {
    /** SUBMITTED */
    SUBMITTED("SUBMITTED"),

    /** AUTHORISED */
    AUTHORISED("AUTHORISED"),

    /** PAID */
    PAID("PAID"),

    /** VOIDED */
    VOIDED("VOIDED"),

    /** DELETED */
    DELETED("DELETED");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    /**
     * getValue
     *
     * @return String value
     */
    @JsonValue
    public String getValue() {
      return value;
    }

    /**
     * toString
     *
     * @return String value
     */
    @Override
    public String toString() {
      return String.valueOf(value);
    }

    /**
     * fromValue
     *
     * @param value String
     */
    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("Status")
  private StatusEnum status;

  @JsonProperty("Payments")
  private List<Payment> payments = new ArrayList<Payment>();

  @JsonProperty("User")
  private User user;

  @JsonProperty("Receipts")
  private List<Receipt> receipts = new ArrayList<Receipt>();

  @JsonProperty("UpdatedDateUTC")
  private String updatedDateUTC;

  @JsonProperty("Total")
  private Double total;

  @JsonProperty("AmountDue")
  private Double amountDue;

  @JsonProperty("AmountPaid")
  private Double amountPaid;

  @JsonProperty("PaymentDueDate")
  private String paymentDueDate;

  @JsonProperty("ReportingDate")
  private String reportingDate;

  @JsonProperty("ReceiptID")
  private UUID receiptID;
  /**
   * Xero generated unique identifier for an expense claim
   *
   * @param expenseClaimID UUID
   * @return ExpenseClaim
   */
  public ExpenseClaim expenseClaimID(UUID expenseClaimID) {
    this.expenseClaimID = expenseClaimID;
    return this;
  }

  /**
   * Xero generated unique identifier for an expense claim
   *
   * @return expenseClaimID
   */
  @ApiModelProperty(value = "Xero generated unique identifier for an expense claim")
  /**
   * Xero generated unique identifier for an expense claim
   *
   * @return expenseClaimID UUID
   */
  public UUID getExpenseClaimID() {
    return expenseClaimID;
  }

  /**
   * Xero generated unique identifier for an expense claim
   *
   * @param expenseClaimID UUID
   */
  public void setExpenseClaimID(UUID expenseClaimID) {
    this.expenseClaimID = expenseClaimID;
  }

  /**
   * Current status of an expense claim – see status types
   *
   * @param status StatusEnum
   * @return ExpenseClaim
   */
  public ExpenseClaim status(StatusEnum status) {
    this.status = status;
    return this;
  }

  /**
   * Current status of an expense claim – see status types
   *
   * @return status
   */
  @ApiModelProperty(value = "Current status of an expense claim – see status types")
  /**
   * Current status of an expense claim – see status types
   *
   * @return status StatusEnum
   */
  public StatusEnum getStatus() {
    return status;
  }

  /**
   * Current status of an expense claim – see status types
   *
   * @param status StatusEnum
   */
  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  /**
   * See Payments
   *
   * @param payments List&lt;Payment&gt;
   * @return ExpenseClaim
   */
  public ExpenseClaim payments(List<Payment> payments) {
    this.payments = payments;
    return this;
  }

  /**
   * See Payments
   *
   * @param paymentsItem Payment
   * @return ExpenseClaim
   */
  public ExpenseClaim addPaymentsItem(Payment paymentsItem) {
    if (this.payments == null) {
      this.payments = new ArrayList<Payment>();
    }
    this.payments.add(paymentsItem);
    return this;
  }

  /**
   * See Payments
   *
   * @return payments
   */
  @ApiModelProperty(value = "See Payments")
  /**
   * See Payments
   *
   * @return payments List<Payment>
   */
  public List<Payment> getPayments() {
    return payments;
  }

  /**
   * See Payments
   *
   * @param payments List&lt;Payment&gt;
   */
  public void setPayments(List<Payment> payments) {
    this.payments = payments;
  }

  /**
   * user
   *
   * @param user User
   * @return ExpenseClaim
   */
  public ExpenseClaim user(User user) {
    this.user = user;
    return this;
  }

  /**
   * Get user
   *
   * @return user
   */
  @ApiModelProperty(value = "")
  /**
   * user
   *
   * @return user User
   */
  public User getUser() {
    return user;
  }

  /**
   * user
   *
   * @param user User
   */
  public void setUser(User user) {
    this.user = user;
  }

  /**
   * receipts
   *
   * @param receipts List&lt;Receipt&gt;
   * @return ExpenseClaim
   */
  public ExpenseClaim receipts(List<Receipt> receipts) {
    this.receipts = receipts;
    return this;
  }

  /**
   * receipts
   *
   * @param receiptsItem Receipt
   * @return ExpenseClaim
   */
  public ExpenseClaim addReceiptsItem(Receipt receiptsItem) {
    if (this.receipts == null) {
      this.receipts = new ArrayList<Receipt>();
    }
    this.receipts.add(receiptsItem);
    return this;
  }

  /**
   * Get receipts
   *
   * @return receipts
   */
  @ApiModelProperty(value = "")
  /**
   * receipts
   *
   * @return receipts List<Receipt>
   */
  public List<Receipt> getReceipts() {
    return receipts;
  }

  /**
   * receipts
   *
   * @param receipts List&lt;Receipt&gt;
   */
  public void setReceipts(List<Receipt> receipts) {
    this.receipts = receipts;
  }

  /**
   * Last modified date UTC format
   *
   * @return updatedDateUTC
   */
  @ApiModelProperty(example = "/Date(1573755038314)/", value = "Last modified date UTC format")
  /**
   * Last modified date UTC format
   *
   * @return updatedDateUTC String
   */
  public String getUpdatedDateUTC() {
    return updatedDateUTC;
  }
  /**
   * Last modified date UTC format
   *
   * @return OffsetDateTime
   */
  public OffsetDateTime getUpdatedDateUTCAsDate() {
    if (this.updatedDateUTC != null) {
      try {
        return util.convertStringToOffsetDateTime(this.updatedDateUTC);
      } catch (IOException e) {
        e.printStackTrace();
      }
    }
    return null;
  }

  /**
   * The total of an expense claim being paid
   *
   * @return total
   */
  @ApiModelProperty(value = "The total of an expense claim being paid")
  /**
   * The total of an expense claim being paid
   *
   * @return total Double
   */
  public Double getTotal() {
    return total;
  }

  /**
   * The amount due to be paid for an expense claim
   *
   * @return amountDue
   */
  @ApiModelProperty(value = "The amount due to be paid for an expense claim")
  /**
   * The amount due to be paid for an expense claim
   *
   * @return amountDue Double
   */
  public Double getAmountDue() {
    return amountDue;
  }

  /**
   * The amount still to pay for an expense claim
   *
   * @return amountPaid
   */
  @ApiModelProperty(value = "The amount still to pay for an expense claim")
  /**
   * The amount still to pay for an expense claim
   *
   * @return amountPaid Double
   */
  public Double getAmountPaid() {
    return amountPaid;
  }

  /**
   * The date when the expense claim is due to be paid YYYY-MM-DD
   *
   * @return paymentDueDate
   */
  @ApiModelProperty(value = "The date when the expense claim is due to be paid YYYY-MM-DD")
  /**
   * The date when the expense claim is due to be paid YYYY-MM-DD
   *
   * @return paymentDueDate String
   */
  public String getPaymentDueDate() {
    return paymentDueDate;
  }
  /**
   * The date when the expense claim is due to be paid YYYY-MM-DD
   *
   * @return LocalDate
   */
  public LocalDate getPaymentDueDateAsDate() {
    if (this.paymentDueDate != null) {
      try {
        return util.convertStringToDate(this.paymentDueDate);
      } catch (IOException e) {
        e.printStackTrace();
      }
    }
    return null;
  }

  /**
   * The date the expense claim will be reported in Xero YYYY-MM-DD
   *
   * @return reportingDate
   */
  @ApiModelProperty(value = "The date the expense claim will be reported in Xero YYYY-MM-DD")
  /**
   * The date the expense claim will be reported in Xero YYYY-MM-DD
   *
   * @return reportingDate String
   */
  public String getReportingDate() {
    return reportingDate;
  }
  /**
   * The date the expense claim will be reported in Xero YYYY-MM-DD
   *
   * @return LocalDate
   */
  public LocalDate getReportingDateAsDate() {
    if (this.reportingDate != null) {
      try {
        return util.convertStringToDate(this.reportingDate);
      } catch (IOException e) {
        e.printStackTrace();
      }
    }
    return null;
  }

  /**
   * The Xero identifier for the Receipt e.g. e59a2c7f-1306-4078-a0f3-73537afcbba9
   *
   * @param receiptID UUID
   * @return ExpenseClaim
   */
  public ExpenseClaim receiptID(UUID receiptID) {
    this.receiptID = receiptID;
    return this;
  }

  /**
   * The Xero identifier for the Receipt e.g. e59a2c7f-1306-4078-a0f3-73537afcbba9
   *
   * @return receiptID
   */
  @ApiModelProperty(
      value = "The Xero identifier for the Receipt e.g. e59a2c7f-1306-4078-a0f3-73537afcbba9")
  /**
   * The Xero identifier for the Receipt e.g. e59a2c7f-1306-4078-a0f3-73537afcbba9
   *
   * @return receiptID UUID
   */
  public UUID getReceiptID() {
    return receiptID;
  }

  /**
   * The Xero identifier for the Receipt e.g. e59a2c7f-1306-4078-a0f3-73537afcbba9
   *
   * @param receiptID UUID
   */
  public void setReceiptID(UUID receiptID) {
    this.receiptID = receiptID;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ExpenseClaim expenseClaim = (ExpenseClaim) o;
    return Objects.equals(this.expenseClaimID, expenseClaim.expenseClaimID)
        && Objects.equals(this.status, expenseClaim.status)
        && Objects.equals(this.payments, expenseClaim.payments)
        && Objects.equals(this.user, expenseClaim.user)
        && Objects.equals(this.receipts, expenseClaim.receipts)
        && Objects.equals(this.updatedDateUTC, expenseClaim.updatedDateUTC)
        && Objects.equals(this.total, expenseClaim.total)
        && Objects.equals(this.amountDue, expenseClaim.amountDue)
        && Objects.equals(this.amountPaid, expenseClaim.amountPaid)
        && Objects.equals(this.paymentDueDate, expenseClaim.paymentDueDate)
        && Objects.equals(this.reportingDate, expenseClaim.reportingDate)
        && Objects.equals(this.receiptID, expenseClaim.receiptID);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        expenseClaimID,
        status,
        payments,
        user,
        receipts,
        updatedDateUTC,
        total,
        amountDue,
        amountPaid,
        paymentDueDate,
        reportingDate,
        receiptID);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ExpenseClaim {\n");
    sb.append("    expenseClaimID: ").append(toIndentedString(expenseClaimID)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    payments: ").append(toIndentedString(payments)).append("\n");
    sb.append("    user: ").append(toIndentedString(user)).append("\n");
    sb.append("    receipts: ").append(toIndentedString(receipts)).append("\n");
    sb.append("    updatedDateUTC: ").append(toIndentedString(updatedDateUTC)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    amountDue: ").append(toIndentedString(amountDue)).append("\n");
    sb.append("    amountPaid: ").append(toIndentedString(amountPaid)).append("\n");
    sb.append("    paymentDueDate: ").append(toIndentedString(paymentDueDate)).append("\n");
    sb.append("    reportingDate: ").append(toIndentedString(reportingDate)).append("\n");
    sb.append("    receiptID: ").append(toIndentedString(receiptID)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
