/*
 * Xero Finance API
 * The Finance API is a collection of endpoints which customers can use in the course of a loan application, which may assist lenders to gain the confidence they need to provide capital.
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.finance;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.threeten.bp.LocalDate;

/** ProfitAndLossResponse */
public class ProfitAndLossResponse {
  StringUtil util = new StringUtil();

  @JsonProperty("startDate")
  private LocalDate startDate;

  @JsonProperty("endDate")
  private LocalDate endDate;

  @JsonProperty("netProfitLoss")
  private Double netProfitLoss;

  @JsonProperty("revenue")
  private PnlAccountClass revenue;

  @JsonProperty("expense")
  private PnlAccountClass expense;
  /**
   * Start date of the report
   *
   * @param startDate LocalDate
   * @return ProfitAndLossResponse
   */
  public ProfitAndLossResponse startDate(LocalDate startDate) {
    this.startDate = startDate;
    return this;
  }

  /**
   * Start date of the report
   *
   * @return startDate
   */
  @ApiModelProperty(value = "Start date of the report")
  /**
   * Start date of the report
   *
   * @return startDate LocalDate
   */
  public LocalDate getStartDate() {
    return startDate;
  }

  /**
   * Start date of the report
   *
   * @param startDate LocalDate
   */
  public void setStartDate(LocalDate startDate) {
    this.startDate = startDate;
  }

  /**
   * End date of the report
   *
   * @param endDate LocalDate
   * @return ProfitAndLossResponse
   */
  public ProfitAndLossResponse endDate(LocalDate endDate) {
    this.endDate = endDate;
    return this;
  }

  /**
   * End date of the report
   *
   * @return endDate
   */
  @ApiModelProperty(value = "End date of the report")
  /**
   * End date of the report
   *
   * @return endDate LocalDate
   */
  public LocalDate getEndDate() {
    return endDate;
  }

  /**
   * End date of the report
   *
   * @param endDate LocalDate
   */
  public void setEndDate(LocalDate endDate) {
    this.endDate = endDate;
  }

  /**
   * Net profit loss value
   *
   * @param netProfitLoss Double
   * @return ProfitAndLossResponse
   */
  public ProfitAndLossResponse netProfitLoss(Double netProfitLoss) {
    this.netProfitLoss = netProfitLoss;
    return this;
  }

  /**
   * Net profit loss value
   *
   * @return netProfitLoss
   */
  @ApiModelProperty(value = "Net profit loss value")
  /**
   * Net profit loss value
   *
   * @return netProfitLoss Double
   */
  public Double getNetProfitLoss() {
    return netProfitLoss;
  }

  /**
   * Net profit loss value
   *
   * @param netProfitLoss Double
   */
  public void setNetProfitLoss(Double netProfitLoss) {
    this.netProfitLoss = netProfitLoss;
  }

  /**
   * revenue
   *
   * @param revenue PnlAccountClass
   * @return ProfitAndLossResponse
   */
  public ProfitAndLossResponse revenue(PnlAccountClass revenue) {
    this.revenue = revenue;
    return this;
  }

  /**
   * Get revenue
   *
   * @return revenue
   */
  @ApiModelProperty(value = "")
  /**
   * revenue
   *
   * @return revenue PnlAccountClass
   */
  public PnlAccountClass getRevenue() {
    return revenue;
  }

  /**
   * revenue
   *
   * @param revenue PnlAccountClass
   */
  public void setRevenue(PnlAccountClass revenue) {
    this.revenue = revenue;
  }

  /**
   * expense
   *
   * @param expense PnlAccountClass
   * @return ProfitAndLossResponse
   */
  public ProfitAndLossResponse expense(PnlAccountClass expense) {
    this.expense = expense;
    return this;
  }

  /**
   * Get expense
   *
   * @return expense
   */
  @ApiModelProperty(value = "")
  /**
   * expense
   *
   * @return expense PnlAccountClass
   */
  public PnlAccountClass getExpense() {
    return expense;
  }

  /**
   * expense
   *
   * @param expense PnlAccountClass
   */
  public void setExpense(PnlAccountClass expense) {
    this.expense = expense;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProfitAndLossResponse profitAndLossResponse = (ProfitAndLossResponse) o;
    return Objects.equals(this.startDate, profitAndLossResponse.startDate)
        && Objects.equals(this.endDate, profitAndLossResponse.endDate)
        && Objects.equals(this.netProfitLoss, profitAndLossResponse.netProfitLoss)
        && Objects.equals(this.revenue, profitAndLossResponse.revenue)
        && Objects.equals(this.expense, profitAndLossResponse.expense);
  }

  @Override
  public int hashCode() {
    return Objects.hash(startDate, endDate, netProfitLoss, revenue, expense);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProfitAndLossResponse {\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    netProfitLoss: ").append(toIndentedString(netProfitLoss)).append("\n");
    sb.append("    revenue: ").append(toIndentedString(revenue)).append("\n");
    sb.append("    expense: ").append(toIndentedString(expense)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
