/*
 * Xero Finance API
 * The Finance API is a collection of endpoints which customers can use in the course of a loan application, which may assist lenders to gain the confidence they need to provide capital.
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.finance;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/** TrialBalanceMovement */
public class TrialBalanceMovement {
  StringUtil util = new StringUtil();

  @JsonProperty("debits")
  private Double debits;

  @JsonProperty("credits")
  private Double credits;

  @JsonProperty("movement")
  private TrialBalanceEntry movement;

  @JsonProperty("signedMovement")
  private Double signedMovement;
  /**
   * Debit amount
   *
   * @param debits Double
   * @return TrialBalanceMovement
   */
  public TrialBalanceMovement debits(Double debits) {
    this.debits = debits;
    return this;
  }

  /**
   * Debit amount
   *
   * @return debits
   */
  @ApiModelProperty(value = "Debit amount")
  /**
   * Debit amount
   *
   * @return debits Double
   */
  public Double getDebits() {
    return debits;
  }

  /**
   * Debit amount
   *
   * @param debits Double
   */
  public void setDebits(Double debits) {
    this.debits = debits;
  }

  /**
   * Credit amount
   *
   * @param credits Double
   * @return TrialBalanceMovement
   */
  public TrialBalanceMovement credits(Double credits) {
    this.credits = credits;
    return this;
  }

  /**
   * Credit amount
   *
   * @return credits
   */
  @ApiModelProperty(value = "Credit amount")
  /**
   * Credit amount
   *
   * @return credits Double
   */
  public Double getCredits() {
    return credits;
  }

  /**
   * Credit amount
   *
   * @param credits Double
   */
  public void setCredits(Double credits) {
    this.credits = credits;
  }

  /**
   * movement
   *
   * @param movement TrialBalanceEntry
   * @return TrialBalanceMovement
   */
  public TrialBalanceMovement movement(TrialBalanceEntry movement) {
    this.movement = movement;
    return this;
  }

  /**
   * Get movement
   *
   * @return movement
   */
  @ApiModelProperty(value = "")
  /**
   * movement
   *
   * @return movement TrialBalanceEntry
   */
  public TrialBalanceEntry getMovement() {
    return movement;
  }

  /**
   * movement
   *
   * @param movement TrialBalanceEntry
   */
  public void setMovement(TrialBalanceEntry movement) {
    this.movement = movement;
  }

  /**
   * Value of movement. Expense and Asset accounts code debits as positive. Revenue, Liability, and
   * Equity accounts code debits as negative
   *
   * @param signedMovement Double
   * @return TrialBalanceMovement
   */
  public TrialBalanceMovement signedMovement(Double signedMovement) {
    this.signedMovement = signedMovement;
    return this;
  }

  /**
   * Value of movement. Expense and Asset accounts code debits as positive. Revenue, Liability, and
   * Equity accounts code debits as negative
   *
   * @return signedMovement
   */
  @ApiModelProperty(
      value =
          "Value of movement. Expense and Asset accounts code debits as positive. Revenue,"
              + " Liability, and Equity accounts code debits as negative")
  /**
   * Value of movement. Expense and Asset accounts code debits as positive. Revenue, Liability, and
   * Equity accounts code debits as negative
   *
   * @return signedMovement Double
   */
  public Double getSignedMovement() {
    return signedMovement;
  }

  /**
   * Value of movement. Expense and Asset accounts code debits as positive. Revenue, Liability, and
   * Equity accounts code debits as negative
   *
   * @param signedMovement Double
   */
  public void setSignedMovement(Double signedMovement) {
    this.signedMovement = signedMovement;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TrialBalanceMovement trialBalanceMovement = (TrialBalanceMovement) o;
    return Objects.equals(this.debits, trialBalanceMovement.debits)
        && Objects.equals(this.credits, trialBalanceMovement.credits)
        && Objects.equals(this.movement, trialBalanceMovement.movement)
        && Objects.equals(this.signedMovement, trialBalanceMovement.signedMovement);
  }

  @Override
  public int hashCode() {
    return Objects.hash(debits, credits, movement, signedMovement);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TrialBalanceMovement {\n");
    sb.append("    debits: ").append(toIndentedString(debits)).append("\n");
    sb.append("    credits: ").append(toIndentedString(credits)).append("\n");
    sb.append("    movement: ").append(toIndentedString(movement)).append("\n");
    sb.append("    signedMovement: ").append(toIndentedString(signedMovement)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
