/*
 * Xero OAuth 2 Identity Service API
 * These endpoints are related to managing authentication tokens and identity for Xero API
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.identity;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/** AccessToken */
public class AccessToken {
  StringUtil util = new StringUtil();

  @JsonProperty("id_token")
  private String idToken;

  @JsonProperty("access_token")
  private String accessToken;

  @JsonProperty("expires_in")
  private Long expiresIn;

  @JsonProperty("token_type")
  private String tokenType;

  @JsonProperty("refresh_token")
  private String refreshToken;
  /**
   * Xero unique identifier
   *
   * @param idToken String
   * @return AccessToken
   */
  public AccessToken idToken(String idToken) {
    this.idToken = idToken;
    return this;
  }

  /**
   * Xero unique identifier
   *
   * @return idToken
   */
  @ApiModelProperty(value = "Xero unique identifier")
  /**
   * Xero unique identifier
   *
   * @return idToken String
   */
  public String getIdToken() {
    return idToken;
  }

  /**
   * Xero unique identifier
   *
   * @param idToken String
   */
  public void setIdToken(String idToken) {
    this.idToken = idToken;
  }

  /**
   * access token provided during authentication flow
   *
   * @param accessToken String
   * @return AccessToken
   */
  public AccessToken accessToken(String accessToken) {
    this.accessToken = accessToken;
    return this;
  }

  /**
   * access token provided during authentication flow
   *
   * @return accessToken
   */
  @ApiModelProperty(value = "access token provided during authentication flow")
  /**
   * access token provided during authentication flow
   *
   * @return accessToken String
   */
  public String getAccessToken() {
    return accessToken;
  }

  /**
   * access token provided during authentication flow
   *
   * @param accessToken String
   */
  public void setAccessToken(String accessToken) {
    this.accessToken = accessToken;
  }

  /**
   * time in seconds until access token expires.
   *
   * @param expiresIn Long
   * @return AccessToken
   */
  public AccessToken expiresIn(Long expiresIn) {
    this.expiresIn = expiresIn;
    return this;
  }

  /**
   * time in seconds until access token expires.
   *
   * @return expiresIn
   */
  @ApiModelProperty(value = "time in seconds until access token expires.")
  /**
   * time in seconds until access token expires.
   *
   * @return expiresIn Long
   */
  public Long getExpiresIn() {
    return expiresIn;
  }

  /**
   * time in seconds until access token expires.
   *
   * @param expiresIn Long
   */
  public void setExpiresIn(Long expiresIn) {
    this.expiresIn = expiresIn;
  }

  /**
   * type of token i.e. Bearer
   *
   * @param tokenType String
   * @return AccessToken
   */
  public AccessToken tokenType(String tokenType) {
    this.tokenType = tokenType;
    return this;
  }

  /**
   * type of token i.e. Bearer
   *
   * @return tokenType
   */
  @ApiModelProperty(value = "type of token i.e. Bearer")
  /**
   * type of token i.e. Bearer
   *
   * @return tokenType String
   */
  public String getTokenType() {
    return tokenType;
  }

  /**
   * type of token i.e. Bearer
   *
   * @param tokenType String
   */
  public void setTokenType(String tokenType) {
    this.tokenType = tokenType;
  }

  /**
   * token used to refresh an expired access token
   *
   * @param refreshToken String
   * @return AccessToken
   */
  public AccessToken refreshToken(String refreshToken) {
    this.refreshToken = refreshToken;
    return this;
  }

  /**
   * token used to refresh an expired access token
   *
   * @return refreshToken
   */
  @ApiModelProperty(value = "token used to refresh an expired access token")
  /**
   * token used to refresh an expired access token
   *
   * @return refreshToken String
   */
  public String getRefreshToken() {
    return refreshToken;
  }

  /**
   * token used to refresh an expired access token
   *
   * @param refreshToken String
   */
  public void setRefreshToken(String refreshToken) {
    this.refreshToken = refreshToken;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AccessToken accessToken = (AccessToken) o;
    return Objects.equals(this.idToken, accessToken.idToken)
        && Objects.equals(this.accessToken, accessToken.accessToken)
        && Objects.equals(this.expiresIn, accessToken.expiresIn)
        && Objects.equals(this.tokenType, accessToken.tokenType)
        && Objects.equals(this.refreshToken, accessToken.refreshToken);
  }

  @Override
  public int hashCode() {
    return Objects.hash(idToken, accessToken, expiresIn, tokenType, refreshToken);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AccessToken {\n");
    sb.append("    idToken: ").append(toIndentedString(idToken)).append("\n");
    sb.append("    accessToken: ").append(toIndentedString(accessToken)).append("\n");
    sb.append("    expiresIn: ").append(toIndentedString(expiresIn)).append("\n");
    sb.append("    tokenType: ").append(toIndentedString(tokenType)).append("\n");
    sb.append("    refreshToken: ").append(toIndentedString(refreshToken)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
