/*
 * Xero Payroll UK
 * This is the Xero Payroll API for orgs in the UK region.
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.payrolluk;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.LocalDate;

/** PayRun */
public class PayRun {
  StringUtil util = new StringUtil();

  @JsonProperty("payRunID")
  private UUID payRunID;

  @JsonProperty("payrollCalendarID")
  private UUID payrollCalendarID;

  @JsonProperty("periodStartDate")
  private LocalDate periodStartDate;

  @JsonProperty("periodEndDate")
  private LocalDate periodEndDate;

  @JsonProperty("paymentDate")
  private LocalDate paymentDate;

  @JsonProperty("totalCost")
  private Double totalCost;

  @JsonProperty("totalPay")
  private Double totalPay;
  /** Pay run status */
  public enum PayRunStatusEnum {
    /** DRAFT */
    DRAFT("Draft"),

    /** POSTED */
    POSTED("Posted");

    private String value;

    PayRunStatusEnum(String value) {
      this.value = value;
    }

    /**
     * getValue
     *
     * @return String value
     */
    @JsonValue
    public String getValue() {
      return value;
    }

    /**
     * toString
     *
     * @return String value
     */
    @Override
    public String toString() {
      return String.valueOf(value);
    }

    /**
     * fromValue
     *
     * @param value String
     */
    @JsonCreator
    public static PayRunStatusEnum fromValue(String value) {
      for (PayRunStatusEnum b : PayRunStatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("payRunStatus")
  private PayRunStatusEnum payRunStatus;
  /** Pay run type */
  public enum PayRunTypeEnum {
    /** SCHEDULED */
    SCHEDULED("Scheduled"),

    /** UNSCHEDULED */
    UNSCHEDULED("Unscheduled"),

    /** EARLIERYEARUPDATE */
    EARLIERYEARUPDATE("EarlierYearUpdate");

    private String value;

    PayRunTypeEnum(String value) {
      this.value = value;
    }

    /**
     * getValue
     *
     * @return String value
     */
    @JsonValue
    public String getValue() {
      return value;
    }

    /**
     * toString
     *
     * @return String value
     */
    @Override
    public String toString() {
      return String.valueOf(value);
    }

    /**
     * fromValue
     *
     * @param value String
     */
    @JsonCreator
    public static PayRunTypeEnum fromValue(String value) {
      for (PayRunTypeEnum b : PayRunTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("payRunType")
  private PayRunTypeEnum payRunType;
  /** Calendar type of the pay run */
  public enum CalendarTypeEnum {
    /** WEEKLY */
    WEEKLY("Weekly"),

    /** FORTNIGHTLY */
    FORTNIGHTLY("Fortnightly"),

    /** FOURWEEKLY */
    FOURWEEKLY("FourWeekly"),

    /** MONTHLY */
    MONTHLY("Monthly"),

    /** ANNUAL */
    ANNUAL("Annual"),

    /** QUARTERLY */
    QUARTERLY("Quarterly");

    private String value;

    CalendarTypeEnum(String value) {
      this.value = value;
    }

    /**
     * getValue
     *
     * @return String value
     */
    @JsonValue
    public String getValue() {
      return value;
    }

    /**
     * toString
     *
     * @return String value
     */
    @Override
    public String toString() {
      return String.valueOf(value);
    }

    /**
     * fromValue
     *
     * @param value String
     */
    @JsonCreator
    public static CalendarTypeEnum fromValue(String value) {
      for (CalendarTypeEnum b : CalendarTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("calendarType")
  private CalendarTypeEnum calendarType;

  @JsonProperty("postedDateTime")
  private LocalDate postedDateTime;

  @JsonProperty("paySlips")
  private List<Payslip> paySlips = new ArrayList<Payslip>();
  /**
   * Xero unique identifier for the pay run
   *
   * @param payRunID UUID
   * @return PayRun
   */
  public PayRun payRunID(UUID payRunID) {
    this.payRunID = payRunID;
    return this;
  }

  /**
   * Xero unique identifier for the pay run
   *
   * @return payRunID
   */
  @ApiModelProperty(value = "Xero unique identifier for the pay run")
  /**
   * Xero unique identifier for the pay run
   *
   * @return payRunID UUID
   */
  public UUID getPayRunID() {
    return payRunID;
  }

  /**
   * Xero unique identifier for the pay run
   *
   * @param payRunID UUID
   */
  public void setPayRunID(UUID payRunID) {
    this.payRunID = payRunID;
  }

  /**
   * Xero unique identifier for the payroll calendar
   *
   * @param payrollCalendarID UUID
   * @return PayRun
   */
  public PayRun payrollCalendarID(UUID payrollCalendarID) {
    this.payrollCalendarID = payrollCalendarID;
    return this;
  }

  /**
   * Xero unique identifier for the payroll calendar
   *
   * @return payrollCalendarID
   */
  @ApiModelProperty(value = "Xero unique identifier for the payroll calendar")
  /**
   * Xero unique identifier for the payroll calendar
   *
   * @return payrollCalendarID UUID
   */
  public UUID getPayrollCalendarID() {
    return payrollCalendarID;
  }

  /**
   * Xero unique identifier for the payroll calendar
   *
   * @param payrollCalendarID UUID
   */
  public void setPayrollCalendarID(UUID payrollCalendarID) {
    this.payrollCalendarID = payrollCalendarID;
  }

  /**
   * Period start date of the payroll calendar
   *
   * @param periodStartDate LocalDate
   * @return PayRun
   */
  public PayRun periodStartDate(LocalDate periodStartDate) {
    this.periodStartDate = periodStartDate;
    return this;
  }

  /**
   * Period start date of the payroll calendar
   *
   * @return periodStartDate
   */
  @ApiModelProperty(value = "Period start date of the payroll calendar")
  /**
   * Period start date of the payroll calendar
   *
   * @return periodStartDate LocalDate
   */
  public LocalDate getPeriodStartDate() {
    return periodStartDate;
  }

  /**
   * Period start date of the payroll calendar
   *
   * @param periodStartDate LocalDate
   */
  public void setPeriodStartDate(LocalDate periodStartDate) {
    this.periodStartDate = periodStartDate;
  }

  /**
   * Period end date of the payroll calendar
   *
   * @param periodEndDate LocalDate
   * @return PayRun
   */
  public PayRun periodEndDate(LocalDate periodEndDate) {
    this.periodEndDate = periodEndDate;
    return this;
  }

  /**
   * Period end date of the payroll calendar
   *
   * @return periodEndDate
   */
  @ApiModelProperty(value = "Period end date of the payroll calendar")
  /**
   * Period end date of the payroll calendar
   *
   * @return periodEndDate LocalDate
   */
  public LocalDate getPeriodEndDate() {
    return periodEndDate;
  }

  /**
   * Period end date of the payroll calendar
   *
   * @param periodEndDate LocalDate
   */
  public void setPeriodEndDate(LocalDate periodEndDate) {
    this.periodEndDate = periodEndDate;
  }

  /**
   * Payment date of the pay run
   *
   * @param paymentDate LocalDate
   * @return PayRun
   */
  public PayRun paymentDate(LocalDate paymentDate) {
    this.paymentDate = paymentDate;
    return this;
  }

  /**
   * Payment date of the pay run
   *
   * @return paymentDate
   */
  @ApiModelProperty(value = "Payment date of the pay run")
  /**
   * Payment date of the pay run
   *
   * @return paymentDate LocalDate
   */
  public LocalDate getPaymentDate() {
    return paymentDate;
  }

  /**
   * Payment date of the pay run
   *
   * @param paymentDate LocalDate
   */
  public void setPaymentDate(LocalDate paymentDate) {
    this.paymentDate = paymentDate;
  }

  /**
   * Total cost of the pay run
   *
   * @param totalCost Double
   * @return PayRun
   */
  public PayRun totalCost(Double totalCost) {
    this.totalCost = totalCost;
    return this;
  }

  /**
   * Total cost of the pay run
   *
   * @return totalCost
   */
  @ApiModelProperty(value = "Total cost of the pay run")
  /**
   * Total cost of the pay run
   *
   * @return totalCost Double
   */
  public Double getTotalCost() {
    return totalCost;
  }

  /**
   * Total cost of the pay run
   *
   * @param totalCost Double
   */
  public void setTotalCost(Double totalCost) {
    this.totalCost = totalCost;
  }

  /**
   * Total pay of the pay run
   *
   * @param totalPay Double
   * @return PayRun
   */
  public PayRun totalPay(Double totalPay) {
    this.totalPay = totalPay;
    return this;
  }

  /**
   * Total pay of the pay run
   *
   * @return totalPay
   */
  @ApiModelProperty(value = "Total pay of the pay run")
  /**
   * Total pay of the pay run
   *
   * @return totalPay Double
   */
  public Double getTotalPay() {
    return totalPay;
  }

  /**
   * Total pay of the pay run
   *
   * @param totalPay Double
   */
  public void setTotalPay(Double totalPay) {
    this.totalPay = totalPay;
  }

  /**
   * Pay run status
   *
   * @param payRunStatus PayRunStatusEnum
   * @return PayRun
   */
  public PayRun payRunStatus(PayRunStatusEnum payRunStatus) {
    this.payRunStatus = payRunStatus;
    return this;
  }

  /**
   * Pay run status
   *
   * @return payRunStatus
   */
  @ApiModelProperty(value = "Pay run status")
  /**
   * Pay run status
   *
   * @return payRunStatus PayRunStatusEnum
   */
  public PayRunStatusEnum getPayRunStatus() {
    return payRunStatus;
  }

  /**
   * Pay run status
   *
   * @param payRunStatus PayRunStatusEnum
   */
  public void setPayRunStatus(PayRunStatusEnum payRunStatus) {
    this.payRunStatus = payRunStatus;
  }

  /**
   * Pay run type
   *
   * @param payRunType PayRunTypeEnum
   * @return PayRun
   */
  public PayRun payRunType(PayRunTypeEnum payRunType) {
    this.payRunType = payRunType;
    return this;
  }

  /**
   * Pay run type
   *
   * @return payRunType
   */
  @ApiModelProperty(value = "Pay run type")
  /**
   * Pay run type
   *
   * @return payRunType PayRunTypeEnum
   */
  public PayRunTypeEnum getPayRunType() {
    return payRunType;
  }

  /**
   * Pay run type
   *
   * @param payRunType PayRunTypeEnum
   */
  public void setPayRunType(PayRunTypeEnum payRunType) {
    this.payRunType = payRunType;
  }

  /**
   * Calendar type of the pay run
   *
   * @param calendarType CalendarTypeEnum
   * @return PayRun
   */
  public PayRun calendarType(CalendarTypeEnum calendarType) {
    this.calendarType = calendarType;
    return this;
  }

  /**
   * Calendar type of the pay run
   *
   * @return calendarType
   */
  @ApiModelProperty(value = "Calendar type of the pay run")
  /**
   * Calendar type of the pay run
   *
   * @return calendarType CalendarTypeEnum
   */
  public CalendarTypeEnum getCalendarType() {
    return calendarType;
  }

  /**
   * Calendar type of the pay run
   *
   * @param calendarType CalendarTypeEnum
   */
  public void setCalendarType(CalendarTypeEnum calendarType) {
    this.calendarType = calendarType;
  }

  /**
   * Posted date time of the pay run
   *
   * @param postedDateTime LocalDate
   * @return PayRun
   */
  public PayRun postedDateTime(LocalDate postedDateTime) {
    this.postedDateTime = postedDateTime;
    return this;
  }

  /**
   * Posted date time of the pay run
   *
   * @return postedDateTime
   */
  @ApiModelProperty(value = "Posted date time of the pay run")
  /**
   * Posted date time of the pay run
   *
   * @return postedDateTime LocalDate
   */
  public LocalDate getPostedDateTime() {
    return postedDateTime;
  }

  /**
   * Posted date time of the pay run
   *
   * @param postedDateTime LocalDate
   */
  public void setPostedDateTime(LocalDate postedDateTime) {
    this.postedDateTime = postedDateTime;
  }

  /**
   * paySlips
   *
   * @param paySlips List&lt;Payslip&gt;
   * @return PayRun
   */
  public PayRun paySlips(List<Payslip> paySlips) {
    this.paySlips = paySlips;
    return this;
  }

  /**
   * paySlips
   *
   * @param paySlipsItem Payslip
   * @return PayRun
   */
  public PayRun addPaySlipsItem(Payslip paySlipsItem) {
    if (this.paySlips == null) {
      this.paySlips = new ArrayList<Payslip>();
    }
    this.paySlips.add(paySlipsItem);
    return this;
  }

  /**
   * Get paySlips
   *
   * @return paySlips
   */
  @ApiModelProperty(value = "")
  /**
   * paySlips
   *
   * @return paySlips List<Payslip>
   */
  public List<Payslip> getPaySlips() {
    return paySlips;
  }

  /**
   * paySlips
   *
   * @param paySlips List&lt;Payslip&gt;
   */
  public void setPaySlips(List<Payslip> paySlips) {
    this.paySlips = paySlips;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PayRun payRun = (PayRun) o;
    return Objects.equals(this.payRunID, payRun.payRunID)
        && Objects.equals(this.payrollCalendarID, payRun.payrollCalendarID)
        && Objects.equals(this.periodStartDate, payRun.periodStartDate)
        && Objects.equals(this.periodEndDate, payRun.periodEndDate)
        && Objects.equals(this.paymentDate, payRun.paymentDate)
        && Objects.equals(this.totalCost, payRun.totalCost)
        && Objects.equals(this.totalPay, payRun.totalPay)
        && Objects.equals(this.payRunStatus, payRun.payRunStatus)
        && Objects.equals(this.payRunType, payRun.payRunType)
        && Objects.equals(this.calendarType, payRun.calendarType)
        && Objects.equals(this.postedDateTime, payRun.postedDateTime)
        && Objects.equals(this.paySlips, payRun.paySlips);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        payRunID,
        payrollCalendarID,
        periodStartDate,
        periodEndDate,
        paymentDate,
        totalCost,
        totalPay,
        payRunStatus,
        payRunType,
        calendarType,
        postedDateTime,
        paySlips);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PayRun {\n");
    sb.append("    payRunID: ").append(toIndentedString(payRunID)).append("\n");
    sb.append("    payrollCalendarID: ").append(toIndentedString(payrollCalendarID)).append("\n");
    sb.append("    periodStartDate: ").append(toIndentedString(periodStartDate)).append("\n");
    sb.append("    periodEndDate: ").append(toIndentedString(periodEndDate)).append("\n");
    sb.append("    paymentDate: ").append(toIndentedString(paymentDate)).append("\n");
    sb.append("    totalCost: ").append(toIndentedString(totalCost)).append("\n");
    sb.append("    totalPay: ").append(toIndentedString(totalPay)).append("\n");
    sb.append("    payRunStatus: ").append(toIndentedString(payRunStatus)).append("\n");
    sb.append("    payRunType: ").append(toIndentedString(payRunType)).append("\n");
    sb.append("    calendarType: ").append(toIndentedString(calendarType)).append("\n");
    sb.append("    postedDateTime: ").append(toIndentedString(postedDateTime)).append("\n");
    sb.append("    paySlips: ").append(toIndentedString(paySlips)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
