/*
 * Xero Payroll UK
 * This is the Xero Payroll API for orgs in the UK region.
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.payrolluk;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.LocalDateTime;

/** Payslip */
public class Payslip {
  StringUtil util = new StringUtil();

  @JsonProperty("paySlipID")
  private UUID paySlipID;

  @JsonProperty("employeeID")
  private UUID employeeID;

  @JsonProperty("payRunID")
  private UUID payRunID;

  @JsonProperty("lastEdited")
  private LocalDateTime lastEdited;

  @JsonProperty("firstName")
  private String firstName;

  @JsonProperty("lastName")
  private String lastName;

  @JsonProperty("totalEarnings")
  private Double totalEarnings;

  @JsonProperty("grossEarnings")
  private Double grossEarnings;

  @JsonProperty("totalPay")
  private Double totalPay;

  @JsonProperty("totalEmployerTaxes")
  private Double totalEmployerTaxes;

  @JsonProperty("totalEmployeeTaxes")
  private Double totalEmployeeTaxes;

  @JsonProperty("totalDeductions")
  private Double totalDeductions;

  @JsonProperty("totalReimbursements")
  private Double totalReimbursements;

  @JsonProperty("totalCourtOrders")
  private Double totalCourtOrders;

  @JsonProperty("totalBenefits")
  private Double totalBenefits;

  @JsonProperty("bacsHash")
  private String bacsHash;
  /** The payment method code */
  public enum PaymentMethodEnum {
    /** CHEQUE */
    CHEQUE("Cheque"),

    /** ELECTRONICALLY */
    ELECTRONICALLY("Electronically"),

    /** MANUAL */
    MANUAL("Manual");

    private String value;

    PaymentMethodEnum(String value) {
      this.value = value;
    }

    /**
     * getValue
     *
     * @return String value
     */
    @JsonValue
    public String getValue() {
      return value;
    }

    /**
     * toString
     *
     * @return String value
     */
    @Override
    public String toString() {
      return String.valueOf(value);
    }

    /**
     * fromValue
     *
     * @param value String
     */
    @JsonCreator
    public static PaymentMethodEnum fromValue(String value) {
      for (PaymentMethodEnum b : PaymentMethodEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("paymentMethod")
  private PaymentMethodEnum paymentMethod;

  @JsonProperty("earningsLines")
  private List<EarningsLine> earningsLines = new ArrayList<EarningsLine>();

  @JsonProperty("leaveEarningsLines")
  private List<LeaveEarningsLine> leaveEarningsLines = new ArrayList<LeaveEarningsLine>();

  @JsonProperty("timesheetEarningsLines")
  private List<TimesheetEarningsLine> timesheetEarningsLines =
      new ArrayList<TimesheetEarningsLine>();

  @JsonProperty("deductionLines")
  private List<DeductionLine> deductionLines = new ArrayList<DeductionLine>();

  @JsonProperty("reimbursementLines")
  private List<ReimbursementLine> reimbursementLines = new ArrayList<ReimbursementLine>();

  @JsonProperty("leaveAccrualLines")
  private List<LeaveAccrualLine> leaveAccrualLines = new ArrayList<LeaveAccrualLine>();

  @JsonProperty("benefitLines")
  private List<BenefitLine> benefitLines = new ArrayList<BenefitLine>();

  @JsonProperty("paymentLines")
  private List<PaymentLine> paymentLines = new ArrayList<PaymentLine>();

  @JsonProperty("employeeTaxLines")
  private List<TaxLine> employeeTaxLines = new ArrayList<TaxLine>();

  @JsonProperty("employerTaxLines")
  private List<TaxLine> employerTaxLines = new ArrayList<TaxLine>();

  @JsonProperty("courtOrderLines")
  private List<CourtOrderLine> courtOrderLines = new ArrayList<CourtOrderLine>();
  /**
   * The Xero identifier for a Payslip
   *
   * @param paySlipID UUID
   * @return Payslip
   */
  public Payslip paySlipID(UUID paySlipID) {
    this.paySlipID = paySlipID;
    return this;
  }

  /**
   * The Xero identifier for a Payslip
   *
   * @return paySlipID
   */
  @ApiModelProperty(value = "The Xero identifier for a Payslip")
  /**
   * The Xero identifier for a Payslip
   *
   * @return paySlipID UUID
   */
  public UUID getPaySlipID() {
    return paySlipID;
  }

  /**
   * The Xero identifier for a Payslip
   *
   * @param paySlipID UUID
   */
  public void setPaySlipID(UUID paySlipID) {
    this.paySlipID = paySlipID;
  }

  /**
   * The Xero identifier for payroll employee
   *
   * @param employeeID UUID
   * @return Payslip
   */
  public Payslip employeeID(UUID employeeID) {
    this.employeeID = employeeID;
    return this;
  }

  /**
   * The Xero identifier for payroll employee
   *
   * @return employeeID
   */
  @ApiModelProperty(value = "The Xero identifier for payroll employee")
  /**
   * The Xero identifier for payroll employee
   *
   * @return employeeID UUID
   */
  public UUID getEmployeeID() {
    return employeeID;
  }

  /**
   * The Xero identifier for payroll employee
   *
   * @param employeeID UUID
   */
  public void setEmployeeID(UUID employeeID) {
    this.employeeID = employeeID;
  }

  /**
   * The Xero identifier for the associated payrun
   *
   * @param payRunID UUID
   * @return Payslip
   */
  public Payslip payRunID(UUID payRunID) {
    this.payRunID = payRunID;
    return this;
  }

  /**
   * The Xero identifier for the associated payrun
   *
   * @return payRunID
   */
  @ApiModelProperty(value = "The Xero identifier for the associated payrun")
  /**
   * The Xero identifier for the associated payrun
   *
   * @return payRunID UUID
   */
  public UUID getPayRunID() {
    return payRunID;
  }

  /**
   * The Xero identifier for the associated payrun
   *
   * @param payRunID UUID
   */
  public void setPayRunID(UUID payRunID) {
    this.payRunID = payRunID;
  }

  /**
   * The date payslip was last updated
   *
   * @param lastEdited LocalDateTime
   * @return Payslip
   */
  public Payslip lastEdited(LocalDateTime lastEdited) {
    this.lastEdited = lastEdited;
    return this;
  }

  /**
   * The date payslip was last updated
   *
   * @return lastEdited
   */
  @ApiModelProperty(value = "The date payslip was last updated")
  /**
   * The date payslip was last updated
   *
   * @return lastEdited LocalDateTime
   */
  public LocalDateTime getLastEdited() {
    return lastEdited;
  }

  /**
   * The date payslip was last updated
   *
   * @param lastEdited LocalDateTime
   */
  public void setLastEdited(LocalDateTime lastEdited) {
    this.lastEdited = lastEdited;
  }

  /**
   * Employee first name
   *
   * @param firstName String
   * @return Payslip
   */
  public Payslip firstName(String firstName) {
    this.firstName = firstName;
    return this;
  }

  /**
   * Employee first name
   *
   * @return firstName
   */
  @ApiModelProperty(value = "Employee first name")
  /**
   * Employee first name
   *
   * @return firstName String
   */
  public String getFirstName() {
    return firstName;
  }

  /**
   * Employee first name
   *
   * @param firstName String
   */
  public void setFirstName(String firstName) {
    this.firstName = firstName;
  }

  /**
   * Employee last name
   *
   * @param lastName String
   * @return Payslip
   */
  public Payslip lastName(String lastName) {
    this.lastName = lastName;
    return this;
  }

  /**
   * Employee last name
   *
   * @return lastName
   */
  @ApiModelProperty(value = "Employee last name")
  /**
   * Employee last name
   *
   * @return lastName String
   */
  public String getLastName() {
    return lastName;
  }

  /**
   * Employee last name
   *
   * @param lastName String
   */
  public void setLastName(String lastName) {
    this.lastName = lastName;
  }

  /**
   * Total earnings before any deductions. Same as gross earnings for UK.
   *
   * @param totalEarnings Double
   * @return Payslip
   */
  public Payslip totalEarnings(Double totalEarnings) {
    this.totalEarnings = totalEarnings;
    return this;
  }

  /**
   * Total earnings before any deductions. Same as gross earnings for UK.
   *
   * @return totalEarnings
   */
  @ApiModelProperty(value = "Total earnings before any deductions. Same as gross earnings for UK.")
  /**
   * Total earnings before any deductions. Same as gross earnings for UK.
   *
   * @return totalEarnings Double
   */
  public Double getTotalEarnings() {
    return totalEarnings;
  }

  /**
   * Total earnings before any deductions. Same as gross earnings for UK.
   *
   * @param totalEarnings Double
   */
  public void setTotalEarnings(Double totalEarnings) {
    this.totalEarnings = totalEarnings;
  }

  /**
   * Total earnings before any deductions. Same as total earnings for UK.
   *
   * @param grossEarnings Double
   * @return Payslip
   */
  public Payslip grossEarnings(Double grossEarnings) {
    this.grossEarnings = grossEarnings;
    return this;
  }

  /**
   * Total earnings before any deductions. Same as total earnings for UK.
   *
   * @return grossEarnings
   */
  @ApiModelProperty(value = "Total earnings before any deductions. Same as total earnings for UK.")
  /**
   * Total earnings before any deductions. Same as total earnings for UK.
   *
   * @return grossEarnings Double
   */
  public Double getGrossEarnings() {
    return grossEarnings;
  }

  /**
   * Total earnings before any deductions. Same as total earnings for UK.
   *
   * @param grossEarnings Double
   */
  public void setGrossEarnings(Double grossEarnings) {
    this.grossEarnings = grossEarnings;
  }

  /**
   * The employee net pay
   *
   * @param totalPay Double
   * @return Payslip
   */
  public Payslip totalPay(Double totalPay) {
    this.totalPay = totalPay;
    return this;
  }

  /**
   * The employee net pay
   *
   * @return totalPay
   */
  @ApiModelProperty(value = "The employee net pay")
  /**
   * The employee net pay
   *
   * @return totalPay Double
   */
  public Double getTotalPay() {
    return totalPay;
  }

  /**
   * The employee net pay
   *
   * @param totalPay Double
   */
  public void setTotalPay(Double totalPay) {
    this.totalPay = totalPay;
  }

  /**
   * The employer&#39;s tax obligation
   *
   * @param totalEmployerTaxes Double
   * @return Payslip
   */
  public Payslip totalEmployerTaxes(Double totalEmployerTaxes) {
    this.totalEmployerTaxes = totalEmployerTaxes;
    return this;
  }

  /**
   * The employer&#39;s tax obligation
   *
   * @return totalEmployerTaxes
   */
  @ApiModelProperty(value = "The employer's tax obligation")
  /**
   * The employer&#39;s tax obligation
   *
   * @return totalEmployerTaxes Double
   */
  public Double getTotalEmployerTaxes() {
    return totalEmployerTaxes;
  }

  /**
   * The employer&#39;s tax obligation
   *
   * @param totalEmployerTaxes Double
   */
  public void setTotalEmployerTaxes(Double totalEmployerTaxes) {
    this.totalEmployerTaxes = totalEmployerTaxes;
  }

  /**
   * The part of an employee&#39;s earnings that is deducted for tax purposes
   *
   * @param totalEmployeeTaxes Double
   * @return Payslip
   */
  public Payslip totalEmployeeTaxes(Double totalEmployeeTaxes) {
    this.totalEmployeeTaxes = totalEmployeeTaxes;
    return this;
  }

  /**
   * The part of an employee&#39;s earnings that is deducted for tax purposes
   *
   * @return totalEmployeeTaxes
   */
  @ApiModelProperty(value = "The part of an employee's earnings that is deducted for tax purposes")
  /**
   * The part of an employee&#39;s earnings that is deducted for tax purposes
   *
   * @return totalEmployeeTaxes Double
   */
  public Double getTotalEmployeeTaxes() {
    return totalEmployeeTaxes;
  }

  /**
   * The part of an employee&#39;s earnings that is deducted for tax purposes
   *
   * @param totalEmployeeTaxes Double
   */
  public void setTotalEmployeeTaxes(Double totalEmployeeTaxes) {
    this.totalEmployeeTaxes = totalEmployeeTaxes;
  }

  /**
   * Total amount subtracted from an employee&#39;s earnings to reach total pay
   *
   * @param totalDeductions Double
   * @return Payslip
   */
  public Payslip totalDeductions(Double totalDeductions) {
    this.totalDeductions = totalDeductions;
    return this;
  }

  /**
   * Total amount subtracted from an employee&#39;s earnings to reach total pay
   *
   * @return totalDeductions
   */
  @ApiModelProperty(
      value = "Total amount subtracted from an employee's earnings to reach total pay")
  /**
   * Total amount subtracted from an employee&#39;s earnings to reach total pay
   *
   * @return totalDeductions Double
   */
  public Double getTotalDeductions() {
    return totalDeductions;
  }

  /**
   * Total amount subtracted from an employee&#39;s earnings to reach total pay
   *
   * @param totalDeductions Double
   */
  public void setTotalDeductions(Double totalDeductions) {
    this.totalDeductions = totalDeductions;
  }

  /**
   * Total reimbursements are nontaxable payments to an employee used to repay out-of-pocket
   * expenses when the person incurs those expenses through employment
   *
   * @param totalReimbursements Double
   * @return Payslip
   */
  public Payslip totalReimbursements(Double totalReimbursements) {
    this.totalReimbursements = totalReimbursements;
    return this;
  }

  /**
   * Total reimbursements are nontaxable payments to an employee used to repay out-of-pocket
   * expenses when the person incurs those expenses through employment
   *
   * @return totalReimbursements
   */
  @ApiModelProperty(
      value =
          "Total reimbursements are nontaxable payments to an employee used to repay out-of-pocket"
              + " expenses when the person incurs those expenses through employment")
  /**
   * Total reimbursements are nontaxable payments to an employee used to repay out-of-pocket
   * expenses when the person incurs those expenses through employment
   *
   * @return totalReimbursements Double
   */
  public Double getTotalReimbursements() {
    return totalReimbursements;
  }

  /**
   * Total reimbursements are nontaxable payments to an employee used to repay out-of-pocket
   * expenses when the person incurs those expenses through employment
   *
   * @param totalReimbursements Double
   */
  public void setTotalReimbursements(Double totalReimbursements) {
    this.totalReimbursements = totalReimbursements;
  }

  /**
   * Total amounts required by law to subtract from the employee&#39;s earnings
   *
   * @param totalCourtOrders Double
   * @return Payslip
   */
  public Payslip totalCourtOrders(Double totalCourtOrders) {
    this.totalCourtOrders = totalCourtOrders;
    return this;
  }

  /**
   * Total amounts required by law to subtract from the employee&#39;s earnings
   *
   * @return totalCourtOrders
   */
  @ApiModelProperty(
      value = "Total amounts required by law to subtract from the employee's earnings")
  /**
   * Total amounts required by law to subtract from the employee&#39;s earnings
   *
   * @return totalCourtOrders Double
   */
  public Double getTotalCourtOrders() {
    return totalCourtOrders;
  }

  /**
   * Total amounts required by law to subtract from the employee&#39;s earnings
   *
   * @param totalCourtOrders Double
   */
  public void setTotalCourtOrders(Double totalCourtOrders) {
    this.totalCourtOrders = totalCourtOrders;
  }

  /**
   * Benefits (also called fringe benefits, perquisites or perks) are various non-earnings
   * compensations provided to employees in addition to their normal earnings or salaries
   *
   * @param totalBenefits Double
   * @return Payslip
   */
  public Payslip totalBenefits(Double totalBenefits) {
    this.totalBenefits = totalBenefits;
    return this;
  }

  /**
   * Benefits (also called fringe benefits, perquisites or perks) are various non-earnings
   * compensations provided to employees in addition to their normal earnings or salaries
   *
   * @return totalBenefits
   */
  @ApiModelProperty(
      value =
          "Benefits (also called fringe benefits, perquisites or perks) are various non-earnings"
              + " compensations provided to employees in addition to their normal earnings or"
              + " salaries")
  /**
   * Benefits (also called fringe benefits, perquisites or perks) are various non-earnings
   * compensations provided to employees in addition to their normal earnings or salaries
   *
   * @return totalBenefits Double
   */
  public Double getTotalBenefits() {
    return totalBenefits;
  }

  /**
   * Benefits (also called fringe benefits, perquisites or perks) are various non-earnings
   * compensations provided to employees in addition to their normal earnings or salaries
   *
   * @param totalBenefits Double
   */
  public void setTotalBenefits(Double totalBenefits) {
    this.totalBenefits = totalBenefits;
  }

  /**
   * BACS Service User Number
   *
   * @param bacsHash String
   * @return Payslip
   */
  public Payslip bacsHash(String bacsHash) {
    this.bacsHash = bacsHash;
    return this;
  }

  /**
   * BACS Service User Number
   *
   * @return bacsHash
   */
  @ApiModelProperty(value = "BACS Service User Number")
  /**
   * BACS Service User Number
   *
   * @return bacsHash String
   */
  public String getBacsHash() {
    return bacsHash;
  }

  /**
   * BACS Service User Number
   *
   * @param bacsHash String
   */
  public void setBacsHash(String bacsHash) {
    this.bacsHash = bacsHash;
  }

  /**
   * The payment method code
   *
   * @param paymentMethod PaymentMethodEnum
   * @return Payslip
   */
  public Payslip paymentMethod(PaymentMethodEnum paymentMethod) {
    this.paymentMethod = paymentMethod;
    return this;
  }

  /**
   * The payment method code
   *
   * @return paymentMethod
   */
  @ApiModelProperty(value = "The payment method code")
  /**
   * The payment method code
   *
   * @return paymentMethod PaymentMethodEnum
   */
  public PaymentMethodEnum getPaymentMethod() {
    return paymentMethod;
  }

  /**
   * The payment method code
   *
   * @param paymentMethod PaymentMethodEnum
   */
  public void setPaymentMethod(PaymentMethodEnum paymentMethod) {
    this.paymentMethod = paymentMethod;
  }

  /**
   * earningsLines
   *
   * @param earningsLines List&lt;EarningsLine&gt;
   * @return Payslip
   */
  public Payslip earningsLines(List<EarningsLine> earningsLines) {
    this.earningsLines = earningsLines;
    return this;
  }

  /**
   * earningsLines
   *
   * @param earningsLinesItem EarningsLine
   * @return Payslip
   */
  public Payslip addEarningsLinesItem(EarningsLine earningsLinesItem) {
    if (this.earningsLines == null) {
      this.earningsLines = new ArrayList<EarningsLine>();
    }
    this.earningsLines.add(earningsLinesItem);
    return this;
  }

  /**
   * Get earningsLines
   *
   * @return earningsLines
   */
  @ApiModelProperty(value = "")
  /**
   * earningsLines
   *
   * @return earningsLines List<EarningsLine>
   */
  public List<EarningsLine> getEarningsLines() {
    return earningsLines;
  }

  /**
   * earningsLines
   *
   * @param earningsLines List&lt;EarningsLine&gt;
   */
  public void setEarningsLines(List<EarningsLine> earningsLines) {
    this.earningsLines = earningsLines;
  }

  /**
   * leaveEarningsLines
   *
   * @param leaveEarningsLines List&lt;LeaveEarningsLine&gt;
   * @return Payslip
   */
  public Payslip leaveEarningsLines(List<LeaveEarningsLine> leaveEarningsLines) {
    this.leaveEarningsLines = leaveEarningsLines;
    return this;
  }

  /**
   * leaveEarningsLines
   *
   * @param leaveEarningsLinesItem LeaveEarningsLine
   * @return Payslip
   */
  public Payslip addLeaveEarningsLinesItem(LeaveEarningsLine leaveEarningsLinesItem) {
    if (this.leaveEarningsLines == null) {
      this.leaveEarningsLines = new ArrayList<LeaveEarningsLine>();
    }
    this.leaveEarningsLines.add(leaveEarningsLinesItem);
    return this;
  }

  /**
   * Get leaveEarningsLines
   *
   * @return leaveEarningsLines
   */
  @ApiModelProperty(value = "")
  /**
   * leaveEarningsLines
   *
   * @return leaveEarningsLines List<LeaveEarningsLine>
   */
  public List<LeaveEarningsLine> getLeaveEarningsLines() {
    return leaveEarningsLines;
  }

  /**
   * leaveEarningsLines
   *
   * @param leaveEarningsLines List&lt;LeaveEarningsLine&gt;
   */
  public void setLeaveEarningsLines(List<LeaveEarningsLine> leaveEarningsLines) {
    this.leaveEarningsLines = leaveEarningsLines;
  }

  /**
   * timesheetEarningsLines
   *
   * @param timesheetEarningsLines List&lt;TimesheetEarningsLine&gt;
   * @return Payslip
   */
  public Payslip timesheetEarningsLines(List<TimesheetEarningsLine> timesheetEarningsLines) {
    this.timesheetEarningsLines = timesheetEarningsLines;
    return this;
  }

  /**
   * timesheetEarningsLines
   *
   * @param timesheetEarningsLinesItem TimesheetEarningsLine
   * @return Payslip
   */
  public Payslip addTimesheetEarningsLinesItem(TimesheetEarningsLine timesheetEarningsLinesItem) {
    if (this.timesheetEarningsLines == null) {
      this.timesheetEarningsLines = new ArrayList<TimesheetEarningsLine>();
    }
    this.timesheetEarningsLines.add(timesheetEarningsLinesItem);
    return this;
  }

  /**
   * Get timesheetEarningsLines
   *
   * @return timesheetEarningsLines
   */
  @ApiModelProperty(value = "")
  /**
   * timesheetEarningsLines
   *
   * @return timesheetEarningsLines List<TimesheetEarningsLine>
   */
  public List<TimesheetEarningsLine> getTimesheetEarningsLines() {
    return timesheetEarningsLines;
  }

  /**
   * timesheetEarningsLines
   *
   * @param timesheetEarningsLines List&lt;TimesheetEarningsLine&gt;
   */
  public void setTimesheetEarningsLines(List<TimesheetEarningsLine> timesheetEarningsLines) {
    this.timesheetEarningsLines = timesheetEarningsLines;
  }

  /**
   * deductionLines
   *
   * @param deductionLines List&lt;DeductionLine&gt;
   * @return Payslip
   */
  public Payslip deductionLines(List<DeductionLine> deductionLines) {
    this.deductionLines = deductionLines;
    return this;
  }

  /**
   * deductionLines
   *
   * @param deductionLinesItem DeductionLine
   * @return Payslip
   */
  public Payslip addDeductionLinesItem(DeductionLine deductionLinesItem) {
    if (this.deductionLines == null) {
      this.deductionLines = new ArrayList<DeductionLine>();
    }
    this.deductionLines.add(deductionLinesItem);
    return this;
  }

  /**
   * Get deductionLines
   *
   * @return deductionLines
   */
  @ApiModelProperty(value = "")
  /**
   * deductionLines
   *
   * @return deductionLines List<DeductionLine>
   */
  public List<DeductionLine> getDeductionLines() {
    return deductionLines;
  }

  /**
   * deductionLines
   *
   * @param deductionLines List&lt;DeductionLine&gt;
   */
  public void setDeductionLines(List<DeductionLine> deductionLines) {
    this.deductionLines = deductionLines;
  }

  /**
   * reimbursementLines
   *
   * @param reimbursementLines List&lt;ReimbursementLine&gt;
   * @return Payslip
   */
  public Payslip reimbursementLines(List<ReimbursementLine> reimbursementLines) {
    this.reimbursementLines = reimbursementLines;
    return this;
  }

  /**
   * reimbursementLines
   *
   * @param reimbursementLinesItem ReimbursementLine
   * @return Payslip
   */
  public Payslip addReimbursementLinesItem(ReimbursementLine reimbursementLinesItem) {
    if (this.reimbursementLines == null) {
      this.reimbursementLines = new ArrayList<ReimbursementLine>();
    }
    this.reimbursementLines.add(reimbursementLinesItem);
    return this;
  }

  /**
   * Get reimbursementLines
   *
   * @return reimbursementLines
   */
  @ApiModelProperty(value = "")
  /**
   * reimbursementLines
   *
   * @return reimbursementLines List<ReimbursementLine>
   */
  public List<ReimbursementLine> getReimbursementLines() {
    return reimbursementLines;
  }

  /**
   * reimbursementLines
   *
   * @param reimbursementLines List&lt;ReimbursementLine&gt;
   */
  public void setReimbursementLines(List<ReimbursementLine> reimbursementLines) {
    this.reimbursementLines = reimbursementLines;
  }

  /**
   * leaveAccrualLines
   *
   * @param leaveAccrualLines List&lt;LeaveAccrualLine&gt;
   * @return Payslip
   */
  public Payslip leaveAccrualLines(List<LeaveAccrualLine> leaveAccrualLines) {
    this.leaveAccrualLines = leaveAccrualLines;
    return this;
  }

  /**
   * leaveAccrualLines
   *
   * @param leaveAccrualLinesItem LeaveAccrualLine
   * @return Payslip
   */
  public Payslip addLeaveAccrualLinesItem(LeaveAccrualLine leaveAccrualLinesItem) {
    if (this.leaveAccrualLines == null) {
      this.leaveAccrualLines = new ArrayList<LeaveAccrualLine>();
    }
    this.leaveAccrualLines.add(leaveAccrualLinesItem);
    return this;
  }

  /**
   * Get leaveAccrualLines
   *
   * @return leaveAccrualLines
   */
  @ApiModelProperty(value = "")
  /**
   * leaveAccrualLines
   *
   * @return leaveAccrualLines List<LeaveAccrualLine>
   */
  public List<LeaveAccrualLine> getLeaveAccrualLines() {
    return leaveAccrualLines;
  }

  /**
   * leaveAccrualLines
   *
   * @param leaveAccrualLines List&lt;LeaveAccrualLine&gt;
   */
  public void setLeaveAccrualLines(List<LeaveAccrualLine> leaveAccrualLines) {
    this.leaveAccrualLines = leaveAccrualLines;
  }

  /**
   * benefitLines
   *
   * @param benefitLines List&lt;BenefitLine&gt;
   * @return Payslip
   */
  public Payslip benefitLines(List<BenefitLine> benefitLines) {
    this.benefitLines = benefitLines;
    return this;
  }

  /**
   * benefitLines
   *
   * @param benefitLinesItem BenefitLine
   * @return Payslip
   */
  public Payslip addBenefitLinesItem(BenefitLine benefitLinesItem) {
    if (this.benefitLines == null) {
      this.benefitLines = new ArrayList<BenefitLine>();
    }
    this.benefitLines.add(benefitLinesItem);
    return this;
  }

  /**
   * Get benefitLines
   *
   * @return benefitLines
   */
  @ApiModelProperty(value = "")
  /**
   * benefitLines
   *
   * @return benefitLines List<BenefitLine>
   */
  public List<BenefitLine> getBenefitLines() {
    return benefitLines;
  }

  /**
   * benefitLines
   *
   * @param benefitLines List&lt;BenefitLine&gt;
   */
  public void setBenefitLines(List<BenefitLine> benefitLines) {
    this.benefitLines = benefitLines;
  }

  /**
   * paymentLines
   *
   * @param paymentLines List&lt;PaymentLine&gt;
   * @return Payslip
   */
  public Payslip paymentLines(List<PaymentLine> paymentLines) {
    this.paymentLines = paymentLines;
    return this;
  }

  /**
   * paymentLines
   *
   * @param paymentLinesItem PaymentLine
   * @return Payslip
   */
  public Payslip addPaymentLinesItem(PaymentLine paymentLinesItem) {
    if (this.paymentLines == null) {
      this.paymentLines = new ArrayList<PaymentLine>();
    }
    this.paymentLines.add(paymentLinesItem);
    return this;
  }

  /**
   * Get paymentLines
   *
   * @return paymentLines
   */
  @ApiModelProperty(value = "")
  /**
   * paymentLines
   *
   * @return paymentLines List<PaymentLine>
   */
  public List<PaymentLine> getPaymentLines() {
    return paymentLines;
  }

  /**
   * paymentLines
   *
   * @param paymentLines List&lt;PaymentLine&gt;
   */
  public void setPaymentLines(List<PaymentLine> paymentLines) {
    this.paymentLines = paymentLines;
  }

  /**
   * employeeTaxLines
   *
   * @param employeeTaxLines List&lt;TaxLine&gt;
   * @return Payslip
   */
  public Payslip employeeTaxLines(List<TaxLine> employeeTaxLines) {
    this.employeeTaxLines = employeeTaxLines;
    return this;
  }

  /**
   * employeeTaxLines
   *
   * @param employeeTaxLinesItem TaxLine
   * @return Payslip
   */
  public Payslip addEmployeeTaxLinesItem(TaxLine employeeTaxLinesItem) {
    if (this.employeeTaxLines == null) {
      this.employeeTaxLines = new ArrayList<TaxLine>();
    }
    this.employeeTaxLines.add(employeeTaxLinesItem);
    return this;
  }

  /**
   * Get employeeTaxLines
   *
   * @return employeeTaxLines
   */
  @ApiModelProperty(value = "")
  /**
   * employeeTaxLines
   *
   * @return employeeTaxLines List<TaxLine>
   */
  public List<TaxLine> getEmployeeTaxLines() {
    return employeeTaxLines;
  }

  /**
   * employeeTaxLines
   *
   * @param employeeTaxLines List&lt;TaxLine&gt;
   */
  public void setEmployeeTaxLines(List<TaxLine> employeeTaxLines) {
    this.employeeTaxLines = employeeTaxLines;
  }

  /**
   * employerTaxLines
   *
   * @param employerTaxLines List&lt;TaxLine&gt;
   * @return Payslip
   */
  public Payslip employerTaxLines(List<TaxLine> employerTaxLines) {
    this.employerTaxLines = employerTaxLines;
    return this;
  }

  /**
   * employerTaxLines
   *
   * @param employerTaxLinesItem TaxLine
   * @return Payslip
   */
  public Payslip addEmployerTaxLinesItem(TaxLine employerTaxLinesItem) {
    if (this.employerTaxLines == null) {
      this.employerTaxLines = new ArrayList<TaxLine>();
    }
    this.employerTaxLines.add(employerTaxLinesItem);
    return this;
  }

  /**
   * Get employerTaxLines
   *
   * @return employerTaxLines
   */
  @ApiModelProperty(value = "")
  /**
   * employerTaxLines
   *
   * @return employerTaxLines List<TaxLine>
   */
  public List<TaxLine> getEmployerTaxLines() {
    return employerTaxLines;
  }

  /**
   * employerTaxLines
   *
   * @param employerTaxLines List&lt;TaxLine&gt;
   */
  public void setEmployerTaxLines(List<TaxLine> employerTaxLines) {
    this.employerTaxLines = employerTaxLines;
  }

  /**
   * courtOrderLines
   *
   * @param courtOrderLines List&lt;CourtOrderLine&gt;
   * @return Payslip
   */
  public Payslip courtOrderLines(List<CourtOrderLine> courtOrderLines) {
    this.courtOrderLines = courtOrderLines;
    return this;
  }

  /**
   * courtOrderLines
   *
   * @param courtOrderLinesItem CourtOrderLine
   * @return Payslip
   */
  public Payslip addCourtOrderLinesItem(CourtOrderLine courtOrderLinesItem) {
    if (this.courtOrderLines == null) {
      this.courtOrderLines = new ArrayList<CourtOrderLine>();
    }
    this.courtOrderLines.add(courtOrderLinesItem);
    return this;
  }

  /**
   * Get courtOrderLines
   *
   * @return courtOrderLines
   */
  @ApiModelProperty(value = "")
  /**
   * courtOrderLines
   *
   * @return courtOrderLines List<CourtOrderLine>
   */
  public List<CourtOrderLine> getCourtOrderLines() {
    return courtOrderLines;
  }

  /**
   * courtOrderLines
   *
   * @param courtOrderLines List&lt;CourtOrderLine&gt;
   */
  public void setCourtOrderLines(List<CourtOrderLine> courtOrderLines) {
    this.courtOrderLines = courtOrderLines;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Payslip payslip = (Payslip) o;
    return Objects.equals(this.paySlipID, payslip.paySlipID)
        && Objects.equals(this.employeeID, payslip.employeeID)
        && Objects.equals(this.payRunID, payslip.payRunID)
        && Objects.equals(this.lastEdited, payslip.lastEdited)
        && Objects.equals(this.firstName, payslip.firstName)
        && Objects.equals(this.lastName, payslip.lastName)
        && Objects.equals(this.totalEarnings, payslip.totalEarnings)
        && Objects.equals(this.grossEarnings, payslip.grossEarnings)
        && Objects.equals(this.totalPay, payslip.totalPay)
        && Objects.equals(this.totalEmployerTaxes, payslip.totalEmployerTaxes)
        && Objects.equals(this.totalEmployeeTaxes, payslip.totalEmployeeTaxes)
        && Objects.equals(this.totalDeductions, payslip.totalDeductions)
        && Objects.equals(this.totalReimbursements, payslip.totalReimbursements)
        && Objects.equals(this.totalCourtOrders, payslip.totalCourtOrders)
        && Objects.equals(this.totalBenefits, payslip.totalBenefits)
        && Objects.equals(this.bacsHash, payslip.bacsHash)
        && Objects.equals(this.paymentMethod, payslip.paymentMethod)
        && Objects.equals(this.earningsLines, payslip.earningsLines)
        && Objects.equals(this.leaveEarningsLines, payslip.leaveEarningsLines)
        && Objects.equals(this.timesheetEarningsLines, payslip.timesheetEarningsLines)
        && Objects.equals(this.deductionLines, payslip.deductionLines)
        && Objects.equals(this.reimbursementLines, payslip.reimbursementLines)
        && Objects.equals(this.leaveAccrualLines, payslip.leaveAccrualLines)
        && Objects.equals(this.benefitLines, payslip.benefitLines)
        && Objects.equals(this.paymentLines, payslip.paymentLines)
        && Objects.equals(this.employeeTaxLines, payslip.employeeTaxLines)
        && Objects.equals(this.employerTaxLines, payslip.employerTaxLines)
        && Objects.equals(this.courtOrderLines, payslip.courtOrderLines);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        paySlipID,
        employeeID,
        payRunID,
        lastEdited,
        firstName,
        lastName,
        totalEarnings,
        grossEarnings,
        totalPay,
        totalEmployerTaxes,
        totalEmployeeTaxes,
        totalDeductions,
        totalReimbursements,
        totalCourtOrders,
        totalBenefits,
        bacsHash,
        paymentMethod,
        earningsLines,
        leaveEarningsLines,
        timesheetEarningsLines,
        deductionLines,
        reimbursementLines,
        leaveAccrualLines,
        benefitLines,
        paymentLines,
        employeeTaxLines,
        employerTaxLines,
        courtOrderLines);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Payslip {\n");
    sb.append("    paySlipID: ").append(toIndentedString(paySlipID)).append("\n");
    sb.append("    employeeID: ").append(toIndentedString(employeeID)).append("\n");
    sb.append("    payRunID: ").append(toIndentedString(payRunID)).append("\n");
    sb.append("    lastEdited: ").append(toIndentedString(lastEdited)).append("\n");
    sb.append("    firstName: ").append(toIndentedString(firstName)).append("\n");
    sb.append("    lastName: ").append(toIndentedString(lastName)).append("\n");
    sb.append("    totalEarnings: ").append(toIndentedString(totalEarnings)).append("\n");
    sb.append("    grossEarnings: ").append(toIndentedString(grossEarnings)).append("\n");
    sb.append("    totalPay: ").append(toIndentedString(totalPay)).append("\n");
    sb.append("    totalEmployerTaxes: ").append(toIndentedString(totalEmployerTaxes)).append("\n");
    sb.append("    totalEmployeeTaxes: ").append(toIndentedString(totalEmployeeTaxes)).append("\n");
    sb.append("    totalDeductions: ").append(toIndentedString(totalDeductions)).append("\n");
    sb.append("    totalReimbursements: ")
        .append(toIndentedString(totalReimbursements))
        .append("\n");
    sb.append("    totalCourtOrders: ").append(toIndentedString(totalCourtOrders)).append("\n");
    sb.append("    totalBenefits: ").append(toIndentedString(totalBenefits)).append("\n");
    sb.append("    bacsHash: ").append(toIndentedString(bacsHash)).append("\n");
    sb.append("    paymentMethod: ").append(toIndentedString(paymentMethod)).append("\n");
    sb.append("    earningsLines: ").append(toIndentedString(earningsLines)).append("\n");
    sb.append("    leaveEarningsLines: ").append(toIndentedString(leaveEarningsLines)).append("\n");
    sb.append("    timesheetEarningsLines: ")
        .append(toIndentedString(timesheetEarningsLines))
        .append("\n");
    sb.append("    deductionLines: ").append(toIndentedString(deductionLines)).append("\n");
    sb.append("    reimbursementLines: ").append(toIndentedString(reimbursementLines)).append("\n");
    sb.append("    leaveAccrualLines: ").append(toIndentedString(leaveAccrualLines)).append("\n");
    sb.append("    benefitLines: ").append(toIndentedString(benefitLines)).append("\n");
    sb.append("    paymentLines: ").append(toIndentedString(paymentLines)).append("\n");
    sb.append("    employeeTaxLines: ").append(toIndentedString(employeeTaxLines)).append("\n");
    sb.append("    employerTaxLines: ").append(toIndentedString(employerTaxLines)).append("\n");
    sb.append("    courtOrderLines: ").append(toIndentedString(courtOrderLines)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
