/*
 * Decompiled with CFR 0.152.
 */
package com.xero.api;

import com.auth0.jwk.Jwk;
import com.auth0.jwk.JwkException;
import com.auth0.jwk.UrlJwkProvider;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.threetenbp.ThreeTenModule;
import com.google.api.client.googleapis.util.Utils;
import com.google.api.client.http.AbstractHttpContent;
import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.xero.api.RFC3339DateFormat;
import com.xero.api.client.AccountingApi;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.interfaces.RSAPublicKey;
import java.text.DateFormat;

public class ApiClient {
    private final String basePath;
    private final HttpRequestFactory httpRequestFactory;
    private final ObjectMapper objectMapper;
    private HttpTransport httpTransport = new NetHttpTransport();
    private int connectionTimeout = 180000;
    private int readTimeout = 180000;
    private static final String defaultBasePath = "https://api.xero.com/api.xro/2.0";

    private static ObjectMapper createDefaultObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).setDateFormat((DateFormat)((Object)new RFC3339DateFormat())).setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        ThreeTenModule module = new ThreeTenModule();
        objectMapper.registerModule((Module)module);
        return objectMapper;
    }

    public ApiClient() {
        this(null, null, null, null, null);
    }

    public ApiClient(String basePath, HttpTransport transport, HttpRequestInitializer initializer, ObjectMapper objectMapper, HttpRequestFactory reqFactory) {
        String string = basePath == null ? defaultBasePath : (this.basePath = basePath.endsWith("/") ? basePath.substring(0, basePath.length() - 1) : basePath);
        if (transport != null) {
            this.httpTransport = transport;
        }
        this.httpRequestFactory = reqFactory != null ? reqFactory : (transport == null ? Utils.getDefaultTransport() : transport).createRequestFactory(initializer);
        this.objectMapper = objectMapper == null ? ApiClient.createDefaultObjectMapper() : objectMapper;
    }

    public HttpRequestFactory getHttpRequestFactory() {
        return this.httpRequestFactory;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public HttpTransport getHttpTransport() {
        return this.httpTransport;
    }

    public void setHttpTransport(HttpTransport transport) {
        this.httpTransport = transport;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public AccountingApi accountingApi() {
        return new AccountingApi(this);
    }

    public DecodedJWT verify(String accessToken) throws MalformedURLException, JwkException {
        DecodedJWT unverifiedJWT = JWT.decode((String)accessToken);
        UrlJwkProvider provider = new UrlJwkProvider(new URL("https://identity.xero.com/.well-known/openid-configuration/jwks"));
        Jwk jwk = provider.get(unverifiedJWT.getKeyId());
        Algorithm algorithm = Algorithm.RSA256((RSAPublicKey)((RSAPublicKey)jwk.getPublicKey()), null);
        JWTVerifier verifier = JWT.require((Algorithm)algorithm).withIssuer("https://identity.xero.com").acceptLeeway(1000L).build();
        DecodedJWT verifiedJWT = verifier.verify(accessToken);
        return verifiedJWT;
    }

    public HttpResponse revoke(String clientId, String clientSecret, String refreshToken) throws IOException {
        HttpHeaders headers = new HttpHeaders();
        headers.setBasicAuthentication(clientId, clientSecret);
        String urlParameters = "token=" + refreshToken;
        byte[] postData = urlParameters.getBytes(StandardCharsets.UTF_8);
        ByteArrayContent content = new ByteArrayContent("application/x-www-form-urlencoded", postData);
        GenericUrl url = new GenericUrl("https://identity.xero.com/connect/revocation");
        HttpTransport transport = this.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory();
        HttpResponse revokeResponse = requestFactory.buildRequest("POST", url, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.getConnectionTimeout()).setReadTimeout(this.getReadTimeout()).execute();
        return revokeResponse;
    }

    public class JacksonJsonHttpContent
    extends AbstractHttpContent {
        private final Object data;

        public JacksonJsonHttpContent(Object data) {
            super("application/json; charset=UTF-8");
            this.data = data;
        }

        public void writeTo(OutputStream out) throws IOException {
            ApiClient.this.objectMapper.writeValue(out, this.data);
        }
    }
}

