/*
 * Decompiled with CFR 0.152.
 */
package com.xero.api;

import com.xero.api.XeroException;
import com.xero.models.accounting.Error;
import java.util.HashMap;
import java.util.Map;

public class XeroApiException
extends XeroException {
    private static final long serialVersionUID = 1L;
    private final int responseCode;
    private String message;
    private Map<String, String> messageMap = new HashMap<String, String>();
    private Error error;

    public XeroApiException(int responseCode) {
        super(responseCode + " response.");
        this.responseCode = responseCode;
    }

    public XeroApiException(int responseCode, String message, Exception e) {
        super(responseCode + " response: " + message, e);
        this.responseCode = responseCode;
        this.message = message;
    }

    public XeroApiException(int responseCode, Map<String, String> map) {
        super(responseCode + "response");
        this.responseCode = responseCode;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (this.message == null) {
                this.message = entry.getValue() + " - ";
                continue;
            }
            this.message = this.message + entry.getValue() + " ";
        }
        this.messageMap = map;
    }

    public XeroApiException(int responseCode, Error error, Exception e) {
        super(responseCode + " response: none", e);
        this.responseCode = responseCode;
        this.error = error;
    }

    public XeroApiException(int responseCode, String message, Error error, Exception e) {
        super(responseCode + " response: " + message, e);
        this.responseCode = responseCode;
        this.message = message;
        this.error = error;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public Map<String, String> getMessages() {
        return this.messageMap;
    }

    public Error getError() {
        return this.error;
    }
}

