/*
 * Decompiled with CFR 0.152.
 */
package com.xero.api;

import com.xero.api.XeroException;
import com.xero.models.accounting.Element;
import com.xero.models.accounting.Error;
import com.xero.models.assets.FieldValidationErrorsElement;
import com.xero.models.bankfeeds.FeedConnection;
import com.xero.models.bankfeeds.FeedConnections;
import com.xero.models.bankfeeds.Statement;
import com.xero.models.bankfeeds.Statements;
import com.xero.models.payrollnz.Problem;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class XeroConflictException
extends XeroException {
    private static final long serialVersionUID = 1L;
    private Integer statusCode;
    private String type;
    private String message;
    private List<Element> elements = new ArrayList<Element>();
    private List<Statement> statementItems = new ArrayList<Statement>();
    private List<FeedConnection> feedConnectionItems = new ArrayList<FeedConnection>();
    private List<FieldValidationErrorsElement> fieldValidationErrorsElements = new ArrayList<FieldValidationErrorsElement>();
    private com.xero.models.payrolluk.Problem payrollUkProblem = new com.xero.models.payrolluk.Problem();
    private Problem payrollNzProblem = new Problem();

    public XeroConflictException(String objectType, Error error) {
        this.statusCode = 409;
        this.type(objectType);
        this.elements(error.getElements());
    }

    public XeroConflictException(String objectType, com.xero.models.assets.Error error) {
        this.statusCode = 409;
        this.type = objectType;
        this.fieldValidationErrorsElements = error.getFieldValidationErrors();
    }

    public XeroConflictException(String objectType, Statements error) {
        this.statusCode = 409;
        this.type = objectType;
        this.statementItems = error.getItems();
    }

    public XeroConflictException(String objectType, FeedConnections error) {
        this.statusCode = 409;
        this.type = objectType;
        this.feedConnectionItems = error.getItems();
    }

    public XeroConflictException(String objectType, com.xero.models.payrolluk.Problem problem) {
        this.statusCode = 409;
        this.type = objectType;
        this.payrollUkProblem = problem;
    }

    public XeroConflictException(String objectType, Problem problem, Exception e) {
        super(e);
        this.statusCode = 409;
        this.type = objectType;
        this.payrollNzProblem = problem;
    }

    public XeroConflictException(Integer statusCode, String message) {
        this.statusCode = statusCode;
        this.message = message;
    }

    public XeroConflictException statusCode(Integer statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    @ApiModelProperty(value="Status Code")
    public Integer getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
    }

    public XeroConflictException type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="API set type")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public XeroConflictException message(String message) {
        this.message = message;
        return this;
    }

    @Override
    @ApiModelProperty(value="Exception message")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public XeroConflictException elements(List<Element> elements) {
        this.elements = elements;
        return this;
    }

    public XeroConflictException addElementsItem(Element elementsItem) {
        if (this.elements == null) {
            this.elements = new ArrayList<Element>();
        }
        this.elements.add(elementsItem);
        return this;
    }

    @ApiModelProperty(value="Array of Elements of validation Errors")
    public List<Element> getElements() {
        return this.elements;
    }

    public void setElements(List<Element> elements) {
        this.elements = elements;
    }

    public XeroConflictException statementItems(List<Statement> statementItems) {
        this.statementItems = statementItems;
        return this;
    }

    public XeroConflictException addStatementItem(Statement item) {
        if (this.statementItems == null) {
            this.statementItems = new ArrayList<Statement>();
        }
        this.statementItems.add(item);
        return this;
    }

    @ApiModelProperty(value="Array of Statement Items with Errors Array")
    public List<Statement> getStatementItems() {
        return this.statementItems;
    }

    public void setStatementItems(List<Statement> statementItems) {
        this.statementItems = statementItems;
    }

    public XeroConflictException feedConnectionItems(List<FeedConnection> feedConnectionItems) {
        this.feedConnectionItems = feedConnectionItems;
        return this;
    }

    public XeroConflictException addFeedConnectionItems(FeedConnection item) {
        if (this.feedConnectionItems == null) {
            this.feedConnectionItems = new ArrayList<FeedConnection>();
        }
        this.feedConnectionItems.add(item);
        return this;
    }

    @ApiModelProperty(value="Array of FeedConnection Items with Errors Array")
    public List<FeedConnection> getFeedConnectionItems() {
        return this.feedConnectionItems;
    }

    public void setFeedConnectionItems(List<FeedConnection> feedConnectionItems) {
        this.feedConnectionItems = feedConnectionItems;
    }

    public XeroConflictException fieldValidationErrorsElements(List<FieldValidationErrorsElement> fieldValidationErrorsElements) {
        this.fieldValidationErrorsElements = fieldValidationErrorsElements;
        return this;
    }

    public XeroConflictException addFieldValidationErrorsElement(FieldValidationErrorsElement element) {
        if (this.fieldValidationErrorsElements == null) {
            this.fieldValidationErrorsElements = new ArrayList<FieldValidationErrorsElement>();
        }
        this.fieldValidationErrorsElements.add(element);
        return this;
    }

    @ApiModelProperty(value="Array of FieldValidationErrorElement")
    public List<FieldValidationErrorsElement> getFieldValidationErrorsElements() {
        return this.fieldValidationErrorsElements;
    }

    public void setFieldValidationErrorsElements(List<FieldValidationErrorsElement> fieldValidationErrorsElements) {
        this.fieldValidationErrorsElements = fieldValidationErrorsElements;
    }

    public XeroConflictException payrollNzProblem(Problem problem) {
        this.payrollNzProblem = problem;
        return this;
    }

    @ApiModelProperty(value="NZ Payroll problem")
    public Problem getPayrollNzProblem() {
        return this.payrollNzProblem;
    }

    public void setPayrollNzProblem(Problem problem) {
        this.payrollNzProblem = problem;
    }

    public XeroConflictException payrollUkProblem(com.xero.models.payrolluk.Problem problem) {
        this.payrollUkProblem = problem;
        return this;
    }

    @ApiModelProperty(value="UK Payroll problem")
    public com.xero.models.payrolluk.Problem getPayrollUkProblem() {
        return this.payrollUkProblem;
    }

    public void setPayrollUkProblem(com.xero.models.payrolluk.Problem problem) {
        this.payrollUkProblem = problem;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XeroConflictException error = (XeroConflictException)o;
        return Objects.equals(this.statusCode, error.statusCode) && Objects.equals(this.type, error.type) && Objects.equals(this.message, error.message) && Objects.equals(this.elements, error.elements);
    }

    public int hashCode() {
        return Objects.hash(this.statusCode, this.type, this.message);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Error {\n");
        sb.append("    statusCode: ").append(this.toIndentedString(this.statusCode)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    elements: ").append(this.toIndentedString(this.elements)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

