/*
 * Decompiled with CFR 0.152.
 */
package com.xero.api.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.FileContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.xero.api.ApiClient;
import com.xero.api.XeroApiExceptionHandler;
import com.xero.models.accounting.Account;
import com.xero.models.accounting.Accounts;
import com.xero.models.accounting.Actions;
import com.xero.models.accounting.Allocation;
import com.xero.models.accounting.Allocations;
import com.xero.models.accounting.Attachments;
import com.xero.models.accounting.BankTransactions;
import com.xero.models.accounting.BankTransfers;
import com.xero.models.accounting.BatchPaymentDelete;
import com.xero.models.accounting.BatchPaymentDeleteByUrlParam;
import com.xero.models.accounting.BatchPayments;
import com.xero.models.accounting.BrandingThemes;
import com.xero.models.accounting.Budgets;
import com.xero.models.accounting.CISOrgSettings;
import com.xero.models.accounting.CISSettings;
import com.xero.models.accounting.ContactGroups;
import com.xero.models.accounting.Contacts;
import com.xero.models.accounting.CreditNotes;
import com.xero.models.accounting.Currencies;
import com.xero.models.accounting.Currency;
import com.xero.models.accounting.Employees;
import com.xero.models.accounting.Error;
import com.xero.models.accounting.ExpenseClaims;
import com.xero.models.accounting.HistoryRecords;
import com.xero.models.accounting.ImportSummaryObject;
import com.xero.models.accounting.InvoiceReminders;
import com.xero.models.accounting.Invoices;
import com.xero.models.accounting.Items;
import com.xero.models.accounting.Journals;
import com.xero.models.accounting.LinkedTransaction;
import com.xero.models.accounting.LinkedTransactions;
import com.xero.models.accounting.ManualJournals;
import com.xero.models.accounting.OnlineInvoices;
import com.xero.models.accounting.Organisations;
import com.xero.models.accounting.Overpayments;
import com.xero.models.accounting.Payment;
import com.xero.models.accounting.PaymentDelete;
import com.xero.models.accounting.PaymentServices;
import com.xero.models.accounting.Payments;
import com.xero.models.accounting.Prepayments;
import com.xero.models.accounting.PurchaseOrders;
import com.xero.models.accounting.Quotes;
import com.xero.models.accounting.Receipts;
import com.xero.models.accounting.RepeatingInvoices;
import com.xero.models.accounting.ReportWithRows;
import com.xero.models.accounting.Reports;
import com.xero.models.accounting.RequestEmpty;
import com.xero.models.accounting.Setup;
import com.xero.models.accounting.TaxRates;
import com.xero.models.accounting.TrackingCategories;
import com.xero.models.accounting.TrackingCategory;
import com.xero.models.accounting.TrackingOption;
import com.xero.models.accounting.TrackingOptions;
import com.xero.models.accounting.Users;
import jakarta.ws.rs.core.UriBuilder;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.constant.Constable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

public class AccountingApi {
    private ApiClient apiClient;
    private static AccountingApi instance = null;
    private String userAgent = "Default";
    private String version = "8.3.0";
    static final Logger logger = LoggerFactory.getLogger(AccountingApi.class);

    public AccountingApi() {
        this(new ApiClient());
    }

    public static AccountingApi getInstance(ApiClient apiClient) {
        if (instance == null) {
            instance = new AccountingApi(apiClient);
        }
        return instance;
    }

    public AccountingApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getUserAgent() {
        return this.userAgent + " [Xero-Java-" + this.version + "]";
    }

    public Accounts createAccount(String accessToken, String xeroTenantId, Account account, String idempotencyKey) throws IOException {
        try {
            TypeReference<Accounts> typeRef = new TypeReference<Accounts>(){};
            HttpResponse response = this.createAccountForHttpResponse(accessToken, xeroTenantId, account, idempotencyKey);
            return (Accounts)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createAccount -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("Accounts", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("Accounts", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createAccountForHttpResponse(String accessToken, String xeroTenantId, Account account, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createAccount");
        }
        if (account == null) {
            throw new IllegalArgumentException("Missing the required parameter 'account' when calling createAccount");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createAccount");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Accounts"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(account);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments createAccountAttachmentByFileName(String accessToken, String xeroTenantId, UUID accountID, String fileName, byte[] body, String idempotencyKey, String mimeType) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.createAccountAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, accountID, fileName, body, idempotencyKey, mimeType);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createAccountAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createAccountAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID accountID, String fileName, byte[] body, String idempotencyKey, String mimeType) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createAccountAttachmentByFileName");
        }
        if (accountID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accountID' when calling createAccountAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling createAccountAttachmentByFileName");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling createAccountAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createAccountAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("AccountID", accountID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Accounts/{AccountID}/Attachments/{FileName}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ByteArrayContent content = null;
        content = new ByteArrayContent(mimeType, body);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments createAccountAttachmentByFileName(String accessToken, String xeroTenantId, UUID accountID, String fileName, File body, String idempotencyKey) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.createAccountAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, accountID, fileName, body, idempotencyKey);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createAccountAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("Attachments", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("Attachments", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createAccountAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID accountID, String fileName, File body, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createAccountAttachmentByFileName");
        }
        if (accountID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accountID' when calling createAccountAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling createAccountAttachmentByFileName");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling createAccountAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createAccountAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("AccountID", accountID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Accounts/{AccountID}/Attachments/{FileName}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        Path bodyPath = body.toPath();
        String mimeType = Files.probeContentType(bodyPath);
        FileContent content = null;
        content = new FileContent(mimeType, body);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments createBankTransactionAttachmentByFileName(String accessToken, String xeroTenantId, UUID bankTransactionID, String fileName, byte[] body, String idempotencyKey, String mimeType) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.createBankTransactionAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, bankTransactionID, fileName, body, idempotencyKey, mimeType);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createBankTransactionAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createBankTransactionAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID bankTransactionID, String fileName, byte[] body, String idempotencyKey, String mimeType) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createBankTransactionAttachmentByFileName");
        }
        if (bankTransactionID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'bankTransactionID' when calling createBankTransactionAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling createBankTransactionAttachmentByFileName");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling createBankTransactionAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createBankTransactionAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("BankTransactionID", bankTransactionID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/BankTransactions/{BankTransactionID}/Attachments/{FileName}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ByteArrayContent content = null;
        content = new ByteArrayContent(mimeType, body);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments createBankTransactionAttachmentByFileName(String accessToken, String xeroTenantId, UUID bankTransactionID, String fileName, File body, String idempotencyKey) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.createBankTransactionAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, bankTransactionID, fileName, body, idempotencyKey);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createBankTransactionAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("Attachments", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("Attachments", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createBankTransactionAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID bankTransactionID, String fileName, File body, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createBankTransactionAttachmentByFileName");
        }
        if (bankTransactionID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'bankTransactionID' when calling createBankTransactionAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling createBankTransactionAttachmentByFileName");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling createBankTransactionAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createBankTransactionAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("BankTransactionID", bankTransactionID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/BankTransactions/{BankTransactionID}/Attachments/{FileName}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        Path bodyPath = body.toPath();
        String mimeType = Files.probeContentType(bodyPath);
        FileContent content = null;
        content = new FileContent(mimeType, body);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public HistoryRecords createBankTransactionHistoryRecord(String accessToken, String xeroTenantId, UUID bankTransactionID, HistoryRecords historyRecords, String idempotencyKey) throws IOException {
        try {
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            HttpResponse response = this.createBankTransactionHistoryRecordForHttpResponse(accessToken, xeroTenantId, bankTransactionID, historyRecords, idempotencyKey);
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createBankTransactionHistoryRecord -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("HistoryRecords", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("HistoryRecords", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createBankTransactionHistoryRecordForHttpResponse(String accessToken, String xeroTenantId, UUID bankTransactionID, HistoryRecords historyRecords, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createBankTransactionHistoryRecord");
        }
        if (bankTransactionID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'bankTransactionID' when calling createBankTransactionHistoryRecord");
        }
        if (historyRecords == null) {
            throw new IllegalArgumentException("Missing the required parameter 'historyRecords' when calling createBankTransactionHistoryRecord");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createBankTransactionHistoryRecord");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("BankTransactionID", bankTransactionID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/BankTransactions/{BankTransactionID}/History"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(historyRecords);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public BankTransactions createBankTransactions(String accessToken, String xeroTenantId, BankTransactions bankTransactions, Boolean summarizeErrors, Integer unitdp, String idempotencyKey) throws IOException {
        try {
            TypeReference<BankTransactions> typeRef = new TypeReference<BankTransactions>(){};
            HttpResponse response = this.createBankTransactionsForHttpResponse(accessToken, xeroTenantId, bankTransactions, summarizeErrors, unitdp, idempotencyKey);
            return (BankTransactions)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createBankTransactions -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("BankTransactions", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("BankTransactions", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createBankTransactionsForHttpResponse(String accessToken, String xeroTenantId, BankTransactions bankTransactions, Boolean summarizeErrors, Integer unitdp, String idempotencyKey) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        Comparable<Boolean> value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createBankTransactions");
        }
        if (bankTransactions == null) {
            throw new IllegalArgumentException("Missing the required parameter 'bankTransactions' when calling createBankTransactions");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createBankTransactions");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/BankTransactions"));
        if (summarizeErrors != null) {
            key = "summarizeErrors";
            value = summarizeErrors;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (unitdp != null) {
            key = "unitdp";
            value = unitdp;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(bankTransactions);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public BankTransfers createBankTransfer(String accessToken, String xeroTenantId, BankTransfers bankTransfers, String idempotencyKey) throws IOException {
        try {
            TypeReference<BankTransfers> typeRef = new TypeReference<BankTransfers>(){};
            HttpResponse response = this.createBankTransferForHttpResponse(accessToken, xeroTenantId, bankTransfers, idempotencyKey);
            return (BankTransfers)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createBankTransfer -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("BankTransfers", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("BankTransfers", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createBankTransferForHttpResponse(String accessToken, String xeroTenantId, BankTransfers bankTransfers, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createBankTransfer");
        }
        if (bankTransfers == null) {
            throw new IllegalArgumentException("Missing the required parameter 'bankTransfers' when calling createBankTransfer");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createBankTransfer");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/BankTransfers"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(bankTransfers);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments createBankTransferAttachmentByFileName(String accessToken, String xeroTenantId, UUID bankTransferID, String fileName, byte[] body, String idempotencyKey, String mimeType) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.createBankTransferAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, bankTransferID, fileName, body, idempotencyKey, mimeType);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createBankTransferAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createBankTransferAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID bankTransferID, String fileName, byte[] body, String idempotencyKey, String mimeType) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createBankTransferAttachmentByFileName");
        }
        if (bankTransferID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'bankTransferID' when calling createBankTransferAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling createBankTransferAttachmentByFileName");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling createBankTransferAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createBankTransferAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("BankTransferID", bankTransferID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/BankTransfers/{BankTransferID}/Attachments/{FileName}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ByteArrayContent content = null;
        content = new ByteArrayContent(mimeType, body);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments createBankTransferAttachmentByFileName(String accessToken, String xeroTenantId, UUID bankTransferID, String fileName, File body, String idempotencyKey) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.createBankTransferAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, bankTransferID, fileName, body, idempotencyKey);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createBankTransferAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("Attachments", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("Attachments", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createBankTransferAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID bankTransferID, String fileName, File body, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createBankTransferAttachmentByFileName");
        }
        if (bankTransferID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'bankTransferID' when calling createBankTransferAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling createBankTransferAttachmentByFileName");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling createBankTransferAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createBankTransferAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("BankTransferID", bankTransferID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/BankTransfers/{BankTransferID}/Attachments/{FileName}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        Path bodyPath = body.toPath();
        String mimeType = Files.probeContentType(bodyPath);
        FileContent content = null;
        content = new FileContent(mimeType, body);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public HistoryRecords createBankTransferHistoryRecord(String accessToken, String xeroTenantId, UUID bankTransferID, HistoryRecords historyRecords, String idempotencyKey) throws IOException {
        try {
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            HttpResponse response = this.createBankTransferHistoryRecordForHttpResponse(accessToken, xeroTenantId, bankTransferID, historyRecords, idempotencyKey);
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createBankTransferHistoryRecord -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("HistoryRecords", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("HistoryRecords", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createBankTransferHistoryRecordForHttpResponse(String accessToken, String xeroTenantId, UUID bankTransferID, HistoryRecords historyRecords, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createBankTransferHistoryRecord");
        }
        if (bankTransferID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'bankTransferID' when calling createBankTransferHistoryRecord");
        }
        if (historyRecords == null) {
            throw new IllegalArgumentException("Missing the required parameter 'historyRecords' when calling createBankTransferHistoryRecord");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createBankTransferHistoryRecord");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("BankTransferID", bankTransferID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/BankTransfers/{BankTransferID}/History"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(historyRecords);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public BatchPayments createBatchPayment(String accessToken, String xeroTenantId, BatchPayments batchPayments, Boolean summarizeErrors, String idempotencyKey) throws IOException {
        try {
            TypeReference<BatchPayments> typeRef = new TypeReference<BatchPayments>(){};
            HttpResponse response = this.createBatchPaymentForHttpResponse(accessToken, xeroTenantId, batchPayments, summarizeErrors, idempotencyKey);
            return (BatchPayments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createBatchPayment -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("BatchPayments", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("BatchPayments", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createBatchPaymentForHttpResponse(String accessToken, String xeroTenantId, BatchPayments batchPayments, Boolean summarizeErrors, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createBatchPayment");
        }
        if (batchPayments == null) {
            throw new IllegalArgumentException("Missing the required parameter 'batchPayments' when calling createBatchPayment");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createBatchPayment");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/BatchPayments"));
        if (summarizeErrors != null) {
            String key = "summarizeErrors";
            Boolean value = summarizeErrors;
            if (value instanceof Collection) {
                ArrayList valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(batchPayments);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public HistoryRecords createBatchPaymentHistoryRecord(String accessToken, String xeroTenantId, UUID batchPaymentID, HistoryRecords historyRecords, String idempotencyKey) throws IOException {
        try {
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            HttpResponse response = this.createBatchPaymentHistoryRecordForHttpResponse(accessToken, xeroTenantId, batchPaymentID, historyRecords, idempotencyKey);
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createBatchPaymentHistoryRecord -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("HistoryRecords", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("HistoryRecords", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createBatchPaymentHistoryRecordForHttpResponse(String accessToken, String xeroTenantId, UUID batchPaymentID, HistoryRecords historyRecords, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createBatchPaymentHistoryRecord");
        }
        if (batchPaymentID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'batchPaymentID' when calling createBatchPaymentHistoryRecord");
        }
        if (historyRecords == null) {
            throw new IllegalArgumentException("Missing the required parameter 'historyRecords' when calling createBatchPaymentHistoryRecord");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createBatchPaymentHistoryRecord");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("BatchPaymentID", batchPaymentID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/BatchPayments/{BatchPaymentID}/History"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(historyRecords);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public PaymentServices createBrandingThemePaymentServices(String accessToken, String xeroTenantId, UUID brandingThemeID, PaymentServices paymentServices, String idempotencyKey) throws IOException {
        try {
            TypeReference<PaymentServices> typeRef = new TypeReference<PaymentServices>(){};
            HttpResponse response = this.createBrandingThemePaymentServicesForHttpResponse(accessToken, xeroTenantId, brandingThemeID, paymentServices, idempotencyKey);
            return (PaymentServices)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createBrandingThemePaymentServices -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("PaymentServices", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("PaymentServices", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createBrandingThemePaymentServicesForHttpResponse(String accessToken, String xeroTenantId, UUID brandingThemeID, PaymentServices paymentServices, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createBrandingThemePaymentServices");
        }
        if (brandingThemeID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'brandingThemeID' when calling createBrandingThemePaymentServices");
        }
        if (paymentServices == null) {
            throw new IllegalArgumentException("Missing the required parameter 'paymentServices' when calling createBrandingThemePaymentServices");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createBrandingThemePaymentServices");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("BrandingThemeID", brandingThemeID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/BrandingThemes/{BrandingThemeID}/PaymentServices"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(paymentServices);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments createContactAttachmentByFileName(String accessToken, String xeroTenantId, UUID contactID, String fileName, byte[] body, String idempotencyKey, String mimeType) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.createContactAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, contactID, fileName, body, idempotencyKey, mimeType);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createContactAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createContactAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID contactID, String fileName, byte[] body, String idempotencyKey, String mimeType) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createContactAttachmentByFileName");
        }
        if (contactID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contactID' when calling createContactAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling createContactAttachmentByFileName");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling createContactAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createContactAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("ContactID", contactID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Contacts/{ContactID}/Attachments/{FileName}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ByteArrayContent content = null;
        content = new ByteArrayContent(mimeType, body);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments createContactAttachmentByFileName(String accessToken, String xeroTenantId, UUID contactID, String fileName, File body, String idempotencyKey) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.createContactAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, contactID, fileName, body, idempotencyKey);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createContactAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("Attachments", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("Attachments", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createContactAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID contactID, String fileName, File body, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createContactAttachmentByFileName");
        }
        if (contactID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contactID' when calling createContactAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling createContactAttachmentByFileName");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling createContactAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createContactAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("ContactID", contactID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Contacts/{ContactID}/Attachments/{FileName}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        Path bodyPath = body.toPath();
        String mimeType = Files.probeContentType(bodyPath);
        FileContent content = null;
        content = new FileContent(mimeType, body);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ContactGroups createContactGroup(String accessToken, String xeroTenantId, ContactGroups contactGroups, String idempotencyKey) throws IOException {
        try {
            TypeReference<ContactGroups> typeRef = new TypeReference<ContactGroups>(){};
            HttpResponse response = this.createContactGroupForHttpResponse(accessToken, xeroTenantId, contactGroups, idempotencyKey);
            return (ContactGroups)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createContactGroup -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("ContactGroups", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("ContactGroups", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createContactGroupForHttpResponse(String accessToken, String xeroTenantId, ContactGroups contactGroups, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createContactGroup");
        }
        if (contactGroups == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contactGroups' when calling createContactGroup");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createContactGroup");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/ContactGroups"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(contactGroups);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Contacts createContactGroupContacts(String accessToken, String xeroTenantId, UUID contactGroupID, Contacts contacts, String idempotencyKey) throws IOException {
        try {
            TypeReference<Contacts> typeRef = new TypeReference<Contacts>(){};
            HttpResponse response = this.createContactGroupContactsForHttpResponse(accessToken, xeroTenantId, contactGroupID, contacts, idempotencyKey);
            return (Contacts)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createContactGroupContacts -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("Contacts", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("Contacts", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createContactGroupContactsForHttpResponse(String accessToken, String xeroTenantId, UUID contactGroupID, Contacts contacts, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createContactGroupContacts");
        }
        if (contactGroupID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contactGroupID' when calling createContactGroupContacts");
        }
        if (contacts == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contacts' when calling createContactGroupContacts");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createContactGroupContacts");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("ContactGroupID", contactGroupID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/ContactGroups/{ContactGroupID}/Contacts"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(contacts);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public HistoryRecords createContactHistory(String accessToken, String xeroTenantId, UUID contactID, HistoryRecords historyRecords, String idempotencyKey) throws IOException {
        try {
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            HttpResponse response = this.createContactHistoryForHttpResponse(accessToken, xeroTenantId, contactID, historyRecords, idempotencyKey);
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createContactHistory -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("HistoryRecords", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("HistoryRecords", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createContactHistoryForHttpResponse(String accessToken, String xeroTenantId, UUID contactID, HistoryRecords historyRecords, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createContactHistory");
        }
        if (contactID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contactID' when calling createContactHistory");
        }
        if (historyRecords == null) {
            throw new IllegalArgumentException("Missing the required parameter 'historyRecords' when calling createContactHistory");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createContactHistory");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("ContactID", contactID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Contacts/{ContactID}/History"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(historyRecords);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Contacts createContacts(String accessToken, String xeroTenantId, Contacts contacts, Boolean summarizeErrors, String idempotencyKey) throws IOException {
        try {
            TypeReference<Contacts> typeRef = new TypeReference<Contacts>(){};
            HttpResponse response = this.createContactsForHttpResponse(accessToken, xeroTenantId, contacts, summarizeErrors, idempotencyKey);
            return (Contacts)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createContacts -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("Contacts", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("Contacts", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createContactsForHttpResponse(String accessToken, String xeroTenantId, Contacts contacts, Boolean summarizeErrors, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createContacts");
        }
        if (contacts == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contacts' when calling createContacts");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createContacts");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Contacts"));
        if (summarizeErrors != null) {
            String key = "summarizeErrors";
            Boolean value = summarizeErrors;
            if (value instanceof Collection) {
                ArrayList valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(contacts);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Allocations createCreditNoteAllocation(String accessToken, String xeroTenantId, UUID creditNoteID, Allocations allocations, Boolean summarizeErrors, String idempotencyKey) throws IOException {
        try {
            TypeReference<Allocations> typeRef = new TypeReference<Allocations>(){};
            HttpResponse response = this.createCreditNoteAllocationForHttpResponse(accessToken, xeroTenantId, creditNoteID, allocations, summarizeErrors, idempotencyKey);
            return (Allocations)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createCreditNoteAllocation -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("Allocations", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("Allocations", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createCreditNoteAllocationForHttpResponse(String accessToken, String xeroTenantId, UUID creditNoteID, Allocations allocations, Boolean summarizeErrors, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createCreditNoteAllocation");
        }
        if (creditNoteID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'creditNoteID' when calling createCreditNoteAllocation");
        }
        if (allocations == null) {
            throw new IllegalArgumentException("Missing the required parameter 'allocations' when calling createCreditNoteAllocation");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createCreditNoteAllocation");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("CreditNoteID", creditNoteID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/CreditNotes/{CreditNoteID}/Allocations"));
        if (summarizeErrors != null) {
            String key = "summarizeErrors";
            Boolean value = summarizeErrors;
            if (value instanceof Collection) {
                ArrayList valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(allocations);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments createCreditNoteAttachmentByFileName(String accessToken, String xeroTenantId, UUID creditNoteID, String fileName, byte[] body, Boolean includeOnline, String idempotencyKey, String mimeType) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.createCreditNoteAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, creditNoteID, fileName, body, includeOnline, idempotencyKey, mimeType);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createCreditNoteAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createCreditNoteAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID creditNoteID, String fileName, byte[] body, Boolean includeOnline, String idempotencyKey, String mimeType) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createCreditNoteAttachmentByFileName");
        }
        if (creditNoteID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'creditNoteID' when calling createCreditNoteAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling createCreditNoteAttachmentByFileName");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling createCreditNoteAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createCreditNoteAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("CreditNoteID", creditNoteID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/CreditNotes/{CreditNoteID}/Attachments/{FileName}"));
        if (includeOnline != null) {
            String key = "IncludeOnline";
            Boolean value = includeOnline;
            if (value instanceof Collection) {
                ArrayList valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ByteArrayContent content = null;
        content = new ByteArrayContent(mimeType, body);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments createCreditNoteAttachmentByFileName(String accessToken, String xeroTenantId, UUID creditNoteID, String fileName, File body, Boolean includeOnline, String idempotencyKey) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.createCreditNoteAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, creditNoteID, fileName, body, includeOnline, idempotencyKey);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createCreditNoteAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("Attachments", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("Attachments", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createCreditNoteAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID creditNoteID, String fileName, File body, Boolean includeOnline, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createCreditNoteAttachmentByFileName");
        }
        if (creditNoteID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'creditNoteID' when calling createCreditNoteAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling createCreditNoteAttachmentByFileName");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling createCreditNoteAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createCreditNoteAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("CreditNoteID", creditNoteID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/CreditNotes/{CreditNoteID}/Attachments/{FileName}"));
        if (includeOnline != null) {
            String key = "IncludeOnline";
            Boolean value = includeOnline;
            if (value instanceof Collection) {
                ArrayList valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        Path bodyPath = body.toPath();
        String mimeType = Files.probeContentType(bodyPath);
        FileContent content = null;
        content = new FileContent(mimeType, body);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public HistoryRecords createCreditNoteHistory(String accessToken, String xeroTenantId, UUID creditNoteID, HistoryRecords historyRecords, String idempotencyKey) throws IOException {
        try {
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            HttpResponse response = this.createCreditNoteHistoryForHttpResponse(accessToken, xeroTenantId, creditNoteID, historyRecords, idempotencyKey);
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createCreditNoteHistory -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("HistoryRecords", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("HistoryRecords", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createCreditNoteHistoryForHttpResponse(String accessToken, String xeroTenantId, UUID creditNoteID, HistoryRecords historyRecords, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createCreditNoteHistory");
        }
        if (creditNoteID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'creditNoteID' when calling createCreditNoteHistory");
        }
        if (historyRecords == null) {
            throw new IllegalArgumentException("Missing the required parameter 'historyRecords' when calling createCreditNoteHistory");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createCreditNoteHistory");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("CreditNoteID", creditNoteID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/CreditNotes/{CreditNoteID}/History"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(historyRecords);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public CreditNotes createCreditNotes(String accessToken, String xeroTenantId, CreditNotes creditNotes, Boolean summarizeErrors, Integer unitdp, String idempotencyKey) throws IOException {
        try {
            TypeReference<CreditNotes> typeRef = new TypeReference<CreditNotes>(){};
            HttpResponse response = this.createCreditNotesForHttpResponse(accessToken, xeroTenantId, creditNotes, summarizeErrors, unitdp, idempotencyKey);
            return (CreditNotes)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createCreditNotes -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("CreditNotes", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("CreditNotes", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createCreditNotesForHttpResponse(String accessToken, String xeroTenantId, CreditNotes creditNotes, Boolean summarizeErrors, Integer unitdp, String idempotencyKey) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        Comparable<Boolean> value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createCreditNotes");
        }
        if (creditNotes == null) {
            throw new IllegalArgumentException("Missing the required parameter 'creditNotes' when calling createCreditNotes");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createCreditNotes");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/CreditNotes"));
        if (summarizeErrors != null) {
            key = "summarizeErrors";
            value = summarizeErrors;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (unitdp != null) {
            key = "unitdp";
            value = unitdp;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(creditNotes);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Currencies createCurrency(String accessToken, String xeroTenantId, Currency currency, String idempotencyKey) throws IOException {
        try {
            TypeReference<Currencies> typeRef = new TypeReference<Currencies>(){};
            HttpResponse response = this.createCurrencyForHttpResponse(accessToken, xeroTenantId, currency, idempotencyKey);
            return (Currencies)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createCurrency -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("Currencies", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("Currencies", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createCurrencyForHttpResponse(String accessToken, String xeroTenantId, Currency currency, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createCurrency");
        }
        if (currency == null) {
            throw new IllegalArgumentException("Missing the required parameter 'currency' when calling createCurrency");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createCurrency");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Currencies"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(currency);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Employees createEmployees(String accessToken, String xeroTenantId, Employees employees, Boolean summarizeErrors, String idempotencyKey) throws IOException {
        try {
            TypeReference<Employees> typeRef = new TypeReference<Employees>(){};
            HttpResponse response = this.createEmployeesForHttpResponse(accessToken, xeroTenantId, employees, summarizeErrors, idempotencyKey);
            return (Employees)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createEmployees -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("Employees", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("Employees", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createEmployeesForHttpResponse(String accessToken, String xeroTenantId, Employees employees, Boolean summarizeErrors, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createEmployees");
        }
        if (employees == null) {
            throw new IllegalArgumentException("Missing the required parameter 'employees' when calling createEmployees");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createEmployees");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Employees"));
        if (summarizeErrors != null) {
            String key = "summarizeErrors";
            Boolean value = summarizeErrors;
            if (value instanceof Collection) {
                ArrayList valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(employees);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public HistoryRecords createExpenseClaimHistory(String accessToken, String xeroTenantId, UUID expenseClaimID, HistoryRecords historyRecords, String idempotencyKey) throws IOException {
        try {
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            HttpResponse response = this.createExpenseClaimHistoryForHttpResponse(accessToken, xeroTenantId, expenseClaimID, historyRecords, idempotencyKey);
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createExpenseClaimHistory -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("HistoryRecords", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("HistoryRecords", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createExpenseClaimHistoryForHttpResponse(String accessToken, String xeroTenantId, UUID expenseClaimID, HistoryRecords historyRecords, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createExpenseClaimHistory");
        }
        if (expenseClaimID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'expenseClaimID' when calling createExpenseClaimHistory");
        }
        if (historyRecords == null) {
            throw new IllegalArgumentException("Missing the required parameter 'historyRecords' when calling createExpenseClaimHistory");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createExpenseClaimHistory");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("ExpenseClaimID", expenseClaimID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/ExpenseClaims/{ExpenseClaimID}/History"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(historyRecords);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ExpenseClaims createExpenseClaims(String accessToken, String xeroTenantId, ExpenseClaims expenseClaims, String idempotencyKey) throws IOException {
        try {
            TypeReference<ExpenseClaims> typeRef = new TypeReference<ExpenseClaims>(){};
            HttpResponse response = this.createExpenseClaimsForHttpResponse(accessToken, xeroTenantId, expenseClaims, idempotencyKey);
            return (ExpenseClaims)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createExpenseClaims -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("ExpenseClaims", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("ExpenseClaims", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createExpenseClaimsForHttpResponse(String accessToken, String xeroTenantId, ExpenseClaims expenseClaims, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createExpenseClaims");
        }
        if (expenseClaims == null) {
            throw new IllegalArgumentException("Missing the required parameter 'expenseClaims' when calling createExpenseClaims");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createExpenseClaims");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/ExpenseClaims"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(expenseClaims);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments createInvoiceAttachmentByFileName(String accessToken, String xeroTenantId, UUID invoiceID, String fileName, byte[] body, Boolean includeOnline, String idempotencyKey, String mimeType) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.createInvoiceAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, invoiceID, fileName, body, includeOnline, idempotencyKey, mimeType);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createInvoiceAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createInvoiceAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID invoiceID, String fileName, byte[] body, Boolean includeOnline, String idempotencyKey, String mimeType) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createInvoiceAttachmentByFileName");
        }
        if (invoiceID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'invoiceID' when calling createInvoiceAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling createInvoiceAttachmentByFileName");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling createInvoiceAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createInvoiceAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("InvoiceID", invoiceID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Invoices/{InvoiceID}/Attachments/{FileName}"));
        if (includeOnline != null) {
            String key = "IncludeOnline";
            Boolean value = includeOnline;
            if (value instanceof Collection) {
                ArrayList valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ByteArrayContent content = null;
        content = new ByteArrayContent(mimeType, body);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments createInvoiceAttachmentByFileName(String accessToken, String xeroTenantId, UUID invoiceID, String fileName, File body, Boolean includeOnline, String idempotencyKey) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.createInvoiceAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, invoiceID, fileName, body, includeOnline, idempotencyKey);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createInvoiceAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("Attachments", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("Attachments", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createInvoiceAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID invoiceID, String fileName, File body, Boolean includeOnline, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createInvoiceAttachmentByFileName");
        }
        if (invoiceID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'invoiceID' when calling createInvoiceAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling createInvoiceAttachmentByFileName");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling createInvoiceAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createInvoiceAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("InvoiceID", invoiceID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Invoices/{InvoiceID}/Attachments/{FileName}"));
        if (includeOnline != null) {
            String key = "IncludeOnline";
            Boolean value = includeOnline;
            if (value instanceof Collection) {
                ArrayList valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        Path bodyPath = body.toPath();
        String mimeType = Files.probeContentType(bodyPath);
        FileContent content = null;
        content = new FileContent(mimeType, body);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public HistoryRecords createInvoiceHistory(String accessToken, String xeroTenantId, UUID invoiceID, HistoryRecords historyRecords, String idempotencyKey) throws IOException {
        try {
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            HttpResponse response = this.createInvoiceHistoryForHttpResponse(accessToken, xeroTenantId, invoiceID, historyRecords, idempotencyKey);
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createInvoiceHistory -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("HistoryRecords", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("HistoryRecords", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createInvoiceHistoryForHttpResponse(String accessToken, String xeroTenantId, UUID invoiceID, HistoryRecords historyRecords, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createInvoiceHistory");
        }
        if (invoiceID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'invoiceID' when calling createInvoiceHistory");
        }
        if (historyRecords == null) {
            throw new IllegalArgumentException("Missing the required parameter 'historyRecords' when calling createInvoiceHistory");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createInvoiceHistory");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("InvoiceID", invoiceID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Invoices/{InvoiceID}/History"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(historyRecords);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Invoices createInvoices(String accessToken, String xeroTenantId, Invoices invoices, Boolean summarizeErrors, Integer unitdp, String idempotencyKey) throws IOException {
        try {
            TypeReference<Invoices> typeRef = new TypeReference<Invoices>(){};
            HttpResponse response = this.createInvoicesForHttpResponse(accessToken, xeroTenantId, invoices, summarizeErrors, unitdp, idempotencyKey);
            return (Invoices)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createInvoices -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("Invoices", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("Invoices", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createInvoicesForHttpResponse(String accessToken, String xeroTenantId, Invoices invoices, Boolean summarizeErrors, Integer unitdp, String idempotencyKey) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        Comparable<Boolean> value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createInvoices");
        }
        if (invoices == null) {
            throw new IllegalArgumentException("Missing the required parameter 'invoices' when calling createInvoices");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createInvoices");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Invoices"));
        if (summarizeErrors != null) {
            key = "summarizeErrors";
            value = summarizeErrors;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (unitdp != null) {
            key = "unitdp";
            value = unitdp;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(invoices);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public HistoryRecords createItemHistory(String accessToken, String xeroTenantId, UUID itemID, HistoryRecords historyRecords, String idempotencyKey) throws IOException {
        try {
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            HttpResponse response = this.createItemHistoryForHttpResponse(accessToken, xeroTenantId, itemID, historyRecords, idempotencyKey);
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createItemHistory -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("HistoryRecords", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("HistoryRecords", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createItemHistoryForHttpResponse(String accessToken, String xeroTenantId, UUID itemID, HistoryRecords historyRecords, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createItemHistory");
        }
        if (itemID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'itemID' when calling createItemHistory");
        }
        if (historyRecords == null) {
            throw new IllegalArgumentException("Missing the required parameter 'historyRecords' when calling createItemHistory");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createItemHistory");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("ItemID", itemID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Items/{ItemID}/History"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(historyRecords);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Items createItems(String accessToken, String xeroTenantId, Items items, Boolean summarizeErrors, Integer unitdp, String idempotencyKey) throws IOException {
        try {
            TypeReference<Items> typeRef = new TypeReference<Items>(){};
            HttpResponse response = this.createItemsForHttpResponse(accessToken, xeroTenantId, items, summarizeErrors, unitdp, idempotencyKey);
            return (Items)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createItems -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("Items", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("Items", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createItemsForHttpResponse(String accessToken, String xeroTenantId, Items items, Boolean summarizeErrors, Integer unitdp, String idempotencyKey) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        Comparable<Boolean> value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createItems");
        }
        if (items == null) {
            throw new IllegalArgumentException("Missing the required parameter 'items' when calling createItems");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createItems");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Items"));
        if (summarizeErrors != null) {
            key = "summarizeErrors";
            value = summarizeErrors;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (unitdp != null) {
            key = "unitdp";
            value = unitdp;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(items);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public LinkedTransactions createLinkedTransaction(String accessToken, String xeroTenantId, LinkedTransaction linkedTransaction, String idempotencyKey) throws IOException {
        try {
            TypeReference<LinkedTransactions> typeRef = new TypeReference<LinkedTransactions>(){};
            HttpResponse response = this.createLinkedTransactionForHttpResponse(accessToken, xeroTenantId, linkedTransaction, idempotencyKey);
            return (LinkedTransactions)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createLinkedTransaction -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("LinkedTransactions", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("LinkedTransactions", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createLinkedTransactionForHttpResponse(String accessToken, String xeroTenantId, LinkedTransaction linkedTransaction, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createLinkedTransaction");
        }
        if (linkedTransaction == null) {
            throw new IllegalArgumentException("Missing the required parameter 'linkedTransaction' when calling createLinkedTransaction");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createLinkedTransaction");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/LinkedTransactions"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(linkedTransaction);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments createManualJournalAttachmentByFileName(String accessToken, String xeroTenantId, UUID manualJournalID, String fileName, byte[] body, String idempotencyKey, String mimeType) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.createManualJournalAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, manualJournalID, fileName, body, idempotencyKey, mimeType);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createManualJournalAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createManualJournalAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID manualJournalID, String fileName, byte[] body, String idempotencyKey, String mimeType) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createManualJournalAttachmentByFileName");
        }
        if (manualJournalID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'manualJournalID' when calling createManualJournalAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling createManualJournalAttachmentByFileName");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling createManualJournalAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createManualJournalAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("ManualJournalID", manualJournalID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/ManualJournals/{ManualJournalID}/Attachments/{FileName}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ByteArrayContent content = null;
        content = new ByteArrayContent(mimeType, body);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments createManualJournalAttachmentByFileName(String accessToken, String xeroTenantId, UUID manualJournalID, String fileName, File body, String idempotencyKey) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.createManualJournalAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, manualJournalID, fileName, body, idempotencyKey);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createManualJournalAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("Attachments", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("Attachments", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createManualJournalAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID manualJournalID, String fileName, File body, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createManualJournalAttachmentByFileName");
        }
        if (manualJournalID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'manualJournalID' when calling createManualJournalAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling createManualJournalAttachmentByFileName");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling createManualJournalAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createManualJournalAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("ManualJournalID", manualJournalID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/ManualJournals/{ManualJournalID}/Attachments/{FileName}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        Path bodyPath = body.toPath();
        String mimeType = Files.probeContentType(bodyPath);
        FileContent content = null;
        content = new FileContent(mimeType, body);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public HistoryRecords createManualJournalHistoryRecord(String accessToken, String xeroTenantId, UUID manualJournalID, HistoryRecords historyRecords, String idempotencyKey) throws IOException {
        try {
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            HttpResponse response = this.createManualJournalHistoryRecordForHttpResponse(accessToken, xeroTenantId, manualJournalID, historyRecords, idempotencyKey);
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createManualJournalHistoryRecord -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("HistoryRecords", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("HistoryRecords", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createManualJournalHistoryRecordForHttpResponse(String accessToken, String xeroTenantId, UUID manualJournalID, HistoryRecords historyRecords, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createManualJournalHistoryRecord");
        }
        if (manualJournalID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'manualJournalID' when calling createManualJournalHistoryRecord");
        }
        if (historyRecords == null) {
            throw new IllegalArgumentException("Missing the required parameter 'historyRecords' when calling createManualJournalHistoryRecord");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createManualJournalHistoryRecord");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("ManualJournalID", manualJournalID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/ManualJournals/{ManualJournalID}/History"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(historyRecords);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ManualJournals createManualJournals(String accessToken, String xeroTenantId, ManualJournals manualJournals, Boolean summarizeErrors, String idempotencyKey) throws IOException {
        try {
            TypeReference<ManualJournals> typeRef = new TypeReference<ManualJournals>(){};
            HttpResponse response = this.createManualJournalsForHttpResponse(accessToken, xeroTenantId, manualJournals, summarizeErrors, idempotencyKey);
            return (ManualJournals)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createManualJournals -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("ManualJournals", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("ManualJournals", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createManualJournalsForHttpResponse(String accessToken, String xeroTenantId, ManualJournals manualJournals, Boolean summarizeErrors, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createManualJournals");
        }
        if (manualJournals == null) {
            throw new IllegalArgumentException("Missing the required parameter 'manualJournals' when calling createManualJournals");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createManualJournals");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/ManualJournals"));
        if (summarizeErrors != null) {
            String key = "summarizeErrors";
            Boolean value = summarizeErrors;
            if (value instanceof Collection) {
                ArrayList valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(manualJournals);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Allocations createOverpaymentAllocations(String accessToken, String xeroTenantId, UUID overpaymentID, Allocations allocations, Boolean summarizeErrors, String idempotencyKey) throws IOException {
        try {
            TypeReference<Allocations> typeRef = new TypeReference<Allocations>(){};
            HttpResponse response = this.createOverpaymentAllocationsForHttpResponse(accessToken, xeroTenantId, overpaymentID, allocations, summarizeErrors, idempotencyKey);
            return (Allocations)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createOverpaymentAllocations -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("Allocations", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("Allocations", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createOverpaymentAllocationsForHttpResponse(String accessToken, String xeroTenantId, UUID overpaymentID, Allocations allocations, Boolean summarizeErrors, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createOverpaymentAllocations");
        }
        if (overpaymentID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'overpaymentID' when calling createOverpaymentAllocations");
        }
        if (allocations == null) {
            throw new IllegalArgumentException("Missing the required parameter 'allocations' when calling createOverpaymentAllocations");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createOverpaymentAllocations");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("OverpaymentID", overpaymentID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Overpayments/{OverpaymentID}/Allocations"));
        if (summarizeErrors != null) {
            String key = "summarizeErrors";
            Boolean value = summarizeErrors;
            if (value instanceof Collection) {
                ArrayList valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(allocations);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public HistoryRecords createOverpaymentHistory(String accessToken, String xeroTenantId, UUID overpaymentID, HistoryRecords historyRecords, String idempotencyKey) throws IOException {
        try {
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            HttpResponse response = this.createOverpaymentHistoryForHttpResponse(accessToken, xeroTenantId, overpaymentID, historyRecords, idempotencyKey);
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createOverpaymentHistory -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("HistoryRecords", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("HistoryRecords", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createOverpaymentHistoryForHttpResponse(String accessToken, String xeroTenantId, UUID overpaymentID, HistoryRecords historyRecords, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createOverpaymentHistory");
        }
        if (overpaymentID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'overpaymentID' when calling createOverpaymentHistory");
        }
        if (historyRecords == null) {
            throw new IllegalArgumentException("Missing the required parameter 'historyRecords' when calling createOverpaymentHistory");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createOverpaymentHistory");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("OverpaymentID", overpaymentID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Overpayments/{OverpaymentID}/History"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(historyRecords);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Payments createPayment(String accessToken, String xeroTenantId, Payment payment, String idempotencyKey) throws IOException {
        try {
            TypeReference<Payments> typeRef = new TypeReference<Payments>(){};
            HttpResponse response = this.createPaymentForHttpResponse(accessToken, xeroTenantId, payment, idempotencyKey);
            return (Payments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createPayment -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("Payments", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("Payments", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createPaymentForHttpResponse(String accessToken, String xeroTenantId, Payment payment, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createPayment");
        }
        if (payment == null) {
            throw new IllegalArgumentException("Missing the required parameter 'payment' when calling createPayment");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createPayment");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Payments"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(payment);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public HistoryRecords createPaymentHistory(String accessToken, String xeroTenantId, UUID paymentID, HistoryRecords historyRecords, String idempotencyKey) throws IOException {
        try {
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            HttpResponse response = this.createPaymentHistoryForHttpResponse(accessToken, xeroTenantId, paymentID, historyRecords, idempotencyKey);
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createPaymentHistory -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("HistoryRecords", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("HistoryRecords", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createPaymentHistoryForHttpResponse(String accessToken, String xeroTenantId, UUID paymentID, HistoryRecords historyRecords, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createPaymentHistory");
        }
        if (paymentID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'paymentID' when calling createPaymentHistory");
        }
        if (historyRecords == null) {
            throw new IllegalArgumentException("Missing the required parameter 'historyRecords' when calling createPaymentHistory");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createPaymentHistory");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("PaymentID", paymentID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Payments/{PaymentID}/History"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(historyRecords);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public PaymentServices createPaymentService(String accessToken, String xeroTenantId, PaymentServices paymentServices, String idempotencyKey) throws IOException {
        try {
            TypeReference<PaymentServices> typeRef = new TypeReference<PaymentServices>(){};
            HttpResponse response = this.createPaymentServiceForHttpResponse(accessToken, xeroTenantId, paymentServices, idempotencyKey);
            return (PaymentServices)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createPaymentService -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("PaymentServices", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("PaymentServices", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createPaymentServiceForHttpResponse(String accessToken, String xeroTenantId, PaymentServices paymentServices, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createPaymentService");
        }
        if (paymentServices == null) {
            throw new IllegalArgumentException("Missing the required parameter 'paymentServices' when calling createPaymentService");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createPaymentService");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/PaymentServices"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(paymentServices);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Payments createPayments(String accessToken, String xeroTenantId, Payments payments, Boolean summarizeErrors, String idempotencyKey) throws IOException {
        try {
            TypeReference<Payments> typeRef = new TypeReference<Payments>(){};
            HttpResponse response = this.createPaymentsForHttpResponse(accessToken, xeroTenantId, payments, summarizeErrors, idempotencyKey);
            return (Payments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createPayments -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("Payments", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("Payments", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createPaymentsForHttpResponse(String accessToken, String xeroTenantId, Payments payments, Boolean summarizeErrors, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createPayments");
        }
        if (payments == null) {
            throw new IllegalArgumentException("Missing the required parameter 'payments' when calling createPayments");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createPayments");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Payments"));
        if (summarizeErrors != null) {
            String key = "summarizeErrors";
            Boolean value = summarizeErrors;
            if (value instanceof Collection) {
                ArrayList valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(payments);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Allocations createPrepaymentAllocations(String accessToken, String xeroTenantId, UUID prepaymentID, Allocations allocations, Boolean summarizeErrors, String idempotencyKey) throws IOException {
        try {
            TypeReference<Allocations> typeRef = new TypeReference<Allocations>(){};
            HttpResponse response = this.createPrepaymentAllocationsForHttpResponse(accessToken, xeroTenantId, prepaymentID, allocations, summarizeErrors, idempotencyKey);
            return (Allocations)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createPrepaymentAllocations -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("Allocations", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("Allocations", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createPrepaymentAllocationsForHttpResponse(String accessToken, String xeroTenantId, UUID prepaymentID, Allocations allocations, Boolean summarizeErrors, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createPrepaymentAllocations");
        }
        if (prepaymentID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'prepaymentID' when calling createPrepaymentAllocations");
        }
        if (allocations == null) {
            throw new IllegalArgumentException("Missing the required parameter 'allocations' when calling createPrepaymentAllocations");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createPrepaymentAllocations");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("PrepaymentID", prepaymentID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Prepayments/{PrepaymentID}/Allocations"));
        if (summarizeErrors != null) {
            String key = "summarizeErrors";
            Boolean value = summarizeErrors;
            if (value instanceof Collection) {
                ArrayList valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(allocations);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public HistoryRecords createPrepaymentHistory(String accessToken, String xeroTenantId, UUID prepaymentID, HistoryRecords historyRecords, String idempotencyKey) throws IOException {
        try {
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            HttpResponse response = this.createPrepaymentHistoryForHttpResponse(accessToken, xeroTenantId, prepaymentID, historyRecords, idempotencyKey);
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createPrepaymentHistory -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("HistoryRecords", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("HistoryRecords", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createPrepaymentHistoryForHttpResponse(String accessToken, String xeroTenantId, UUID prepaymentID, HistoryRecords historyRecords, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createPrepaymentHistory");
        }
        if (prepaymentID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'prepaymentID' when calling createPrepaymentHistory");
        }
        if (historyRecords == null) {
            throw new IllegalArgumentException("Missing the required parameter 'historyRecords' when calling createPrepaymentHistory");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createPrepaymentHistory");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("PrepaymentID", prepaymentID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Prepayments/{PrepaymentID}/History"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(historyRecords);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments createPurchaseOrderAttachmentByFileName(String accessToken, String xeroTenantId, UUID purchaseOrderID, String fileName, byte[] body, String idempotencyKey, String mimeType) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.createPurchaseOrderAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, purchaseOrderID, fileName, body, idempotencyKey, mimeType);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createPurchaseOrderAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createPurchaseOrderAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID purchaseOrderID, String fileName, byte[] body, String idempotencyKey, String mimeType) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createPurchaseOrderAttachmentByFileName");
        }
        if (purchaseOrderID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'purchaseOrderID' when calling createPurchaseOrderAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling createPurchaseOrderAttachmentByFileName");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling createPurchaseOrderAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createPurchaseOrderAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("PurchaseOrderID", purchaseOrderID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/PurchaseOrders/{PurchaseOrderID}/Attachments/{FileName}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ByteArrayContent content = null;
        content = new ByteArrayContent(mimeType, body);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments createPurchaseOrderAttachmentByFileName(String accessToken, String xeroTenantId, UUID purchaseOrderID, String fileName, File body, String idempotencyKey) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.createPurchaseOrderAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, purchaseOrderID, fileName, body, idempotencyKey);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createPurchaseOrderAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("Attachments", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("Attachments", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createPurchaseOrderAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID purchaseOrderID, String fileName, File body, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createPurchaseOrderAttachmentByFileName");
        }
        if (purchaseOrderID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'purchaseOrderID' when calling createPurchaseOrderAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling createPurchaseOrderAttachmentByFileName");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling createPurchaseOrderAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createPurchaseOrderAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("PurchaseOrderID", purchaseOrderID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/PurchaseOrders/{PurchaseOrderID}/Attachments/{FileName}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        Path bodyPath = body.toPath();
        String mimeType = Files.probeContentType(bodyPath);
        FileContent content = null;
        content = new FileContent(mimeType, body);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public HistoryRecords createPurchaseOrderHistory(String accessToken, String xeroTenantId, UUID purchaseOrderID, HistoryRecords historyRecords, String idempotencyKey) throws IOException {
        try {
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            HttpResponse response = this.createPurchaseOrderHistoryForHttpResponse(accessToken, xeroTenantId, purchaseOrderID, historyRecords, idempotencyKey);
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createPurchaseOrderHistory -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("HistoryRecords", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("HistoryRecords", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createPurchaseOrderHistoryForHttpResponse(String accessToken, String xeroTenantId, UUID purchaseOrderID, HistoryRecords historyRecords, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createPurchaseOrderHistory");
        }
        if (purchaseOrderID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'purchaseOrderID' when calling createPurchaseOrderHistory");
        }
        if (historyRecords == null) {
            throw new IllegalArgumentException("Missing the required parameter 'historyRecords' when calling createPurchaseOrderHistory");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createPurchaseOrderHistory");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("PurchaseOrderID", purchaseOrderID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/PurchaseOrders/{PurchaseOrderID}/History"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(historyRecords);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public PurchaseOrders createPurchaseOrders(String accessToken, String xeroTenantId, PurchaseOrders purchaseOrders, Boolean summarizeErrors, String idempotencyKey) throws IOException {
        try {
            TypeReference<PurchaseOrders> typeRef = new TypeReference<PurchaseOrders>(){};
            HttpResponse response = this.createPurchaseOrdersForHttpResponse(accessToken, xeroTenantId, purchaseOrders, summarizeErrors, idempotencyKey);
            return (PurchaseOrders)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createPurchaseOrders -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("PurchaseOrders", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("PurchaseOrders", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createPurchaseOrdersForHttpResponse(String accessToken, String xeroTenantId, PurchaseOrders purchaseOrders, Boolean summarizeErrors, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createPurchaseOrders");
        }
        if (purchaseOrders == null) {
            throw new IllegalArgumentException("Missing the required parameter 'purchaseOrders' when calling createPurchaseOrders");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createPurchaseOrders");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/PurchaseOrders"));
        if (summarizeErrors != null) {
            String key = "summarizeErrors";
            Boolean value = summarizeErrors;
            if (value instanceof Collection) {
                ArrayList valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(purchaseOrders);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments createQuoteAttachmentByFileName(String accessToken, String xeroTenantId, UUID quoteID, String fileName, byte[] body, String idempotencyKey, String mimeType) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.createQuoteAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, quoteID, fileName, body, idempotencyKey, mimeType);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createQuoteAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createQuoteAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID quoteID, String fileName, byte[] body, String idempotencyKey, String mimeType) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createQuoteAttachmentByFileName");
        }
        if (quoteID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'quoteID' when calling createQuoteAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling createQuoteAttachmentByFileName");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling createQuoteAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createQuoteAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("QuoteID", quoteID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Quotes/{QuoteID}/Attachments/{FileName}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ByteArrayContent content = null;
        content = new ByteArrayContent(mimeType, body);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments createQuoteAttachmentByFileName(String accessToken, String xeroTenantId, UUID quoteID, String fileName, File body, String idempotencyKey) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.createQuoteAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, quoteID, fileName, body, idempotencyKey);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createQuoteAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("Attachments", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("Attachments", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createQuoteAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID quoteID, String fileName, File body, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createQuoteAttachmentByFileName");
        }
        if (quoteID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'quoteID' when calling createQuoteAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling createQuoteAttachmentByFileName");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling createQuoteAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createQuoteAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("QuoteID", quoteID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Quotes/{QuoteID}/Attachments/{FileName}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        Path bodyPath = body.toPath();
        String mimeType = Files.probeContentType(bodyPath);
        FileContent content = null;
        content = new FileContent(mimeType, body);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public HistoryRecords createQuoteHistory(String accessToken, String xeroTenantId, UUID quoteID, HistoryRecords historyRecords, String idempotencyKey) throws IOException {
        try {
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            HttpResponse response = this.createQuoteHistoryForHttpResponse(accessToken, xeroTenantId, quoteID, historyRecords, idempotencyKey);
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createQuoteHistory -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("HistoryRecords", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("HistoryRecords", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createQuoteHistoryForHttpResponse(String accessToken, String xeroTenantId, UUID quoteID, HistoryRecords historyRecords, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createQuoteHistory");
        }
        if (quoteID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'quoteID' when calling createQuoteHistory");
        }
        if (historyRecords == null) {
            throw new IllegalArgumentException("Missing the required parameter 'historyRecords' when calling createQuoteHistory");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createQuoteHistory");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("QuoteID", quoteID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Quotes/{QuoteID}/History"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(historyRecords);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Quotes createQuotes(String accessToken, String xeroTenantId, Quotes quotes, Boolean summarizeErrors, String idempotencyKey) throws IOException {
        try {
            TypeReference<Quotes> typeRef = new TypeReference<Quotes>(){};
            HttpResponse response = this.createQuotesForHttpResponse(accessToken, xeroTenantId, quotes, summarizeErrors, idempotencyKey);
            return (Quotes)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createQuotes -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("Quotes", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("Quotes", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createQuotesForHttpResponse(String accessToken, String xeroTenantId, Quotes quotes, Boolean summarizeErrors, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createQuotes");
        }
        if (quotes == null) {
            throw new IllegalArgumentException("Missing the required parameter 'quotes' when calling createQuotes");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createQuotes");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Quotes"));
        if (summarizeErrors != null) {
            String key = "summarizeErrors";
            Boolean value = summarizeErrors;
            if (value instanceof Collection) {
                ArrayList valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(quotes);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Receipts createReceipt(String accessToken, String xeroTenantId, Receipts receipts, Integer unitdp, String idempotencyKey) throws IOException {
        try {
            TypeReference<Receipts> typeRef = new TypeReference<Receipts>(){};
            HttpResponse response = this.createReceiptForHttpResponse(accessToken, xeroTenantId, receipts, unitdp, idempotencyKey);
            return (Receipts)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createReceipt -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("Receipts", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("Receipts", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createReceiptForHttpResponse(String accessToken, String xeroTenantId, Receipts receipts, Integer unitdp, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createReceipt");
        }
        if (receipts == null) {
            throw new IllegalArgumentException("Missing the required parameter 'receipts' when calling createReceipt");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createReceipt");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Receipts"));
        if (unitdp != null) {
            String key = "unitdp";
            Integer value = unitdp;
            if (value instanceof Collection) {
                ArrayList valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(receipts);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments createReceiptAttachmentByFileName(String accessToken, String xeroTenantId, UUID receiptID, String fileName, byte[] body, String idempotencyKey, String mimeType) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.createReceiptAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, receiptID, fileName, body, idempotencyKey, mimeType);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createReceiptAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createReceiptAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID receiptID, String fileName, byte[] body, String idempotencyKey, String mimeType) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createReceiptAttachmentByFileName");
        }
        if (receiptID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'receiptID' when calling createReceiptAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling createReceiptAttachmentByFileName");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling createReceiptAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createReceiptAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("ReceiptID", receiptID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Receipts/{ReceiptID}/Attachments/{FileName}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ByteArrayContent content = null;
        content = new ByteArrayContent(mimeType, body);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments createReceiptAttachmentByFileName(String accessToken, String xeroTenantId, UUID receiptID, String fileName, File body, String idempotencyKey) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.createReceiptAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, receiptID, fileName, body, idempotencyKey);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createReceiptAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("Attachments", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("Attachments", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createReceiptAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID receiptID, String fileName, File body, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createReceiptAttachmentByFileName");
        }
        if (receiptID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'receiptID' when calling createReceiptAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling createReceiptAttachmentByFileName");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling createReceiptAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createReceiptAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("ReceiptID", receiptID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Receipts/{ReceiptID}/Attachments/{FileName}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        Path bodyPath = body.toPath();
        String mimeType = Files.probeContentType(bodyPath);
        FileContent content = null;
        content = new FileContent(mimeType, body);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public HistoryRecords createReceiptHistory(String accessToken, String xeroTenantId, UUID receiptID, HistoryRecords historyRecords, String idempotencyKey) throws IOException {
        try {
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            HttpResponse response = this.createReceiptHistoryForHttpResponse(accessToken, xeroTenantId, receiptID, historyRecords, idempotencyKey);
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createReceiptHistory -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("HistoryRecords", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("HistoryRecords", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createReceiptHistoryForHttpResponse(String accessToken, String xeroTenantId, UUID receiptID, HistoryRecords historyRecords, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createReceiptHistory");
        }
        if (receiptID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'receiptID' when calling createReceiptHistory");
        }
        if (historyRecords == null) {
            throw new IllegalArgumentException("Missing the required parameter 'historyRecords' when calling createReceiptHistory");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createReceiptHistory");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("ReceiptID", receiptID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Receipts/{ReceiptID}/History"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(historyRecords);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments createRepeatingInvoiceAttachmentByFileName(String accessToken, String xeroTenantId, UUID repeatingInvoiceID, String fileName, byte[] body, String idempotencyKey, String mimeType) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.createRepeatingInvoiceAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, repeatingInvoiceID, fileName, body, idempotencyKey, mimeType);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createRepeatingInvoiceAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createRepeatingInvoiceAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID repeatingInvoiceID, String fileName, byte[] body, String idempotencyKey, String mimeType) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createRepeatingInvoiceAttachmentByFileName");
        }
        if (repeatingInvoiceID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'repeatingInvoiceID' when calling createRepeatingInvoiceAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling createRepeatingInvoiceAttachmentByFileName");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling createRepeatingInvoiceAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createRepeatingInvoiceAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("RepeatingInvoiceID", repeatingInvoiceID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/RepeatingInvoices/{RepeatingInvoiceID}/Attachments/{FileName}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ByteArrayContent content = null;
        content = new ByteArrayContent(mimeType, body);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments createRepeatingInvoiceAttachmentByFileName(String accessToken, String xeroTenantId, UUID repeatingInvoiceID, String fileName, File body, String idempotencyKey) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.createRepeatingInvoiceAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, repeatingInvoiceID, fileName, body, idempotencyKey);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createRepeatingInvoiceAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("Attachments", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("Attachments", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createRepeatingInvoiceAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID repeatingInvoiceID, String fileName, File body, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createRepeatingInvoiceAttachmentByFileName");
        }
        if (repeatingInvoiceID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'repeatingInvoiceID' when calling createRepeatingInvoiceAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling createRepeatingInvoiceAttachmentByFileName");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling createRepeatingInvoiceAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createRepeatingInvoiceAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("RepeatingInvoiceID", repeatingInvoiceID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/RepeatingInvoices/{RepeatingInvoiceID}/Attachments/{FileName}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        Path bodyPath = body.toPath();
        String mimeType = Files.probeContentType(bodyPath);
        FileContent content = null;
        content = new FileContent(mimeType, body);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public HistoryRecords createRepeatingInvoiceHistory(String accessToken, String xeroTenantId, UUID repeatingInvoiceID, HistoryRecords historyRecords, String idempotencyKey) throws IOException {
        try {
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            HttpResponse response = this.createRepeatingInvoiceHistoryForHttpResponse(accessToken, xeroTenantId, repeatingInvoiceID, historyRecords, idempotencyKey);
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createRepeatingInvoiceHistory -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("HistoryRecords", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("HistoryRecords", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createRepeatingInvoiceHistoryForHttpResponse(String accessToken, String xeroTenantId, UUID repeatingInvoiceID, HistoryRecords historyRecords, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createRepeatingInvoiceHistory");
        }
        if (repeatingInvoiceID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'repeatingInvoiceID' when calling createRepeatingInvoiceHistory");
        }
        if (historyRecords == null) {
            throw new IllegalArgumentException("Missing the required parameter 'historyRecords' when calling createRepeatingInvoiceHistory");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createRepeatingInvoiceHistory");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("RepeatingInvoiceID", repeatingInvoiceID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/RepeatingInvoices/{RepeatingInvoiceID}/History"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(historyRecords);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public RepeatingInvoices createRepeatingInvoices(String accessToken, String xeroTenantId, RepeatingInvoices repeatingInvoices, Boolean summarizeErrors, String idempotencyKey) throws IOException {
        try {
            TypeReference<RepeatingInvoices> typeRef = new TypeReference<RepeatingInvoices>(){};
            HttpResponse response = this.createRepeatingInvoicesForHttpResponse(accessToken, xeroTenantId, repeatingInvoices, summarizeErrors, idempotencyKey);
            return (RepeatingInvoices)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createRepeatingInvoices -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("RepeatingInvoices", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("RepeatingInvoices", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createRepeatingInvoicesForHttpResponse(String accessToken, String xeroTenantId, RepeatingInvoices repeatingInvoices, Boolean summarizeErrors, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createRepeatingInvoices");
        }
        if (repeatingInvoices == null) {
            throw new IllegalArgumentException("Missing the required parameter 'repeatingInvoices' when calling createRepeatingInvoices");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createRepeatingInvoices");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/RepeatingInvoices"));
        if (summarizeErrors != null) {
            String key = "summarizeErrors";
            Boolean value = summarizeErrors;
            if (value instanceof Collection) {
                ArrayList valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(repeatingInvoices);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public TaxRates createTaxRates(String accessToken, String xeroTenantId, TaxRates taxRates, String idempotencyKey) throws IOException {
        try {
            TypeReference<TaxRates> typeRef = new TypeReference<TaxRates>(){};
            HttpResponse response = this.createTaxRatesForHttpResponse(accessToken, xeroTenantId, taxRates, idempotencyKey);
            return (TaxRates)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createTaxRates -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("TaxRates", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("TaxRates", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createTaxRatesForHttpResponse(String accessToken, String xeroTenantId, TaxRates taxRates, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createTaxRates");
        }
        if (taxRates == null) {
            throw new IllegalArgumentException("Missing the required parameter 'taxRates' when calling createTaxRates");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createTaxRates");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/TaxRates"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(taxRates);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public TrackingCategories createTrackingCategory(String accessToken, String xeroTenantId, TrackingCategory trackingCategory, String idempotencyKey) throws IOException {
        try {
            TypeReference<TrackingCategories> typeRef = new TypeReference<TrackingCategories>(){};
            HttpResponse response = this.createTrackingCategoryForHttpResponse(accessToken, xeroTenantId, trackingCategory, idempotencyKey);
            return (TrackingCategories)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createTrackingCategory -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("TrackingCategories", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("TrackingCategories", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createTrackingCategoryForHttpResponse(String accessToken, String xeroTenantId, TrackingCategory trackingCategory, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createTrackingCategory");
        }
        if (trackingCategory == null) {
            throw new IllegalArgumentException("Missing the required parameter 'trackingCategory' when calling createTrackingCategory");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createTrackingCategory");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/TrackingCategories"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(trackingCategory);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public TrackingOptions createTrackingOptions(String accessToken, String xeroTenantId, UUID trackingCategoryID, TrackingOption trackingOption, String idempotencyKey) throws IOException {
        try {
            TypeReference<TrackingOptions> typeRef = new TypeReference<TrackingOptions>(){};
            HttpResponse response = this.createTrackingOptionsForHttpResponse(accessToken, xeroTenantId, trackingCategoryID, trackingOption, idempotencyKey);
            return (TrackingOptions)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createTrackingOptions -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("TrackingOptions", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("TrackingOptions", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createTrackingOptionsForHttpResponse(String accessToken, String xeroTenantId, UUID trackingCategoryID, TrackingOption trackingOption, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createTrackingOptions");
        }
        if (trackingCategoryID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'trackingCategoryID' when calling createTrackingOptions");
        }
        if (trackingOption == null) {
            throw new IllegalArgumentException("Missing the required parameter 'trackingOption' when calling createTrackingOptions");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createTrackingOptions");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("TrackingCategoryID", trackingCategoryID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/TrackingCategories/{TrackingCategoryID}/Options"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(trackingOption);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Accounts deleteAccount(String accessToken, String xeroTenantId, UUID accountID) throws IOException {
        try {
            TypeReference<Accounts> typeRef = new TypeReference<Accounts>(){};
            HttpResponse response = this.deleteAccountForHttpResponse(accessToken, xeroTenantId, accountID);
            return (Accounts)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : deleteAccount -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("Accounts", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("Accounts", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse deleteAccountForHttpResponse(String accessToken, String xeroTenantId, UUID accountID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling deleteAccount");
        }
        if (accountID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accountID' when calling deleteAccount");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling deleteAccount");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("AccountID", accountID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Accounts/{AccountID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("DELETE " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("DELETE", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public BatchPayments deleteBatchPayment(String accessToken, String xeroTenantId, BatchPaymentDelete batchPaymentDelete, String idempotencyKey) throws IOException {
        try {
            TypeReference<BatchPayments> typeRef = new TypeReference<BatchPayments>(){};
            HttpResponse response = this.deleteBatchPaymentForHttpResponse(accessToken, xeroTenantId, batchPaymentDelete, idempotencyKey);
            return (BatchPayments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : deleteBatchPayment -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("BatchPayments", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("BatchPayments", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse deleteBatchPaymentForHttpResponse(String accessToken, String xeroTenantId, BatchPaymentDelete batchPaymentDelete, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling deleteBatchPayment");
        }
        if (batchPaymentDelete == null) {
            throw new IllegalArgumentException("Missing the required parameter 'batchPaymentDelete' when calling deleteBatchPayment");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling deleteBatchPayment");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/BatchPayments"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(batchPaymentDelete);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public BatchPayments deleteBatchPaymentByUrlParam(String accessToken, String xeroTenantId, UUID batchPaymentID, BatchPaymentDeleteByUrlParam batchPaymentDeleteByUrlParam, String idempotencyKey) throws IOException {
        try {
            TypeReference<BatchPayments> typeRef = new TypeReference<BatchPayments>(){};
            HttpResponse response = this.deleteBatchPaymentByUrlParamForHttpResponse(accessToken, xeroTenantId, batchPaymentID, batchPaymentDeleteByUrlParam, idempotencyKey);
            return (BatchPayments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : deleteBatchPaymentByUrlParam -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse deleteBatchPaymentByUrlParamForHttpResponse(String accessToken, String xeroTenantId, UUID batchPaymentID, BatchPaymentDeleteByUrlParam batchPaymentDeleteByUrlParam, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling deleteBatchPaymentByUrlParam");
        }
        if (batchPaymentID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'batchPaymentID' when calling deleteBatchPaymentByUrlParam");
        }
        if (batchPaymentDeleteByUrlParam == null) {
            throw new IllegalArgumentException("Missing the required parameter 'batchPaymentDeleteByUrlParam' when calling deleteBatchPaymentByUrlParam");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling deleteBatchPaymentByUrlParam");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("BatchPaymentID", batchPaymentID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/BatchPayments/{BatchPaymentID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(batchPaymentDeleteByUrlParam);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public void deleteContactGroupContact(String accessToken, String xeroTenantId, UUID contactGroupID, UUID contactID) throws IOException {
        try {
            this.deleteContactGroupContactForHttpResponse(accessToken, xeroTenantId, contactGroupID, contactID);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : deleteContactGroupContact -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
    }

    public HttpResponse deleteContactGroupContactForHttpResponse(String accessToken, String xeroTenantId, UUID contactGroupID, UUID contactID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling deleteContactGroupContact");
        }
        if (contactGroupID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contactGroupID' when calling deleteContactGroupContact");
        }
        if (contactID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contactID' when calling deleteContactGroupContact");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling deleteContactGroupContact");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("ContactGroupID", contactGroupID);
        uriVariables.put("ContactID", contactID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/ContactGroups/{ContactGroupID}/Contacts/{ContactID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("DELETE " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("DELETE", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public void deleteContactGroupContacts(String accessToken, String xeroTenantId, UUID contactGroupID) throws IOException {
        try {
            this.deleteContactGroupContactsForHttpResponse(accessToken, xeroTenantId, contactGroupID);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : deleteContactGroupContacts -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
    }

    public HttpResponse deleteContactGroupContactsForHttpResponse(String accessToken, String xeroTenantId, UUID contactGroupID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling deleteContactGroupContacts");
        }
        if (contactGroupID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contactGroupID' when calling deleteContactGroupContacts");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling deleteContactGroupContacts");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("ContactGroupID", contactGroupID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/ContactGroups/{ContactGroupID}/Contacts"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("DELETE " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("DELETE", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Allocation deleteCreditNoteAllocations(String accessToken, String xeroTenantId, UUID creditNoteID, UUID allocationID) throws IOException {
        try {
            TypeReference<Allocation> typeRef = new TypeReference<Allocation>(){};
            HttpResponse response = this.deleteCreditNoteAllocationsForHttpResponse(accessToken, xeroTenantId, creditNoteID, allocationID);
            return (Allocation)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : deleteCreditNoteAllocations -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse deleteCreditNoteAllocationsForHttpResponse(String accessToken, String xeroTenantId, UUID creditNoteID, UUID allocationID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling deleteCreditNoteAllocations");
        }
        if (creditNoteID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'creditNoteID' when calling deleteCreditNoteAllocations");
        }
        if (allocationID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'allocationID' when calling deleteCreditNoteAllocations");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling deleteCreditNoteAllocations");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("CreditNoteID", creditNoteID);
        uriVariables.put("AllocationID", allocationID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/CreditNotes/{CreditNoteID}/Allocations/{AllocationID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("DELETE " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("DELETE", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public void deleteItem(String accessToken, String xeroTenantId, UUID itemID) throws IOException {
        try {
            this.deleteItemForHttpResponse(accessToken, xeroTenantId, itemID);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : deleteItem -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
    }

    public HttpResponse deleteItemForHttpResponse(String accessToken, String xeroTenantId, UUID itemID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling deleteItem");
        }
        if (itemID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'itemID' when calling deleteItem");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling deleteItem");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("ItemID", itemID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Items/{ItemID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("DELETE " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("DELETE", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public void deleteLinkedTransaction(String accessToken, String xeroTenantId, UUID linkedTransactionID) throws IOException {
        try {
            this.deleteLinkedTransactionForHttpResponse(accessToken, xeroTenantId, linkedTransactionID);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : deleteLinkedTransaction -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
    }

    public HttpResponse deleteLinkedTransactionForHttpResponse(String accessToken, String xeroTenantId, UUID linkedTransactionID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling deleteLinkedTransaction");
        }
        if (linkedTransactionID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'linkedTransactionID' when calling deleteLinkedTransaction");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling deleteLinkedTransaction");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("LinkedTransactionID", linkedTransactionID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/LinkedTransactions/{LinkedTransactionID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("DELETE " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("DELETE", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Allocation deleteOverpaymentAllocations(String accessToken, String xeroTenantId, UUID overpaymentID, UUID allocationID) throws IOException {
        try {
            TypeReference<Allocation> typeRef = new TypeReference<Allocation>(){};
            HttpResponse response = this.deleteOverpaymentAllocationsForHttpResponse(accessToken, xeroTenantId, overpaymentID, allocationID);
            return (Allocation)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : deleteOverpaymentAllocations -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse deleteOverpaymentAllocationsForHttpResponse(String accessToken, String xeroTenantId, UUID overpaymentID, UUID allocationID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling deleteOverpaymentAllocations");
        }
        if (overpaymentID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'overpaymentID' when calling deleteOverpaymentAllocations");
        }
        if (allocationID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'allocationID' when calling deleteOverpaymentAllocations");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling deleteOverpaymentAllocations");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("OverpaymentID", overpaymentID);
        uriVariables.put("AllocationID", allocationID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Overpayments/{OverpaymentID}/Allocations/{AllocationID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("DELETE " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("DELETE", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Payments deletePayment(String accessToken, String xeroTenantId, UUID paymentID, PaymentDelete paymentDelete, String idempotencyKey) throws IOException {
        try {
            TypeReference<Payments> typeRef = new TypeReference<Payments>(){};
            HttpResponse response = this.deletePaymentForHttpResponse(accessToken, xeroTenantId, paymentID, paymentDelete, idempotencyKey);
            return (Payments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : deletePayment -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("Payments", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("Payments", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse deletePaymentForHttpResponse(String accessToken, String xeroTenantId, UUID paymentID, PaymentDelete paymentDelete, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling deletePayment");
        }
        if (paymentID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'paymentID' when calling deletePayment");
        }
        if (paymentDelete == null) {
            throw new IllegalArgumentException("Missing the required parameter 'paymentDelete' when calling deletePayment");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling deletePayment");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("PaymentID", paymentID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Payments/{PaymentID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(paymentDelete);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Allocation deletePrepaymentAllocations(String accessToken, String xeroTenantId, UUID prepaymentID, UUID allocationID) throws IOException {
        try {
            TypeReference<Allocation> typeRef = new TypeReference<Allocation>(){};
            HttpResponse response = this.deletePrepaymentAllocationsForHttpResponse(accessToken, xeroTenantId, prepaymentID, allocationID);
            return (Allocation)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : deletePrepaymentAllocations -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse deletePrepaymentAllocationsForHttpResponse(String accessToken, String xeroTenantId, UUID prepaymentID, UUID allocationID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling deletePrepaymentAllocations");
        }
        if (prepaymentID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'prepaymentID' when calling deletePrepaymentAllocations");
        }
        if (allocationID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'allocationID' when calling deletePrepaymentAllocations");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling deletePrepaymentAllocations");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("PrepaymentID", prepaymentID);
        uriVariables.put("AllocationID", allocationID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Prepayments/{PrepaymentID}/Allocations/{AllocationID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("DELETE " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("DELETE", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public TrackingCategories deleteTrackingCategory(String accessToken, String xeroTenantId, UUID trackingCategoryID) throws IOException {
        try {
            TypeReference<TrackingCategories> typeRef = new TypeReference<TrackingCategories>(){};
            HttpResponse response = this.deleteTrackingCategoryForHttpResponse(accessToken, xeroTenantId, trackingCategoryID);
            return (TrackingCategories)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : deleteTrackingCategory -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse deleteTrackingCategoryForHttpResponse(String accessToken, String xeroTenantId, UUID trackingCategoryID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling deleteTrackingCategory");
        }
        if (trackingCategoryID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'trackingCategoryID' when calling deleteTrackingCategory");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling deleteTrackingCategory");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("TrackingCategoryID", trackingCategoryID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/TrackingCategories/{TrackingCategoryID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("DELETE " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("DELETE", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public TrackingOptions deleteTrackingOptions(String accessToken, String xeroTenantId, UUID trackingCategoryID, UUID trackingOptionID) throws IOException {
        try {
            TypeReference<TrackingOptions> typeRef = new TypeReference<TrackingOptions>(){};
            HttpResponse response = this.deleteTrackingOptionsForHttpResponse(accessToken, xeroTenantId, trackingCategoryID, trackingOptionID);
            return (TrackingOptions)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : deleteTrackingOptions -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse deleteTrackingOptionsForHttpResponse(String accessToken, String xeroTenantId, UUID trackingCategoryID, UUID trackingOptionID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling deleteTrackingOptions");
        }
        if (trackingCategoryID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'trackingCategoryID' when calling deleteTrackingOptions");
        }
        if (trackingOptionID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'trackingOptionID' when calling deleteTrackingOptions");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling deleteTrackingOptions");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("TrackingCategoryID", trackingCategoryID);
        uriVariables.put("TrackingOptionID", trackingOptionID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/TrackingCategories/{TrackingCategoryID}/Options/{TrackingOptionID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("DELETE " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("DELETE", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public void emailInvoice(String accessToken, String xeroTenantId, UUID invoiceID, RequestEmpty requestEmpty, String idempotencyKey) throws IOException {
        try {
            this.emailInvoiceForHttpResponse(accessToken, xeroTenantId, invoiceID, requestEmpty, idempotencyKey);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : emailInvoice -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
    }

    public HttpResponse emailInvoiceForHttpResponse(String accessToken, String xeroTenantId, UUID invoiceID, RequestEmpty requestEmpty, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling emailInvoice");
        }
        if (invoiceID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'invoiceID' when calling emailInvoice");
        }
        if (requestEmpty == null) {
            throw new IllegalArgumentException("Missing the required parameter 'requestEmpty' when calling emailInvoice");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling emailInvoice");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("InvoiceID", invoiceID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Invoices/{InvoiceID}/Email"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(requestEmpty);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Accounts getAccount(String accessToken, String xeroTenantId, UUID accountID) throws IOException {
        try {
            TypeReference<Accounts> typeRef = new TypeReference<Accounts>(){};
            HttpResponse response = this.getAccountForHttpResponse(accessToken, xeroTenantId, accountID);
            return (Accounts)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getAccount -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getAccountForHttpResponse(String accessToken, String xeroTenantId, UUID accountID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getAccount");
        }
        if (accountID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accountID' when calling getAccount");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getAccount");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("AccountID", accountID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Accounts/{AccountID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ByteArrayInputStream getAccountAttachmentByFileName(String accessToken, String xeroTenantId, UUID accountID, String fileName, String contentType) throws IOException {
        try {
            TypeReference<File> typeRef = new TypeReference<File>(){};
            HttpResponse response = this.getAccountAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, accountID, fileName, contentType);
            InputStream is = response.getContent();
            return this.convertInputToByteArray(is);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getAccountAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getAccountAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID accountID, String fileName, String contentType) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getAccountAttachmentByFileName");
        }
        if (accountID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accountID' when calling getAccountAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling getAccountAttachmentByFileName");
        }
        if (contentType == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contentType' when calling getAccountAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getAccountAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("contentType", (Object)contentType);
        headers.setAccept("application/octet-stream");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("AccountID", accountID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Accounts/{AccountID}/Attachments/{FileName}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ByteArrayInputStream getAccountAttachmentById(String accessToken, String xeroTenantId, UUID accountID, UUID attachmentID, String contentType) throws IOException {
        try {
            TypeReference<File> typeRef = new TypeReference<File>(){};
            HttpResponse response = this.getAccountAttachmentByIdForHttpResponse(accessToken, xeroTenantId, accountID, attachmentID, contentType);
            InputStream is = response.getContent();
            return this.convertInputToByteArray(is);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getAccountAttachmentById -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getAccountAttachmentByIdForHttpResponse(String accessToken, String xeroTenantId, UUID accountID, UUID attachmentID, String contentType) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getAccountAttachmentById");
        }
        if (accountID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accountID' when calling getAccountAttachmentById");
        }
        if (attachmentID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'attachmentID' when calling getAccountAttachmentById");
        }
        if (contentType == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contentType' when calling getAccountAttachmentById");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getAccountAttachmentById");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("contentType", (Object)contentType);
        headers.setAccept("application/octet-stream");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("AccountID", accountID);
        uriVariables.put("AttachmentID", attachmentID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Accounts/{AccountID}/Attachments/{AttachmentID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments getAccountAttachments(String accessToken, String xeroTenantId, UUID accountID) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.getAccountAttachmentsForHttpResponse(accessToken, xeroTenantId, accountID);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getAccountAttachments -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getAccountAttachmentsForHttpResponse(String accessToken, String xeroTenantId, UUID accountID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getAccountAttachments");
        }
        if (accountID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accountID' when calling getAccountAttachments");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getAccountAttachments");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("AccountID", accountID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Accounts/{AccountID}/Attachments"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Accounts getAccounts(String accessToken, String xeroTenantId, OffsetDateTime ifModifiedSince, String where, String order) throws IOException {
        try {
            TypeReference<Accounts> typeRef = new TypeReference<Accounts>(){};
            HttpResponse response = this.getAccountsForHttpResponse(accessToken, xeroTenantId, ifModifiedSince, where, order);
            return (Accounts)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getAccounts -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getAccountsForHttpResponse(String accessToken, String xeroTenantId, OffsetDateTime ifModifiedSince, String where, String order) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        String value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getAccounts");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getAccounts");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        if (ifModifiedSince != null) {
            headers.setIfModifiedSince(ifModifiedSince.toString());
        }
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Accounts"));
        if (where != null) {
            key = "where";
            value = where;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (order != null) {
            key = "order";
            value = order;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public BankTransactions getBankTransaction(String accessToken, String xeroTenantId, UUID bankTransactionID, Integer unitdp) throws IOException {
        try {
            TypeReference<BankTransactions> typeRef = new TypeReference<BankTransactions>(){};
            HttpResponse response = this.getBankTransactionForHttpResponse(accessToken, xeroTenantId, bankTransactionID, unitdp);
            return (BankTransactions)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getBankTransaction -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getBankTransactionForHttpResponse(String accessToken, String xeroTenantId, UUID bankTransactionID, Integer unitdp) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getBankTransaction");
        }
        if (bankTransactionID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'bankTransactionID' when calling getBankTransaction");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getBankTransaction");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("BankTransactionID", bankTransactionID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/BankTransactions/{BankTransactionID}"));
        if (unitdp != null) {
            String key = "unitdp";
            Integer value = unitdp;
            if (value instanceof Collection) {
                ArrayList valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ByteArrayInputStream getBankTransactionAttachmentByFileName(String accessToken, String xeroTenantId, UUID bankTransactionID, String fileName, String contentType) throws IOException {
        try {
            TypeReference<File> typeRef = new TypeReference<File>(){};
            HttpResponse response = this.getBankTransactionAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, bankTransactionID, fileName, contentType);
            InputStream is = response.getContent();
            return this.convertInputToByteArray(is);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getBankTransactionAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getBankTransactionAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID bankTransactionID, String fileName, String contentType) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getBankTransactionAttachmentByFileName");
        }
        if (bankTransactionID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'bankTransactionID' when calling getBankTransactionAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling getBankTransactionAttachmentByFileName");
        }
        if (contentType == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contentType' when calling getBankTransactionAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getBankTransactionAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("contentType", (Object)contentType);
        headers.setAccept("application/octet-stream");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("BankTransactionID", bankTransactionID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/BankTransactions/{BankTransactionID}/Attachments/{FileName}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ByteArrayInputStream getBankTransactionAttachmentById(String accessToken, String xeroTenantId, UUID bankTransactionID, UUID attachmentID, String contentType) throws IOException {
        try {
            TypeReference<File> typeRef = new TypeReference<File>(){};
            HttpResponse response = this.getBankTransactionAttachmentByIdForHttpResponse(accessToken, xeroTenantId, bankTransactionID, attachmentID, contentType);
            InputStream is = response.getContent();
            return this.convertInputToByteArray(is);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getBankTransactionAttachmentById -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getBankTransactionAttachmentByIdForHttpResponse(String accessToken, String xeroTenantId, UUID bankTransactionID, UUID attachmentID, String contentType) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getBankTransactionAttachmentById");
        }
        if (bankTransactionID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'bankTransactionID' when calling getBankTransactionAttachmentById");
        }
        if (attachmentID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'attachmentID' when calling getBankTransactionAttachmentById");
        }
        if (contentType == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contentType' when calling getBankTransactionAttachmentById");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getBankTransactionAttachmentById");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("contentType", (Object)contentType);
        headers.setAccept("application/octet-stream");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("BankTransactionID", bankTransactionID);
        uriVariables.put("AttachmentID", attachmentID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/BankTransactions/{BankTransactionID}/Attachments/{AttachmentID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments getBankTransactionAttachments(String accessToken, String xeroTenantId, UUID bankTransactionID) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.getBankTransactionAttachmentsForHttpResponse(accessToken, xeroTenantId, bankTransactionID);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getBankTransactionAttachments -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getBankTransactionAttachmentsForHttpResponse(String accessToken, String xeroTenantId, UUID bankTransactionID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getBankTransactionAttachments");
        }
        if (bankTransactionID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'bankTransactionID' when calling getBankTransactionAttachments");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getBankTransactionAttachments");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("BankTransactionID", bankTransactionID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/BankTransactions/{BankTransactionID}/Attachments"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public BankTransactions getBankTransactions(String accessToken, String xeroTenantId, OffsetDateTime ifModifiedSince, String where, String order, Integer page, Integer unitdp, Integer pageSize) throws IOException {
        try {
            TypeReference<BankTransactions> typeRef = new TypeReference<BankTransactions>(){};
            HttpResponse response = this.getBankTransactionsForHttpResponse(accessToken, xeroTenantId, ifModifiedSince, where, order, page, unitdp, pageSize);
            return (BankTransactions)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getBankTransactions -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getBankTransactionsForHttpResponse(String accessToken, String xeroTenantId, OffsetDateTime ifModifiedSince, String where, String order, Integer page, Integer unitdp, Integer pageSize) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        Object value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getBankTransactions");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getBankTransactions");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        if (ifModifiedSince != null) {
            headers.setIfModifiedSince(ifModifiedSince.toString());
        }
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/BankTransactions"));
        if (where != null) {
            key = "where";
            value = where;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (order != null) {
            key = "order";
            value = order;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (page != null) {
            key = "page";
            value = page;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (unitdp != null) {
            key = "unitdp";
            value = unitdp;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (pageSize != null) {
            key = "pageSize";
            value = pageSize;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public HistoryRecords getBankTransactionsHistory(String accessToken, String xeroTenantId, UUID bankTransactionID) throws IOException {
        try {
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            HttpResponse response = this.getBankTransactionsHistoryForHttpResponse(accessToken, xeroTenantId, bankTransactionID);
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getBankTransactionsHistory -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getBankTransactionsHistoryForHttpResponse(String accessToken, String xeroTenantId, UUID bankTransactionID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getBankTransactionsHistory");
        }
        if (bankTransactionID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'bankTransactionID' when calling getBankTransactionsHistory");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getBankTransactionsHistory");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("BankTransactionID", bankTransactionID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/BankTransactions/{BankTransactionID}/History"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public BankTransfers getBankTransfer(String accessToken, String xeroTenantId, UUID bankTransferID) throws IOException {
        try {
            TypeReference<BankTransfers> typeRef = new TypeReference<BankTransfers>(){};
            HttpResponse response = this.getBankTransferForHttpResponse(accessToken, xeroTenantId, bankTransferID);
            return (BankTransfers)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getBankTransfer -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getBankTransferForHttpResponse(String accessToken, String xeroTenantId, UUID bankTransferID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getBankTransfer");
        }
        if (bankTransferID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'bankTransferID' when calling getBankTransfer");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getBankTransfer");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("BankTransferID", bankTransferID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/BankTransfers/{BankTransferID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ByteArrayInputStream getBankTransferAttachmentByFileName(String accessToken, String xeroTenantId, UUID bankTransferID, String fileName, String contentType) throws IOException {
        try {
            TypeReference<File> typeRef = new TypeReference<File>(){};
            HttpResponse response = this.getBankTransferAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, bankTransferID, fileName, contentType);
            InputStream is = response.getContent();
            return this.convertInputToByteArray(is);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getBankTransferAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getBankTransferAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID bankTransferID, String fileName, String contentType) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getBankTransferAttachmentByFileName");
        }
        if (bankTransferID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'bankTransferID' when calling getBankTransferAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling getBankTransferAttachmentByFileName");
        }
        if (contentType == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contentType' when calling getBankTransferAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getBankTransferAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("contentType", (Object)contentType);
        headers.setAccept("application/octet-stream");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("BankTransferID", bankTransferID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/BankTransfers/{BankTransferID}/Attachments/{FileName}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ByteArrayInputStream getBankTransferAttachmentById(String accessToken, String xeroTenantId, UUID bankTransferID, UUID attachmentID, String contentType) throws IOException {
        try {
            TypeReference<File> typeRef = new TypeReference<File>(){};
            HttpResponse response = this.getBankTransferAttachmentByIdForHttpResponse(accessToken, xeroTenantId, bankTransferID, attachmentID, contentType);
            InputStream is = response.getContent();
            return this.convertInputToByteArray(is);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getBankTransferAttachmentById -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getBankTransferAttachmentByIdForHttpResponse(String accessToken, String xeroTenantId, UUID bankTransferID, UUID attachmentID, String contentType) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getBankTransferAttachmentById");
        }
        if (bankTransferID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'bankTransferID' when calling getBankTransferAttachmentById");
        }
        if (attachmentID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'attachmentID' when calling getBankTransferAttachmentById");
        }
        if (contentType == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contentType' when calling getBankTransferAttachmentById");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getBankTransferAttachmentById");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("contentType", (Object)contentType);
        headers.setAccept("application/octet-stream");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("BankTransferID", bankTransferID);
        uriVariables.put("AttachmentID", attachmentID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/BankTransfers/{BankTransferID}/Attachments/{AttachmentID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments getBankTransferAttachments(String accessToken, String xeroTenantId, UUID bankTransferID) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.getBankTransferAttachmentsForHttpResponse(accessToken, xeroTenantId, bankTransferID);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getBankTransferAttachments -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getBankTransferAttachmentsForHttpResponse(String accessToken, String xeroTenantId, UUID bankTransferID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getBankTransferAttachments");
        }
        if (bankTransferID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'bankTransferID' when calling getBankTransferAttachments");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getBankTransferAttachments");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("BankTransferID", bankTransferID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/BankTransfers/{BankTransferID}/Attachments"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public HistoryRecords getBankTransferHistory(String accessToken, String xeroTenantId, UUID bankTransferID) throws IOException {
        try {
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            HttpResponse response = this.getBankTransferHistoryForHttpResponse(accessToken, xeroTenantId, bankTransferID);
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getBankTransferHistory -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getBankTransferHistoryForHttpResponse(String accessToken, String xeroTenantId, UUID bankTransferID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getBankTransferHistory");
        }
        if (bankTransferID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'bankTransferID' when calling getBankTransferHistory");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getBankTransferHistory");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("BankTransferID", bankTransferID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/BankTransfers/{BankTransferID}/History"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public BankTransfers getBankTransfers(String accessToken, String xeroTenantId, OffsetDateTime ifModifiedSince, String where, String order) throws IOException {
        try {
            TypeReference<BankTransfers> typeRef = new TypeReference<BankTransfers>(){};
            HttpResponse response = this.getBankTransfersForHttpResponse(accessToken, xeroTenantId, ifModifiedSince, where, order);
            return (BankTransfers)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getBankTransfers -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getBankTransfersForHttpResponse(String accessToken, String xeroTenantId, OffsetDateTime ifModifiedSince, String where, String order) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        String value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getBankTransfers");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getBankTransfers");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        if (ifModifiedSince != null) {
            headers.setIfModifiedSince(ifModifiedSince.toString());
        }
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/BankTransfers"));
        if (where != null) {
            key = "where";
            value = where;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (order != null) {
            key = "order";
            value = order;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public BatchPayments getBatchPayment(String accessToken, String xeroTenantId, UUID batchPaymentID) throws IOException {
        try {
            TypeReference<BatchPayments> typeRef = new TypeReference<BatchPayments>(){};
            HttpResponse response = this.getBatchPaymentForHttpResponse(accessToken, xeroTenantId, batchPaymentID);
            return (BatchPayments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getBatchPayment -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getBatchPaymentForHttpResponse(String accessToken, String xeroTenantId, UUID batchPaymentID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getBatchPayment");
        }
        if (batchPaymentID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'batchPaymentID' when calling getBatchPayment");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getBatchPayment");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("BatchPaymentID", batchPaymentID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/BatchPayments/{BatchPaymentID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public HistoryRecords getBatchPaymentHistory(String accessToken, String xeroTenantId, UUID batchPaymentID) throws IOException {
        try {
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            HttpResponse response = this.getBatchPaymentHistoryForHttpResponse(accessToken, xeroTenantId, batchPaymentID);
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getBatchPaymentHistory -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getBatchPaymentHistoryForHttpResponse(String accessToken, String xeroTenantId, UUID batchPaymentID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getBatchPaymentHistory");
        }
        if (batchPaymentID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'batchPaymentID' when calling getBatchPaymentHistory");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getBatchPaymentHistory");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("BatchPaymentID", batchPaymentID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/BatchPayments/{BatchPaymentID}/History"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public BatchPayments getBatchPayments(String accessToken, String xeroTenantId, OffsetDateTime ifModifiedSince, String where, String order) throws IOException {
        try {
            TypeReference<BatchPayments> typeRef = new TypeReference<BatchPayments>(){};
            HttpResponse response = this.getBatchPaymentsForHttpResponse(accessToken, xeroTenantId, ifModifiedSince, where, order);
            return (BatchPayments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getBatchPayments -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getBatchPaymentsForHttpResponse(String accessToken, String xeroTenantId, OffsetDateTime ifModifiedSince, String where, String order) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        String value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getBatchPayments");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getBatchPayments");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        if (ifModifiedSince != null) {
            headers.setIfModifiedSince(ifModifiedSince.toString());
        }
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/BatchPayments"));
        if (where != null) {
            key = "where";
            value = where;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (order != null) {
            key = "order";
            value = order;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public BrandingThemes getBrandingTheme(String accessToken, String xeroTenantId, UUID brandingThemeID) throws IOException {
        try {
            TypeReference<BrandingThemes> typeRef = new TypeReference<BrandingThemes>(){};
            HttpResponse response = this.getBrandingThemeForHttpResponse(accessToken, xeroTenantId, brandingThemeID);
            return (BrandingThemes)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getBrandingTheme -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getBrandingThemeForHttpResponse(String accessToken, String xeroTenantId, UUID brandingThemeID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getBrandingTheme");
        }
        if (brandingThemeID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'brandingThemeID' when calling getBrandingTheme");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getBrandingTheme");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("BrandingThemeID", brandingThemeID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/BrandingThemes/{BrandingThemeID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public PaymentServices getBrandingThemePaymentServices(String accessToken, String xeroTenantId, UUID brandingThemeID) throws IOException {
        try {
            TypeReference<PaymentServices> typeRef = new TypeReference<PaymentServices>(){};
            HttpResponse response = this.getBrandingThemePaymentServicesForHttpResponse(accessToken, xeroTenantId, brandingThemeID);
            return (PaymentServices)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getBrandingThemePaymentServices -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getBrandingThemePaymentServicesForHttpResponse(String accessToken, String xeroTenantId, UUID brandingThemeID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getBrandingThemePaymentServices");
        }
        if (brandingThemeID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'brandingThemeID' when calling getBrandingThemePaymentServices");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getBrandingThemePaymentServices");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("BrandingThemeID", brandingThemeID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/BrandingThemes/{BrandingThemeID}/PaymentServices"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public BrandingThemes getBrandingThemes(String accessToken, String xeroTenantId) throws IOException {
        try {
            TypeReference<BrandingThemes> typeRef = new TypeReference<BrandingThemes>(){};
            HttpResponse response = this.getBrandingThemesForHttpResponse(accessToken, xeroTenantId);
            return (BrandingThemes)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getBrandingThemes -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getBrandingThemesForHttpResponse(String accessToken, String xeroTenantId) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getBrandingThemes");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getBrandingThemes");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/BrandingThemes"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Budgets getBudget(String accessToken, String xeroTenantId, UUID budgetID, LocalDate dateTo, LocalDate dateFrom) throws IOException {
        try {
            TypeReference<Budgets> typeRef = new TypeReference<Budgets>(){};
            HttpResponse response = this.getBudgetForHttpResponse(accessToken, xeroTenantId, budgetID, dateTo, dateFrom);
            return (Budgets)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getBudget -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getBudgetForHttpResponse(String accessToken, String xeroTenantId, UUID budgetID, LocalDate dateTo, LocalDate dateFrom) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        LocalDate value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getBudget");
        }
        if (budgetID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'budgetID' when calling getBudget");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getBudget");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("BudgetID", budgetID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Budgets/{BudgetID}"));
        if (dateTo != null) {
            key = "DateTo";
            value = dateTo;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (dateFrom != null) {
            key = "DateFrom";
            value = dateFrom;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Budgets getBudgets(String accessToken, String xeroTenantId, List<UUID> ids, LocalDate dateTo, LocalDate dateFrom) throws IOException {
        try {
            TypeReference<Budgets> typeRef = new TypeReference<Budgets>(){};
            HttpResponse response = this.getBudgetsForHttpResponse(accessToken, xeroTenantId, ids, dateTo, dateFrom);
            return (Budgets)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getBudgets -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getBudgetsForHttpResponse(String accessToken, String xeroTenantId, List<UUID> ids, LocalDate dateTo, LocalDate dateFrom) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        LocalDate value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getBudgets");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getBudgets");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Budgets"));
        if (ids != null) {
            key = "IDs";
            value = ids;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (dateTo != null) {
            key = "DateTo";
            value = dateTo;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (dateFrom != null) {
            key = "DateFrom";
            value = dateFrom;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Contacts getContact(String accessToken, String xeroTenantId, UUID contactID) throws IOException {
        try {
            TypeReference<Contacts> typeRef = new TypeReference<Contacts>(){};
            HttpResponse response = this.getContactForHttpResponse(accessToken, xeroTenantId, contactID);
            return (Contacts)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getContact -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getContactForHttpResponse(String accessToken, String xeroTenantId, UUID contactID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getContact");
        }
        if (contactID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contactID' when calling getContact");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getContact");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("ContactID", contactID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Contacts/{ContactID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ByteArrayInputStream getContactAttachmentByFileName(String accessToken, String xeroTenantId, UUID contactID, String fileName, String contentType) throws IOException {
        try {
            TypeReference<File> typeRef = new TypeReference<File>(){};
            HttpResponse response = this.getContactAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, contactID, fileName, contentType);
            InputStream is = response.getContent();
            return this.convertInputToByteArray(is);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getContactAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getContactAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID contactID, String fileName, String contentType) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getContactAttachmentByFileName");
        }
        if (contactID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contactID' when calling getContactAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling getContactAttachmentByFileName");
        }
        if (contentType == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contentType' when calling getContactAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getContactAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("contentType", (Object)contentType);
        headers.setAccept("application/octet-stream");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("ContactID", contactID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Contacts/{ContactID}/Attachments/{FileName}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ByteArrayInputStream getContactAttachmentById(String accessToken, String xeroTenantId, UUID contactID, UUID attachmentID, String contentType) throws IOException {
        try {
            TypeReference<File> typeRef = new TypeReference<File>(){};
            HttpResponse response = this.getContactAttachmentByIdForHttpResponse(accessToken, xeroTenantId, contactID, attachmentID, contentType);
            InputStream is = response.getContent();
            return this.convertInputToByteArray(is);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getContactAttachmentById -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getContactAttachmentByIdForHttpResponse(String accessToken, String xeroTenantId, UUID contactID, UUID attachmentID, String contentType) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getContactAttachmentById");
        }
        if (contactID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contactID' when calling getContactAttachmentById");
        }
        if (attachmentID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'attachmentID' when calling getContactAttachmentById");
        }
        if (contentType == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contentType' when calling getContactAttachmentById");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getContactAttachmentById");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("contentType", (Object)contentType);
        headers.setAccept("application/octet-stream");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("ContactID", contactID);
        uriVariables.put("AttachmentID", attachmentID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Contacts/{ContactID}/Attachments/{AttachmentID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments getContactAttachments(String accessToken, String xeroTenantId, UUID contactID) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.getContactAttachmentsForHttpResponse(accessToken, xeroTenantId, contactID);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getContactAttachments -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("Attachments", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("Attachments", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getContactAttachmentsForHttpResponse(String accessToken, String xeroTenantId, UUID contactID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getContactAttachments");
        }
        if (contactID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contactID' when calling getContactAttachments");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getContactAttachments");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("ContactID", contactID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Contacts/{ContactID}/Attachments"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Contacts getContactByContactNumber(String accessToken, String xeroTenantId, String contactNumber) throws IOException {
        try {
            TypeReference<Contacts> typeRef = new TypeReference<Contacts>(){};
            HttpResponse response = this.getContactByContactNumberForHttpResponse(accessToken, xeroTenantId, contactNumber);
            return (Contacts)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getContactByContactNumber -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getContactByContactNumberForHttpResponse(String accessToken, String xeroTenantId, String contactNumber) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getContactByContactNumber");
        }
        if (contactNumber == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contactNumber' when calling getContactByContactNumber");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getContactByContactNumber");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("ContactNumber", contactNumber);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Contacts/{ContactNumber}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public CISSettings getContactCISSettings(String accessToken, String xeroTenantId, UUID contactID) throws IOException {
        try {
            TypeReference<CISSettings> typeRef = new TypeReference<CISSettings>(){};
            HttpResponse response = this.getContactCISSettingsForHttpResponse(accessToken, xeroTenantId, contactID);
            return (CISSettings)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getContactCISSettings -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getContactCISSettingsForHttpResponse(String accessToken, String xeroTenantId, UUID contactID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getContactCISSettings");
        }
        if (contactID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contactID' when calling getContactCISSettings");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getContactCISSettings");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("ContactID", contactID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Contacts/{ContactID}/CISSettings"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ContactGroups getContactGroup(String accessToken, String xeroTenantId, UUID contactGroupID) throws IOException {
        try {
            TypeReference<ContactGroups> typeRef = new TypeReference<ContactGroups>(){};
            HttpResponse response = this.getContactGroupForHttpResponse(accessToken, xeroTenantId, contactGroupID);
            return (ContactGroups)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getContactGroup -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getContactGroupForHttpResponse(String accessToken, String xeroTenantId, UUID contactGroupID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getContactGroup");
        }
        if (contactGroupID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contactGroupID' when calling getContactGroup");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getContactGroup");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("ContactGroupID", contactGroupID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/ContactGroups/{ContactGroupID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ContactGroups getContactGroups(String accessToken, String xeroTenantId, String where, String order) throws IOException {
        try {
            TypeReference<ContactGroups> typeRef = new TypeReference<ContactGroups>(){};
            HttpResponse response = this.getContactGroupsForHttpResponse(accessToken, xeroTenantId, where, order);
            return (ContactGroups)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getContactGroups -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getContactGroupsForHttpResponse(String accessToken, String xeroTenantId, String where, String order) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        String value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getContactGroups");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getContactGroups");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/ContactGroups"));
        if (where != null) {
            key = "where";
            value = where;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (order != null) {
            key = "order";
            value = order;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public HistoryRecords getContactHistory(String accessToken, String xeroTenantId, UUID contactID) throws IOException {
        try {
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            HttpResponse response = this.getContactHistoryForHttpResponse(accessToken, xeroTenantId, contactID);
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getContactHistory -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getContactHistoryForHttpResponse(String accessToken, String xeroTenantId, UUID contactID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getContactHistory");
        }
        if (contactID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contactID' when calling getContactHistory");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getContactHistory");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("ContactID", contactID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Contacts/{ContactID}/History"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Contacts getContacts(String accessToken, String xeroTenantId, OffsetDateTime ifModifiedSince, String where, String order, List<UUID> ids, Integer page, Boolean includeArchived, Boolean summaryOnly, String searchTerm, Integer pageSize) throws IOException {
        try {
            TypeReference<Contacts> typeRef = new TypeReference<Contacts>(){};
            HttpResponse response = this.getContactsForHttpResponse(accessToken, xeroTenantId, ifModifiedSince, where, order, ids, page, includeArchived, summaryOnly, searchTerm, pageSize);
            return (Contacts)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getContacts -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getContactsForHttpResponse(String accessToken, String xeroTenantId, OffsetDateTime ifModifiedSince, String where, String order, List<UUID> ids, Integer page, Boolean includeArchived, Boolean summaryOnly, String searchTerm, Integer pageSize) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        Object value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getContacts");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getContacts");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        if (ifModifiedSince != null) {
            headers.setIfModifiedSince(ifModifiedSince.toString());
        }
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Contacts"));
        if (where != null) {
            key = "where";
            value = where;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (order != null) {
            key = "order";
            value = order;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (ids != null) {
            key = "IDs";
            value = ids;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (page != null) {
            key = "page";
            value = page;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (includeArchived != null) {
            key = "includeArchived";
            value = includeArchived;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (summaryOnly != null) {
            key = "summaryOnly";
            value = summaryOnly;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (searchTerm != null) {
            key = "searchTerm";
            value = searchTerm;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (pageSize != null) {
            key = "pageSize";
            value = pageSize;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public CreditNotes getCreditNote(String accessToken, String xeroTenantId, UUID creditNoteID, Integer unitdp) throws IOException {
        try {
            TypeReference<CreditNotes> typeRef = new TypeReference<CreditNotes>(){};
            HttpResponse response = this.getCreditNoteForHttpResponse(accessToken, xeroTenantId, creditNoteID, unitdp);
            return (CreditNotes)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getCreditNote -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getCreditNoteForHttpResponse(String accessToken, String xeroTenantId, UUID creditNoteID, Integer unitdp) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getCreditNote");
        }
        if (creditNoteID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'creditNoteID' when calling getCreditNote");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getCreditNote");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("CreditNoteID", creditNoteID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/CreditNotes/{CreditNoteID}"));
        if (unitdp != null) {
            String key = "unitdp";
            Integer value = unitdp;
            if (value instanceof Collection) {
                ArrayList valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ByteArrayInputStream getCreditNoteAsPdf(String accessToken, String xeroTenantId, UUID creditNoteID) throws IOException {
        try {
            TypeReference<File> typeRef = new TypeReference<File>(){};
            HttpResponse response = this.getCreditNoteAsPdfForHttpResponse(accessToken, xeroTenantId, creditNoteID);
            InputStream is = response.getContent();
            return this.convertInputToByteArray(is);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getCreditNoteAsPdf -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getCreditNoteAsPdfForHttpResponse(String accessToken, String xeroTenantId, UUID creditNoteID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getCreditNoteAsPdf");
        }
        if (creditNoteID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'creditNoteID' when calling getCreditNoteAsPdf");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getCreditNoteAsPdf");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/pdf");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("CreditNoteID", creditNoteID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/CreditNotes/{CreditNoteID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ByteArrayInputStream getCreditNoteAttachmentByFileName(String accessToken, String xeroTenantId, UUID creditNoteID, String fileName, String contentType) throws IOException {
        try {
            TypeReference<File> typeRef = new TypeReference<File>(){};
            HttpResponse response = this.getCreditNoteAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, creditNoteID, fileName, contentType);
            InputStream is = response.getContent();
            return this.convertInputToByteArray(is);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getCreditNoteAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getCreditNoteAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID creditNoteID, String fileName, String contentType) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getCreditNoteAttachmentByFileName");
        }
        if (creditNoteID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'creditNoteID' when calling getCreditNoteAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling getCreditNoteAttachmentByFileName");
        }
        if (contentType == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contentType' when calling getCreditNoteAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getCreditNoteAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("contentType", (Object)contentType);
        headers.setAccept("application/octet-stream");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("CreditNoteID", creditNoteID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/CreditNotes/{CreditNoteID}/Attachments/{FileName}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ByteArrayInputStream getCreditNoteAttachmentById(String accessToken, String xeroTenantId, UUID creditNoteID, UUID attachmentID, String contentType) throws IOException {
        try {
            TypeReference<File> typeRef = new TypeReference<File>(){};
            HttpResponse response = this.getCreditNoteAttachmentByIdForHttpResponse(accessToken, xeroTenantId, creditNoteID, attachmentID, contentType);
            InputStream is = response.getContent();
            return this.convertInputToByteArray(is);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getCreditNoteAttachmentById -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getCreditNoteAttachmentByIdForHttpResponse(String accessToken, String xeroTenantId, UUID creditNoteID, UUID attachmentID, String contentType) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getCreditNoteAttachmentById");
        }
        if (creditNoteID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'creditNoteID' when calling getCreditNoteAttachmentById");
        }
        if (attachmentID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'attachmentID' when calling getCreditNoteAttachmentById");
        }
        if (contentType == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contentType' when calling getCreditNoteAttachmentById");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getCreditNoteAttachmentById");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("contentType", (Object)contentType);
        headers.setAccept("application/octet-stream");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("CreditNoteID", creditNoteID);
        uriVariables.put("AttachmentID", attachmentID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/CreditNotes/{CreditNoteID}/Attachments/{AttachmentID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments getCreditNoteAttachments(String accessToken, String xeroTenantId, UUID creditNoteID) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.getCreditNoteAttachmentsForHttpResponse(accessToken, xeroTenantId, creditNoteID);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getCreditNoteAttachments -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getCreditNoteAttachmentsForHttpResponse(String accessToken, String xeroTenantId, UUID creditNoteID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getCreditNoteAttachments");
        }
        if (creditNoteID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'creditNoteID' when calling getCreditNoteAttachments");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getCreditNoteAttachments");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("CreditNoteID", creditNoteID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/CreditNotes/{CreditNoteID}/Attachments"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public HistoryRecords getCreditNoteHistory(String accessToken, String xeroTenantId, UUID creditNoteID) throws IOException {
        try {
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            HttpResponse response = this.getCreditNoteHistoryForHttpResponse(accessToken, xeroTenantId, creditNoteID);
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getCreditNoteHistory -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getCreditNoteHistoryForHttpResponse(String accessToken, String xeroTenantId, UUID creditNoteID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getCreditNoteHistory");
        }
        if (creditNoteID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'creditNoteID' when calling getCreditNoteHistory");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getCreditNoteHistory");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("CreditNoteID", creditNoteID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/CreditNotes/{CreditNoteID}/History"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public CreditNotes getCreditNotes(String accessToken, String xeroTenantId, OffsetDateTime ifModifiedSince, String where, String order, Integer page, Integer unitdp, Integer pageSize) throws IOException {
        try {
            TypeReference<CreditNotes> typeRef = new TypeReference<CreditNotes>(){};
            HttpResponse response = this.getCreditNotesForHttpResponse(accessToken, xeroTenantId, ifModifiedSince, where, order, page, unitdp, pageSize);
            return (CreditNotes)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getCreditNotes -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getCreditNotesForHttpResponse(String accessToken, String xeroTenantId, OffsetDateTime ifModifiedSince, String where, String order, Integer page, Integer unitdp, Integer pageSize) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        Object value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getCreditNotes");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getCreditNotes");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        if (ifModifiedSince != null) {
            headers.setIfModifiedSince(ifModifiedSince.toString());
        }
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/CreditNotes"));
        if (where != null) {
            key = "where";
            value = where;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (order != null) {
            key = "order";
            value = order;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (page != null) {
            key = "page";
            value = page;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (unitdp != null) {
            key = "unitdp";
            value = unitdp;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (pageSize != null) {
            key = "pageSize";
            value = pageSize;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Currencies getCurrencies(String accessToken, String xeroTenantId, String where, String order) throws IOException {
        try {
            TypeReference<Currencies> typeRef = new TypeReference<Currencies>(){};
            HttpResponse response = this.getCurrenciesForHttpResponse(accessToken, xeroTenantId, where, order);
            return (Currencies)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getCurrencies -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getCurrenciesForHttpResponse(String accessToken, String xeroTenantId, String where, String order) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        String value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getCurrencies");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getCurrencies");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Currencies"));
        if (where != null) {
            key = "where";
            value = where;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (order != null) {
            key = "order";
            value = order;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Employees getEmployee(String accessToken, String xeroTenantId, UUID employeeID) throws IOException {
        try {
            TypeReference<Employees> typeRef = new TypeReference<Employees>(){};
            HttpResponse response = this.getEmployeeForHttpResponse(accessToken, xeroTenantId, employeeID);
            return (Employees)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getEmployee -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getEmployeeForHttpResponse(String accessToken, String xeroTenantId, UUID employeeID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getEmployee");
        }
        if (employeeID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'employeeID' when calling getEmployee");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getEmployee");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("EmployeeID", employeeID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Employees/{EmployeeID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Employees getEmployees(String accessToken, String xeroTenantId, OffsetDateTime ifModifiedSince, String where, String order) throws IOException {
        try {
            TypeReference<Employees> typeRef = new TypeReference<Employees>(){};
            HttpResponse response = this.getEmployeesForHttpResponse(accessToken, xeroTenantId, ifModifiedSince, where, order);
            return (Employees)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getEmployees -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getEmployeesForHttpResponse(String accessToken, String xeroTenantId, OffsetDateTime ifModifiedSince, String where, String order) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        String value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getEmployees");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getEmployees");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        if (ifModifiedSince != null) {
            headers.setIfModifiedSince(ifModifiedSince.toString());
        }
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Employees"));
        if (where != null) {
            key = "where";
            value = where;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (order != null) {
            key = "order";
            value = order;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ExpenseClaims getExpenseClaim(String accessToken, String xeroTenantId, UUID expenseClaimID) throws IOException {
        try {
            TypeReference<ExpenseClaims> typeRef = new TypeReference<ExpenseClaims>(){};
            HttpResponse response = this.getExpenseClaimForHttpResponse(accessToken, xeroTenantId, expenseClaimID);
            return (ExpenseClaims)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getExpenseClaim -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getExpenseClaimForHttpResponse(String accessToken, String xeroTenantId, UUID expenseClaimID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getExpenseClaim");
        }
        if (expenseClaimID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'expenseClaimID' when calling getExpenseClaim");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getExpenseClaim");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("ExpenseClaimID", expenseClaimID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/ExpenseClaims/{ExpenseClaimID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public HistoryRecords getExpenseClaimHistory(String accessToken, String xeroTenantId, UUID expenseClaimID) throws IOException {
        try {
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            HttpResponse response = this.getExpenseClaimHistoryForHttpResponse(accessToken, xeroTenantId, expenseClaimID);
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getExpenseClaimHistory -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getExpenseClaimHistoryForHttpResponse(String accessToken, String xeroTenantId, UUID expenseClaimID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getExpenseClaimHistory");
        }
        if (expenseClaimID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'expenseClaimID' when calling getExpenseClaimHistory");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getExpenseClaimHistory");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("ExpenseClaimID", expenseClaimID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/ExpenseClaims/{ExpenseClaimID}/History"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ExpenseClaims getExpenseClaims(String accessToken, String xeroTenantId, OffsetDateTime ifModifiedSince, String where, String order) throws IOException {
        try {
            TypeReference<ExpenseClaims> typeRef = new TypeReference<ExpenseClaims>(){};
            HttpResponse response = this.getExpenseClaimsForHttpResponse(accessToken, xeroTenantId, ifModifiedSince, where, order);
            return (ExpenseClaims)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getExpenseClaims -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getExpenseClaimsForHttpResponse(String accessToken, String xeroTenantId, OffsetDateTime ifModifiedSince, String where, String order) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        String value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getExpenseClaims");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getExpenseClaims");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        if (ifModifiedSince != null) {
            headers.setIfModifiedSince(ifModifiedSince.toString());
        }
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/ExpenseClaims"));
        if (where != null) {
            key = "where";
            value = where;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (order != null) {
            key = "order";
            value = order;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Invoices getInvoice(String accessToken, String xeroTenantId, UUID invoiceID, Integer unitdp) throws IOException {
        try {
            TypeReference<Invoices> typeRef = new TypeReference<Invoices>(){};
            HttpResponse response = this.getInvoiceForHttpResponse(accessToken, xeroTenantId, invoiceID, unitdp);
            return (Invoices)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getInvoice -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getInvoiceForHttpResponse(String accessToken, String xeroTenantId, UUID invoiceID, Integer unitdp) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getInvoice");
        }
        if (invoiceID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'invoiceID' when calling getInvoice");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getInvoice");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("InvoiceID", invoiceID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Invoices/{InvoiceID}"));
        if (unitdp != null) {
            String key = "unitdp";
            Integer value = unitdp;
            if (value instanceof Collection) {
                ArrayList valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ByteArrayInputStream getInvoiceAsPdf(String accessToken, String xeroTenantId, UUID invoiceID) throws IOException {
        try {
            TypeReference<File> typeRef = new TypeReference<File>(){};
            HttpResponse response = this.getInvoiceAsPdfForHttpResponse(accessToken, xeroTenantId, invoiceID);
            InputStream is = response.getContent();
            return this.convertInputToByteArray(is);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getInvoiceAsPdf -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getInvoiceAsPdfForHttpResponse(String accessToken, String xeroTenantId, UUID invoiceID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getInvoiceAsPdf");
        }
        if (invoiceID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'invoiceID' when calling getInvoiceAsPdf");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getInvoiceAsPdf");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/pdf");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("InvoiceID", invoiceID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Invoices/{InvoiceID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ByteArrayInputStream getInvoiceAttachmentByFileName(String accessToken, String xeroTenantId, UUID invoiceID, String fileName, String contentType) throws IOException {
        try {
            TypeReference<File> typeRef = new TypeReference<File>(){};
            HttpResponse response = this.getInvoiceAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, invoiceID, fileName, contentType);
            InputStream is = response.getContent();
            return this.convertInputToByteArray(is);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getInvoiceAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getInvoiceAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID invoiceID, String fileName, String contentType) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getInvoiceAttachmentByFileName");
        }
        if (invoiceID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'invoiceID' when calling getInvoiceAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling getInvoiceAttachmentByFileName");
        }
        if (contentType == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contentType' when calling getInvoiceAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getInvoiceAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("contentType", (Object)contentType);
        headers.setAccept("application/octet-stream");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("InvoiceID", invoiceID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Invoices/{InvoiceID}/Attachments/{FileName}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ByteArrayInputStream getInvoiceAttachmentById(String accessToken, String xeroTenantId, UUID invoiceID, UUID attachmentID, String contentType) throws IOException {
        try {
            TypeReference<File> typeRef = new TypeReference<File>(){};
            HttpResponse response = this.getInvoiceAttachmentByIdForHttpResponse(accessToken, xeroTenantId, invoiceID, attachmentID, contentType);
            InputStream is = response.getContent();
            return this.convertInputToByteArray(is);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getInvoiceAttachmentById -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getInvoiceAttachmentByIdForHttpResponse(String accessToken, String xeroTenantId, UUID invoiceID, UUID attachmentID, String contentType) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getInvoiceAttachmentById");
        }
        if (invoiceID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'invoiceID' when calling getInvoiceAttachmentById");
        }
        if (attachmentID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'attachmentID' when calling getInvoiceAttachmentById");
        }
        if (contentType == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contentType' when calling getInvoiceAttachmentById");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getInvoiceAttachmentById");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("contentType", (Object)contentType);
        headers.setAccept("application/octet-stream");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("InvoiceID", invoiceID);
        uriVariables.put("AttachmentID", attachmentID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Invoices/{InvoiceID}/Attachments/{AttachmentID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments getInvoiceAttachments(String accessToken, String xeroTenantId, UUID invoiceID) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.getInvoiceAttachmentsForHttpResponse(accessToken, xeroTenantId, invoiceID);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getInvoiceAttachments -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getInvoiceAttachmentsForHttpResponse(String accessToken, String xeroTenantId, UUID invoiceID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getInvoiceAttachments");
        }
        if (invoiceID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'invoiceID' when calling getInvoiceAttachments");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getInvoiceAttachments");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("InvoiceID", invoiceID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Invoices/{InvoiceID}/Attachments"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public HistoryRecords getInvoiceHistory(String accessToken, String xeroTenantId, UUID invoiceID) throws IOException {
        try {
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            HttpResponse response = this.getInvoiceHistoryForHttpResponse(accessToken, xeroTenantId, invoiceID);
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getInvoiceHistory -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getInvoiceHistoryForHttpResponse(String accessToken, String xeroTenantId, UUID invoiceID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getInvoiceHistory");
        }
        if (invoiceID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'invoiceID' when calling getInvoiceHistory");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getInvoiceHistory");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("InvoiceID", invoiceID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Invoices/{InvoiceID}/History"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public InvoiceReminders getInvoiceReminders(String accessToken, String xeroTenantId) throws IOException {
        try {
            TypeReference<InvoiceReminders> typeRef = new TypeReference<InvoiceReminders>(){};
            HttpResponse response = this.getInvoiceRemindersForHttpResponse(accessToken, xeroTenantId);
            return (InvoiceReminders)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getInvoiceReminders -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getInvoiceRemindersForHttpResponse(String accessToken, String xeroTenantId) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getInvoiceReminders");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getInvoiceReminders");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/InvoiceReminders/Settings"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Invoices getInvoices(String accessToken, String xeroTenantId, OffsetDateTime ifModifiedSince, String where, String order, List<UUID> ids, List<String> invoiceNumbers, List<UUID> contactIDs, List<String> statuses, Integer page, Boolean includeArchived, Boolean createdByMyApp, Integer unitdp, Boolean summaryOnly, Integer pageSize, String searchTerm) throws IOException {
        try {
            TypeReference<Invoices> typeRef = new TypeReference<Invoices>(){};
            HttpResponse response = this.getInvoicesForHttpResponse(accessToken, xeroTenantId, ifModifiedSince, where, order, ids, invoiceNumbers, contactIDs, statuses, page, includeArchived, createdByMyApp, unitdp, summaryOnly, pageSize, searchTerm);
            return (Invoices)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getInvoices -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getInvoicesForHttpResponse(String accessToken, String xeroTenantId, OffsetDateTime ifModifiedSince, String where, String order, List<UUID> ids, List<String> invoiceNumbers, List<UUID> contactIDs, List<String> statuses, Integer page, Boolean includeArchived, Boolean createdByMyApp, Integer unitdp, Boolean summaryOnly, Integer pageSize, String searchTerm) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        Object value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getInvoices");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getInvoices");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        if (ifModifiedSince != null) {
            headers.setIfModifiedSince(ifModifiedSince.toString());
        }
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Invoices"));
        if (where != null) {
            key = "where";
            value = where;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (order != null) {
            key = "order";
            value = order;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (ids != null) {
            key = "IDs";
            value = ids;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (invoiceNumbers != null) {
            key = "InvoiceNumbers";
            value = invoiceNumbers;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (contactIDs != null) {
            key = "ContactIDs";
            value = contactIDs;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (statuses != null) {
            key = "Statuses";
            value = statuses;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (page != null) {
            key = "page";
            value = page;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (includeArchived != null) {
            key = "includeArchived";
            value = includeArchived;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (createdByMyApp != null) {
            key = "createdByMyApp";
            value = createdByMyApp;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (unitdp != null) {
            key = "unitdp";
            value = unitdp;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (summaryOnly != null) {
            key = "summaryOnly";
            value = summaryOnly;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (pageSize != null) {
            key = "pageSize";
            value = pageSize;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (searchTerm != null) {
            key = "searchTerm";
            value = searchTerm;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Items getItem(String accessToken, String xeroTenantId, UUID itemID, Integer unitdp) throws IOException {
        try {
            TypeReference<Items> typeRef = new TypeReference<Items>(){};
            HttpResponse response = this.getItemForHttpResponse(accessToken, xeroTenantId, itemID, unitdp);
            return (Items)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getItem -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getItemForHttpResponse(String accessToken, String xeroTenantId, UUID itemID, Integer unitdp) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getItem");
        }
        if (itemID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'itemID' when calling getItem");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getItem");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("ItemID", itemID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Items/{ItemID}"));
        if (unitdp != null) {
            String key = "unitdp";
            Integer value = unitdp;
            if (value instanceof Collection) {
                ArrayList valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public HistoryRecords getItemHistory(String accessToken, String xeroTenantId, UUID itemID) throws IOException {
        try {
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            HttpResponse response = this.getItemHistoryForHttpResponse(accessToken, xeroTenantId, itemID);
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getItemHistory -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getItemHistoryForHttpResponse(String accessToken, String xeroTenantId, UUID itemID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getItemHistory");
        }
        if (itemID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'itemID' when calling getItemHistory");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getItemHistory");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("ItemID", itemID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Items/{ItemID}/History"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Items getItems(String accessToken, String xeroTenantId, OffsetDateTime ifModifiedSince, String where, String order, Integer unitdp) throws IOException {
        try {
            TypeReference<Items> typeRef = new TypeReference<Items>(){};
            HttpResponse response = this.getItemsForHttpResponse(accessToken, xeroTenantId, ifModifiedSince, where, order, unitdp);
            return (Items)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getItems -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getItemsForHttpResponse(String accessToken, String xeroTenantId, OffsetDateTime ifModifiedSince, String where, String order, Integer unitdp) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        Object value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getItems");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getItems");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        if (ifModifiedSince != null) {
            headers.setIfModifiedSince(ifModifiedSince.toString());
        }
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Items"));
        if (where != null) {
            key = "where";
            value = where;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (order != null) {
            key = "order";
            value = order;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (unitdp != null) {
            key = "unitdp";
            value = unitdp;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Journals getJournal(String accessToken, String xeroTenantId, UUID journalID) throws IOException {
        try {
            TypeReference<Journals> typeRef = new TypeReference<Journals>(){};
            HttpResponse response = this.getJournalForHttpResponse(accessToken, xeroTenantId, journalID);
            return (Journals)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getJournal -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getJournalForHttpResponse(String accessToken, String xeroTenantId, UUID journalID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getJournal");
        }
        if (journalID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'journalID' when calling getJournal");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getJournal");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("JournalID", journalID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Journals/{JournalID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Journals getJournalByNumber(String accessToken, String xeroTenantId, Integer journalNumber) throws IOException {
        try {
            TypeReference<Journals> typeRef = new TypeReference<Journals>(){};
            HttpResponse response = this.getJournalByNumberForHttpResponse(accessToken, xeroTenantId, journalNumber);
            return (Journals)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getJournalByNumber -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getJournalByNumberForHttpResponse(String accessToken, String xeroTenantId, Integer journalNumber) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getJournalByNumber");
        }
        if (journalNumber == null) {
            throw new IllegalArgumentException("Missing the required parameter 'journalNumber' when calling getJournalByNumber");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getJournalByNumber");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Integer> uriVariables = new HashMap<String, Integer>();
        uriVariables.put("JournalNumber", journalNumber);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Journals/{JournalNumber}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Journals getJournals(String accessToken, String xeroTenantId, OffsetDateTime ifModifiedSince, Integer offset, Boolean paymentsOnly) throws IOException {
        try {
            TypeReference<Journals> typeRef = new TypeReference<Journals>(){};
            HttpResponse response = this.getJournalsForHttpResponse(accessToken, xeroTenantId, ifModifiedSince, offset, paymentsOnly);
            return (Journals)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getJournals -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getJournalsForHttpResponse(String accessToken, String xeroTenantId, OffsetDateTime ifModifiedSince, Integer offset, Boolean paymentsOnly) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        Constable value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getJournals");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getJournals");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        if (ifModifiedSince != null) {
            headers.setIfModifiedSince(ifModifiedSince.toString());
        }
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Journals"));
        if (offset != null) {
            key = "offset";
            value = offset;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (paymentsOnly != null) {
            key = "paymentsOnly";
            value = paymentsOnly;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public LinkedTransactions getLinkedTransaction(String accessToken, String xeroTenantId, UUID linkedTransactionID) throws IOException {
        try {
            TypeReference<LinkedTransactions> typeRef = new TypeReference<LinkedTransactions>(){};
            HttpResponse response = this.getLinkedTransactionForHttpResponse(accessToken, xeroTenantId, linkedTransactionID);
            return (LinkedTransactions)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getLinkedTransaction -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getLinkedTransactionForHttpResponse(String accessToken, String xeroTenantId, UUID linkedTransactionID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getLinkedTransaction");
        }
        if (linkedTransactionID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'linkedTransactionID' when calling getLinkedTransaction");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getLinkedTransaction");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("LinkedTransactionID", linkedTransactionID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/LinkedTransactions/{LinkedTransactionID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public LinkedTransactions getLinkedTransactions(String accessToken, String xeroTenantId, Integer page, UUID linkedTransactionID, UUID sourceTransactionID, UUID contactID, String status, UUID targetTransactionID) throws IOException {
        try {
            TypeReference<LinkedTransactions> typeRef = new TypeReference<LinkedTransactions>(){};
            HttpResponse response = this.getLinkedTransactionsForHttpResponse(accessToken, xeroTenantId, page, linkedTransactionID, sourceTransactionID, contactID, status, targetTransactionID);
            return (LinkedTransactions)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getLinkedTransactions -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getLinkedTransactionsForHttpResponse(String accessToken, String xeroTenantId, Integer page, UUID linkedTransactionID, UUID sourceTransactionID, UUID contactID, String status, UUID targetTransactionID) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        Object value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getLinkedTransactions");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getLinkedTransactions");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/LinkedTransactions"));
        if (page != null) {
            key = "page";
            value = page;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (linkedTransactionID != null) {
            key = "LinkedTransactionID";
            value = linkedTransactionID;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (sourceTransactionID != null) {
            key = "SourceTransactionID";
            value = sourceTransactionID;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (contactID != null) {
            key = "ContactID";
            value = contactID;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (status != null) {
            key = "Status";
            value = status;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (targetTransactionID != null) {
            key = "TargetTransactionID";
            value = targetTransactionID;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ManualJournals getManualJournal(String accessToken, String xeroTenantId, UUID manualJournalID) throws IOException {
        try {
            TypeReference<ManualJournals> typeRef = new TypeReference<ManualJournals>(){};
            HttpResponse response = this.getManualJournalForHttpResponse(accessToken, xeroTenantId, manualJournalID);
            return (ManualJournals)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getManualJournal -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getManualJournalForHttpResponse(String accessToken, String xeroTenantId, UUID manualJournalID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getManualJournal");
        }
        if (manualJournalID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'manualJournalID' when calling getManualJournal");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getManualJournal");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("ManualJournalID", manualJournalID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/ManualJournals/{ManualJournalID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ByteArrayInputStream getManualJournalAttachmentByFileName(String accessToken, String xeroTenantId, UUID manualJournalID, String fileName, String contentType) throws IOException {
        try {
            TypeReference<File> typeRef = new TypeReference<File>(){};
            HttpResponse response = this.getManualJournalAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, manualJournalID, fileName, contentType);
            InputStream is = response.getContent();
            return this.convertInputToByteArray(is);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getManualJournalAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getManualJournalAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID manualJournalID, String fileName, String contentType) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getManualJournalAttachmentByFileName");
        }
        if (manualJournalID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'manualJournalID' when calling getManualJournalAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling getManualJournalAttachmentByFileName");
        }
        if (contentType == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contentType' when calling getManualJournalAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getManualJournalAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("contentType", (Object)contentType);
        headers.setAccept("application/octet-stream");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("ManualJournalID", manualJournalID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/ManualJournals/{ManualJournalID}/Attachments/{FileName}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ByteArrayInputStream getManualJournalAttachmentById(String accessToken, String xeroTenantId, UUID manualJournalID, UUID attachmentID, String contentType) throws IOException {
        try {
            TypeReference<File> typeRef = new TypeReference<File>(){};
            HttpResponse response = this.getManualJournalAttachmentByIdForHttpResponse(accessToken, xeroTenantId, manualJournalID, attachmentID, contentType);
            InputStream is = response.getContent();
            return this.convertInputToByteArray(is);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getManualJournalAttachmentById -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getManualJournalAttachmentByIdForHttpResponse(String accessToken, String xeroTenantId, UUID manualJournalID, UUID attachmentID, String contentType) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getManualJournalAttachmentById");
        }
        if (manualJournalID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'manualJournalID' when calling getManualJournalAttachmentById");
        }
        if (attachmentID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'attachmentID' when calling getManualJournalAttachmentById");
        }
        if (contentType == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contentType' when calling getManualJournalAttachmentById");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getManualJournalAttachmentById");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("contentType", (Object)contentType);
        headers.setAccept("application/octet-stream");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("ManualJournalID", manualJournalID);
        uriVariables.put("AttachmentID", attachmentID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/ManualJournals/{ManualJournalID}/Attachments/{AttachmentID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments getManualJournalAttachments(String accessToken, String xeroTenantId, UUID manualJournalID) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.getManualJournalAttachmentsForHttpResponse(accessToken, xeroTenantId, manualJournalID);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getManualJournalAttachments -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getManualJournalAttachmentsForHttpResponse(String accessToken, String xeroTenantId, UUID manualJournalID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getManualJournalAttachments");
        }
        if (manualJournalID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'manualJournalID' when calling getManualJournalAttachments");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getManualJournalAttachments");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("ManualJournalID", manualJournalID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/ManualJournals/{ManualJournalID}/Attachments"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ManualJournals getManualJournals(String accessToken, String xeroTenantId, OffsetDateTime ifModifiedSince, String where, String order, Integer page, Integer pageSize) throws IOException {
        try {
            TypeReference<ManualJournals> typeRef = new TypeReference<ManualJournals>(){};
            HttpResponse response = this.getManualJournalsForHttpResponse(accessToken, xeroTenantId, ifModifiedSince, where, order, page, pageSize);
            return (ManualJournals)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getManualJournals -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getManualJournalsForHttpResponse(String accessToken, String xeroTenantId, OffsetDateTime ifModifiedSince, String where, String order, Integer page, Integer pageSize) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        Object value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getManualJournals");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getManualJournals");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        if (ifModifiedSince != null) {
            headers.setIfModifiedSince(ifModifiedSince.toString());
        }
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/ManualJournals"));
        if (where != null) {
            key = "where";
            value = where;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (order != null) {
            key = "order";
            value = order;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (page != null) {
            key = "page";
            value = page;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (pageSize != null) {
            key = "pageSize";
            value = pageSize;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public HistoryRecords getManualJournalsHistory(String accessToken, String xeroTenantId, UUID manualJournalID) throws IOException {
        try {
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            HttpResponse response = this.getManualJournalsHistoryForHttpResponse(accessToken, xeroTenantId, manualJournalID);
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getManualJournalsHistory -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getManualJournalsHistoryForHttpResponse(String accessToken, String xeroTenantId, UUID manualJournalID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getManualJournalsHistory");
        }
        if (manualJournalID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'manualJournalID' when calling getManualJournalsHistory");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getManualJournalsHistory");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("ManualJournalID", manualJournalID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/ManualJournals/{ManualJournalID}/History"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public OnlineInvoices getOnlineInvoice(String accessToken, String xeroTenantId, UUID invoiceID) throws IOException {
        try {
            TypeReference<OnlineInvoices> typeRef = new TypeReference<OnlineInvoices>(){};
            HttpResponse response = this.getOnlineInvoiceForHttpResponse(accessToken, xeroTenantId, invoiceID);
            return (OnlineInvoices)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getOnlineInvoice -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getOnlineInvoiceForHttpResponse(String accessToken, String xeroTenantId, UUID invoiceID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getOnlineInvoice");
        }
        if (invoiceID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'invoiceID' when calling getOnlineInvoice");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getOnlineInvoice");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("InvoiceID", invoiceID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Invoices/{InvoiceID}/OnlineInvoice"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Actions getOrganisationActions(String accessToken, String xeroTenantId) throws IOException {
        try {
            TypeReference<Actions> typeRef = new TypeReference<Actions>(){};
            HttpResponse response = this.getOrganisationActionsForHttpResponse(accessToken, xeroTenantId);
            return (Actions)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getOrganisationActions -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getOrganisationActionsForHttpResponse(String accessToken, String xeroTenantId) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getOrganisationActions");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getOrganisationActions");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Organisation/Actions"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public CISOrgSettings getOrganisationCISSettings(String accessToken, String xeroTenantId, UUID organisationID) throws IOException {
        try {
            TypeReference<CISOrgSettings> typeRef = new TypeReference<CISOrgSettings>(){};
            HttpResponse response = this.getOrganisationCISSettingsForHttpResponse(accessToken, xeroTenantId, organisationID);
            return (CISOrgSettings)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getOrganisationCISSettings -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getOrganisationCISSettingsForHttpResponse(String accessToken, String xeroTenantId, UUID organisationID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getOrganisationCISSettings");
        }
        if (organisationID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'organisationID' when calling getOrganisationCISSettings");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getOrganisationCISSettings");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("OrganisationID", organisationID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Organisation/{OrganisationID}/CISSettings"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Organisations getOrganisations(String accessToken, String xeroTenantId) throws IOException {
        try {
            TypeReference<Organisations> typeRef = new TypeReference<Organisations>(){};
            HttpResponse response = this.getOrganisationsForHttpResponse(accessToken, xeroTenantId);
            return (Organisations)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getOrganisations -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getOrganisationsForHttpResponse(String accessToken, String xeroTenantId) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getOrganisations");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getOrganisations");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Organisation"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Overpayments getOverpayment(String accessToken, String xeroTenantId, UUID overpaymentID) throws IOException {
        try {
            TypeReference<Overpayments> typeRef = new TypeReference<Overpayments>(){};
            HttpResponse response = this.getOverpaymentForHttpResponse(accessToken, xeroTenantId, overpaymentID);
            return (Overpayments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getOverpayment -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getOverpaymentForHttpResponse(String accessToken, String xeroTenantId, UUID overpaymentID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getOverpayment");
        }
        if (overpaymentID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'overpaymentID' when calling getOverpayment");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getOverpayment");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("OverpaymentID", overpaymentID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Overpayments/{OverpaymentID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public HistoryRecords getOverpaymentHistory(String accessToken, String xeroTenantId, UUID overpaymentID) throws IOException {
        try {
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            HttpResponse response = this.getOverpaymentHistoryForHttpResponse(accessToken, xeroTenantId, overpaymentID);
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getOverpaymentHistory -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getOverpaymentHistoryForHttpResponse(String accessToken, String xeroTenantId, UUID overpaymentID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getOverpaymentHistory");
        }
        if (overpaymentID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'overpaymentID' when calling getOverpaymentHistory");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getOverpaymentHistory");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("OverpaymentID", overpaymentID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Overpayments/{OverpaymentID}/History"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Overpayments getOverpayments(String accessToken, String xeroTenantId, OffsetDateTime ifModifiedSince, String where, String order, Integer page, Integer unitdp, Integer pageSize) throws IOException {
        try {
            TypeReference<Overpayments> typeRef = new TypeReference<Overpayments>(){};
            HttpResponse response = this.getOverpaymentsForHttpResponse(accessToken, xeroTenantId, ifModifiedSince, where, order, page, unitdp, pageSize);
            return (Overpayments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getOverpayments -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getOverpaymentsForHttpResponse(String accessToken, String xeroTenantId, OffsetDateTime ifModifiedSince, String where, String order, Integer page, Integer unitdp, Integer pageSize) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        Object value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getOverpayments");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getOverpayments");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        if (ifModifiedSince != null) {
            headers.setIfModifiedSince(ifModifiedSince.toString());
        }
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Overpayments"));
        if (where != null) {
            key = "where";
            value = where;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (order != null) {
            key = "order";
            value = order;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (page != null) {
            key = "page";
            value = page;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (unitdp != null) {
            key = "unitdp";
            value = unitdp;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (pageSize != null) {
            key = "pageSize";
            value = pageSize;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Payments getPayment(String accessToken, String xeroTenantId, UUID paymentID) throws IOException {
        try {
            TypeReference<Payments> typeRef = new TypeReference<Payments>(){};
            HttpResponse response = this.getPaymentForHttpResponse(accessToken, xeroTenantId, paymentID);
            return (Payments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getPayment -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getPaymentForHttpResponse(String accessToken, String xeroTenantId, UUID paymentID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getPayment");
        }
        if (paymentID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'paymentID' when calling getPayment");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getPayment");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("PaymentID", paymentID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Payments/{PaymentID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public HistoryRecords getPaymentHistory(String accessToken, String xeroTenantId, UUID paymentID) throws IOException {
        try {
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            HttpResponse response = this.getPaymentHistoryForHttpResponse(accessToken, xeroTenantId, paymentID);
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getPaymentHistory -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getPaymentHistoryForHttpResponse(String accessToken, String xeroTenantId, UUID paymentID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getPaymentHistory");
        }
        if (paymentID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'paymentID' when calling getPaymentHistory");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getPaymentHistory");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("PaymentID", paymentID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Payments/{PaymentID}/History"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public PaymentServices getPaymentServices(String accessToken, String xeroTenantId) throws IOException {
        try {
            TypeReference<PaymentServices> typeRef = new TypeReference<PaymentServices>(){};
            HttpResponse response = this.getPaymentServicesForHttpResponse(accessToken, xeroTenantId);
            return (PaymentServices)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getPaymentServices -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getPaymentServicesForHttpResponse(String accessToken, String xeroTenantId) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getPaymentServices");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getPaymentServices");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/PaymentServices"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Payments getPayments(String accessToken, String xeroTenantId, OffsetDateTime ifModifiedSince, String where, String order, Integer page, Integer pageSize) throws IOException {
        try {
            TypeReference<Payments> typeRef = new TypeReference<Payments>(){};
            HttpResponse response = this.getPaymentsForHttpResponse(accessToken, xeroTenantId, ifModifiedSince, where, order, page, pageSize);
            return (Payments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getPayments -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getPaymentsForHttpResponse(String accessToken, String xeroTenantId, OffsetDateTime ifModifiedSince, String where, String order, Integer page, Integer pageSize) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        Object value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getPayments");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getPayments");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        if (ifModifiedSince != null) {
            headers.setIfModifiedSince(ifModifiedSince.toString());
        }
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Payments"));
        if (where != null) {
            key = "where";
            value = where;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (order != null) {
            key = "order";
            value = order;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (page != null) {
            key = "page";
            value = page;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (pageSize != null) {
            key = "pageSize";
            value = pageSize;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Prepayments getPrepayment(String accessToken, String xeroTenantId, UUID prepaymentID) throws IOException {
        try {
            TypeReference<Prepayments> typeRef = new TypeReference<Prepayments>(){};
            HttpResponse response = this.getPrepaymentForHttpResponse(accessToken, xeroTenantId, prepaymentID);
            return (Prepayments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getPrepayment -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getPrepaymentForHttpResponse(String accessToken, String xeroTenantId, UUID prepaymentID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getPrepayment");
        }
        if (prepaymentID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'prepaymentID' when calling getPrepayment");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getPrepayment");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("PrepaymentID", prepaymentID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Prepayments/{PrepaymentID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public HistoryRecords getPrepaymentHistory(String accessToken, String xeroTenantId, UUID prepaymentID) throws IOException {
        try {
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            HttpResponse response = this.getPrepaymentHistoryForHttpResponse(accessToken, xeroTenantId, prepaymentID);
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getPrepaymentHistory -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getPrepaymentHistoryForHttpResponse(String accessToken, String xeroTenantId, UUID prepaymentID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getPrepaymentHistory");
        }
        if (prepaymentID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'prepaymentID' when calling getPrepaymentHistory");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getPrepaymentHistory");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("PrepaymentID", prepaymentID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Prepayments/{PrepaymentID}/History"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Prepayments getPrepayments(String accessToken, String xeroTenantId, OffsetDateTime ifModifiedSince, String where, String order, Integer page, Integer unitdp, Integer pageSize) throws IOException {
        try {
            TypeReference<Prepayments> typeRef = new TypeReference<Prepayments>(){};
            HttpResponse response = this.getPrepaymentsForHttpResponse(accessToken, xeroTenantId, ifModifiedSince, where, order, page, unitdp, pageSize);
            return (Prepayments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getPrepayments -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getPrepaymentsForHttpResponse(String accessToken, String xeroTenantId, OffsetDateTime ifModifiedSince, String where, String order, Integer page, Integer unitdp, Integer pageSize) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        Object value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getPrepayments");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getPrepayments");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        if (ifModifiedSince != null) {
            headers.setIfModifiedSince(ifModifiedSince.toString());
        }
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Prepayments"));
        if (where != null) {
            key = "where";
            value = where;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (order != null) {
            key = "order";
            value = order;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (page != null) {
            key = "page";
            value = page;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (unitdp != null) {
            key = "unitdp";
            value = unitdp;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (pageSize != null) {
            key = "pageSize";
            value = pageSize;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public PurchaseOrders getPurchaseOrder(String accessToken, String xeroTenantId, UUID purchaseOrderID) throws IOException {
        try {
            TypeReference<PurchaseOrders> typeRef = new TypeReference<PurchaseOrders>(){};
            HttpResponse response = this.getPurchaseOrderForHttpResponse(accessToken, xeroTenantId, purchaseOrderID);
            return (PurchaseOrders)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getPurchaseOrder -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getPurchaseOrderForHttpResponse(String accessToken, String xeroTenantId, UUID purchaseOrderID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getPurchaseOrder");
        }
        if (purchaseOrderID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'purchaseOrderID' when calling getPurchaseOrder");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getPurchaseOrder");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("PurchaseOrderID", purchaseOrderID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/PurchaseOrders/{PurchaseOrderID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ByteArrayInputStream getPurchaseOrderAsPdf(String accessToken, String xeroTenantId, UUID purchaseOrderID) throws IOException {
        try {
            TypeReference<File> typeRef = new TypeReference<File>(){};
            HttpResponse response = this.getPurchaseOrderAsPdfForHttpResponse(accessToken, xeroTenantId, purchaseOrderID);
            InputStream is = response.getContent();
            return this.convertInputToByteArray(is);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getPurchaseOrderAsPdf -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getPurchaseOrderAsPdfForHttpResponse(String accessToken, String xeroTenantId, UUID purchaseOrderID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getPurchaseOrderAsPdf");
        }
        if (purchaseOrderID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'purchaseOrderID' when calling getPurchaseOrderAsPdf");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getPurchaseOrderAsPdf");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/pdf");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("PurchaseOrderID", purchaseOrderID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/PurchaseOrders/{PurchaseOrderID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ByteArrayInputStream getPurchaseOrderAttachmentByFileName(String accessToken, String xeroTenantId, UUID purchaseOrderID, String fileName, String contentType) throws IOException {
        try {
            TypeReference<File> typeRef = new TypeReference<File>(){};
            HttpResponse response = this.getPurchaseOrderAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, purchaseOrderID, fileName, contentType);
            InputStream is = response.getContent();
            return this.convertInputToByteArray(is);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getPurchaseOrderAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getPurchaseOrderAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID purchaseOrderID, String fileName, String contentType) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getPurchaseOrderAttachmentByFileName");
        }
        if (purchaseOrderID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'purchaseOrderID' when calling getPurchaseOrderAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling getPurchaseOrderAttachmentByFileName");
        }
        if (contentType == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contentType' when calling getPurchaseOrderAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getPurchaseOrderAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("contentType", (Object)contentType);
        headers.setAccept("application/octet-stream");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("PurchaseOrderID", purchaseOrderID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/PurchaseOrders/{PurchaseOrderID}/Attachments/{FileName}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ByteArrayInputStream getPurchaseOrderAttachmentById(String accessToken, String xeroTenantId, UUID purchaseOrderID, UUID attachmentID, String contentType) throws IOException {
        try {
            TypeReference<File> typeRef = new TypeReference<File>(){};
            HttpResponse response = this.getPurchaseOrderAttachmentByIdForHttpResponse(accessToken, xeroTenantId, purchaseOrderID, attachmentID, contentType);
            InputStream is = response.getContent();
            return this.convertInputToByteArray(is);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getPurchaseOrderAttachmentById -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getPurchaseOrderAttachmentByIdForHttpResponse(String accessToken, String xeroTenantId, UUID purchaseOrderID, UUID attachmentID, String contentType) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getPurchaseOrderAttachmentById");
        }
        if (purchaseOrderID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'purchaseOrderID' when calling getPurchaseOrderAttachmentById");
        }
        if (attachmentID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'attachmentID' when calling getPurchaseOrderAttachmentById");
        }
        if (contentType == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contentType' when calling getPurchaseOrderAttachmentById");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getPurchaseOrderAttachmentById");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("contentType", (Object)contentType);
        headers.setAccept("application/octet-stream");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("PurchaseOrderID", purchaseOrderID);
        uriVariables.put("AttachmentID", attachmentID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/PurchaseOrders/{PurchaseOrderID}/Attachments/{AttachmentID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments getPurchaseOrderAttachments(String accessToken, String xeroTenantId, UUID purchaseOrderID) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.getPurchaseOrderAttachmentsForHttpResponse(accessToken, xeroTenantId, purchaseOrderID);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getPurchaseOrderAttachments -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getPurchaseOrderAttachmentsForHttpResponse(String accessToken, String xeroTenantId, UUID purchaseOrderID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getPurchaseOrderAttachments");
        }
        if (purchaseOrderID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'purchaseOrderID' when calling getPurchaseOrderAttachments");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getPurchaseOrderAttachments");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("PurchaseOrderID", purchaseOrderID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/PurchaseOrders/{PurchaseOrderID}/Attachments"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public PurchaseOrders getPurchaseOrderByNumber(String accessToken, String xeroTenantId, String purchaseOrderNumber) throws IOException {
        try {
            TypeReference<PurchaseOrders> typeRef = new TypeReference<PurchaseOrders>(){};
            HttpResponse response = this.getPurchaseOrderByNumberForHttpResponse(accessToken, xeroTenantId, purchaseOrderNumber);
            return (PurchaseOrders)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getPurchaseOrderByNumber -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getPurchaseOrderByNumberForHttpResponse(String accessToken, String xeroTenantId, String purchaseOrderNumber) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getPurchaseOrderByNumber");
        }
        if (purchaseOrderNumber == null) {
            throw new IllegalArgumentException("Missing the required parameter 'purchaseOrderNumber' when calling getPurchaseOrderByNumber");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getPurchaseOrderByNumber");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("PurchaseOrderNumber", purchaseOrderNumber);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/PurchaseOrders/{PurchaseOrderNumber}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public HistoryRecords getPurchaseOrderHistory(String accessToken, String xeroTenantId, UUID purchaseOrderID) throws IOException {
        try {
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            HttpResponse response = this.getPurchaseOrderHistoryForHttpResponse(accessToken, xeroTenantId, purchaseOrderID);
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getPurchaseOrderHistory -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getPurchaseOrderHistoryForHttpResponse(String accessToken, String xeroTenantId, UUID purchaseOrderID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getPurchaseOrderHistory");
        }
        if (purchaseOrderID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'purchaseOrderID' when calling getPurchaseOrderHistory");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getPurchaseOrderHistory");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("PurchaseOrderID", purchaseOrderID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/PurchaseOrders/{PurchaseOrderID}/History"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public PurchaseOrders getPurchaseOrders(String accessToken, String xeroTenantId, OffsetDateTime ifModifiedSince, String status, String dateFrom, String dateTo, String order, Integer page, Integer pageSize) throws IOException {
        try {
            TypeReference<PurchaseOrders> typeRef = new TypeReference<PurchaseOrders>(){};
            HttpResponse response = this.getPurchaseOrdersForHttpResponse(accessToken, xeroTenantId, ifModifiedSince, status, dateFrom, dateTo, order, page, pageSize);
            return (PurchaseOrders)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getPurchaseOrders -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getPurchaseOrdersForHttpResponse(String accessToken, String xeroTenantId, OffsetDateTime ifModifiedSince, String status, String dateFrom, String dateTo, String order, Integer page, Integer pageSize) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        Object value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getPurchaseOrders");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getPurchaseOrders");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        if (ifModifiedSince != null) {
            headers.setIfModifiedSince(ifModifiedSince.toString());
        }
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/PurchaseOrders"));
        if (status != null) {
            key = "Status";
            value = status;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (dateFrom != null) {
            key = "DateFrom";
            value = dateFrom;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (dateTo != null) {
            key = "DateTo";
            value = dateTo;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (order != null) {
            key = "order";
            value = order;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (page != null) {
            key = "page";
            value = page;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (pageSize != null) {
            key = "pageSize";
            value = pageSize;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Quotes getQuote(String accessToken, String xeroTenantId, UUID quoteID) throws IOException {
        try {
            TypeReference<Quotes> typeRef = new TypeReference<Quotes>(){};
            HttpResponse response = this.getQuoteForHttpResponse(accessToken, xeroTenantId, quoteID);
            return (Quotes)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getQuote -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getQuoteForHttpResponse(String accessToken, String xeroTenantId, UUID quoteID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getQuote");
        }
        if (quoteID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'quoteID' when calling getQuote");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getQuote");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("QuoteID", quoteID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Quotes/{QuoteID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ByteArrayInputStream getQuoteAsPdf(String accessToken, String xeroTenantId, UUID quoteID) throws IOException {
        try {
            TypeReference<File> typeRef = new TypeReference<File>(){};
            HttpResponse response = this.getQuoteAsPdfForHttpResponse(accessToken, xeroTenantId, quoteID);
            InputStream is = response.getContent();
            return this.convertInputToByteArray(is);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getQuoteAsPdf -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getQuoteAsPdfForHttpResponse(String accessToken, String xeroTenantId, UUID quoteID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getQuoteAsPdf");
        }
        if (quoteID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'quoteID' when calling getQuoteAsPdf");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getQuoteAsPdf");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/pdf");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("QuoteID", quoteID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Quotes/{QuoteID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ByteArrayInputStream getQuoteAttachmentByFileName(String accessToken, String xeroTenantId, UUID quoteID, String fileName, String contentType) throws IOException {
        try {
            TypeReference<File> typeRef = new TypeReference<File>(){};
            HttpResponse response = this.getQuoteAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, quoteID, fileName, contentType);
            InputStream is = response.getContent();
            return this.convertInputToByteArray(is);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getQuoteAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getQuoteAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID quoteID, String fileName, String contentType) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getQuoteAttachmentByFileName");
        }
        if (quoteID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'quoteID' when calling getQuoteAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling getQuoteAttachmentByFileName");
        }
        if (contentType == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contentType' when calling getQuoteAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getQuoteAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("contentType", (Object)contentType);
        headers.setAccept("application/octet-stream");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("QuoteID", quoteID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Quotes/{QuoteID}/Attachments/{FileName}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ByteArrayInputStream getQuoteAttachmentById(String accessToken, String xeroTenantId, UUID quoteID, UUID attachmentID, String contentType) throws IOException {
        try {
            TypeReference<File> typeRef = new TypeReference<File>(){};
            HttpResponse response = this.getQuoteAttachmentByIdForHttpResponse(accessToken, xeroTenantId, quoteID, attachmentID, contentType);
            InputStream is = response.getContent();
            return this.convertInputToByteArray(is);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getQuoteAttachmentById -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getQuoteAttachmentByIdForHttpResponse(String accessToken, String xeroTenantId, UUID quoteID, UUID attachmentID, String contentType) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getQuoteAttachmentById");
        }
        if (quoteID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'quoteID' when calling getQuoteAttachmentById");
        }
        if (attachmentID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'attachmentID' when calling getQuoteAttachmentById");
        }
        if (contentType == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contentType' when calling getQuoteAttachmentById");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getQuoteAttachmentById");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("contentType", (Object)contentType);
        headers.setAccept("application/octet-stream");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("QuoteID", quoteID);
        uriVariables.put("AttachmentID", attachmentID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Quotes/{QuoteID}/Attachments/{AttachmentID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments getQuoteAttachments(String accessToken, String xeroTenantId, UUID quoteID) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.getQuoteAttachmentsForHttpResponse(accessToken, xeroTenantId, quoteID);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getQuoteAttachments -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getQuoteAttachmentsForHttpResponse(String accessToken, String xeroTenantId, UUID quoteID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getQuoteAttachments");
        }
        if (quoteID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'quoteID' when calling getQuoteAttachments");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getQuoteAttachments");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("QuoteID", quoteID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Quotes/{QuoteID}/Attachments"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public HistoryRecords getQuoteHistory(String accessToken, String xeroTenantId, UUID quoteID) throws IOException {
        try {
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            HttpResponse response = this.getQuoteHistoryForHttpResponse(accessToken, xeroTenantId, quoteID);
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getQuoteHistory -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getQuoteHistoryForHttpResponse(String accessToken, String xeroTenantId, UUID quoteID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getQuoteHistory");
        }
        if (quoteID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'quoteID' when calling getQuoteHistory");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getQuoteHistory");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("QuoteID", quoteID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Quotes/{QuoteID}/History"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Quotes getQuotes(String accessToken, String xeroTenantId, OffsetDateTime ifModifiedSince, LocalDate dateFrom, LocalDate dateTo, LocalDate expiryDateFrom, LocalDate expiryDateTo, UUID contactID, String status, Integer page, String order, String quoteNumber) throws IOException {
        try {
            TypeReference<Quotes> typeRef = new TypeReference<Quotes>(){};
            HttpResponse response = this.getQuotesForHttpResponse(accessToken, xeroTenantId, ifModifiedSince, dateFrom, dateTo, expiryDateFrom, expiryDateTo, contactID, status, page, order, quoteNumber);
            return (Quotes)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getQuotes -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getQuotesForHttpResponse(String accessToken, String xeroTenantId, OffsetDateTime ifModifiedSince, LocalDate dateFrom, LocalDate dateTo, LocalDate expiryDateFrom, LocalDate expiryDateTo, UUID contactID, String status, Integer page, String order, String quoteNumber) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        Object value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getQuotes");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getQuotes");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        if (ifModifiedSince != null) {
            headers.setIfModifiedSince(ifModifiedSince.toString());
        }
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Quotes"));
        if (dateFrom != null) {
            key = "DateFrom";
            value = dateFrom;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (dateTo != null) {
            key = "DateTo";
            value = dateTo;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (expiryDateFrom != null) {
            key = "ExpiryDateFrom";
            value = expiryDateFrom;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (expiryDateTo != null) {
            key = "ExpiryDateTo";
            value = expiryDateTo;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (contactID != null) {
            key = "ContactID";
            value = contactID;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (status != null) {
            key = "Status";
            value = status;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (page != null) {
            key = "page";
            value = page;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (order != null) {
            key = "order";
            value = order;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (quoteNumber != null) {
            key = "QuoteNumber";
            value = quoteNumber;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Receipts getReceipt(String accessToken, String xeroTenantId, UUID receiptID, Integer unitdp) throws IOException {
        try {
            TypeReference<Receipts> typeRef = new TypeReference<Receipts>(){};
            HttpResponse response = this.getReceiptForHttpResponse(accessToken, xeroTenantId, receiptID, unitdp);
            return (Receipts)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getReceipt -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getReceiptForHttpResponse(String accessToken, String xeroTenantId, UUID receiptID, Integer unitdp) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getReceipt");
        }
        if (receiptID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'receiptID' when calling getReceipt");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getReceipt");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("ReceiptID", receiptID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Receipts/{ReceiptID}"));
        if (unitdp != null) {
            String key = "unitdp";
            Integer value = unitdp;
            if (value instanceof Collection) {
                ArrayList valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ByteArrayInputStream getReceiptAttachmentByFileName(String accessToken, String xeroTenantId, UUID receiptID, String fileName, String contentType) throws IOException {
        try {
            TypeReference<File> typeRef = new TypeReference<File>(){};
            HttpResponse response = this.getReceiptAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, receiptID, fileName, contentType);
            InputStream is = response.getContent();
            return this.convertInputToByteArray(is);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getReceiptAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getReceiptAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID receiptID, String fileName, String contentType) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getReceiptAttachmentByFileName");
        }
        if (receiptID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'receiptID' when calling getReceiptAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling getReceiptAttachmentByFileName");
        }
        if (contentType == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contentType' when calling getReceiptAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getReceiptAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("contentType", (Object)contentType);
        headers.setAccept("application/octet-stream");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("ReceiptID", receiptID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Receipts/{ReceiptID}/Attachments/{FileName}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ByteArrayInputStream getReceiptAttachmentById(String accessToken, String xeroTenantId, UUID receiptID, UUID attachmentID, String contentType) throws IOException {
        try {
            TypeReference<File> typeRef = new TypeReference<File>(){};
            HttpResponse response = this.getReceiptAttachmentByIdForHttpResponse(accessToken, xeroTenantId, receiptID, attachmentID, contentType);
            InputStream is = response.getContent();
            return this.convertInputToByteArray(is);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getReceiptAttachmentById -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getReceiptAttachmentByIdForHttpResponse(String accessToken, String xeroTenantId, UUID receiptID, UUID attachmentID, String contentType) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getReceiptAttachmentById");
        }
        if (receiptID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'receiptID' when calling getReceiptAttachmentById");
        }
        if (attachmentID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'attachmentID' when calling getReceiptAttachmentById");
        }
        if (contentType == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contentType' when calling getReceiptAttachmentById");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getReceiptAttachmentById");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("contentType", (Object)contentType);
        headers.setAccept("application/octet-stream");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("ReceiptID", receiptID);
        uriVariables.put("AttachmentID", attachmentID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Receipts/{ReceiptID}/Attachments/{AttachmentID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments getReceiptAttachments(String accessToken, String xeroTenantId, UUID receiptID) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.getReceiptAttachmentsForHttpResponse(accessToken, xeroTenantId, receiptID);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getReceiptAttachments -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getReceiptAttachmentsForHttpResponse(String accessToken, String xeroTenantId, UUID receiptID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getReceiptAttachments");
        }
        if (receiptID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'receiptID' when calling getReceiptAttachments");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getReceiptAttachments");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("ReceiptID", receiptID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Receipts/{ReceiptID}/Attachments"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public HistoryRecords getReceiptHistory(String accessToken, String xeroTenantId, UUID receiptID) throws IOException {
        try {
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            HttpResponse response = this.getReceiptHistoryForHttpResponse(accessToken, xeroTenantId, receiptID);
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getReceiptHistory -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getReceiptHistoryForHttpResponse(String accessToken, String xeroTenantId, UUID receiptID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getReceiptHistory");
        }
        if (receiptID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'receiptID' when calling getReceiptHistory");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getReceiptHistory");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("ReceiptID", receiptID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Receipts/{ReceiptID}/History"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Receipts getReceipts(String accessToken, String xeroTenantId, OffsetDateTime ifModifiedSince, String where, String order, Integer unitdp) throws IOException {
        try {
            TypeReference<Receipts> typeRef = new TypeReference<Receipts>(){};
            HttpResponse response = this.getReceiptsForHttpResponse(accessToken, xeroTenantId, ifModifiedSince, where, order, unitdp);
            return (Receipts)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getReceipts -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getReceiptsForHttpResponse(String accessToken, String xeroTenantId, OffsetDateTime ifModifiedSince, String where, String order, Integer unitdp) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        Object value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getReceipts");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getReceipts");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        if (ifModifiedSince != null) {
            headers.setIfModifiedSince(ifModifiedSince.toString());
        }
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Receipts"));
        if (where != null) {
            key = "where";
            value = where;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (order != null) {
            key = "order";
            value = order;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (unitdp != null) {
            key = "unitdp";
            value = unitdp;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public RepeatingInvoices getRepeatingInvoice(String accessToken, String xeroTenantId, UUID repeatingInvoiceID) throws IOException {
        try {
            TypeReference<RepeatingInvoices> typeRef = new TypeReference<RepeatingInvoices>(){};
            HttpResponse response = this.getRepeatingInvoiceForHttpResponse(accessToken, xeroTenantId, repeatingInvoiceID);
            return (RepeatingInvoices)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getRepeatingInvoice -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getRepeatingInvoiceForHttpResponse(String accessToken, String xeroTenantId, UUID repeatingInvoiceID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getRepeatingInvoice");
        }
        if (repeatingInvoiceID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'repeatingInvoiceID' when calling getRepeatingInvoice");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getRepeatingInvoice");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("RepeatingInvoiceID", repeatingInvoiceID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/RepeatingInvoices/{RepeatingInvoiceID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ByteArrayInputStream getRepeatingInvoiceAttachmentByFileName(String accessToken, String xeroTenantId, UUID repeatingInvoiceID, String fileName, String contentType) throws IOException {
        try {
            TypeReference<File> typeRef = new TypeReference<File>(){};
            HttpResponse response = this.getRepeatingInvoiceAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, repeatingInvoiceID, fileName, contentType);
            InputStream is = response.getContent();
            return this.convertInputToByteArray(is);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getRepeatingInvoiceAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getRepeatingInvoiceAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID repeatingInvoiceID, String fileName, String contentType) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getRepeatingInvoiceAttachmentByFileName");
        }
        if (repeatingInvoiceID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'repeatingInvoiceID' when calling getRepeatingInvoiceAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling getRepeatingInvoiceAttachmentByFileName");
        }
        if (contentType == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contentType' when calling getRepeatingInvoiceAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getRepeatingInvoiceAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("contentType", (Object)contentType);
        headers.setAccept("application/octet-stream");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("RepeatingInvoiceID", repeatingInvoiceID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/RepeatingInvoices/{RepeatingInvoiceID}/Attachments/{FileName}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ByteArrayInputStream getRepeatingInvoiceAttachmentById(String accessToken, String xeroTenantId, UUID repeatingInvoiceID, UUID attachmentID, String contentType) throws IOException {
        try {
            TypeReference<File> typeRef = new TypeReference<File>(){};
            HttpResponse response = this.getRepeatingInvoiceAttachmentByIdForHttpResponse(accessToken, xeroTenantId, repeatingInvoiceID, attachmentID, contentType);
            InputStream is = response.getContent();
            return this.convertInputToByteArray(is);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getRepeatingInvoiceAttachmentById -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getRepeatingInvoiceAttachmentByIdForHttpResponse(String accessToken, String xeroTenantId, UUID repeatingInvoiceID, UUID attachmentID, String contentType) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getRepeatingInvoiceAttachmentById");
        }
        if (repeatingInvoiceID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'repeatingInvoiceID' when calling getRepeatingInvoiceAttachmentById");
        }
        if (attachmentID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'attachmentID' when calling getRepeatingInvoiceAttachmentById");
        }
        if (contentType == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contentType' when calling getRepeatingInvoiceAttachmentById");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getRepeatingInvoiceAttachmentById");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("contentType", (Object)contentType);
        headers.setAccept("application/octet-stream");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("RepeatingInvoiceID", repeatingInvoiceID);
        uriVariables.put("AttachmentID", attachmentID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/RepeatingInvoices/{RepeatingInvoiceID}/Attachments/{AttachmentID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments getRepeatingInvoiceAttachments(String accessToken, String xeroTenantId, UUID repeatingInvoiceID) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.getRepeatingInvoiceAttachmentsForHttpResponse(accessToken, xeroTenantId, repeatingInvoiceID);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getRepeatingInvoiceAttachments -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getRepeatingInvoiceAttachmentsForHttpResponse(String accessToken, String xeroTenantId, UUID repeatingInvoiceID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getRepeatingInvoiceAttachments");
        }
        if (repeatingInvoiceID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'repeatingInvoiceID' when calling getRepeatingInvoiceAttachments");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getRepeatingInvoiceAttachments");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("RepeatingInvoiceID", repeatingInvoiceID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/RepeatingInvoices/{RepeatingInvoiceID}/Attachments"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public HistoryRecords getRepeatingInvoiceHistory(String accessToken, String xeroTenantId, UUID repeatingInvoiceID) throws IOException {
        try {
            TypeReference<HistoryRecords> typeRef = new TypeReference<HistoryRecords>(){};
            HttpResponse response = this.getRepeatingInvoiceHistoryForHttpResponse(accessToken, xeroTenantId, repeatingInvoiceID);
            return (HistoryRecords)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getRepeatingInvoiceHistory -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getRepeatingInvoiceHistoryForHttpResponse(String accessToken, String xeroTenantId, UUID repeatingInvoiceID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getRepeatingInvoiceHistory");
        }
        if (repeatingInvoiceID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'repeatingInvoiceID' when calling getRepeatingInvoiceHistory");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getRepeatingInvoiceHistory");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("RepeatingInvoiceID", repeatingInvoiceID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/RepeatingInvoices/{RepeatingInvoiceID}/History"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public RepeatingInvoices getRepeatingInvoices(String accessToken, String xeroTenantId, String where, String order) throws IOException {
        try {
            TypeReference<RepeatingInvoices> typeRef = new TypeReference<RepeatingInvoices>(){};
            HttpResponse response = this.getRepeatingInvoicesForHttpResponse(accessToken, xeroTenantId, where, order);
            return (RepeatingInvoices)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getRepeatingInvoices -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getRepeatingInvoicesForHttpResponse(String accessToken, String xeroTenantId, String where, String order) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        String value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getRepeatingInvoices");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getRepeatingInvoices");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/RepeatingInvoices"));
        if (where != null) {
            key = "where";
            value = where;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (order != null) {
            key = "order";
            value = order;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ReportWithRows getReportAgedPayablesByContact(String accessToken, String xeroTenantId, UUID contactId, LocalDate date, LocalDate fromDate, LocalDate toDate) throws IOException {
        try {
            TypeReference<ReportWithRows> typeRef = new TypeReference<ReportWithRows>(){};
            HttpResponse response = this.getReportAgedPayablesByContactForHttpResponse(accessToken, xeroTenantId, contactId, date, fromDate, toDate);
            return (ReportWithRows)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getReportAgedPayablesByContact -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getReportAgedPayablesByContactForHttpResponse(String accessToken, String xeroTenantId, UUID contactId, LocalDate date, LocalDate fromDate, LocalDate toDate) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        UUID value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getReportAgedPayablesByContact");
        }
        if (contactId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contactId' when calling getReportAgedPayablesByContact");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getReportAgedPayablesByContact");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Reports/AgedPayablesByContact"));
        if (contactId != null) {
            key = "contactId";
            value = contactId;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (date != null) {
            key = "date";
            value = date;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (fromDate != null) {
            key = "fromDate";
            value = fromDate;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (toDate != null) {
            key = "toDate";
            value = toDate;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ReportWithRows getReportAgedReceivablesByContact(String accessToken, String xeroTenantId, UUID contactId, LocalDate date, LocalDate fromDate, LocalDate toDate) throws IOException {
        try {
            TypeReference<ReportWithRows> typeRef = new TypeReference<ReportWithRows>(){};
            HttpResponse response = this.getReportAgedReceivablesByContactForHttpResponse(accessToken, xeroTenantId, contactId, date, fromDate, toDate);
            return (ReportWithRows)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getReportAgedReceivablesByContact -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getReportAgedReceivablesByContactForHttpResponse(String accessToken, String xeroTenantId, UUID contactId, LocalDate date, LocalDate fromDate, LocalDate toDate) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        UUID value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getReportAgedReceivablesByContact");
        }
        if (contactId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contactId' when calling getReportAgedReceivablesByContact");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getReportAgedReceivablesByContact");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Reports/AgedReceivablesByContact"));
        if (contactId != null) {
            key = "contactId";
            value = contactId;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (date != null) {
            key = "date";
            value = date;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (fromDate != null) {
            key = "fromDate";
            value = fromDate;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (toDate != null) {
            key = "toDate";
            value = toDate;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ReportWithRows getReportBalanceSheet(String accessToken, String xeroTenantId, LocalDate date, Integer periods, String timeframe, String trackingOptionID1, String trackingOptionID2, Boolean standardLayout, Boolean paymentsOnly) throws IOException {
        try {
            TypeReference<ReportWithRows> typeRef = new TypeReference<ReportWithRows>(){};
            HttpResponse response = this.getReportBalanceSheetForHttpResponse(accessToken, xeroTenantId, date, periods, timeframe, trackingOptionID1, trackingOptionID2, standardLayout, paymentsOnly);
            return (ReportWithRows)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getReportBalanceSheet -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getReportBalanceSheetForHttpResponse(String accessToken, String xeroTenantId, LocalDate date, Integer periods, String timeframe, String trackingOptionID1, String trackingOptionID2, Boolean standardLayout, Boolean paymentsOnly) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        Object value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getReportBalanceSheet");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getReportBalanceSheet");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Reports/BalanceSheet"));
        if (date != null) {
            key = "date";
            value = date;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (periods != null) {
            key = "periods";
            value = periods;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (timeframe != null) {
            key = "timeframe";
            value = timeframe;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (trackingOptionID1 != null) {
            key = "trackingOptionID1";
            value = trackingOptionID1;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (trackingOptionID2 != null) {
            key = "trackingOptionID2";
            value = trackingOptionID2;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (standardLayout != null) {
            key = "standardLayout";
            value = standardLayout;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (paymentsOnly != null) {
            key = "paymentsOnly";
            value = paymentsOnly;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ReportWithRows getReportBankSummary(String accessToken, String xeroTenantId, LocalDate fromDate, LocalDate toDate) throws IOException {
        try {
            TypeReference<ReportWithRows> typeRef = new TypeReference<ReportWithRows>(){};
            HttpResponse response = this.getReportBankSummaryForHttpResponse(accessToken, xeroTenantId, fromDate, toDate);
            return (ReportWithRows)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getReportBankSummary -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getReportBankSummaryForHttpResponse(String accessToken, String xeroTenantId, LocalDate fromDate, LocalDate toDate) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        LocalDate value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getReportBankSummary");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getReportBankSummary");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Reports/BankSummary"));
        if (fromDate != null) {
            key = "fromDate";
            value = fromDate;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (toDate != null) {
            key = "toDate";
            value = toDate;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ReportWithRows getReportBudgetSummary(String accessToken, String xeroTenantId, LocalDate date, Integer periods, Integer timeframe) throws IOException {
        try {
            TypeReference<ReportWithRows> typeRef = new TypeReference<ReportWithRows>(){};
            HttpResponse response = this.getReportBudgetSummaryForHttpResponse(accessToken, xeroTenantId, date, periods, timeframe);
            return (ReportWithRows)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getReportBudgetSummary -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getReportBudgetSummaryForHttpResponse(String accessToken, String xeroTenantId, LocalDate date, Integer periods, Integer timeframe) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        Object value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getReportBudgetSummary");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getReportBudgetSummary");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Reports/BudgetSummary"));
        if (date != null) {
            key = "date";
            value = date;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (periods != null) {
            key = "periods";
            value = periods;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (timeframe != null) {
            key = "timeframe";
            value = timeframe;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ReportWithRows getReportExecutiveSummary(String accessToken, String xeroTenantId, LocalDate date) throws IOException {
        try {
            TypeReference<ReportWithRows> typeRef = new TypeReference<ReportWithRows>(){};
            HttpResponse response = this.getReportExecutiveSummaryForHttpResponse(accessToken, xeroTenantId, date);
            return (ReportWithRows)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getReportExecutiveSummary -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getReportExecutiveSummaryForHttpResponse(String accessToken, String xeroTenantId, LocalDate date) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getReportExecutiveSummary");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getReportExecutiveSummary");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Reports/ExecutiveSummary"));
        if (date != null) {
            String key = "date";
            LocalDate value = date;
            if (value instanceof Collection) {
                ArrayList valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ReportWithRows getReportFromId(String accessToken, String xeroTenantId, String reportID) throws IOException {
        try {
            TypeReference<ReportWithRows> typeRef = new TypeReference<ReportWithRows>(){};
            HttpResponse response = this.getReportFromIdForHttpResponse(accessToken, xeroTenantId, reportID);
            return (ReportWithRows)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getReportFromId -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getReportFromIdForHttpResponse(String accessToken, String xeroTenantId, String reportID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getReportFromId");
        }
        if (reportID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'reportID' when calling getReportFromId");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getReportFromId");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("ReportID", reportID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Reports/{ReportID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ReportWithRows getReportProfitAndLoss(String accessToken, String xeroTenantId, LocalDate fromDate, LocalDate toDate, Integer periods, String timeframe, String trackingCategoryID, String trackingCategoryID2, String trackingOptionID, String trackingOptionID2, Boolean standardLayout, Boolean paymentsOnly) throws IOException {
        try {
            TypeReference<ReportWithRows> typeRef = new TypeReference<ReportWithRows>(){};
            HttpResponse response = this.getReportProfitAndLossForHttpResponse(accessToken, xeroTenantId, fromDate, toDate, periods, timeframe, trackingCategoryID, trackingCategoryID2, trackingOptionID, trackingOptionID2, standardLayout, paymentsOnly);
            return (ReportWithRows)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getReportProfitAndLoss -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getReportProfitAndLossForHttpResponse(String accessToken, String xeroTenantId, LocalDate fromDate, LocalDate toDate, Integer periods, String timeframe, String trackingCategoryID, String trackingCategoryID2, String trackingOptionID, String trackingOptionID2, Boolean standardLayout, Boolean paymentsOnly) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        Object value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getReportProfitAndLoss");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getReportProfitAndLoss");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Reports/ProfitAndLoss"));
        if (fromDate != null) {
            key = "fromDate";
            value = fromDate;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (toDate != null) {
            key = "toDate";
            value = toDate;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (periods != null) {
            key = "periods";
            value = periods;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (timeframe != null) {
            key = "timeframe";
            value = timeframe;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (trackingCategoryID != null) {
            key = "trackingCategoryID";
            value = trackingCategoryID;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (trackingCategoryID2 != null) {
            key = "trackingCategoryID2";
            value = trackingCategoryID2;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (trackingOptionID != null) {
            key = "trackingOptionID";
            value = trackingOptionID;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (trackingOptionID2 != null) {
            key = "trackingOptionID2";
            value = trackingOptionID2;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (standardLayout != null) {
            key = "standardLayout";
            value = standardLayout;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (paymentsOnly != null) {
            key = "paymentsOnly";
            value = paymentsOnly;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Reports getReportTenNinetyNine(String accessToken, String xeroTenantId, String reportYear) throws IOException {
        try {
            TypeReference<Reports> typeRef = new TypeReference<Reports>(){};
            HttpResponse response = this.getReportTenNinetyNineForHttpResponse(accessToken, xeroTenantId, reportYear);
            return (Reports)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getReportTenNinetyNine -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getReportTenNinetyNineForHttpResponse(String accessToken, String xeroTenantId, String reportYear) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getReportTenNinetyNine");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getReportTenNinetyNine");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Reports/TenNinetyNine"));
        if (reportYear != null) {
            String key = "reportYear";
            String value = reportYear;
            if (value instanceof Collection) {
                ArrayList valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ReportWithRows getReportTrialBalance(String accessToken, String xeroTenantId, LocalDate date, Boolean paymentsOnly) throws IOException {
        try {
            TypeReference<ReportWithRows> typeRef = new TypeReference<ReportWithRows>(){};
            HttpResponse response = this.getReportTrialBalanceForHttpResponse(accessToken, xeroTenantId, date, paymentsOnly);
            return (ReportWithRows)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getReportTrialBalance -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getReportTrialBalanceForHttpResponse(String accessToken, String xeroTenantId, LocalDate date, Boolean paymentsOnly) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        Object value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getReportTrialBalance");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getReportTrialBalance");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Reports/TrialBalance"));
        if (date != null) {
            key = "date";
            value = date;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (paymentsOnly != null) {
            key = "paymentsOnly";
            value = paymentsOnly;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ReportWithRows getReportsList(String accessToken, String xeroTenantId) throws IOException {
        try {
            TypeReference<ReportWithRows> typeRef = new TypeReference<ReportWithRows>(){};
            HttpResponse response = this.getReportsListForHttpResponse(accessToken, xeroTenantId);
            return (ReportWithRows)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getReportsList -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getReportsListForHttpResponse(String accessToken, String xeroTenantId) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getReportsList");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getReportsList");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Reports"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public TaxRates getTaxRateByTaxType(String accessToken, String xeroTenantId, String taxType) throws IOException {
        try {
            TypeReference<TaxRates> typeRef = new TypeReference<TaxRates>(){};
            HttpResponse response = this.getTaxRateByTaxTypeForHttpResponse(accessToken, xeroTenantId, taxType);
            return (TaxRates)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getTaxRateByTaxType -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getTaxRateByTaxTypeForHttpResponse(String accessToken, String xeroTenantId, String taxType) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getTaxRateByTaxType");
        }
        if (taxType == null) {
            throw new IllegalArgumentException("Missing the required parameter 'taxType' when calling getTaxRateByTaxType");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getTaxRateByTaxType");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("TaxType", taxType);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/TaxRates/{TaxType}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public TaxRates getTaxRates(String accessToken, String xeroTenantId, String where, String order) throws IOException {
        try {
            TypeReference<TaxRates> typeRef = new TypeReference<TaxRates>(){};
            HttpResponse response = this.getTaxRatesForHttpResponse(accessToken, xeroTenantId, where, order);
            return (TaxRates)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getTaxRates -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getTaxRatesForHttpResponse(String accessToken, String xeroTenantId, String where, String order) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        String value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getTaxRates");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getTaxRates");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/TaxRates"));
        if (where != null) {
            key = "where";
            value = where;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (order != null) {
            key = "order";
            value = order;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public TrackingCategories getTrackingCategories(String accessToken, String xeroTenantId, String where, String order, Boolean includeArchived) throws IOException {
        try {
            TypeReference<TrackingCategories> typeRef = new TypeReference<TrackingCategories>(){};
            HttpResponse response = this.getTrackingCategoriesForHttpResponse(accessToken, xeroTenantId, where, order, includeArchived);
            return (TrackingCategories)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getTrackingCategories -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getTrackingCategoriesForHttpResponse(String accessToken, String xeroTenantId, String where, String order, Boolean includeArchived) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        Object value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getTrackingCategories");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getTrackingCategories");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/TrackingCategories"));
        if (where != null) {
            key = "where";
            value = where;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (order != null) {
            key = "order";
            value = order;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (includeArchived != null) {
            key = "includeArchived";
            value = includeArchived;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public TrackingCategories getTrackingCategory(String accessToken, String xeroTenantId, UUID trackingCategoryID) throws IOException {
        try {
            TypeReference<TrackingCategories> typeRef = new TypeReference<TrackingCategories>(){};
            HttpResponse response = this.getTrackingCategoryForHttpResponse(accessToken, xeroTenantId, trackingCategoryID);
            return (TrackingCategories)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getTrackingCategory -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getTrackingCategoryForHttpResponse(String accessToken, String xeroTenantId, UUID trackingCategoryID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getTrackingCategory");
        }
        if (trackingCategoryID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'trackingCategoryID' when calling getTrackingCategory");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getTrackingCategory");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("TrackingCategoryID", trackingCategoryID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/TrackingCategories/{TrackingCategoryID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Users getUser(String accessToken, String xeroTenantId, UUID userID) throws IOException {
        try {
            TypeReference<Users> typeRef = new TypeReference<Users>(){};
            HttpResponse response = this.getUserForHttpResponse(accessToken, xeroTenantId, userID);
            return (Users)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getUser -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getUserForHttpResponse(String accessToken, String xeroTenantId, UUID userID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getUser");
        }
        if (userID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'userID' when calling getUser");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getUser");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("UserID", userID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Users/{UserID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Users getUsers(String accessToken, String xeroTenantId, OffsetDateTime ifModifiedSince, String where, String order) throws IOException {
        try {
            TypeReference<Users> typeRef = new TypeReference<Users>(){};
            HttpResponse response = this.getUsersForHttpResponse(accessToken, xeroTenantId, ifModifiedSince, where, order);
            return (Users)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getUsers -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getUsersForHttpResponse(String accessToken, String xeroTenantId, OffsetDateTime ifModifiedSince, String where, String order) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        String value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getUsers");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getUsers");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        if (ifModifiedSince != null) {
            headers.setIfModifiedSince(ifModifiedSince.toString());
        }
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Users"));
        if (where != null) {
            key = "where";
            value = where;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (order != null) {
            key = "order";
            value = order;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ImportSummaryObject postSetup(String accessToken, String xeroTenantId, Setup setup, String idempotencyKey) throws IOException {
        try {
            TypeReference<ImportSummaryObject> typeRef = new TypeReference<ImportSummaryObject>(){};
            HttpResponse response = this.postSetupForHttpResponse(accessToken, xeroTenantId, setup, idempotencyKey);
            return (ImportSummaryObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : postSetup -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse postSetupForHttpResponse(String accessToken, String xeroTenantId, Setup setup, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling postSetup");
        }
        if (setup == null) {
            throw new IllegalArgumentException("Missing the required parameter 'setup' when calling postSetup");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling postSetup");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Setup"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(setup);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Accounts updateAccount(String accessToken, String xeroTenantId, UUID accountID, Accounts accounts, String idempotencyKey) throws IOException {
        try {
            TypeReference<Accounts> typeRef = new TypeReference<Accounts>(){};
            HttpResponse response = this.updateAccountForHttpResponse(accessToken, xeroTenantId, accountID, accounts, idempotencyKey);
            return (Accounts)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updateAccount -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("Accounts", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("Accounts", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse updateAccountForHttpResponse(String accessToken, String xeroTenantId, UUID accountID, Accounts accounts, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updateAccount");
        }
        if (accountID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accountID' when calling updateAccount");
        }
        if (accounts == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accounts' when calling updateAccount");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updateAccount");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("AccountID", accountID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Accounts/{AccountID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(accounts);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments updateAccountAttachmentByFileName(String accessToken, String xeroTenantId, UUID accountID, String fileName, byte[] body, String idempotencyKey, String mimeType) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.updateAccountAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, accountID, fileName, body, idempotencyKey, mimeType);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updateAccountAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse updateAccountAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID accountID, String fileName, byte[] body, String idempotencyKey, String mimeType) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updateAccountAttachmentByFileName");
        }
        if (accountID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accountID' when calling updateAccountAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling updateAccountAttachmentByFileName");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling updateAccountAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updateAccountAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("AccountID", accountID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Accounts/{AccountID}/Attachments/{FileName}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ByteArrayContent content = null;
        content = new ByteArrayContent(mimeType, body);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments updateAccountAttachmentByFileName(String accessToken, String xeroTenantId, UUID accountID, String fileName, File body, String idempotencyKey) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.updateAccountAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, accountID, fileName, body, idempotencyKey);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updateAccountAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("Attachments", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("Attachments", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse updateAccountAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID accountID, String fileName, File body, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updateAccountAttachmentByFileName");
        }
        if (accountID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accountID' when calling updateAccountAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling updateAccountAttachmentByFileName");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling updateAccountAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updateAccountAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("AccountID", accountID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Accounts/{AccountID}/Attachments/{FileName}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        Path bodyPath = body.toPath();
        String mimeType = Files.probeContentType(bodyPath);
        FileContent content = null;
        content = new FileContent(mimeType, body);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public BankTransactions updateBankTransaction(String accessToken, String xeroTenantId, UUID bankTransactionID, BankTransactions bankTransactions, Integer unitdp, String idempotencyKey) throws IOException {
        try {
            TypeReference<BankTransactions> typeRef = new TypeReference<BankTransactions>(){};
            HttpResponse response = this.updateBankTransactionForHttpResponse(accessToken, xeroTenantId, bankTransactionID, bankTransactions, unitdp, idempotencyKey);
            return (BankTransactions)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updateBankTransaction -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("BankTransactions", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("BankTransactions", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse updateBankTransactionForHttpResponse(String accessToken, String xeroTenantId, UUID bankTransactionID, BankTransactions bankTransactions, Integer unitdp, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updateBankTransaction");
        }
        if (bankTransactionID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'bankTransactionID' when calling updateBankTransaction");
        }
        if (bankTransactions == null) {
            throw new IllegalArgumentException("Missing the required parameter 'bankTransactions' when calling updateBankTransaction");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updateBankTransaction");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("BankTransactionID", bankTransactionID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/BankTransactions/{BankTransactionID}"));
        if (unitdp != null) {
            String key = "unitdp";
            Integer value = unitdp;
            if (value instanceof Collection) {
                ArrayList valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(bankTransactions);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments updateBankTransactionAttachmentByFileName(String accessToken, String xeroTenantId, UUID bankTransactionID, String fileName, byte[] body, String idempotencyKey, String mimeType) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.updateBankTransactionAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, bankTransactionID, fileName, body, idempotencyKey, mimeType);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updateBankTransactionAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse updateBankTransactionAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID bankTransactionID, String fileName, byte[] body, String idempotencyKey, String mimeType) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updateBankTransactionAttachmentByFileName");
        }
        if (bankTransactionID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'bankTransactionID' when calling updateBankTransactionAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling updateBankTransactionAttachmentByFileName");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling updateBankTransactionAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updateBankTransactionAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("BankTransactionID", bankTransactionID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/BankTransactions/{BankTransactionID}/Attachments/{FileName}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ByteArrayContent content = null;
        content = new ByteArrayContent(mimeType, body);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments updateBankTransactionAttachmentByFileName(String accessToken, String xeroTenantId, UUID bankTransactionID, String fileName, File body, String idempotencyKey) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.updateBankTransactionAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, bankTransactionID, fileName, body, idempotencyKey);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updateBankTransactionAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("Attachments", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("Attachments", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse updateBankTransactionAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID bankTransactionID, String fileName, File body, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updateBankTransactionAttachmentByFileName");
        }
        if (bankTransactionID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'bankTransactionID' when calling updateBankTransactionAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling updateBankTransactionAttachmentByFileName");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling updateBankTransactionAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updateBankTransactionAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("BankTransactionID", bankTransactionID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/BankTransactions/{BankTransactionID}/Attachments/{FileName}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        Path bodyPath = body.toPath();
        String mimeType = Files.probeContentType(bodyPath);
        FileContent content = null;
        content = new FileContent(mimeType, body);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments updateBankTransferAttachmentByFileName(String accessToken, String xeroTenantId, UUID bankTransferID, String fileName, byte[] body, String idempotencyKey, String mimeType) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.updateBankTransferAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, bankTransferID, fileName, body, idempotencyKey, mimeType);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updateBankTransferAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse updateBankTransferAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID bankTransferID, String fileName, byte[] body, String idempotencyKey, String mimeType) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updateBankTransferAttachmentByFileName");
        }
        if (bankTransferID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'bankTransferID' when calling updateBankTransferAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling updateBankTransferAttachmentByFileName");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling updateBankTransferAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updateBankTransferAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("BankTransferID", bankTransferID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/BankTransfers/{BankTransferID}/Attachments/{FileName}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ByteArrayContent content = null;
        content = new ByteArrayContent(mimeType, body);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments updateBankTransferAttachmentByFileName(String accessToken, String xeroTenantId, UUID bankTransferID, String fileName, File body, String idempotencyKey) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.updateBankTransferAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, bankTransferID, fileName, body, idempotencyKey);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updateBankTransferAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("Attachments", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("Attachments", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse updateBankTransferAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID bankTransferID, String fileName, File body, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updateBankTransferAttachmentByFileName");
        }
        if (bankTransferID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'bankTransferID' when calling updateBankTransferAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling updateBankTransferAttachmentByFileName");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling updateBankTransferAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updateBankTransferAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("BankTransferID", bankTransferID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/BankTransfers/{BankTransferID}/Attachments/{FileName}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        Path bodyPath = body.toPath();
        String mimeType = Files.probeContentType(bodyPath);
        FileContent content = null;
        content = new FileContent(mimeType, body);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Contacts updateContact(String accessToken, String xeroTenantId, UUID contactID, Contacts contacts, String idempotencyKey) throws IOException {
        try {
            TypeReference<Contacts> typeRef = new TypeReference<Contacts>(){};
            HttpResponse response = this.updateContactForHttpResponse(accessToken, xeroTenantId, contactID, contacts, idempotencyKey);
            return (Contacts)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updateContact -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("Contacts", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("Contacts", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse updateContactForHttpResponse(String accessToken, String xeroTenantId, UUID contactID, Contacts contacts, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updateContact");
        }
        if (contactID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contactID' when calling updateContact");
        }
        if (contacts == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contacts' when calling updateContact");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updateContact");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("ContactID", contactID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Contacts/{ContactID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(contacts);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments updateContactAttachmentByFileName(String accessToken, String xeroTenantId, UUID contactID, String fileName, byte[] body, String idempotencyKey, String mimeType) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.updateContactAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, contactID, fileName, body, idempotencyKey, mimeType);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updateContactAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse updateContactAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID contactID, String fileName, byte[] body, String idempotencyKey, String mimeType) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updateContactAttachmentByFileName");
        }
        if (contactID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contactID' when calling updateContactAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling updateContactAttachmentByFileName");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling updateContactAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updateContactAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("ContactID", contactID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Contacts/{ContactID}/Attachments/{FileName}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ByteArrayContent content = null;
        content = new ByteArrayContent(mimeType, body);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments updateContactAttachmentByFileName(String accessToken, String xeroTenantId, UUID contactID, String fileName, File body, String idempotencyKey) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.updateContactAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, contactID, fileName, body, idempotencyKey);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updateContactAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("Attachments", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("Attachments", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse updateContactAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID contactID, String fileName, File body, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updateContactAttachmentByFileName");
        }
        if (contactID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contactID' when calling updateContactAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling updateContactAttachmentByFileName");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling updateContactAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updateContactAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("ContactID", contactID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Contacts/{ContactID}/Attachments/{FileName}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        Path bodyPath = body.toPath();
        String mimeType = Files.probeContentType(bodyPath);
        FileContent content = null;
        content = new FileContent(mimeType, body);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ContactGroups updateContactGroup(String accessToken, String xeroTenantId, UUID contactGroupID, ContactGroups contactGroups, String idempotencyKey) throws IOException {
        try {
            TypeReference<ContactGroups> typeRef = new TypeReference<ContactGroups>(){};
            HttpResponse response = this.updateContactGroupForHttpResponse(accessToken, xeroTenantId, contactGroupID, contactGroups, idempotencyKey);
            return (ContactGroups)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updateContactGroup -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("ContactGroups", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("ContactGroups", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse updateContactGroupForHttpResponse(String accessToken, String xeroTenantId, UUID contactGroupID, ContactGroups contactGroups, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updateContactGroup");
        }
        if (contactGroupID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contactGroupID' when calling updateContactGroup");
        }
        if (contactGroups == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contactGroups' when calling updateContactGroup");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updateContactGroup");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("ContactGroupID", contactGroupID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/ContactGroups/{ContactGroupID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(contactGroups);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public CreditNotes updateCreditNote(String accessToken, String xeroTenantId, UUID creditNoteID, CreditNotes creditNotes, Integer unitdp, String idempotencyKey) throws IOException {
        try {
            TypeReference<CreditNotes> typeRef = new TypeReference<CreditNotes>(){};
            HttpResponse response = this.updateCreditNoteForHttpResponse(accessToken, xeroTenantId, creditNoteID, creditNotes, unitdp, idempotencyKey);
            return (CreditNotes)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updateCreditNote -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("CreditNotes", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("CreditNotes", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse updateCreditNoteForHttpResponse(String accessToken, String xeroTenantId, UUID creditNoteID, CreditNotes creditNotes, Integer unitdp, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updateCreditNote");
        }
        if (creditNoteID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'creditNoteID' when calling updateCreditNote");
        }
        if (creditNotes == null) {
            throw new IllegalArgumentException("Missing the required parameter 'creditNotes' when calling updateCreditNote");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updateCreditNote");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("CreditNoteID", creditNoteID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/CreditNotes/{CreditNoteID}"));
        if (unitdp != null) {
            String key = "unitdp";
            Integer value = unitdp;
            if (value instanceof Collection) {
                ArrayList valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(creditNotes);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments updateCreditNoteAttachmentByFileName(String accessToken, String xeroTenantId, UUID creditNoteID, String fileName, byte[] body, String idempotencyKey, String mimeType) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.updateCreditNoteAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, creditNoteID, fileName, body, idempotencyKey, mimeType);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updateCreditNoteAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse updateCreditNoteAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID creditNoteID, String fileName, byte[] body, String idempotencyKey, String mimeType) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updateCreditNoteAttachmentByFileName");
        }
        if (creditNoteID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'creditNoteID' when calling updateCreditNoteAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling updateCreditNoteAttachmentByFileName");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling updateCreditNoteAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updateCreditNoteAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("CreditNoteID", creditNoteID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/CreditNotes/{CreditNoteID}/Attachments/{FileName}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ByteArrayContent content = null;
        content = new ByteArrayContent(mimeType, body);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments updateCreditNoteAttachmentByFileName(String accessToken, String xeroTenantId, UUID creditNoteID, String fileName, File body, String idempotencyKey) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.updateCreditNoteAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, creditNoteID, fileName, body, idempotencyKey);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updateCreditNoteAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("Attachments", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("Attachments", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse updateCreditNoteAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID creditNoteID, String fileName, File body, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updateCreditNoteAttachmentByFileName");
        }
        if (creditNoteID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'creditNoteID' when calling updateCreditNoteAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling updateCreditNoteAttachmentByFileName");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling updateCreditNoteAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updateCreditNoteAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("CreditNoteID", creditNoteID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/CreditNotes/{CreditNoteID}/Attachments/{FileName}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        Path bodyPath = body.toPath();
        String mimeType = Files.probeContentType(bodyPath);
        FileContent content = null;
        content = new FileContent(mimeType, body);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ExpenseClaims updateExpenseClaim(String accessToken, String xeroTenantId, UUID expenseClaimID, ExpenseClaims expenseClaims, String idempotencyKey) throws IOException {
        try {
            TypeReference<ExpenseClaims> typeRef = new TypeReference<ExpenseClaims>(){};
            HttpResponse response = this.updateExpenseClaimForHttpResponse(accessToken, xeroTenantId, expenseClaimID, expenseClaims, idempotencyKey);
            return (ExpenseClaims)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updateExpenseClaim -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("ExpenseClaims", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("ExpenseClaims", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse updateExpenseClaimForHttpResponse(String accessToken, String xeroTenantId, UUID expenseClaimID, ExpenseClaims expenseClaims, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updateExpenseClaim");
        }
        if (expenseClaimID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'expenseClaimID' when calling updateExpenseClaim");
        }
        if (expenseClaims == null) {
            throw new IllegalArgumentException("Missing the required parameter 'expenseClaims' when calling updateExpenseClaim");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updateExpenseClaim");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("ExpenseClaimID", expenseClaimID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/ExpenseClaims/{ExpenseClaimID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(expenseClaims);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Invoices updateInvoice(String accessToken, String xeroTenantId, UUID invoiceID, Invoices invoices, Integer unitdp, String idempotencyKey) throws IOException {
        try {
            TypeReference<Invoices> typeRef = new TypeReference<Invoices>(){};
            HttpResponse response = this.updateInvoiceForHttpResponse(accessToken, xeroTenantId, invoiceID, invoices, unitdp, idempotencyKey);
            return (Invoices)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updateInvoice -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("Invoices", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("Invoices", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse updateInvoiceForHttpResponse(String accessToken, String xeroTenantId, UUID invoiceID, Invoices invoices, Integer unitdp, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updateInvoice");
        }
        if (invoiceID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'invoiceID' when calling updateInvoice");
        }
        if (invoices == null) {
            throw new IllegalArgumentException("Missing the required parameter 'invoices' when calling updateInvoice");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updateInvoice");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("InvoiceID", invoiceID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Invoices/{InvoiceID}"));
        if (unitdp != null) {
            String key = "unitdp";
            Integer value = unitdp;
            if (value instanceof Collection) {
                ArrayList valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(invoices);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments updateInvoiceAttachmentByFileName(String accessToken, String xeroTenantId, UUID invoiceID, String fileName, byte[] body, String idempotencyKey, String mimeType) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.updateInvoiceAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, invoiceID, fileName, body, idempotencyKey, mimeType);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updateInvoiceAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse updateInvoiceAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID invoiceID, String fileName, byte[] body, String idempotencyKey, String mimeType) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updateInvoiceAttachmentByFileName");
        }
        if (invoiceID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'invoiceID' when calling updateInvoiceAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling updateInvoiceAttachmentByFileName");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling updateInvoiceAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updateInvoiceAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("InvoiceID", invoiceID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Invoices/{InvoiceID}/Attachments/{FileName}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ByteArrayContent content = null;
        content = new ByteArrayContent(mimeType, body);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments updateInvoiceAttachmentByFileName(String accessToken, String xeroTenantId, UUID invoiceID, String fileName, File body, String idempotencyKey) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.updateInvoiceAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, invoiceID, fileName, body, idempotencyKey);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updateInvoiceAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("Attachments", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("Attachments", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse updateInvoiceAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID invoiceID, String fileName, File body, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updateInvoiceAttachmentByFileName");
        }
        if (invoiceID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'invoiceID' when calling updateInvoiceAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling updateInvoiceAttachmentByFileName");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling updateInvoiceAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updateInvoiceAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("InvoiceID", invoiceID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Invoices/{InvoiceID}/Attachments/{FileName}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        Path bodyPath = body.toPath();
        String mimeType = Files.probeContentType(bodyPath);
        FileContent content = null;
        content = new FileContent(mimeType, body);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Items updateItem(String accessToken, String xeroTenantId, UUID itemID, Items items, Integer unitdp, String idempotencyKey) throws IOException {
        try {
            TypeReference<Items> typeRef = new TypeReference<Items>(){};
            HttpResponse response = this.updateItemForHttpResponse(accessToken, xeroTenantId, itemID, items, unitdp, idempotencyKey);
            return (Items)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updateItem -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("Items", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("Items", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse updateItemForHttpResponse(String accessToken, String xeroTenantId, UUID itemID, Items items, Integer unitdp, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updateItem");
        }
        if (itemID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'itemID' when calling updateItem");
        }
        if (items == null) {
            throw new IllegalArgumentException("Missing the required parameter 'items' when calling updateItem");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updateItem");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("ItemID", itemID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Items/{ItemID}"));
        if (unitdp != null) {
            String key = "unitdp";
            Integer value = unitdp;
            if (value instanceof Collection) {
                ArrayList valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(items);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public LinkedTransactions updateLinkedTransaction(String accessToken, String xeroTenantId, UUID linkedTransactionID, LinkedTransactions linkedTransactions, String idempotencyKey) throws IOException {
        try {
            TypeReference<LinkedTransactions> typeRef = new TypeReference<LinkedTransactions>(){};
            HttpResponse response = this.updateLinkedTransactionForHttpResponse(accessToken, xeroTenantId, linkedTransactionID, linkedTransactions, idempotencyKey);
            return (LinkedTransactions)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updateLinkedTransaction -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("LinkedTransactions", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("LinkedTransactions", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse updateLinkedTransactionForHttpResponse(String accessToken, String xeroTenantId, UUID linkedTransactionID, LinkedTransactions linkedTransactions, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updateLinkedTransaction");
        }
        if (linkedTransactionID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'linkedTransactionID' when calling updateLinkedTransaction");
        }
        if (linkedTransactions == null) {
            throw new IllegalArgumentException("Missing the required parameter 'linkedTransactions' when calling updateLinkedTransaction");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updateLinkedTransaction");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("LinkedTransactionID", linkedTransactionID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/LinkedTransactions/{LinkedTransactionID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(linkedTransactions);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ManualJournals updateManualJournal(String accessToken, String xeroTenantId, UUID manualJournalID, ManualJournals manualJournals, String idempotencyKey) throws IOException {
        try {
            TypeReference<ManualJournals> typeRef = new TypeReference<ManualJournals>(){};
            HttpResponse response = this.updateManualJournalForHttpResponse(accessToken, xeroTenantId, manualJournalID, manualJournals, idempotencyKey);
            return (ManualJournals)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updateManualJournal -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("ManualJournals", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("ManualJournals", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse updateManualJournalForHttpResponse(String accessToken, String xeroTenantId, UUID manualJournalID, ManualJournals manualJournals, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updateManualJournal");
        }
        if (manualJournalID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'manualJournalID' when calling updateManualJournal");
        }
        if (manualJournals == null) {
            throw new IllegalArgumentException("Missing the required parameter 'manualJournals' when calling updateManualJournal");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updateManualJournal");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("ManualJournalID", manualJournalID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/ManualJournals/{ManualJournalID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(manualJournals);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments updateManualJournalAttachmentByFileName(String accessToken, String xeroTenantId, UUID manualJournalID, String fileName, byte[] body, String idempotencyKey, String mimeType) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.updateManualJournalAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, manualJournalID, fileName, body, idempotencyKey, mimeType);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updateManualJournalAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse updateManualJournalAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID manualJournalID, String fileName, byte[] body, String idempotencyKey, String mimeType) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updateManualJournalAttachmentByFileName");
        }
        if (manualJournalID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'manualJournalID' when calling updateManualJournalAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling updateManualJournalAttachmentByFileName");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling updateManualJournalAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updateManualJournalAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("ManualJournalID", manualJournalID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/ManualJournals/{ManualJournalID}/Attachments/{FileName}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ByteArrayContent content = null;
        content = new ByteArrayContent(mimeType, body);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Attachments updateManualJournalAttachmentByFileName(String accessToken, String xeroTenantId, UUID manualJournalID, String fileName, File body, String idempotencyKey) throws IOException {
        try {
            TypeReference<Attachments> typeRef = new TypeReference<Attachments>(){};
            HttpResponse response = this.updateManualJournalAttachmentByFileNameForHttpResponse(accessToken, xeroTenantId, manualJournalID, fileName, body, idempotencyKey);
            return (Attachments)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updateManualJournalAttachmentByFileName -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("Attachments", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("Attachments", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse updateManualJournalAttachmentByFileNameForHttpResponse(String accessToken, String xeroTenantId, UUID manualJournalID, String fileName, File body, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updateManualJournalAttachmentByFileName");
        }
        if (manualJournalID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'manualJournalID' when calling updateManualJournalAttachmentByFileName");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileName' when calling updateManualJournalAttachmentByFileName");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling updateManualJournalAttachmentByFileName");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updateManualJournalAttachmentByFileName");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("ManualJournalID", manualJournalID);
        uriVariables.put("FileName", fileName);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/ManualJournals/{ManualJournalID}/Attachments/{FileName}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        Path bodyPath = body.toPath();
        String mimeType = Files.probeContentType(bodyPath);
        FileContent content = null;
        content = new FileContent(mimeType, body);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public BankTransactions updateOrCreateBankTransactions(String accessToken, String xeroTenantId, BankTransactions bankTransactions, Boolean summarizeErrors, Integer unitdp, String idempotencyKey) throws IOException {
        try {
            TypeReference<BankTransactions> typeRef = new TypeReference<BankTransactions>(){};
            HttpResponse response = this.updateOrCreateBankTransactionsForHttpResponse(accessToken, xeroTenantId, bankTransactions, summarizeErrors, unitdp, idempotencyKey);
            return (BankTransactions)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updateOrCreateBankTransactions -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("BankTransactions", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("BankTransactions", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse updateOrCreateBankTransactionsForHttpResponse(String accessToken, String xeroTenantId, BankTransactions bankTransactions, Boolean summarizeErrors, Integer unitdp, String idempotencyKey) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        Comparable<Boolean> value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updateOrCreateBankTransactions");
        }
        if (bankTransactions == null) {
            throw new IllegalArgumentException("Missing the required parameter 'bankTransactions' when calling updateOrCreateBankTransactions");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updateOrCreateBankTransactions");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/BankTransactions"));
        if (summarizeErrors != null) {
            key = "summarizeErrors";
            value = summarizeErrors;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (unitdp != null) {
            key = "unitdp";
            value = unitdp;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(bankTransactions);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Contacts updateOrCreateContacts(String accessToken, String xeroTenantId, Contacts contacts, Boolean summarizeErrors, String idempotencyKey) throws IOException {
        try {
            TypeReference<Contacts> typeRef = new TypeReference<Contacts>(){};
            HttpResponse response = this.updateOrCreateContactsForHttpResponse(accessToken, xeroTenantId, contacts, summarizeErrors, idempotencyKey);
            return (Contacts)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updateOrCreateContacts -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("Contacts", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("Contacts", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse updateOrCreateContactsForHttpResponse(String accessToken, String xeroTenantId, Contacts contacts, Boolean summarizeErrors, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updateOrCreateContacts");
        }
        if (contacts == null) {
            throw new IllegalArgumentException("Missing the required parameter 'contacts' when calling updateOrCreateContacts");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updateOrCreateContacts");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Contacts"));
        if (summarizeErrors != null) {
            String key = "summarizeErrors";
            Boolean value = summarizeErrors;
            if (value instanceof Collection) {
                ArrayList valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(contacts);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public CreditNotes updateOrCreateCreditNotes(String accessToken, String xeroTenantId, CreditNotes creditNotes, Boolean summarizeErrors, Integer unitdp, String idempotencyKey) throws IOException {
        try {
            TypeReference<CreditNotes> typeRef = new TypeReference<CreditNotes>(){};
            HttpResponse response = this.updateOrCreateCreditNotesForHttpResponse(accessToken, xeroTenantId, creditNotes, summarizeErrors, unitdp, idempotencyKey);
            return (CreditNotes)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updateOrCreateCreditNotes -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("CreditNotes", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("CreditNotes", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse updateOrCreateCreditNotesForHttpResponse(String accessToken, String xeroTenantId, CreditNotes creditNotes, Boolean summarizeErrors, Integer unitdp, String idempotencyKey) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        Comparable<Boolean> value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updateOrCreateCreditNotes");
        }
        if (creditNotes == null) {
            throw new IllegalArgumentException("Missing the required parameter 'creditNotes' when calling updateOrCreateCreditNotes");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updateOrCreateCreditNotes");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/CreditNotes"));
        if (summarizeErrors != null) {
            key = "summarizeErrors";
            value = summarizeErrors;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (unitdp != null) {
            key = "unitdp";
            value = unitdp;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(creditNotes);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Employees updateOrCreateEmployees(String accessToken, String xeroTenantId, Employees employees, Boolean summarizeErrors, String idempotencyKey) throws IOException {
        try {
            TypeReference<Employees> typeRef = new TypeReference<Employees>(){};
            HttpResponse response = this.updateOrCreateEmployeesForHttpResponse(accessToken, xeroTenantId, employees, summarizeErrors, idempotencyKey);
            return (Employees)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updateOrCreateEmployees -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("Employees", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("Employees", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse updateOrCreateEmployeesForHttpResponse(String accessToken, String xeroTenantId, Employees employees, Boolean summarizeErrors, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updateOrCreateEmployees");
        }
        if (employees == null) {
            throw new IllegalArgumentException("Missing the required parameter 'employees' when calling updateOrCreateEmployees");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updateOrCreateEmployees");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Employees"));
        if (summarizeErrors != null) {
            String key = "summarizeErrors";
            Boolean value = summarizeErrors;
            if (value instanceof Collection) {
                ArrayList valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(employees);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Invoices updateOrCreateInvoices(String accessToken, String xeroTenantId, Invoices invoices, Boolean summarizeErrors, Integer unitdp, String idempotencyKey) throws IOException {
        try {
            TypeReference<Invoices> typeRef = new TypeReference<Invoices>(){};
            HttpResponse response = this.updateOrCreateInvoicesForHttpResponse(accessToken, xeroTenantId, invoices, summarizeErrors, unitdp, idempotencyKey);
            return (Invoices)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updateOrCreateInvoices -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("Invoices", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("Invoices", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse updateOrCreateInvoicesForHttpResponse(String accessToken, String xeroTenantId, Invoices invoices, Boolean summarizeErrors, Integer unitdp, String idempotencyKey) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        Comparable<Boolean> value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updateOrCreateInvoices");
        }
        if (invoices == null) {
            throw new IllegalArgumentException("Missing the required parameter 'invoices' when calling updateOrCreateInvoices");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updateOrCreateInvoices");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Invoices"));
        if (summarizeErrors != null) {
            key = "summarizeErrors";
            value = summarizeErrors;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (unitdp != null) {
            key = "unitdp";
            value = unitdp;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(invoices);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Items updateOrCreateItems(String accessToken, String xeroTenantId, Items items, Boolean summarizeErrors, Integer unitdp, String idempotencyKey) throws IOException {
        try {
            TypeReference<Items> typeRef = new TypeReference<Items>(){};
            HttpResponse response = this.updateOrCreateItemsForHttpResponse(accessToken, xeroTenantId, items, summarizeErrors, unitdp, idempotencyKey);
            return (Items)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updateOrCreateItems -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error object = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                if (object.getElements() == null || object.getElements().isEmpty()) {
                    handler.validationError("Items", object.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("Items", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse updateOrCreateItemsForHttpResponse(String accessToken, String xeroTenantId, Items items, Boolean summarizeErrors, Integer unitdp, String idempotencyKey) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        Comparable<Boolean> value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updateOrCreateItems");
        }
        if (items == null) {
            throw new IllegalArgumentException("Missing the required parameter 'items' when calling updateOrCreateItems");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updateOrCreateItems");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Items"));
        if (summarizeErrors != null) {
            key = "summarizeErrors";
            value = summarizeErrors;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (unitdp != null) {
            key = "unitdp";
            value = unitdp;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(items);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ManualJournals updateOrCreateManualJournals(String accessToken, String xeroTenantId, ManualJournals manualJournals, Boolean summarizeErrors, String idempotencyKey) throws IOException {
        try {
            TypeReference<ManualJournals> typeRef = new TypeReference<ManualJournals>(){};
            HttpResponse response = this.updateOrCreateManualJournalsForHttpResponse(accessToken, xeroTenantId, manualJournals, summarizeErrors, idempotencyKey);
        