/*
 * Decompiled with CFR 0.152.
 */
package com.xero.api.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.FileContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpMediaType;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.MultipartContent;
import com.google.api.client.util.Maps;
import com.xero.api.ApiClient;
import com.xero.api.XeroApiExceptionHandler;
import com.xero.models.file.Association;
import com.xero.models.file.FileObject;
import com.xero.models.file.Files;
import com.xero.models.file.Folder;
import jakarta.ws.rs.core.UriBuilder;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesApi {
    private ApiClient apiClient;
    private static FilesApi instance = null;
    private String userAgent = "Default";
    private String version = "8.3.0";
    static final Logger logger = LoggerFactory.getLogger(FilesApi.class);

    public FilesApi() {
        this(new ApiClient());
    }

    public static FilesApi getInstance(ApiClient apiClient) {
        if (instance == null) {
            instance = new FilesApi(apiClient);
        }
        return instance;
    }

    public FilesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getUserAgent() {
        return this.userAgent + " [Xero-Java-" + this.version + "]";
    }

    public Association createFileAssociation(String accessToken, String xeroTenantId, UUID fileId, Association association, String idempotencyKey) throws IOException {
        try {
            TypeReference<Association> typeRef = new TypeReference<Association>(){};
            HttpResponse response = this.createFileAssociationForHttpResponse(accessToken, xeroTenantId, fileId, association, idempotencyKey);
            return (Association)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createFileAssociation -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createFileAssociationForHttpResponse(String accessToken, String xeroTenantId, UUID fileId, Association association, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createFileAssociation");
        }
        if (fileId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileId' when calling createFileAssociation");
        }
        if (association == null) {
            throw new IllegalArgumentException("Missing the required parameter 'association' when calling createFileAssociation");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createFileAssociation");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("FileId", fileId);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Files/{FileId}/Associations"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(association);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Folder createFolder(String accessToken, String xeroTenantId, Folder folder, String idempotencyKey) throws IOException {
        try {
            TypeReference<Folder> typeRef = new TypeReference<Folder>(){};
            HttpResponse response = this.createFolderForHttpResponse(accessToken, xeroTenantId, folder, idempotencyKey);
            return (Folder)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createFolder -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createFolderForHttpResponse(String accessToken, String xeroTenantId, Folder folder, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createFolder");
        }
        if (folder == null) {
            throw new IllegalArgumentException("Missing the required parameter 'folder' when calling createFolder");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createFolder");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Folders"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(folder);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public void deleteFile(String accessToken, String xeroTenantId, UUID fileId) throws IOException {
        try {
            this.deleteFileForHttpResponse(accessToken, xeroTenantId, fileId);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : deleteFile -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
    }

    public HttpResponse deleteFileForHttpResponse(String accessToken, String xeroTenantId, UUID fileId) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling deleteFile");
        }
        if (fileId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileId' when calling deleteFile");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling deleteFile");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("FileId", fileId);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Files/{FileId}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("DELETE " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("DELETE", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public void deleteFileAssociation(String accessToken, String xeroTenantId, UUID fileId, UUID objectId) throws IOException {
        try {
            this.deleteFileAssociationForHttpResponse(accessToken, xeroTenantId, fileId, objectId);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : deleteFileAssociation -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
    }

    public HttpResponse deleteFileAssociationForHttpResponse(String accessToken, String xeroTenantId, UUID fileId, UUID objectId) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling deleteFileAssociation");
        }
        if (fileId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileId' when calling deleteFileAssociation");
        }
        if (objectId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'objectId' when calling deleteFileAssociation");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling deleteFileAssociation");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("FileId", fileId);
        uriVariables.put("ObjectId", objectId);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Files/{FileId}/Associations/{ObjectId}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("DELETE " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("DELETE", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public void deleteFolder(String accessToken, String xeroTenantId, UUID folderId) throws IOException {
        try {
            this.deleteFolderForHttpResponse(accessToken, xeroTenantId, folderId);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : deleteFolder -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
    }

    public HttpResponse deleteFolderForHttpResponse(String accessToken, String xeroTenantId, UUID folderId) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling deleteFolder");
        }
        if (folderId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'folderId' when calling deleteFolder");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling deleteFolder");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("FolderId", folderId);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Folders/{FolderId}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("DELETE " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("DELETE", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public List<Association> getAssociationsByObject(String accessToken, String xeroTenantId, UUID objectId, Integer pagesize, Integer page, String sort, String direction) throws IOException {
        try {
            TypeReference<List<Association>> typeRef = new TypeReference<List<Association>>(){};
            HttpResponse response = this.getAssociationsByObjectForHttpResponse(accessToken, xeroTenantId, objectId, pagesize, page, sort, direction);
            return (List)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getAssociationsByObject -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getAssociationsByObjectForHttpResponse(String accessToken, String xeroTenantId, UUID objectId, Integer pagesize, Integer page, String sort, String direction) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        Object value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getAssociationsByObject");
        }
        if (objectId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'objectId' when calling getAssociationsByObject");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getAssociationsByObject");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("ObjectId", objectId);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Associations/{ObjectId}"));
        if (pagesize != null) {
            key = "pagesize";
            value = pagesize;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (page != null) {
            key = "page";
            value = page;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (sort != null) {
            key = "sort";
            value = sort;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (direction != null) {
            key = "direction";
            value = direction;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Object getAssociationsCount(String accessToken, String xeroTenantId, List<UUID> objectIds) throws IOException {
        try {
            TypeReference<Object> typeRef = new TypeReference<Object>(){};
            HttpResponse response = this.getAssociationsCountForHttpResponse(accessToken, xeroTenantId, objectIds);
            return this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getAssociationsCount -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getAssociationsCountForHttpResponse(String accessToken, String xeroTenantId, List<UUID> objectIds) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getAssociationsCount");
        }
        if (objectIds == null) {
            throw new IllegalArgumentException("Missing the required parameter 'objectIds' when calling getAssociationsCount");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getAssociationsCount");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Associations/Count"));
        if (objectIds != null) {
            String key = "ObjectIds";
            List<UUID> value = objectIds;
            if (value instanceof Collection) {
                ArrayList valueList = new ArrayList(value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public FileObject getFile(String accessToken, String xeroTenantId, UUID fileId) throws IOException {
        try {
            TypeReference<FileObject> typeRef = new TypeReference<FileObject>(){};
            HttpResponse response = this.getFileForHttpResponse(accessToken, xeroTenantId, fileId);
            return (FileObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getFile -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getFileForHttpResponse(String accessToken, String xeroTenantId, UUID fileId) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getFile");
        }
        if (fileId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileId' when calling getFile");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getFile");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("FileId", fileId);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Files/{FileId}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public List<Association> getFileAssociations(String accessToken, String xeroTenantId, UUID fileId) throws IOException {
        try {
            TypeReference<List<Association>> typeRef = new TypeReference<List<Association>>(){};
            HttpResponse response = this.getFileAssociationsForHttpResponse(accessToken, xeroTenantId, fileId);
            return (List)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getFileAssociations -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getFileAssociationsForHttpResponse(String accessToken, String xeroTenantId, UUID fileId) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getFileAssociations");
        }
        if (fileId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileId' when calling getFileAssociations");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getFileAssociations");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("FileId", fileId);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Files/{FileId}/Associations"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ByteArrayInputStream getFileContent(String accessToken, String xeroTenantId, UUID fileId) throws IOException {
        try {
            TypeReference<File> typeRef = new TypeReference<File>(){};
            HttpResponse response = this.getFileContentForHttpResponse(accessToken, xeroTenantId, fileId);
            InputStream is = response.getContent();
            return this.convertInputToByteArray(is);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getFileContent -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getFileContentForHttpResponse(String accessToken, String xeroTenantId, UUID fileId) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getFileContent");
        }
        if (fileId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileId' when calling getFileContent");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getFileContent");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/octet-stream");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("FileId", fileId);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Files/{FileId}/Content"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Files getFiles(String accessToken, String xeroTenantId, Integer pagesize, Integer page, String sort) throws IOException {
        try {
            TypeReference<Files> typeRef = new TypeReference<Files>(){};
            HttpResponse response = this.getFilesForHttpResponse(accessToken, xeroTenantId, pagesize, page, sort);
            return (Files)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getFiles -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getFilesForHttpResponse(String accessToken, String xeroTenantId, Integer pagesize, Integer page, String sort) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        Object value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getFiles");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getFiles");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Files"));
        if (pagesize != null) {
            key = "pagesize";
            value = pagesize;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (page != null) {
            key = "page";
            value = page;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (sort != null) {
            key = "sort";
            value = sort;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Folder getFolder(String accessToken, String xeroTenantId, UUID folderId) throws IOException {
        try {
            TypeReference<Folder> typeRef = new TypeReference<Folder>(){};
            HttpResponse response = this.getFolderForHttpResponse(accessToken, xeroTenantId, folderId);
            return (Folder)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getFolder -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getFolderForHttpResponse(String accessToken, String xeroTenantId, UUID folderId) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getFolder");
        }
        if (folderId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'folderId' when calling getFolder");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getFolder");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("FolderId", folderId);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Folders/{FolderId}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public List<Folder> getFolders(String accessToken, String xeroTenantId, String sort) throws IOException {
        try {
            TypeReference<List<Folder>> typeRef = new TypeReference<List<Folder>>(){};
            HttpResponse response = this.getFoldersForHttpResponse(accessToken, xeroTenantId, sort);
            return (List)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getFolders -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getFoldersForHttpResponse(String accessToken, String xeroTenantId, String sort) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getFolders");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getFolders");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Folders"));
        if (sort != null) {
            String key = "sort";
            String value = sort;
            if (value instanceof Collection) {
                ArrayList valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Folder getInbox(String accessToken, String xeroTenantId) throws IOException {
        try {
            TypeReference<Folder> typeRef = new TypeReference<Folder>(){};
            HttpResponse response = this.getInboxForHttpResponse(accessToken, xeroTenantId);
            return (Folder)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getInbox -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getInboxForHttpResponse(String accessToken, String xeroTenantId) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getInbox");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getInbox");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Inbox"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public FileObject updateFile(String accessToken, String xeroTenantId, UUID fileId, FileObject fileObject, String idempotencyKey) throws IOException {
        try {
            TypeReference<FileObject> typeRef = new TypeReference<FileObject>(){};
            HttpResponse response = this.updateFileForHttpResponse(accessToken, xeroTenantId, fileId, fileObject, idempotencyKey);
            return (FileObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updateFile -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse updateFileForHttpResponse(String accessToken, String xeroTenantId, UUID fileId, FileObject fileObject, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updateFile");
        }
        if (fileId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileId' when calling updateFile");
        }
        if (fileObject == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fileObject' when calling updateFile");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updateFile");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("FileId", fileId);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Files/{FileId}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(fileObject);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Folder updateFolder(String accessToken, String xeroTenantId, UUID folderId, Folder folder, String idempotencyKey) throws IOException {
        try {
            TypeReference<Folder> typeRef = new TypeReference<Folder>(){};
            HttpResponse response = this.updateFolderForHttpResponse(accessToken, xeroTenantId, folderId, folder, idempotencyKey);
            return (Folder)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updateFolder -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse updateFolderForHttpResponse(String accessToken, String xeroTenantId, UUID folderId, Folder folder, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updateFolder");
        }
        if (folderId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'folderId' when calling updateFolder");
        }
        if (folder == null) {
            throw new IllegalArgumentException("Missing the required parameter 'folder' when calling updateFolder");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updateFolder");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("FolderId", folderId);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Folders/{FolderId}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(folder);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public FileObject uploadFile(String accessToken, String xeroTenantId, File body, String name, String filename, String idempotencyKey, String mimeType) throws IOException {
        try {
            TypeReference<FileObject> typeRef = new TypeReference<FileObject>(){};
            HttpResponse response = this.uploadFileForHttpResponse(accessToken, xeroTenantId, body, name, filename, idempotencyKey, mimeType);
            return (FileObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : uploadFile -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse uploadFileForHttpResponse(String accessToken, String xeroTenantId, File body, String name, String filename, String idempotencyKey, String mimeType) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling uploadFile");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling uploadFile");
        }
        if (name == null) {
            throw new IllegalArgumentException("Missing the required parameter 'name' when calling uploadFile");
        }
        if (filename == null) {
            throw new IllegalArgumentException("Missing the required parameter 'filename' when calling uploadFile");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling uploadFile");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Files"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        HashMap parameters = Maps.newHashMap();
        parameters.put("name", name);
        parameters.put("filename", filename);
        MultipartContent content = new MultipartContent().setMediaType(new HttpMediaType("multipart/form-data").setParameter("boundary", "__END_OF_PART__"));
        for (String key : parameters.keySet()) {
            MultipartContent.Part part = new MultipartContent.Part((HttpContent)new ByteArrayContent(null, ((String)parameters.get(key)).getBytes()));
            part.setHeaders(new HttpHeaders().set("Content-Disposition", (Object)String.format("form-data; name=\"%s\"", key)));
            content.addPart(part);
        }
        FileContent fileContent = new FileContent(mimeType, body);
        MultipartContent.Part part = new MultipartContent.Part((HttpContent)fileContent);
        part.setHeaders(new HttpHeaders().set("Content-Disposition", (Object)String.format("form-data; name=\"content\"; filename=\"%s\"", filename)));
        content.addPart(part);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public FileObject uploadFileToFolder(String accessToken, String xeroTenantId, UUID folderId, File body, String name, String filename, String idempotencyKey, String mimeType) throws IOException {
        try {
            TypeReference<FileObject> typeRef = new TypeReference<FileObject>(){};
            HttpResponse response = this.uploadFileToFolderForHttpResponse(accessToken, xeroTenantId, folderId, body, name, filename, idempotencyKey, mimeType);
            return (FileObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : uploadFileToFolder -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse uploadFileToFolderForHttpResponse(String accessToken, String xeroTenantId, UUID folderId, File body, String name, String filename, String idempotencyKey, String mimeType) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling uploadFileToFolder");
        }
        if (folderId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'folderId' when calling uploadFileToFolder");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling uploadFileToFolder");
        }
        if (name == null) {
            throw new IllegalArgumentException("Missing the required parameter 'name' when calling uploadFileToFolder");
        }
        if (filename == null) {
            throw new IllegalArgumentException("Missing the required parameter 'filename' when calling uploadFileToFolder");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling uploadFileToFolder");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("FolderId", folderId);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Files/{FolderId}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        HashMap parameters = Maps.newHashMap();
        parameters.put("name", name);
        parameters.put("filename", filename);
        MultipartContent content = new MultipartContent().setMediaType(new HttpMediaType("multipart/form-data").setParameter("boundary", "__END_OF_PART__"));
        for (String key : parameters.keySet()) {
            MultipartContent.Part part = new MultipartContent.Part((HttpContent)new ByteArrayContent(null, ((String)parameters.get(key)).getBytes()));
            part.setHeaders(new HttpHeaders().set("Content-Disposition", (Object)String.format("form-data; name=\"%s\"", key)));
            content.addPart(part);
        }
        FileContent fileContent = new FileContent(mimeType, body);
        MultipartContent.Part part = new MultipartContent.Part((HttpContent)fileContent);
        part.setHeaders(new HttpHeaders().set("Content-Disposition", (Object)String.format("form-data; name=\"content\"; filename=\"%s\"", filename)));
        content.addPart(part);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayInputStream convertInputToByteArray(InputStream is) throws IOException {
        byte[] bytes = IOUtils.toByteArray((InputStream)is);
        try {
            ByteArrayInputStream byteArrayInputStream;
            ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream = new ByteArrayInputStream(bytes);
            return byteArrayInputStream2;
        }
        finally {
            is.close();
        }
    }
}

