/*
 * Decompiled with CFR 0.152.
 */
package com.xero.api.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.xero.api.ApiClient;
import com.xero.api.XeroApiExceptionHandler;
import com.xero.models.identity.Connection;
import jakarta.ws.rs.core.UriBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentityApi {
    private ApiClient apiClient;
    private static IdentityApi instance = null;
    private String userAgent = "Default";
    private String version = "8.3.0";
    static final Logger logger = LoggerFactory.getLogger(IdentityApi.class);

    public IdentityApi() {
        this(new ApiClient());
    }

    public static IdentityApi getInstance(ApiClient apiClient) {
        if (instance == null) {
            instance = new IdentityApi(apiClient);
        }
        return instance;
    }

    public IdentityApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getUserAgent() {
        return this.userAgent + " [Xero-Java-" + this.version + "]";
    }

    public void deleteConnection(String accessToken, UUID id) throws IOException {
        try {
            this.deleteConnectionForHttpResponse(accessToken, id);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : deleteConnection -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
    }

    public HttpResponse deleteConnectionForHttpResponse(String accessToken, UUID id) throws IOException {
        if (id == null) {
            throw new IllegalArgumentException("Missing the required parameter 'id' when calling deleteConnection");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling deleteConnection");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept("");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("id", id);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Connections/{id}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("DELETE " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("DELETE", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public List<Connection> getConnections(String accessToken, UUID authEventId) throws IOException {
        try {
            TypeReference<List<Connection>> typeRef = new TypeReference<List<Connection>>(){};
            HttpResponse response = this.getConnectionsForHttpResponse(accessToken, authEventId);
            return (List)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getConnections -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getConnectionsForHttpResponse(String accessToken, UUID authEventId) throws IOException {
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getConnections");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Connections"));
        if (authEventId != null) {
            String key = "authEventId";
            UUID value = authEventId;
            if (value instanceof Collection) {
                ArrayList valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayInputStream convertInputToByteArray(InputStream is) throws IOException {
        byte[] bytes = IOUtils.toByteArray((InputStream)is);
        try {
            ByteArrayInputStream byteArrayInputStream;
            ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream = new ByteArrayInputStream(bytes);
            return byteArrayInputStream2;
        }
        finally {
            is.close();
        }
    }
}

