/*
 * Decompiled with CFR 0.152.
 */
package com.xero.api.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.xero.api.ApiClient;
import com.xero.api.XeroApiExceptionHandler;
import com.xero.models.payrolluk.Benefit;
import com.xero.models.payrolluk.BenefitObject;
import com.xero.models.payrolluk.Benefits;
import com.xero.models.payrolluk.Deduction;
import com.xero.models.payrolluk.DeductionObject;
import com.xero.models.payrolluk.Deductions;
import com.xero.models.payrolluk.EarningsOrderObject;
import com.xero.models.payrolluk.EarningsOrders;
import com.xero.models.payrolluk.EarningsRate;
import com.xero.models.payrolluk.EarningsRateObject;
import com.xero.models.payrolluk.EarningsRates;
import com.xero.models.payrolluk.EarningsTemplate;
import com.xero.models.payrolluk.EarningsTemplateObject;
import com.xero.models.payrolluk.Employee;
import com.xero.models.payrolluk.EmployeeLeave;
import com.xero.models.payrolluk.EmployeeLeaveBalances;
import com.xero.models.payrolluk.EmployeeLeaveObject;
import com.xero.models.payrolluk.EmployeeLeaveType;
import com.xero.models.payrolluk.EmployeeLeaveTypeObject;
import com.xero.models.payrolluk.EmployeeLeaveTypes;
import com.xero.models.payrolluk.EmployeeLeaves;
import com.xero.models.payrolluk.EmployeeObject;
import com.xero.models.payrolluk.EmployeeOpeningBalances;
import com.xero.models.payrolluk.EmployeeOpeningBalancesObject;
import com.xero.models.payrolluk.EmployeePayTemplateObject;
import com.xero.models.payrolluk.EmployeePayTemplates;
import com.xero.models.payrolluk.EmployeeStatutoryLeaveBalanceObject;
import com.xero.models.payrolluk.EmployeeStatutoryLeavesSummaries;
import com.xero.models.payrolluk.EmployeeStatutorySickLeave;
import com.xero.models.payrolluk.EmployeeStatutorySickLeaveObject;
import com.xero.models.payrolluk.EmployeeTaxObject;
import com.xero.models.payrolluk.Employees;
import com.xero.models.payrolluk.Employment;
import com.xero.models.payrolluk.EmploymentObject;
import com.xero.models.payrolluk.LeavePeriods;
import com.xero.models.payrolluk.LeaveType;
import com.xero.models.payrolluk.LeaveTypeObject;
import com.xero.models.payrolluk.LeaveTypes;
import com.xero.models.payrolluk.PayRun;
import com.xero.models.payrolluk.PayRunCalendar;
import com.xero.models.payrolluk.PayRunCalendarObject;
import com.xero.models.payrolluk.PayRunCalendars;
import com.xero.models.payrolluk.PayRunObject;
import com.xero.models.payrolluk.PayRuns;
import com.xero.models.payrolluk.PaymentMethod;
import com.xero.models.payrolluk.PaymentMethodObject;
import com.xero.models.payrolluk.PayslipObject;
import com.xero.models.payrolluk.Payslips;
import com.xero.models.payrolluk.Reimbursement;
import com.xero.models.payrolluk.ReimbursementObject;
import com.xero.models.payrolluk.Reimbursements;
import com.xero.models.payrolluk.SalaryAndWage;
import com.xero.models.payrolluk.SalaryAndWageObject;
import com.xero.models.payrolluk.SalaryAndWages;
import com.xero.models.payrolluk.Settings;
import com.xero.models.payrolluk.Timesheet;
import com.xero.models.payrolluk.TimesheetLine;
import com.xero.models.payrolluk.TimesheetLineObject;
import com.xero.models.payrolluk.TimesheetObject;
import com.xero.models.payrolluk.Timesheets;
import com.xero.models.payrolluk.TrackingCategories;
import jakarta.ws.rs.core.UriBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.threeten.bp.LocalDate;

public class PayrollUkApi {
    private ApiClient apiClient;
    private static PayrollUkApi instance = null;
    private String userAgent = "Default";
    private String version = "8.3.0";
    static final Logger logger = LoggerFactory.getLogger(PayrollUkApi.class);

    public PayrollUkApi() {
        this(new ApiClient());
    }

    public static PayrollUkApi getInstance(ApiClient apiClient) {
        if (instance == null) {
            instance = new PayrollUkApi(apiClient);
        }
        return instance;
    }

    public PayrollUkApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getUserAgent() {
        return this.userAgent + " [Xero-Java-" + this.version + "]";
    }

    public TimesheetObject approveTimesheet(String accessToken, String xeroTenantId, UUID timesheetID, String idempotencyKey) throws IOException {
        try {
            TypeReference<TimesheetObject> typeRef = new TypeReference<TimesheetObject>(){};
            HttpResponse response = this.approveTimesheetForHttpResponse(accessToken, xeroTenantId, timesheetID, idempotencyKey);
            return (TimesheetObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : approveTimesheet -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<TimesheetObject> errorTypeRef = new TypeReference<TimesheetObject>(){};
                TimesheetObject object = (TimesheetObject)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "TimesheetObject", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse approveTimesheetForHttpResponse(String accessToken, String xeroTenantId, UUID timesheetID, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling approveTimesheet");
        }
        if (timesheetID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'timesheetID' when calling approveTimesheet");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling approveTimesheet");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("TimesheetID", timesheetID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Timesheets/{TimesheetID}/Approve"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public BenefitObject createBenefit(String accessToken, String xeroTenantId, Benefit benefit, String idempotencyKey) throws IOException {
        try {
            TypeReference<BenefitObject> typeRef = new TypeReference<BenefitObject>(){};
            HttpResponse response = this.createBenefitForHttpResponse(accessToken, xeroTenantId, benefit, idempotencyKey);
            return (BenefitObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createBenefit -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<BenefitObject> errorTypeRef = new TypeReference<BenefitObject>(){};
                BenefitObject object = (BenefitObject)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "BenefitObject", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createBenefitForHttpResponse(String accessToken, String xeroTenantId, Benefit benefit, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createBenefit");
        }
        if (benefit == null) {
            throw new IllegalArgumentException("Missing the required parameter 'benefit' when calling createBenefit");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createBenefit");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Benefits"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(benefit);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public DeductionObject createDeduction(String accessToken, String xeroTenantId, Deduction deduction, String idempotencyKey) throws IOException {
        try {
            TypeReference<DeductionObject> typeRef = new TypeReference<DeductionObject>(){};
            HttpResponse response = this.createDeductionForHttpResponse(accessToken, xeroTenantId, deduction, idempotencyKey);
            return (DeductionObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createDeduction -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<DeductionObject> errorTypeRef = new TypeReference<DeductionObject>(){};
                DeductionObject object = (DeductionObject)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "DeductionObject", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createDeductionForHttpResponse(String accessToken, String xeroTenantId, Deduction deduction, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createDeduction");
        }
        if (deduction == null) {
            throw new IllegalArgumentException("Missing the required parameter 'deduction' when calling createDeduction");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createDeduction");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Deductions"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(deduction);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public EarningsRateObject createEarningsRate(String accessToken, String xeroTenantId, EarningsRate earningsRate, String idempotencyKey) throws IOException {
        try {
            TypeReference<EarningsRateObject> typeRef = new TypeReference<EarningsRateObject>(){};
            HttpResponse response = this.createEarningsRateForHttpResponse(accessToken, xeroTenantId, earningsRate, idempotencyKey);
            return (EarningsRateObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createEarningsRate -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<EarningsRateObject> errorTypeRef = new TypeReference<EarningsRateObject>(){};
                EarningsRateObject object = (EarningsRateObject)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "EarningsRateObject", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createEarningsRateForHttpResponse(String accessToken, String xeroTenantId, EarningsRate earningsRate, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createEarningsRate");
        }
        if (earningsRate == null) {
            throw new IllegalArgumentException("Missing the required parameter 'earningsRate' when calling createEarningsRate");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createEarningsRate");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/EarningsRates"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(earningsRate);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public EmployeeObject createEmployee(String accessToken, String xeroTenantId, Employee employee, String idempotencyKey) throws IOException {
        try {
            TypeReference<EmployeeObject> typeRef = new TypeReference<EmployeeObject>(){};
            HttpResponse response = this.createEmployeeForHttpResponse(accessToken, xeroTenantId, employee, idempotencyKey);
            return (EmployeeObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createEmployee -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<EmployeeObject> errorTypeRef = new TypeReference<EmployeeObject>(){};
                EmployeeObject object = (EmployeeObject)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "EmployeeObject", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createEmployeeForHttpResponse(String accessToken, String xeroTenantId, Employee employee, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createEmployee");
        }
        if (employee == null) {
            throw new IllegalArgumentException("Missing the required parameter 'employee' when calling createEmployee");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createEmployee");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Employees"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(employee);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public EarningsTemplateObject createEmployeeEarningsTemplate(String accessToken, String xeroTenantId, UUID employeeID, EarningsTemplate earningsTemplate, String idempotencyKey) throws IOException {
        try {
            TypeReference<EarningsTemplateObject> typeRef = new TypeReference<EarningsTemplateObject>(){};
            HttpResponse response = this.createEmployeeEarningsTemplateForHttpResponse(accessToken, xeroTenantId, employeeID, earningsTemplate, idempotencyKey);
            return (EarningsTemplateObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createEmployeeEarningsTemplate -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<EarningsTemplateObject> errorTypeRef = new TypeReference<EarningsTemplateObject>(){};
                EarningsTemplateObject object = (EarningsTemplateObject)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "EarningsTemplateObject", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createEmployeeEarningsTemplateForHttpResponse(String accessToken, String xeroTenantId, UUID employeeID, EarningsTemplate earningsTemplate, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createEmployeeEarningsTemplate");
        }
        if (employeeID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'employeeID' when calling createEmployeeEarningsTemplate");
        }
        if (earningsTemplate == null) {
            throw new IllegalArgumentException("Missing the required parameter 'earningsTemplate' when calling createEmployeeEarningsTemplate");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createEmployeeEarningsTemplate");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("EmployeeID", employeeID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Employees/{EmployeeID}/PayTemplates/earnings"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(earningsTemplate);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public EmployeeLeaveObject createEmployeeLeave(String accessToken, String xeroTenantId, UUID employeeID, EmployeeLeave employeeLeave, String idempotencyKey) throws IOException {
        try {
            TypeReference<EmployeeLeaveObject> typeRef = new TypeReference<EmployeeLeaveObject>(){};
            HttpResponse response = this.createEmployeeLeaveForHttpResponse(accessToken, xeroTenantId, employeeID, employeeLeave, idempotencyKey);
            return (EmployeeLeaveObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createEmployeeLeave -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<EmployeeLeaveObject> errorTypeRef = new TypeReference<EmployeeLeaveObject>(){};
                EmployeeLeaveObject object = (EmployeeLeaveObject)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "EmployeeLeaveObject", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createEmployeeLeaveForHttpResponse(String accessToken, String xeroTenantId, UUID employeeID, EmployeeLeave employeeLeave, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createEmployeeLeave");
        }
        if (employeeID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'employeeID' when calling createEmployeeLeave");
        }
        if (employeeLeave == null) {
            throw new IllegalArgumentException("Missing the required parameter 'employeeLeave' when calling createEmployeeLeave");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createEmployeeLeave");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("EmployeeID", employeeID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Employees/{EmployeeID}/Leave"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(employeeLeave);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public EmployeeLeaveTypeObject createEmployeeLeaveType(String accessToken, String xeroTenantId, UUID employeeID, EmployeeLeaveType employeeLeaveType, String idempotencyKey) throws IOException {
        try {
            TypeReference<EmployeeLeaveTypeObject> typeRef = new TypeReference<EmployeeLeaveTypeObject>(){};
            HttpResponse response = this.createEmployeeLeaveTypeForHttpResponse(accessToken, xeroTenantId, employeeID, employeeLeaveType, idempotencyKey);
            return (EmployeeLeaveTypeObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createEmployeeLeaveType -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<EmployeeLeaveTypeObject> errorTypeRef = new TypeReference<EmployeeLeaveTypeObject>(){};
                EmployeeLeaveTypeObject object = (EmployeeLeaveTypeObject)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "EmployeeLeaveTypeObject", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createEmployeeLeaveTypeForHttpResponse(String accessToken, String xeroTenantId, UUID employeeID, EmployeeLeaveType employeeLeaveType, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createEmployeeLeaveType");
        }
        if (employeeID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'employeeID' when calling createEmployeeLeaveType");
        }
        if (employeeLeaveType == null) {
            throw new IllegalArgumentException("Missing the required parameter 'employeeLeaveType' when calling createEmployeeLeaveType");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createEmployeeLeaveType");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("EmployeeID", employeeID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Employees/{EmployeeID}/LeaveTypes"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(employeeLeaveType);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public EmployeeOpeningBalancesObject createEmployeeOpeningBalances(String accessToken, String xeroTenantId, UUID employeeID, EmployeeOpeningBalances employeeOpeningBalances, String idempotencyKey) throws IOException {
        try {
            TypeReference<EmployeeOpeningBalancesObject> typeRef = new TypeReference<EmployeeOpeningBalancesObject>(){};
            HttpResponse response = this.createEmployeeOpeningBalancesForHttpResponse(accessToken, xeroTenantId, employeeID, employeeOpeningBalances, idempotencyKey);
            return (EmployeeOpeningBalancesObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createEmployeeOpeningBalances -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<EmployeeOpeningBalancesObject> errorTypeRef = new TypeReference<EmployeeOpeningBalancesObject>(){};
                EmployeeOpeningBalancesObject object = (EmployeeOpeningBalancesObject)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "EmployeeOpeningBalancesObject", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createEmployeeOpeningBalancesForHttpResponse(String accessToken, String xeroTenantId, UUID employeeID, EmployeeOpeningBalances employeeOpeningBalances, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createEmployeeOpeningBalances");
        }
        if (employeeID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'employeeID' when calling createEmployeeOpeningBalances");
        }
        if (employeeOpeningBalances == null) {
            throw new IllegalArgumentException("Missing the required parameter 'employeeOpeningBalances' when calling createEmployeeOpeningBalances");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createEmployeeOpeningBalances");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("EmployeeID", employeeID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Employees/{EmployeeID}/ukopeningbalances"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(employeeOpeningBalances);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public PaymentMethodObject createEmployeePaymentMethod(String accessToken, String xeroTenantId, UUID employeeID, PaymentMethod paymentMethod, String idempotencyKey) throws IOException {
        try {
            TypeReference<PaymentMethodObject> typeRef = new TypeReference<PaymentMethodObject>(){};
            HttpResponse response = this.createEmployeePaymentMethodForHttpResponse(accessToken, xeroTenantId, employeeID, paymentMethod, idempotencyKey);
            return (PaymentMethodObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createEmployeePaymentMethod -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<PaymentMethodObject> errorTypeRef = new TypeReference<PaymentMethodObject>(){};
                PaymentMethodObject object = (PaymentMethodObject)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "PaymentMethodObject", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createEmployeePaymentMethodForHttpResponse(String accessToken, String xeroTenantId, UUID employeeID, PaymentMethod paymentMethod, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createEmployeePaymentMethod");
        }
        if (employeeID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'employeeID' when calling createEmployeePaymentMethod");
        }
        if (paymentMethod == null) {
            throw new IllegalArgumentException("Missing the required parameter 'paymentMethod' when calling createEmployeePaymentMethod");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createEmployeePaymentMethod");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("EmployeeID", employeeID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Employees/{EmployeeID}/PaymentMethods"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(paymentMethod);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public SalaryAndWageObject createEmployeeSalaryAndWage(String accessToken, String xeroTenantId, UUID employeeID, SalaryAndWage salaryAndWage, String idempotencyKey) throws IOException {
        try {
            TypeReference<SalaryAndWageObject> typeRef = new TypeReference<SalaryAndWageObject>(){};
            HttpResponse response = this.createEmployeeSalaryAndWageForHttpResponse(accessToken, xeroTenantId, employeeID, salaryAndWage, idempotencyKey);
            return (SalaryAndWageObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createEmployeeSalaryAndWage -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<SalaryAndWageObject> errorTypeRef = new TypeReference<SalaryAndWageObject>(){};
                SalaryAndWageObject object = (SalaryAndWageObject)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "SalaryAndWageObject", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createEmployeeSalaryAndWageForHttpResponse(String accessToken, String xeroTenantId, UUID employeeID, SalaryAndWage salaryAndWage, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createEmployeeSalaryAndWage");
        }
        if (employeeID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'employeeID' when calling createEmployeeSalaryAndWage");
        }
        if (salaryAndWage == null) {
            throw new IllegalArgumentException("Missing the required parameter 'salaryAndWage' when calling createEmployeeSalaryAndWage");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createEmployeeSalaryAndWage");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("EmployeeID", employeeID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Employees/{EmployeeID}/SalaryAndWages"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(salaryAndWage);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public EmployeeStatutorySickLeaveObject createEmployeeStatutorySickLeave(String accessToken, String xeroTenantId, EmployeeStatutorySickLeave employeeStatutorySickLeave, String idempotencyKey) throws IOException {
        try {
            TypeReference<EmployeeStatutorySickLeaveObject> typeRef = new TypeReference<EmployeeStatutorySickLeaveObject>(){};
            HttpResponse response = this.createEmployeeStatutorySickLeaveForHttpResponse(accessToken, xeroTenantId, employeeStatutorySickLeave, idempotencyKey);
            return (EmployeeStatutorySickLeaveObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createEmployeeStatutorySickLeave -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<EmployeeStatutorySickLeaveObject> errorTypeRef = new TypeReference<EmployeeStatutorySickLeaveObject>(){};
                EmployeeStatutorySickLeaveObject object = (EmployeeStatutorySickLeaveObject)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "EmployeeStatutorySickLeaveObject", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createEmployeeStatutorySickLeaveForHttpResponse(String accessToken, String xeroTenantId, EmployeeStatutorySickLeave employeeStatutorySickLeave, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createEmployeeStatutorySickLeave");
        }
        if (employeeStatutorySickLeave == null) {
            throw new IllegalArgumentException("Missing the required parameter 'employeeStatutorySickLeave' when calling createEmployeeStatutorySickLeave");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createEmployeeStatutorySickLeave");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/StatutoryLeaves/Sick"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(employeeStatutorySickLeave);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public EmploymentObject createEmployment(String accessToken, String xeroTenantId, UUID employeeID, Employment employment, String idempotencyKey) throws IOException {
        try {
            TypeReference<EmploymentObject> typeRef = new TypeReference<EmploymentObject>(){};
            HttpResponse response = this.createEmploymentForHttpResponse(accessToken, xeroTenantId, employeeID, employment, idempotencyKey);
            return (EmploymentObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createEmployment -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<EmploymentObject> errorTypeRef = new TypeReference<EmploymentObject>(){};
                EmploymentObject object = (EmploymentObject)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "EmploymentObject", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createEmploymentForHttpResponse(String accessToken, String xeroTenantId, UUID employeeID, Employment employment, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createEmployment");
        }
        if (employeeID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'employeeID' when calling createEmployment");
        }
        if (employment == null) {
            throw new IllegalArgumentException("Missing the required parameter 'employment' when calling createEmployment");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createEmployment");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("EmployeeID", employeeID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Employees/{EmployeeID}/Employment"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(employment);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public LeaveTypeObject createLeaveType(String accessToken, String xeroTenantId, LeaveType leaveType, String idempotencyKey) throws IOException {
        try {
            TypeReference<LeaveTypeObject> typeRef = new TypeReference<LeaveTypeObject>(){};
            HttpResponse response = this.createLeaveTypeForHttpResponse(accessToken, xeroTenantId, leaveType, idempotencyKey);
            return (LeaveTypeObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createLeaveType -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<LeaveTypeObject> errorTypeRef = new TypeReference<LeaveTypeObject>(){};
                LeaveTypeObject object = (LeaveTypeObject)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "LeaveTypeObject", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createLeaveTypeForHttpResponse(String accessToken, String xeroTenantId, LeaveType leaveType, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createLeaveType");
        }
        if (leaveType == null) {
            throw new IllegalArgumentException("Missing the required parameter 'leaveType' when calling createLeaveType");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createLeaveType");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/LeaveTypes"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(leaveType);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public EmployeePayTemplates createMultipleEmployeeEarningsTemplate(String accessToken, String xeroTenantId, UUID employeeID, List<EarningsTemplate> earningsTemplate, String idempotencyKey) throws IOException {
        try {
            TypeReference<EmployeePayTemplates> typeRef = new TypeReference<EmployeePayTemplates>(){};
            HttpResponse response = this.createMultipleEmployeeEarningsTemplateForHttpResponse(accessToken, xeroTenantId, employeeID, earningsTemplate, idempotencyKey);
            return (EmployeePayTemplates)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createMultipleEmployeeEarningsTemplate -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<EmployeePayTemplates> errorTypeRef = new TypeReference<EmployeePayTemplates>(){};
                EmployeePayTemplates object = (EmployeePayTemplates)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "EmployeePayTemplates", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createMultipleEmployeeEarningsTemplateForHttpResponse(String accessToken, String xeroTenantId, UUID employeeID, List<EarningsTemplate> earningsTemplate, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createMultipleEmployeeEarningsTemplate");
        }
        if (employeeID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'employeeID' when calling createMultipleEmployeeEarningsTemplate");
        }
        if (earningsTemplate == null) {
            throw new IllegalArgumentException("Missing the required parameter 'earningsTemplate' when calling createMultipleEmployeeEarningsTemplate");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createMultipleEmployeeEarningsTemplate");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("EmployeeID", employeeID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Employees/{EmployeeID}/paytemplateearnings"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(earningsTemplate);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public PayRunCalendarObject createPayRunCalendar(String accessToken, String xeroTenantId, PayRunCalendar payRunCalendar, String idempotencyKey) throws IOException {
        try {
            TypeReference<PayRunCalendarObject> typeRef = new TypeReference<PayRunCalendarObject>(){};
            HttpResponse response = this.createPayRunCalendarForHttpResponse(accessToken, xeroTenantId, payRunCalendar, idempotencyKey);
            return (PayRunCalendarObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createPayRunCalendar -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<PayRunCalendarObject> errorTypeRef = new TypeReference<PayRunCalendarObject>(){};
                PayRunCalendarObject object = (PayRunCalendarObject)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "PayRunCalendarObject", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createPayRunCalendarForHttpResponse(String accessToken, String xeroTenantId, PayRunCalendar payRunCalendar, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createPayRunCalendar");
        }
        if (payRunCalendar == null) {
            throw new IllegalArgumentException("Missing the required parameter 'payRunCalendar' when calling createPayRunCalendar");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createPayRunCalendar");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/PayRunCalendars"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(payRunCalendar);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ReimbursementObject createReimbursement(String accessToken, String xeroTenantId, Reimbursement reimbursement, String idempotencyKey) throws IOException {
        try {
            TypeReference<ReimbursementObject> typeRef = new TypeReference<ReimbursementObject>(){};
            HttpResponse response = this.createReimbursementForHttpResponse(accessToken, xeroTenantId, reimbursement, idempotencyKey);
            return (ReimbursementObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createReimbursement -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<ReimbursementObject> errorTypeRef = new TypeReference<ReimbursementObject>(){};
                ReimbursementObject object = (ReimbursementObject)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "ReimbursementObject", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createReimbursementForHttpResponse(String accessToken, String xeroTenantId, Reimbursement reimbursement, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createReimbursement");
        }
        if (reimbursement == null) {
            throw new IllegalArgumentException("Missing the required parameter 'reimbursement' when calling createReimbursement");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createReimbursement");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Reimbursements"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(reimbursement);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public TimesheetObject createTimesheet(String accessToken, String xeroTenantId, Timesheet timesheet, String idempotencyKey) throws IOException {
        try {
            TypeReference<TimesheetObject> typeRef = new TypeReference<TimesheetObject>(){};
            HttpResponse response = this.createTimesheetForHttpResponse(accessToken, xeroTenantId, timesheet, idempotencyKey);
            return (TimesheetObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createTimesheet -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<TimesheetObject> errorTypeRef = new TypeReference<TimesheetObject>(){};
                TimesheetObject object = (TimesheetObject)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "TimesheetObject", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createTimesheetForHttpResponse(String accessToken, String xeroTenantId, Timesheet timesheet, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createTimesheet");
        }
        if (timesheet == null) {
            throw new IllegalArgumentException("Missing the required parameter 'timesheet' when calling createTimesheet");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createTimesheet");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Timesheets"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(timesheet);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public TimesheetLineObject createTimesheetLine(String accessToken, String xeroTenantId, UUID timesheetID, TimesheetLine timesheetLine, String idempotencyKey) throws IOException {
        try {
            TypeReference<TimesheetLineObject> typeRef = new TypeReference<TimesheetLineObject>(){};
            HttpResponse response = this.createTimesheetLineForHttpResponse(accessToken, xeroTenantId, timesheetID, timesheetLine, idempotencyKey);
            return (TimesheetLineObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createTimesheetLine -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<TimesheetLineObject> errorTypeRef = new TypeReference<TimesheetLineObject>(){};
                TimesheetLineObject object = (TimesheetLineObject)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "TimesheetLineObject", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createTimesheetLineForHttpResponse(String accessToken, String xeroTenantId, UUID timesheetID, TimesheetLine timesheetLine, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createTimesheetLine");
        }
        if (timesheetID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'timesheetID' when calling createTimesheetLine");
        }
        if (timesheetLine == null) {
            throw new IllegalArgumentException("Missing the required parameter 'timesheetLine' when calling createTimesheetLine");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createTimesheetLine");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("TimesheetID", timesheetID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Timesheets/{TimesheetID}/Lines"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(timesheetLine);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public void deleteEmployeeEarningsTemplate(String accessToken, String xeroTenantId, UUID employeeID, UUID payTemplateEarningID) throws IOException {
        try {
            this.deleteEmployeeEarningsTemplateForHttpResponse(accessToken, xeroTenantId, employeeID, payTemplateEarningID);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : deleteEmployeeEarningsTemplate -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
    }

    public HttpResponse deleteEmployeeEarningsTemplateForHttpResponse(String accessToken, String xeroTenantId, UUID employeeID, UUID payTemplateEarningID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling deleteEmployeeEarningsTemplate");
        }
        if (employeeID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'employeeID' when calling deleteEmployeeEarningsTemplate");
        }
        if (payTemplateEarningID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'payTemplateEarningID' when calling deleteEmployeeEarningsTemplate");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling deleteEmployeeEarningsTemplate");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("EmployeeID", employeeID);
        uriVariables.put("PayTemplateEarningID", payTemplateEarningID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Employees/{EmployeeID}/PayTemplates/earnings/{PayTemplateEarningID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("DELETE " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("DELETE", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public EmployeeLeaveObject deleteEmployeeLeave(String accessToken, String xeroTenantId, UUID employeeID, UUID leaveID) throws IOException {
        try {
            TypeReference<EmployeeLeaveObject> typeRef = new TypeReference<EmployeeLeaveObject>(){};
            HttpResponse response = this.deleteEmployeeLeaveForHttpResponse(accessToken, xeroTenantId, employeeID, leaveID);
            return (EmployeeLeaveObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : deleteEmployeeLeave -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<EmployeeLeaveObject> errorTypeRef = new TypeReference<EmployeeLeaveObject>(){};
                EmployeeLeaveObject object = (EmployeeLeaveObject)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "EmployeeLeaveObject", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse deleteEmployeeLeaveForHttpResponse(String accessToken, String xeroTenantId, UUID employeeID, UUID leaveID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling deleteEmployeeLeave");
        }
        if (employeeID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'employeeID' when calling deleteEmployeeLeave");
        }
        if (leaveID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'leaveID' when calling deleteEmployeeLeave");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling deleteEmployeeLeave");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("EmployeeID", employeeID);
        uriVariables.put("LeaveID", leaveID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Employees/{EmployeeID}/Leave/{LeaveID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("DELETE " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("DELETE", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public void deleteEmployeeSalaryAndWage(String accessToken, String xeroTenantId, UUID employeeID, UUID salaryAndWagesID) throws IOException {
        try {
            this.deleteEmployeeSalaryAndWageForHttpResponse(accessToken, xeroTenantId, employeeID, salaryAndWagesID);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : deleteEmployeeSalaryAndWage -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
    }

    public HttpResponse deleteEmployeeSalaryAndWageForHttpResponse(String accessToken, String xeroTenantId, UUID employeeID, UUID salaryAndWagesID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling deleteEmployeeSalaryAndWage");
        }
        if (employeeID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'employeeID' when calling deleteEmployeeSalaryAndWage");
        }
        if (salaryAndWagesID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'salaryAndWagesID' when calling deleteEmployeeSalaryAndWage");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling deleteEmployeeSalaryAndWage");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("EmployeeID", employeeID);
        uriVariables.put("SalaryAndWagesID", salaryAndWagesID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Employees/{EmployeeID}/SalaryAndWages/{SalaryAndWagesID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("DELETE " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("DELETE", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public TimesheetLine deleteTimesheet(String accessToken, String xeroTenantId, UUID timesheetID) throws IOException {
        try {
            TypeReference<TimesheetLine> typeRef = new TypeReference<TimesheetLine>(){};
            HttpResponse response = this.deleteTimesheetForHttpResponse(accessToken, xeroTenantId, timesheetID);
            return (TimesheetLine)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : deleteTimesheet -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse deleteTimesheetForHttpResponse(String accessToken, String xeroTenantId, UUID timesheetID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling deleteTimesheet");
        }
        if (timesheetID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'timesheetID' when calling deleteTimesheet");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling deleteTimesheet");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("TimesheetID", timesheetID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Timesheets/{TimesheetID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("DELETE " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("DELETE", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public TimesheetLine deleteTimesheetLine(String accessToken, String xeroTenantId, UUID timesheetID, UUID timesheetLineID) throws IOException {
        try {
            TypeReference<TimesheetLine> typeRef = new TypeReference<TimesheetLine>(){};
            HttpResponse response = this.deleteTimesheetLineForHttpResponse(accessToken, xeroTenantId, timesheetID, timesheetLineID);
            return (TimesheetLine)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : deleteTimesheetLine -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse deleteTimesheetLineForHttpResponse(String accessToken, String xeroTenantId, UUID timesheetID, UUID timesheetLineID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling deleteTimesheetLine");
        }
        if (timesheetID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'timesheetID' when calling deleteTimesheetLine");
        }
        if (timesheetLineID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'timesheetLineID' when calling deleteTimesheetLine");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling deleteTimesheetLine");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("TimesheetID", timesheetID);
        uriVariables.put("TimesheetLineID", timesheetLineID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Timesheets/{TimesheetID}/Lines/{TimesheetLineID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("DELETE " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("DELETE", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public BenefitObject getBenefit(String accessToken, String xeroTenantId, UUID id) throws IOException {
        try {
            TypeReference<BenefitObject> typeRef = new TypeReference<BenefitObject>(){};
            HttpResponse response = this.getBenefitForHttpResponse(accessToken, xeroTenantId, id);
            return (BenefitObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getBenefit -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<BenefitObject> errorTypeRef = new TypeReference<BenefitObject>(){};
                BenefitObject object = (BenefitObject)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "BenefitObject", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getBenefitForHttpResponse(String accessToken, String xeroTenantId, UUID id) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getBenefit");
        }
        if (id == null) {
            throw new IllegalArgumentException("Missing the required parameter 'id' when calling getBenefit");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getBenefit");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("id", id);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Benefits/{id}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Benefits getBenefits(String accessToken, String xeroTenantId, Integer page) throws IOException {
        try {
            TypeReference<Benefits> typeRef = new TypeReference<Benefits>(){};
            HttpResponse response = this.getBenefitsForHttpResponse(accessToken, xeroTenantId, page);
            return (Benefits)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getBenefits -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<Benefits> errorTypeRef = new TypeReference<Benefits>(){};
                Benefits object = (Benefits)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "Benefits", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getBenefitsForHttpResponse(String accessToken, String xeroTenantId, Integer page) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getBenefits");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getBenefits");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Benefits"));
        if (page != null) {
            String key = "page";
            Integer value = page;
            if (value instanceof Collection) {
                ArrayList valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public DeductionObject getDeduction(String accessToken, String xeroTenantId, UUID deductionId) throws IOException {
        try {
            TypeReference<DeductionObject> typeRef = new TypeReference<DeductionObject>(){};
            HttpResponse response = this.getDeductionForHttpResponse(accessToken, xeroTenantId, deductionId);
            return (DeductionObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getDeduction -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<DeductionObject> errorTypeRef = new TypeReference<DeductionObject>(){};
                DeductionObject object = (DeductionObject)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "DeductionObject", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getDeductionForHttpResponse(String accessToken, String xeroTenantId, UUID deductionId) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getDeduction");
        }
        if (deductionId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'deductionId' when calling getDeduction");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getDeduction");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("deductionId", deductionId);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Deductions/{deductionId}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Deductions getDeductions(String accessToken, String xeroTenantId, Integer page) throws IOException {
        try {
            TypeReference<Deductions> typeRef = new TypeReference<Deductions>(){};
            HttpResponse response = this.getDeductionsForHttpResponse(accessToken, xeroTenantId, page);
            return (Deductions)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getDeductions -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<Deductions> errorTypeRef = new TypeReference<Deductions>(){};
                Deductions object = (Deductions)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "Deductions", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getDeductionsForHttpResponse(String accessToken, String xeroTenantId, Integer page) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getDeductions");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getDeductions");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Deductions"));
        if (page != null) {
            String key = "page";
            Integer value = page;
            if (value instanceof Collection) {
                ArrayList valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public EarningsOrderObject getEarningsOrder(String accessToken, String xeroTenantId, UUID id) throws IOException {
        try {
            TypeReference<EarningsOrderObject> typeRef = new TypeReference<EarningsOrderObject>(){};
            HttpResponse response = this.getEarningsOrderForHttpResponse(accessToken, xeroTenantId, id);
            return (EarningsOrderObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getEarningsOrder -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<EarningsOrderObject> errorTypeRef = new TypeReference<EarningsOrderObject>(){};
                EarningsOrderObject object = (EarningsOrderObject)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "EarningsOrderObject", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getEarningsOrderForHttpResponse(String accessToken, String xeroTenantId, UUID id) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getEarningsOrder");
        }
        if (id == null) {
            throw new IllegalArgumentException("Missing the required parameter 'id' when calling getEarningsOrder");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getEarningsOrder");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("id", id);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/EarningsOrders/{id}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public EarningsOrders getEarningsOrders(String accessToken, String xeroTenantId, Integer page) throws IOException {
        try {
            TypeReference<EarningsOrders> typeRef = new TypeReference<EarningsOrders>(){};
            HttpResponse response = this.getEarningsOrdersForHttpResponse(accessToken, xeroTenantId, page);
            return (EarningsOrders)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getEarningsOrders -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<EarningsOrders> errorTypeRef = new TypeReference<EarningsOrders>(){};
                EarningsOrders object = (EarningsOrders)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "EarningsOrders", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getEarningsOrdersForHttpResponse(String accessToken, String xeroTenantId, Integer page) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getEarningsOrders");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getEarningsOrders");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/EarningsOrders"));
        if (page != null) {
            String key = "page";
            Integer value = page;
            if (value instanceof Collection) {
                ArrayList valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public EarningsRateObject getEarningsRate(String accessToken, String xeroTenantId, UUID earningsRateID) throws IOException {
        try {
            TypeReference<EarningsRateObject> typeRef = new TypeReference<EarningsRateObject>(){};
            HttpResponse response = this.getEarningsRateForHttpResponse(accessToken, xeroTenantId, earningsRateID);
            return (EarningsRateObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getEarningsRate -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<EarningsRateObject> errorTypeRef = new TypeReference<EarningsRateObject>(){};
                EarningsRateObject object = (EarningsRateObject)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "EarningsRateObject", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getEarningsRateForHttpResponse(String accessToken, String xeroTenantId, UUID earningsRateID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getEarningsRate");
        }
        if (earningsRateID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'earningsRateID' when calling getEarningsRate");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getEarningsRate");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("EarningsRateID", earningsRateID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/EarningsRates/{EarningsRateID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public EarningsRates getEarningsRates(String accessToken, String xeroTenantId, Integer page) throws IOException {
        try {
            TypeReference<EarningsRates> typeRef = new TypeReference<EarningsRates>(){};
            HttpResponse response = this.getEarningsRatesForHttpResponse(accessToken, xeroTenantId, page);
            return (EarningsRates)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getEarningsRates -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<EarningsRates> errorTypeRef = new TypeReference<EarningsRates>(){};
                EarningsRates object = (EarningsRates)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "EarningsRates", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getEarningsRatesForHttpResponse(String accessToken, String xeroTenantId, Integer page) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getEarningsRates");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getEarningsRates");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/EarningsRates"));
        if (page != null) {
            String key = "page";
            Integer value = page;
            if (value instanceof Collection) {
                ArrayList valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public EmployeeObject getEmployee(String accessToken, String xeroTenantId, UUID employeeID) throws IOException {
        try {
            TypeReference<EmployeeObject> typeRef = new TypeReference<EmployeeObject>(){};
            HttpResponse response = this.getEmployeeForHttpResponse(accessToken, xeroTenantId, employeeID);
            return (EmployeeObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getEmployee -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<EmployeeObject> errorTypeRef = new TypeReference<EmployeeObject>(){};
                EmployeeObject object = (EmployeeObject)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "EmployeeObject", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getEmployeeForHttpResponse(String accessToken, String xeroTenantId, UUID employeeID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getEmployee");
        }
        if (employeeID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'employeeID' when calling getEmployee");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getEmployee");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("EmployeeID", employeeID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Employees/{EmployeeID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public EmployeeLeaveObject getEmployeeLeave(String accessToken, String xeroTenantId, UUID employeeID, UUID leaveID) throws IOException {
        try {
            TypeReference<EmployeeLeaveObject> typeRef = new TypeReference<EmployeeLeaveObject>(){};
            HttpResponse response = this.getEmployeeLeaveForHttpResponse(accessToken, xeroTenantId, employeeID, leaveID);
            return (EmployeeLeaveObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getEmployeeLeave -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<EmployeeLeaveObject> errorTypeRef = new TypeReference<EmployeeLeaveObject>(){};
                EmployeeLeaveObject object = (EmployeeLeaveObject)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "EmployeeLeaveObject", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getEmployeeLeaveForHttpResponse(String accessToken, String xeroTenantId, UUID employeeID, UUID leaveID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getEmployeeLeave");
        }
        if (employeeID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'employeeID' when calling getEmployeeLeave");
        }
        if (leaveID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'leaveID' when calling getEmployeeLeave");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getEmployeeLeave");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("EmployeeID", employeeID);
        uriVariables.put("LeaveID", leaveID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Employees/{EmployeeID}/Leave/{LeaveID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public EmployeeLeaveBalances getEmployeeLeaveBalances(String accessToken, String xeroTenantId, UUID employeeID) throws IOException {
        try {
            TypeReference<EmployeeLeaveBalances> typeRef = new TypeReference<EmployeeLeaveBalances>(){};
            HttpResponse response = this.getEmployeeLeaveBalancesForHttpResponse(accessToken, xeroTenantId, employeeID);
            return (EmployeeLeaveBalances)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getEmployeeLeaveBalances -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<EmployeeLeaveBalances> errorTypeRef = new TypeReference<EmployeeLeaveBalances>(){};
                EmployeeLeaveBalances object = (EmployeeLeaveBalances)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "EmployeeLeaveBalances", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getEmployeeLeaveBalancesForHttpResponse(String accessToken, String xeroTenantId, UUID employeeID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getEmployeeLeaveBalances");
        }
        if (employeeID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'employeeID' when calling getEmployeeLeaveBalances");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getEmployeeLeaveBalances");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("EmployeeID", employeeID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Employees/{EmployeeID}/LeaveBalances"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public LeavePeriods getEmployeeLeavePeriods(String accessToken, String xeroTenantId, UUID employeeID, LocalDate startDate, LocalDate endDate) throws IOException {
        try {
            TypeReference<LeavePeriods> typeRef = new TypeReference<LeavePeriods>(){};
            HttpResponse response = this.getEmployeeLeavePeriodsForHttpResponse(accessToken, xeroTenantId, employeeID, startDate, endDate);
            return (LeavePeriods)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getEmployeeLeavePeriods -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<LeavePeriods> errorTypeRef = new TypeReference<LeavePeriods>(){};
                LeavePeriods object = (LeavePeriods)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "LeavePeriods", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getEmployeeLeavePeriodsForHttpResponse(String accessToken, String xeroTenantId, UUID employeeID, LocalDate startDate, LocalDate endDate) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        LocalDate value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getEmployeeLeavePeriods");
        }
        if (employeeID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'employeeID' when calling getEmployeeLeavePeriods");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getEmployeeLeavePeriods");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("EmployeeID", employeeID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Employees/{EmployeeID}/LeavePeriods"));
        if (startDate != null) {
            key = "startDate";
            value = startDate;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (endDate != null) {
            key = "endDate";
            value = endDate;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public EmployeeLeaveTypes getEmployeeLeaveTypes(String accessToken, String xeroTenantId, UUID employeeID) throws IOException {
        try {
            TypeReference<EmployeeLeaveTypes> typeRef = new TypeReference<EmployeeLeaveTypes>(){};
            HttpResponse response = this.getEmployeeLeaveTypesForHttpResponse(accessToken, xeroTenantId, employeeID);
            return (EmployeeLeaveTypes)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getEmployeeLeaveTypes -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<EmployeeLeaveTypes> errorTypeRef = new TypeReference<EmployeeLeaveTypes>(){};
                EmployeeLeaveTypes object = (EmployeeLeaveTypes)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "EmployeeLeaveTypes", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getEmployeeLeaveTypesForHttpResponse(String accessToken, String xeroTenantId, UUID employeeID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getEmployeeLeaveTypes");
        }
        if (employeeID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'employeeID' when calling getEmployeeLeaveTypes");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getEmployeeLeaveTypes");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("EmployeeID", employeeID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Employees/{EmployeeID}/LeaveTypes"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public EmployeeLeaves getEmployeeLeaves(String accessToken, String xeroTenantId, UUID employeeID) throws IOException {
        try {
            TypeReference<EmployeeLeaves> typeRef = new TypeReference<EmployeeLeaves>(){};
            HttpResponse response = this.getEmployeeLeavesForHttpResponse(accessToken, xeroTenantId, employeeID);
            return (EmployeeLeaves)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getEmployeeLeaves -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<EmployeeLeaves> errorTypeRef = new TypeReference<EmployeeLeaves>(){};
                EmployeeLeaves object = (EmployeeLeaves)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "EmployeeLeaves", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getEmployeeLeavesForHttpResponse(String accessToken, String xeroTenantId, UUID employeeID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getEmployeeLeaves");
        }
        if (employeeID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'employeeID' when calling getEmployeeLeaves");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getEmployeeLeaves");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("EmployeeID", employeeID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Employees/{EmployeeID}/Leave"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public EmployeeOpeningBalancesObject getEmployeeOpeningBalances(String accessToken, String xeroTenantId, UUID employeeID) throws IOException {
        try {
            TypeReference<EmployeeOpeningBalancesObject> typeRef = new TypeReference<EmployeeOpeningBalancesObject>(){};
            HttpResponse response = this.getEmployeeOpeningBalancesForHttpResponse(accessToken, xeroTenantId, employeeID);
            return (EmployeeOpeningBalancesObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getEmployeeOpeningBalances -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<EmployeeOpeningBalancesObject> errorTypeRef = new TypeReference<EmployeeOpeningBalancesObject>(){};
                EmployeeOpeningBalancesObject object = (EmployeeOpeningBalancesObject)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "EmployeeOpeningBalancesObject", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getEmployeeOpeningBalancesForHttpResponse(String accessToken, String xeroTenantId, UUID employeeID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getEmployeeOpeningBalances");
        }
        if (employeeID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'employeeID' when calling getEmployeeOpeningBalances");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getEmployeeOpeningBalances");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("EmployeeID", employeeID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Employees/{EmployeeID}/ukopeningbalances"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public EmployeePayTemplateObject getEmployeePayTemplate(String accessToken, String xeroTenantId, UUID employeeID) throws IOException {
        try {
            TypeReference<EmployeePayTemplateObject> typeRef = new TypeReference<EmployeePayTemplateObject>(){};
            HttpResponse response = this.getEmployeePayTemplateForHttpResponse(accessToken, xeroTenantId, employeeID);
            return (EmployeePayTemplateObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getEmployeePayTemplate -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<EmployeePayTemplateObject> errorTypeRef = new TypeReference<EmployeePayTemplateObject>(){};
                EmployeePayTemplateObject object = (EmployeePayTemplateObject)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "EmployeePayTemplateObject", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getEmployeePayTemplateForHttpResponse(String accessToken, String xeroTenantId, UUID employeeID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getEmployeePayTemplate");
        }
        if (employeeID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'employeeID' when calling getEmployeePayTemplate");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getEmployeePayTemplate");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("EmployeeID", employeeID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Employees/{EmployeeID}/PayTemplates"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public PaymentMethodObject getEmployeePaymentMethod(String accessToken, String xeroTenantId, UUID employeeID) throws IOException {
        try {
            TypeReference<PaymentMethodObject> typeRef = new TypeReference<PaymentMethodObject>(){};
            HttpResponse response = this.getEmployeePaymentMethodForHttpResponse(accessToken, xeroTenantId, employeeID);
            return (PaymentMethodObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getEmployeePaymentMethod -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<PaymentMethodObject> errorTypeRef = new TypeReference<PaymentMethodObject>(){};
                PaymentMethodObject object = (PaymentMethodObject)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "PaymentMethodObject", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getEmployeePaymentMethodForHttpResponse(String accessToken, String xeroTenantId, UUID employeeID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getEmployeePaymentMethod");
        }
        if (employeeID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'employeeID' when calling getEmployeePaymentMethod");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getEmployeePaymentMethod");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("EmployeeID", employeeID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Employees/{EmployeeID}/PaymentMethods"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public SalaryAndWages getEmployeeSalaryAndWage(String accessToken, String xeroTenantId, UUID employeeID, UUID salaryAndWagesID) throws IOException {
        try {
            TypeReference<SalaryAndWages> typeRef = new TypeReference<SalaryAndWages>(){};
            HttpResponse response = this.getEmployeeSalaryAndWageForHttpResponse(accessToken, xeroTenantId, employeeID, salaryAndWagesID);
            return (SalaryAndWages)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getEmployeeSalaryAndWage -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<SalaryAndWages> errorTypeRef = new TypeReference<SalaryAndWages>(){};
                SalaryAndWages object = (SalaryAndWages)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "SalaryAndWages", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getEmployeeSalaryAndWageForHttpResponse(String accessToken, String xeroTenantId, UUID employeeID, UUID salaryAndWagesID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getEmployeeSalaryAndWage");
        }
        if (employeeID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'employeeID' when calling getEmployeeSalaryAndWage");
        }
        if (salaryAndWagesID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'salaryAndWagesID' when calling getEmployeeSalaryAndWage");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getEmployeeSalaryAndWage");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("EmployeeID", employeeID);
        uriVariables.put("SalaryAndWagesID", salaryAndWagesID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Employees/{EmployeeID}/SalaryAndWages/{SalaryAndWagesID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public SalaryAndWages getEmployeeSalaryAndWages(String accessToken, String xeroTenantId, UUID employeeID, Integer page) throws IOException {
        try {
            TypeReference<SalaryAndWages> typeRef = new TypeReference<SalaryAndWages>(){};
            HttpResponse response = this.getEmployeeSalaryAndWagesForHttpResponse(accessToken, xeroTenantId, employeeID, page);
            return (SalaryAndWages)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getEmployeeSalaryAndWages -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<SalaryAndWages> errorTypeRef = new TypeReference<SalaryAndWages>(){};
                SalaryAndWages object = (SalaryAndWages)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "SalaryAndWages", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getEmployeeSalaryAndWagesForHttpResponse(String accessToken, String xeroTenantId, UUID employeeID, Integer page) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getEmployeeSalaryAndWages");
        }
        if (employeeID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'employeeID' when calling getEmployeeSalaryAndWages");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getEmployeeSalaryAndWages");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("EmployeeID", employeeID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Employees/{EmployeeID}/SalaryAndWages"));
        if (page != null) {
            String key = "page";
            Integer value = page;
            if (value instanceof Collection) {
                ArrayList valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public EmployeeStatutoryLeaveBalanceObject getEmployeeStatutoryLeaveBalances(String accessToken, String xeroTenantId, UUID employeeID, String leaveType, LocalDate asOfDate) throws IOException {
        try {
            TypeReference<EmployeeStatutoryLeaveBalanceObject> typeRef = new TypeReference<EmployeeStatutoryLeaveBalanceObject>(){};
            HttpResponse response = this.getEmployeeStatutoryLeaveBalancesForHttpResponse(accessToken, xeroTenantId, employeeID, leaveType, asOfDate);
            return (EmployeeStatutoryLeaveBalanceObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getEmployeeStatutoryLeaveBalances -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<EmployeeStatutoryLeaveBalanceObject> errorTypeRef = new TypeReference<EmployeeStatutoryLeaveBalanceObject>(){};
                EmployeeStatutoryLeaveBalanceObject object = (EmployeeStatutoryLeaveBalanceObject)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "EmployeeStatutoryLeaveBalanceObject", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getEmployeeStatutoryLeaveBalancesForHttpResponse(String accessToken, String xeroTenantId, UUID employeeID, String leaveType, LocalDate asOfDate) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        String value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getEmployeeStatutoryLeaveBalances");
        }
        if (employeeID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'employeeID' when calling getEmployeeStatutoryLeaveBalances");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getEmployeeStatutoryLeaveBalances");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("EmployeeID", employeeID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Employees/{EmployeeID}/StatutoryLeaveBalance"));
        if (leaveType != null) {
            key = "LeaveType";
            value = leaveType;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (asOfDate != null) {
            key = "AsOfDate";
            value = asOfDate;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public EmployeeStatutorySickLeaveObject getEmployeeStatutorySickLeave(String accessToken, String xeroTenantId, UUID statutorySickLeaveID) throws IOException {
        try {
            TypeReference<EmployeeStatutorySickLeaveObject> typeRef = new TypeReference<EmployeeStatutorySickLeaveObject>(){};
            HttpResponse response = this.getEmployeeStatutorySickLeaveForHttpResponse(accessToken, xeroTenantId, statutorySickLeaveID);
            return (EmployeeStatutorySickLeaveObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getEmployeeStatutorySickLeave -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<EmployeeStatutorySickLeaveObject> errorTypeRef = new TypeReference<EmployeeStatutorySickLeaveObject>(){};
                EmployeeStatutorySickLeaveObject object = (EmployeeStatutorySickLeaveObject)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "EmployeeStatutorySickLeaveObject", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getEmployeeStatutorySickLeaveForHttpResponse(String accessToken, String xeroTenantId, UUID statutorySickLeaveID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getEmployeeStatutorySickLeave");
        }
        if (statutorySickLeaveID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'statutorySickLeaveID' when calling getEmployeeStatutorySickLeave");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getEmployeeStatutorySickLeave");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("StatutorySickLeaveID", statutorySickLeaveID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/StatutoryLeaves/Sick/{StatutorySickLeaveID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public EmployeeTaxObject getEmployeeTax(String accessToken, String xeroTenantId, UUID employeeID) throws IOException {
        try {
            TypeReference<EmployeeTaxObject> typeRef = new TypeReference<EmployeeTaxObject>(){};
            HttpResponse response = this.getEmployeeTaxForHttpResponse(accessToken, xeroTenantId, employeeID);
            return (EmployeeTaxObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getEmployeeTax -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<EmployeeTaxObject> errorTypeRef = new TypeReference<EmployeeTaxObject>(){};
                EmployeeTaxObject object = (EmployeeTaxObject)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "EmployeeTaxObject", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getEmployeeTaxForHttpResponse(String accessToken, String xeroTenantId, UUID employeeID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getEmployeeTax");
        }
        if (employeeID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'employeeID' when calling getEmployeeTax");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getEmployeeTax");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("EmployeeID", employeeID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Employees/{EmployeeID}/Tax"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Employees getEmployees(String accessToken, String xeroTenantId, String filter, Integer page) throws IOException {
        try {
            TypeReference<Employees> typeRef = new TypeReference<Employees>(){};
            HttpResponse response = this.getEmployeesForHttpResponse(accessToken, xeroTenantId, filter, page);
            return (Employees)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getEmployees -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<Employees> errorTypeRef = new TypeReference<Employees>(){};
                Employees object = (Employees)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "Employees", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getEmployeesForHttpResponse(String accessToken, String xeroTenantId, String filter, Integer page) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        Object value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getEmployees");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getEmployees");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Employees"));
        if (filter != null) {
            key = "filter";
            value = filter;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (page != null) {
            key = "page";
            value = page;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public LeaveTypeObject getLeaveType(String accessToken, String xeroTenantId, UUID leaveTypeID) throws IOException {
        try {
            TypeReference<LeaveTypeObject> typeRef = new TypeReference<LeaveTypeObject>(){};
            HttpResponse response = this.getLeaveTypeForHttpResponse(accessToken, xeroTenantId, leaveTypeID);
            return (LeaveTypeObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getLeaveType -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<LeaveTypeObject> errorTypeRef = new TypeReference<LeaveTypeObject>(){};
                LeaveTypeObject object = (LeaveTypeObject)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "LeaveTypeObject", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getLeaveTypeForHttpResponse(String accessToken, String xeroTenantId, UUID leaveTypeID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getLeaveType");
        }
        if (leaveTypeID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'leaveTypeID' when calling getLeaveType");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getLeaveType");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("LeaveTypeID", leaveTypeID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/LeaveTypes/{LeaveTypeID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public LeaveTypes getLeaveTypes(String accessToken, String xeroTenantId, Integer page, Boolean activeOnly) throws IOException {
        try {
            TypeReference<LeaveTypes> typeRef = new TypeReference<LeaveTypes>(){};
            HttpResponse response = this.getLeaveTypesForHttpResponse(accessToken, xeroTenantId, page, activeOnly);
            return (LeaveTypes)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getLeaveTypes -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<LeaveTypes> errorTypeRef = new TypeReference<LeaveTypes>(){};
                LeaveTypes object = (LeaveTypes)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "LeaveTypes", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getLeaveTypesForHttpResponse(String accessToken, String xeroTenantId, Integer page, Boolean activeOnly) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        Constable value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getLeaveTypes");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getLeaveTypes");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/LeaveTypes"));
        if (page != null) {
            key = "page";
            value = page;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (activeOnly != null) {
            key = "ActiveOnly";
            value = activeOnly;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public PayRunObject getPayRun(String accessToken, String xeroTenantId, UUID payRunID) throws IOException {
        try {
            TypeReference<PayRunObject> typeRef = new TypeReference<PayRunObject>(){};
            HttpResponse response = this.getPayRunForHttpResponse(accessToken, xeroTenantId, payRunID);
            return (PayRunObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getPayRun -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<PayRunObject> errorTypeRef = new TypeReference<PayRunObject>(){};
                PayRunObject object = (PayRunObject)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "PayRunObject", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getPayRunForHttpResponse(String accessToken, String xeroTenantId, UUID payRunID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getPayRun");
        }
        if (payRunID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'payRunID' when calling getPayRun");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getPayRun");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("PayRunID", payRunID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/PayRuns/{PayRunID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public PayRunCalendarObject getPayRunCalendar(String accessToken, String xeroTenantId, UUID payRunCalendarID) throws IOException {
        try {
            TypeReference<PayRunCalendarObject> typeRef = new TypeReference<PayRunCalendarObject>(){};
            HttpResponse response = this.getPayRunCalendarForHttpResponse(accessToken, xeroTenantId, payRunCalendarID);
            return (PayRunCalendarObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getPayRunCalendar -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<PayRunCalendarObject> errorTypeRef = new TypeReference<PayRunCalendarObject>(){};
                PayRunCalendarObject object = (PayRunCalendarObject)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "PayRunCalendarObject", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getPayRunCalendarForHttpResponse(String accessToken, String xeroTenantId, UUID payRunCalendarID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getPayRunCalendar");
        }
        if (payRunCalendarID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'payRunCalendarID' when calling getPayRunCalendar");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getPayRunCalendar");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("PayRunCalendarID", payRunCalendarID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/PayRunCalendars/{PayRunCalendarID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public PayRunCalendars getPayRunCalendars(String accessToken, String xeroTenantId, Integer page) throws IOException {
        try {
            TypeReference<PayRunCalendars> typeRef = new TypeReference<PayRunCalendars>(){};
            HttpResponse response = this.getPayRunCalendarsForHttpResponse(accessToken, xeroTenantId, page);
            return (PayRunCalendars)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getPayRunCalendars -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<PayRunCalendars> errorTypeRef = new TypeReference<PayRunCalendars>(){};
                PayRunCalendars object = (PayRunCalendars)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "PayRunCalendars", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getPayRunCalendarsForHttpResponse(String accessToken, String xeroTenantId, Integer page) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getPayRunCalendars");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getPayRunCalendars");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/PayRunCalendars"));
        if (page != null) {
            String key = "page";
            Integer value = page;
            if (value instanceof Collection) {
                ArrayList valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public PayRuns getPayRuns(String accessToken, String xeroTenantId, Integer page, String status) throws IOException {
        try {
            TypeReference<PayRuns> typeRef = new TypeReference<PayRuns>(){};
            HttpResponse response = this.getPayRunsForHttpResponse(accessToken, xeroTenantId, page, status);
            return (PayRuns)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getPayRuns -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<PayRuns> errorTypeRef = new TypeReference<PayRuns>(){};
                PayRuns object = (PayRuns)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "PayRuns", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getPayRunsForHttpResponse(String accessToken, String xeroTenantId, Integer page, String status) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        Object value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getPayRuns");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getPayRuns");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/PayRuns"));
        if (page != null) {
            key = "page";
            value = page;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (status != null) {
            key = "status";
            value = status;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public PayslipObject getPaySlip(String accessToken, String xeroTenantId, UUID payslipID) throws IOException {
        try {
            TypeReference<PayslipObject> typeRef = new TypeReference<PayslipObject>(){};
            HttpResponse response = this.getPaySlipForHttpResponse(accessToken, xeroTenantId, payslipID);
            return (PayslipObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getPaySlip -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<PayslipObject> errorTypeRef = new TypeReference<PayslipObject>(){};
                PayslipObject object = (PayslipObject)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "PayslipObject", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getPaySlipForHttpResponse(String accessToken, String xeroTenantId, UUID payslipID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getPaySlip");
        }
        if (payslipID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'payslipID' when calling getPaySlip");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getPaySlip");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("PayslipID", payslipID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Payslips/{PayslipID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Payslips getPaySlips(String accessToken, String xeroTenantId, UUID payRunID, Integer page) throws IOException {
        try {
            TypeReference<Payslips> typeRef = new TypeReference<Payslips>(){};
            HttpResponse response = this.getPaySlipsForHttpResponse(accessToken, xeroTenantId, payRunID, page);
            return (Payslips)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getPaySlips -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<Payslips> errorTypeRef = new TypeReference<Payslips>(){};
                Payslips object = (Payslips)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "Payslips", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getPaySlipsForHttpResponse(String accessToken, String xeroTenantId, UUID payRunID, Integer page) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        Comparable<Integer> value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getPaySlips");
        }
        if (payRunID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'payRunID' when calling getPaySlips");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getPaySlips");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Payslips"));
        if (page != null) {
            key = "page";
            value = page;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (payRunID != null) {
            key = "PayRunID";
            value = payRunID;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ReimbursementObject getReimbursement(String accessToken, String xeroTenantId, UUID reimbursementID) throws IOException {
        try {
            TypeReference<ReimbursementObject> typeRef = new TypeReference<ReimbursementObject>(){};
            HttpResponse response = this.getReimbursementForHttpResponse(accessToken, xeroTenantId, reimbursementID);
            return (ReimbursementObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getReimbursement -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<ReimbursementObject> errorTypeRef = new TypeReference<ReimbursementObject>(){};
                ReimbursementObject object = (ReimbursementObject)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "ReimbursementObject", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getReimbursementForHttpResponse(String accessToken, String xeroTenantId, UUID reimbursementID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getReimbursement");
        }
        if (reimbursementID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'reimbursementID' when calling getReimbursement");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getReimbursement");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("ReimbursementID", reimbursementID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Reimbursements/{ReimbursementID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Reimbursements getReimbursements(String accessToken, String xeroTenantId, Integer page) throws IOException {
        try {
            TypeReference<Reimbursements> typeRef = new TypeReference<Reimbursements>(){};
            HttpResponse response = this.getReimbursementsForHttpResponse(accessToken, xeroTenantId, page);
            return (Reimbursements)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getReimbursements -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<Reimbursements> errorTypeRef = new TypeReference<Reimbursements>(){};
                Reimbursements object = (Reimbursements)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "Reimbursements", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getReimbursementsForHttpResponse(String accessToken, String xeroTenantId, Integer page) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getReimbursements");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getReimbursements");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Reimbursements"));
        if (page != null) {
            String key = "page";
            Integer value = page;
            if (value instanceof Collection) {
                ArrayList valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Settings getSettings(String accessToken, String xeroTenantId) throws IOException {
        try {
            TypeReference<Settings> typeRef = new TypeReference<Settings>(){};
            HttpResponse response = this.getSettingsForHttpResponse(accessToken, xeroTenantId);
            return (Settings)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getSettings -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<Settings> errorTypeRef = new TypeReference<Settings>(){};
                Settings object = (Settings)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "Settings", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getSettingsForHttpResponse(String accessToken, String xeroTenantId) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getSettings");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getSettings");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Settings"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public EmployeeStatutoryLeavesSummaries getStatutoryLeaveSummary(String accessToken, String xeroTenantId, UUID employeeID, Boolean activeOnly) throws IOException {
        try {
            TypeReference<EmployeeStatutoryLeavesSummaries> typeRef = new TypeReference<EmployeeStatutoryLeavesSummaries>(){};
            HttpResponse response = this.getStatutoryLeaveSummaryForHttpResponse(accessToken, xeroTenantId, employeeID, activeOnly);
            return (EmployeeStatutoryLeavesSummaries)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getStatutoryLeaveSummary -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<EmployeeStatutoryLeavesSummaries> errorTypeRef = new TypeReference<EmployeeStatutoryLeavesSummaries>(){};
                EmployeeStatutoryLeavesSummaries object = (EmployeeStatutoryLeavesSummaries)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "EmployeeStatutoryLeavesSummaries", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getStatutoryLeaveSummaryForHttpResponse(String accessToken, String xeroTenantId, UUID employeeID, Boolean activeOnly) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getStatutoryLeaveSummary");
        }
        if (employeeID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'employeeID' when calling getStatutoryLeaveSummary");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getStatutoryLeaveSummary");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("EmployeeID", employeeID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/StatutoryLeaves/Summary/{EmployeeID}"));
        if (activeOnly != null) {
            String key = "activeOnly";
            Boolean value = activeOnly;
            if (value instanceof Collection) {
                ArrayList valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public TimesheetObject getTimesheet(String accessToken, String xeroTenantId, UUID timesheetID) throws IOException {
        try {
            TypeReference<TimesheetObject> typeRef = new TypeReference<TimesheetObject>(){};
            HttpResponse response = this.getTimesheetForHttpResponse(accessToken, xeroTenantId, timesheetID);
            return (TimesheetObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getTimesheet -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<TimesheetObject> errorTypeRef = new TypeReference<TimesheetObject>(){};
                TimesheetObject object = (TimesheetObject)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "TimesheetObject", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getTimesheetForHttpResponse(String accessToken, String xeroTenantId, UUID timesheetID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getTimesheet");
        }
        if (timesheetID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'timesheetID' when calling getTimesheet");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getTimesheet");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("TimesheetID", timesheetID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Timesheets/{TimesheetID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Timesheets getTimesheets(String accessToken, String xeroTenantId, Integer page, String filter, String status, String startDate, String endDate, String sort) throws IOException {
        try {
            TypeReference<Timesheets> typeRef = new TypeReference<Timesheets>(){};
            HttpResponse response = this.getTimesheetsForHttpResponse(accessToken, xeroTenantId, page, filter, status, startDate, endDate, sort);
            return (Timesheets)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getTimesheets -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<Timesheets> errorTypeRef = new TypeReference<Timesheets>(){};
                Timesheets object = (Timesheets)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "Timesheets", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getTimesheetsForHttpResponse(String accessToken, String xeroTenantId, Integer page, String filter, String status, String startDate, String endDate, String sort) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        Object value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getTimesheets");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getTimesheets");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Timesheets"));
        if (page != null) {
            key = "page";
            value = page;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (filter != null) {
            key = "filter";
            value = filter;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (status != null) {
            key = "status";
            value = status;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (startDate != null) {
            key = "startDate";
            value = startDate;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (endDate != null) {
            key = "endDate";
            value = endDate;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (sort != null) {
            key = "sort";
            value = sort;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public TrackingCategories getTrackingCategories(String accessToken, String xeroTenantId) throws IOException {
        try {
            TypeReference<TrackingCategories> typeRef = new TypeReference<TrackingCategories>(){};
            HttpResponse response = this.getTrackingCategoriesForHttpResponse(accessToken, xeroTenantId);
            return (TrackingCategories)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getTrackingCategories -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<TrackingCategories> errorTypeRef = new TypeReference<TrackingCategories>(){};
                TrackingCategories object = (TrackingCategories)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "TrackingCategories", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getTrackingCategoriesForHttpResponse(String accessToken, String xeroTenantId) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getTrackingCategories");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getTrackingCategories");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Settings/trackingCategories"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public TimesheetObject revertTimesheet(String accessToken, String xeroTenantId, UUID timesheetID, String idempotencyKey) throws IOException {
        try {
            TypeReference<TimesheetObject> typeRef = new TypeReference<TimesheetObject>(){};
            HttpResponse response = this.revertTimesheetForHttpResponse(accessToken, xeroTenantId, timesheetID, idempotencyKey);
            return (TimesheetObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : revertTimesheet -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<TimesheetObject> errorTypeRef = new TypeReference<TimesheetObject>(){};
                TimesheetObject object = (TimesheetObject)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "TimesheetObject", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse revertTimesheetForHttpResponse(String accessToken, String xeroTenantId, UUID timesheetID, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling revertTimesheet");
        }
        if (timesheetID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'timesheetID' when calling revertTimesheet");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling revertTimesheet");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("TimesheetID", timesheetID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Timesheets/{TimesheetID}/RevertToDraft"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public EmployeeObject updateEmployee(String accessToken, String xeroTenantId, UUID employeeID, Employee employee, String idempotencyKey) throws IOException {
        try {
            TypeReference<EmployeeObject> typeRef = new TypeReference<EmployeeObject>(){};
            HttpResponse response = this.updateEmployeeForHttpResponse(accessToken, xeroTenantId, employeeID, employee, idempotencyKey);
            return (EmployeeObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updateEmployee -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<EmployeeObject> errorTypeRef = new TypeReference<EmployeeObject>(){};
                EmployeeObject object = (EmployeeObject)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "EmployeeObject", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse updateEmployeeForHttpResponse(String accessToken, String xeroTenantId, UUID employeeID, Employee employee, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updateEmployee");
        }
        if (employeeID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'employeeID' when calling updateEmployee");
        }
        if (employee == null) {
            throw new IllegalArgumentException("Missing the required parameter 'employee' when calling updateEmployee");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updateEmployee");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("EmployeeID", employeeID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Employees/{EmployeeID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(employee);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public EarningsTemplateObject updateEmployeeEarningsTemplate(String accessToken, String xeroTenantId, UUID employeeID, UUID payTemplateEarningID, EarningsTemplate earningsTemplate, String idempotencyKey) throws IOException {
        try {
            TypeReference<EarningsTemplateObject> typeRef = new TypeReference<EarningsTemplateObject>(){};
            HttpResponse response = this.updateEmployeeEarningsTemplateForHttpResponse(accessToken, xeroTenantId, employeeID, payTemplateEarningID, earningsTemplate, idempotencyKey);
            return (EarningsTemplateObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updateEmployeeEarningsTemplate -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<EarningsTemplateObject> errorTypeRef = new TypeReference<EarningsTemplateObject>(){};
                EarningsTemplateObject object = (EarningsTemplateObject)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "EarningsTemplateObject", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse updateEmployeeEarningsTemplateForHttpResponse(String accessToken, String xeroTenantId, UUID employeeID, UUID payTemplateEarningID, EarningsTemplate earningsTemplate, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updateEmployeeEarningsTemplate");
        }
        if (employeeID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'employeeID' when calling updateEmployeeEarningsTemplate");
        }
        if (payTemplateEarningID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'payTemplateEarningID' when calling updateEmployeeEarningsTemplate");
        }
        if (earningsTemplate == null) {
            throw new IllegalArgumentException("Missing the required parameter 'earningsTemplate' when calling updateEmployeeEarningsTemplate");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updateEmployeeEarningsTemplate");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("EmployeeID", employeeID);
        uriVariables.put("PayTemplateEarningID", payTemplateEarningID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Employees/{EmployeeID}/PayTemplates/earnings/{PayTemplateEarningID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(earningsTemplate);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public EmployeeLeaveObject updateEmployeeLeave(String accessToken, String xeroTenantId, UUID employeeID, UUID leaveID, EmployeeLeave employeeLeave, String idempotencyKey) throws IOException {
        try {
            TypeReference<EmployeeLeaveObject> typeRef = new TypeReference<EmployeeLeaveObject>(){};
            HttpResponse response = this.updateEmployeeLeaveForHttpResponse(accessToken, xeroTenantId, employeeID, leaveID, employeeLeave, idempotencyKey);
            return (EmployeeLeaveObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updateEmployeeLeave -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<EmployeeLeaveObject> errorTypeRef = new TypeReference<EmployeeLeaveObject>(){};
                EmployeeLeaveObject object = (EmployeeLeaveObject)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "EmployeeLeaveObject", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse updateEmployeeLeaveForHttpResponse(String accessToken, String xeroTenantId, UUID employeeID, UUID leaveID, EmployeeLeave employeeLeave, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updateEmployeeLeave");
        }
        if (employeeID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'employeeID' when calling updateEmployeeLeave");
        }
        if (leaveID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'leaveID' when calling updateEmployeeLeave");
        }
        if (employeeLeave == null) {
            throw new IllegalArgumentException("Missing the required parameter 'employeeLeave' when calling updateEmployeeLeave");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updateEmployeeLeave");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("EmployeeID", employeeID);
        uriVariables.put("LeaveID", leaveID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Employees/{EmployeeID}/Leave/{LeaveID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(employeeLeave);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public EmployeeOpeningBalancesObject updateEmployeeOpeningBalances(String accessToken, String xeroTenantId, UUID employeeID, EmployeeOpeningBalances employeeOpeningBalances, String idempotencyKey) throws IOException {
        try {
            TypeReference<EmployeeOpeningBalancesObject> typeRef = new TypeReference<EmployeeOpeningBalancesObject>(){};
            HttpResponse response = this.updateEmployeeOpeningBalancesForHttpResponse(accessToken, xeroTenantId, employeeID, employeeOpeningBalances, idempotencyKey);
            return (EmployeeOpeningBalancesObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updateEmployeeOpeningBalances -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<EmployeeOpeningBalancesObject> errorTypeRef = new TypeReference<EmployeeOpeningBalancesObject>(){};
                EmployeeOpeningBalancesObject object = (EmployeeOpeningBalancesObject)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "EmployeeOpeningBalancesObject", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse updateEmployeeOpeningBalancesForHttpResponse(String accessToken, String xeroTenantId, UUID employeeID, EmployeeOpeningBalances employeeOpeningBalances, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updateEmployeeOpeningBalances");
        }
        if (employeeID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'employeeID' when calling updateEmployeeOpeningBalances");
        }
        if (employeeOpeningBalances == null) {
            throw new IllegalArgumentException("Missing the required parameter 'employeeOpeningBalances' when calling updateEmployeeOpeningBalances");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updateEmployeeOpeningBalances");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("EmployeeID", employeeID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Employees/{EmployeeID}/ukopeningbalances"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(employeeOpeningBalances);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public SalaryAndWageObject updateEmployeeSalaryAndWage(String accessToken, String xeroTenantId, UUID employeeID, UUID salaryAndWagesID, SalaryAndWage salaryAndWage, String idempotencyKey) throws IOException {
        try {
            TypeReference<SalaryAndWageObject> typeRef = new TypeReference<SalaryAndWageObject>(){};
            HttpResponse response = this.updateEmployeeSalaryAndWageForHttpResponse(accessToken, xeroTenantId, employeeID, salaryAndWagesID, salaryAndWage, idempotencyKey);
            return (SalaryAndWageObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updateEmployeeSalaryAndWage -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<SalaryAndWageObject> errorTypeRef = new TypeReference<SalaryAndWageObject>(){};
                SalaryAndWageObject object = (SalaryAndWageObject)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "SalaryAndWageObject", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse updateEmployeeSalaryAndWageForHttpResponse(String accessToken, String xeroTenantId, UUID employeeID, UUID salaryAndWagesID, SalaryAndWage salaryAndWage, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updateEmployeeSalaryAndWage");
        }
        if (employeeID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'employeeID' when calling updateEmployeeSalaryAndWage");
        }
        if (salaryAndWagesID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'salaryAndWagesID' when calling updateEmployeeSalaryAndWage");
        }
        if (salaryAndWage == null) {
            throw new IllegalArgumentException("Missing the required parameter 'salaryAndWage' when calling updateEmployeeSalaryAndWage");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updateEmployeeSalaryAndWage");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("EmployeeID", employeeID);
        uriVariables.put("SalaryAndWagesID", salaryAndWagesID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Employees/{EmployeeID}/SalaryAndWages/{SalaryAndWagesID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(salaryAndWage);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public PayRunObject updatePayRun(String accessToken, String xeroTenantId, UUID payRunID, PayRun payRun, String idempotencyKey) throws IOException {
        try {
            TypeReference<PayRunObject> typeRef = new TypeReference<PayRunObject>(){};
            HttpResponse response = this.updatePayRunForHttpResponse(accessToken, xeroTenantId, payRunID, payRun, idempotencyKey);
            return (PayRunObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updatePayRun -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<PayRunObject> errorTypeRef = new TypeReference<PayRunObject>(){};
                PayRunObject object = (PayRunObject)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "PayRunObject", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse updatePayRunForHttpResponse(String accessToken, String xeroTenantId, UUID payRunID, PayRun payRun, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updatePayRun");
        }
        if (payRunID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'payRunID' when calling updatePayRun");
        }
        if (payRun == null) {
            throw new IllegalArgumentException("Missing the required parameter 'payRun' when calling updatePayRun");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updatePayRun");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("PayRunID", payRunID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/PayRuns/{PayRunID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(payRun);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public TimesheetLineObject updateTimesheetLine(String accessToken, String xeroTenantId, UUID timesheetID, UUID timesheetLineID, TimesheetLine timesheetLine, String idempotencyKey) throws IOException {
        try {
            TypeReference<TimesheetLineObject> typeRef = new TypeReference<TimesheetLineObject>(){};
            HttpResponse response = this.updateTimesheetLineForHttpResponse(accessToken, xeroTenantId, timesheetID, timesheetLineID, timesheetLine, idempotencyKey);
            return (TimesheetLineObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updateTimesheetLine -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<TimesheetLineObject> errorTypeRef = new TypeReference<TimesheetLineObject>(){};
                TimesheetLineObject object = (TimesheetLineObject)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError((Integer)e.getStatusCode(), "TimesheetLineObject", object.getProblem(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse updateTimesheetLineForHttpResponse(String accessToken, String xeroTenantId, UUID timesheetID, UUID timesheetLineID, TimesheetLine timesheetLine, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updateTimesheetLine");
        }
        if (timesheetID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'timesheetID' when calling updateTimesheetLine");
        }
        if (timesheetLineID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'timesheetLineID' when calling updateTimesheetLine");
        }
        if (timesheetLine == null) {
            throw new IllegalArgumentException("Missing the required parameter 'timesheetLine' when calling updateTimesheetLine");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updateTimesheetLine");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("TimesheetID", timesheetID);
        uriVariables.put("TimesheetLineID", timesheetLineID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Timesheets/{TimesheetID}/Lines/{TimesheetLineID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(timesheetLine);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayInputStream convertInputToByteArray(InputStream is) throws IOException {
        byte[] bytes = IOUtils.toByteArray((InputStream)is);
        try {
            ByteArrayInputStream byteArrayInputStream;
            ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream = new ByteArrayInputStream(bytes);
            return byteArrayInputStream2;
        }
        finally {
            is.close();
        }
    }
}

