/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;

public class Attachment {
    StringUtil util = new StringUtil();
    @JsonProperty(value="AttachmentID")
    private UUID attachmentID;
    @JsonProperty(value="FileName")
    private String fileName;
    @JsonProperty(value="Url")
    private String url;
    @JsonProperty(value="MimeType")
    private String mimeType;
    @JsonProperty(value="ContentLength")
    private Integer contentLength;
    @JsonProperty(value="IncludeOnline")
    private Boolean includeOnline;

    public Attachment attachmentID(UUID attachmentID) {
        this.attachmentID = attachmentID;
        return this;
    }

    @ApiModelProperty(example="00000000-0000-0000-0000-000000000000", value="Unique ID for the file")
    public UUID getAttachmentID() {
        return this.attachmentID;
    }

    public void setAttachmentID(UUID attachmentID) {
        this.attachmentID = attachmentID;
    }

    public Attachment fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    @ApiModelProperty(example="xero-dev.jpg", value="Name of the file")
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Attachment url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(example="https://api.xero.com/api.xro/2.0/Accounts/da962997-a8bd-4dff-9616-01cdc199283f/Attachments/sample5.jpg", value="URL to the file on xero.com")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Attachment mimeType(String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    @ApiModelProperty(example="image/jpg", value="Type of file")
    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public Attachment contentLength(Integer contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    @ApiModelProperty(value="Length of the file content")
    public Integer getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(Integer contentLength) {
        this.contentLength = contentLength;
    }

    public Attachment includeOnline(Boolean includeOnline) {
        this.includeOnline = includeOnline;
        return this;
    }

    @ApiModelProperty(value="Include the file with the online invoice")
    public Boolean getIncludeOnline() {
        return this.includeOnline;
    }

    public void setIncludeOnline(Boolean includeOnline) {
        this.includeOnline = includeOnline;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attachment attachment = (Attachment)o;
        return Objects.equals(this.attachmentID, attachment.attachmentID) && Objects.equals(this.fileName, attachment.fileName) && Objects.equals(this.url, attachment.url) && Objects.equals(this.mimeType, attachment.mimeType) && Objects.equals(this.contentLength, attachment.contentLength) && Objects.equals(this.includeOnline, attachment.includeOnline);
    }

    public int hashCode() {
        return Objects.hash(this.attachmentID, this.fileName, this.url, this.mimeType, this.contentLength, this.includeOnline);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Attachment {\n");
        sb.append("    attachmentID: ").append(this.toIndentedString(this.attachmentID)).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.fileName)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    mimeType: ").append(this.toIndentedString(this.mimeType)).append("\n");
        sb.append("    contentLength: ").append(this.toIndentedString(this.contentLength)).append("\n");
        sb.append("    includeOnline: ").append(this.toIndentedString(this.includeOnline)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

