/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import com.xero.models.accounting.Account;
import com.xero.models.accounting.Contact;
import com.xero.models.accounting.CurrencyCode;
import com.xero.models.accounting.LineAmountTypes;
import com.xero.models.accounting.LineItem;
import com.xero.models.accounting.ValidationError;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.ZoneId;

public class BankTransaction {
    StringUtil util = new StringUtil();
    @JsonProperty(value="Type")
    private TypeEnum type;
    @JsonProperty(value="Contact")
    private Contact contact;
    @JsonProperty(value="LineItems")
    private List<LineItem> lineItems = new ArrayList<LineItem>();
    @JsonProperty(value="BankAccount")
    private Account bankAccount;
    @JsonProperty(value="IsReconciled")
    private Boolean isReconciled;
    @JsonProperty(value="Date")
    private String date;
    @JsonProperty(value="Reference")
    private String reference;
    @JsonProperty(value="CurrencyCode")
    private CurrencyCode currencyCode;
    @JsonProperty(value="CurrencyRate")
    private Double currencyRate;
    @JsonProperty(value="Url")
    private String url;
    @JsonProperty(value="Status")
    private StatusEnum status;
    @JsonProperty(value="LineAmountTypes")
    private LineAmountTypes lineAmountTypes;
    @JsonProperty(value="SubTotal")
    private Double subTotal;
    @JsonProperty(value="TotalTax")
    private Double totalTax;
    @JsonProperty(value="Total")
    private Double total;
    @JsonProperty(value="BankTransactionID")
    private UUID bankTransactionID;
    @JsonProperty(value="PrepaymentID")
    private UUID prepaymentID;
    @JsonProperty(value="OverpaymentID")
    private UUID overpaymentID;
    @JsonProperty(value="UpdatedDateUTC")
    private String updatedDateUTC;
    @JsonProperty(value="HasAttachments")
    private Boolean hasAttachments = false;
    @JsonProperty(value="StatusAttributeString")
    private String statusAttributeString;
    @JsonProperty(value="ValidationErrors")
    private List<ValidationError> validationErrors = new ArrayList<ValidationError>();

    public BankTransaction type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="See Bank Transaction Types")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public BankTransaction contact(Contact contact) {
        this.contact = contact;
        return this;
    }

    @ApiModelProperty(value="")
    public Contact getContact() {
        return this.contact;
    }

    public void setContact(Contact contact) {
        this.contact = contact;
    }

    public BankTransaction lineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
        return this;
    }

    public BankTransaction addLineItemsItem(LineItem lineItemsItem) {
        this.lineItems.add(lineItemsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="See LineItems")
    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    public void setLineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
    }

    public BankTransaction bankAccount(Account bankAccount) {
        this.bankAccount = bankAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Account getBankAccount() {
        return this.bankAccount;
    }

    public void setBankAccount(Account bankAccount) {
        this.bankAccount = bankAccount;
    }

    public BankTransaction isReconciled(Boolean isReconciled) {
        this.isReconciled = isReconciled;
        return this;
    }

    @ApiModelProperty(value="Boolean to show if transaction is reconciled")
    public Boolean getIsReconciled() {
        return this.isReconciled;
    }

    public void setIsReconciled(Boolean isReconciled) {
        this.isReconciled = isReconciled;
    }

    public BankTransaction date(String date) {
        this.date = date;
        return this;
    }

    @ApiModelProperty(value="Date of transaction \u2013 YYYY-MM-DD")
    public String getDate() {
        return this.date;
    }

    public LocalDate getDateAsDate() {
        if (this.date != null) {
            try {
                return this.util.convertStringToDate(this.date);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public void setDate(LocalDate date) {
        Instant instant = date.atStartOfDay(ZoneId.of((String)"UTC").normalized()).toInstant();
        long timeInMillis = instant.toEpochMilli();
        this.date = "/Date(" + Long.toString(timeInMillis) + "+0000)/";
    }

    public BankTransaction reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Reference for the transaction. Only supported for SPEND and RECEIVE transactions.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public BankTransaction currencyCode(CurrencyCode currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @ApiModelProperty(value="")
    public CurrencyCode getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(CurrencyCode currencyCode) {
        this.currencyCode = currencyCode;
    }

    public BankTransaction currencyRate(Double currencyRate) {
        this.currencyRate = currencyRate;
        return this;
    }

    @ApiModelProperty(value="Exchange rate to base currency when money is spent or received. e.g.0.7500 Only used for bank transactions in non base currency. If this isn\u2019t specified for non base currency accounts then either the user-defined rate (preference) or the XE.com day rate will be used. Setting currency is only supported on overpayments.")
    public Double getCurrencyRate() {
        return this.currencyRate;
    }

    public void setCurrencyRate(Double currencyRate) {
        this.currencyRate = currencyRate;
    }

    public BankTransaction url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(value="URL link to a source document \u2013 shown as \u201cGo to App Name\u201d")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public BankTransaction status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="See Bank Transaction Status Codes")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public BankTransaction lineAmountTypes(LineAmountTypes lineAmountTypes) {
        this.lineAmountTypes = lineAmountTypes;
        return this;
    }

    @ApiModelProperty(value="")
    public LineAmountTypes getLineAmountTypes() {
        return this.lineAmountTypes;
    }

    public void setLineAmountTypes(LineAmountTypes lineAmountTypes) {
        this.lineAmountTypes = lineAmountTypes;
    }

    public BankTransaction subTotal(Double subTotal) {
        this.subTotal = subTotal;
        return this;
    }

    @ApiModelProperty(value="Total of bank transaction excluding taxes")
    public Double getSubTotal() {
        return this.subTotal;
    }

    public void setSubTotal(Double subTotal) {
        this.subTotal = subTotal;
    }

    public BankTransaction totalTax(Double totalTax) {
        this.totalTax = totalTax;
        return this;
    }

    @ApiModelProperty(value="Total tax on bank transaction")
    public Double getTotalTax() {
        return this.totalTax;
    }

    public void setTotalTax(Double totalTax) {
        this.totalTax = totalTax;
    }

    public BankTransaction total(Double total) {
        this.total = total;
        return this;
    }

    @ApiModelProperty(value="Total of bank transaction tax inclusive")
    public Double getTotal() {
        return this.total;
    }

    public void setTotal(Double total) {
        this.total = total;
    }

    public BankTransaction bankTransactionID(UUID bankTransactionID) {
        this.bankTransactionID = bankTransactionID;
        return this;
    }

    @ApiModelProperty(example="00000000-0000-0000-0000-000000000000", value="Xero generated unique identifier for bank transaction")
    public UUID getBankTransactionID() {
        return this.bankTransactionID;
    }

    public void setBankTransactionID(UUID bankTransactionID) {
        this.bankTransactionID = bankTransactionID;
    }

    @ApiModelProperty(example="00000000-0000-0000-0000-000000000000", value="Xero generated unique identifier for a Prepayment. This will be returned on BankTransactions with a Type of SPEND-PREPAYMENT or RECEIVE-PREPAYMENT")
    public UUID getPrepaymentID() {
        return this.prepaymentID;
    }

    @ApiModelProperty(example="00000000-0000-0000-0000-000000000000", value="Xero generated unique identifier for an Overpayment. This will be returned on BankTransactions with a Type of SPEND-OVERPAYMENT or RECEIVE-OVERPAYMENT")
    public UUID getOverpaymentID() {
        return this.overpaymentID;
    }

    @ApiModelProperty(example="/Date(1573755038314)/", value="Last modified date UTC format")
    public String getUpdatedDateUTC() {
        return this.updatedDateUTC;
    }

    public OffsetDateTime getUpdatedDateUTCAsDate() {
        if (this.updatedDateUTC != null) {
            try {
                return this.util.convertStringToOffsetDateTime(this.updatedDateUTC);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @ApiModelProperty(example="false", value="Boolean to indicate if a bank transaction has an attachment")
    public Boolean getHasAttachments() {
        return this.hasAttachments;
    }

    public BankTransaction statusAttributeString(String statusAttributeString) {
        this.statusAttributeString = statusAttributeString;
        return this;
    }

    @ApiModelProperty(value="A string to indicate if a invoice status")
    public String getStatusAttributeString() {
        return this.statusAttributeString;
    }

    public void setStatusAttributeString(String statusAttributeString) {
        this.statusAttributeString = statusAttributeString;
    }

    public BankTransaction validationErrors(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
        return this;
    }

    public BankTransaction addValidationErrorsItem(ValidationError validationErrorsItem) {
        if (this.validationErrors == null) {
            this.validationErrors = new ArrayList<ValidationError>();
        }
        this.validationErrors.add(validationErrorsItem);
        return this;
    }

    @ApiModelProperty(value="Displays array of validation error messages from the API")
    public List<ValidationError> getValidationErrors() {
        return this.validationErrors;
    }

    public void setValidationErrors(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankTransaction bankTransaction = (BankTransaction)o;
        return Objects.equals((Object)this.type, (Object)bankTransaction.type) && Objects.equals(this.contact, bankTransaction.contact) && Objects.equals(this.lineItems, bankTransaction.lineItems) && Objects.equals(this.bankAccount, bankTransaction.bankAccount) && Objects.equals(this.isReconciled, bankTransaction.isReconciled) && Objects.equals(this.date, bankTransaction.date) && Objects.equals(this.reference, bankTransaction.reference) && Objects.equals((Object)this.currencyCode, (Object)bankTransaction.currencyCode) && Objects.equals(this.currencyRate, bankTransaction.currencyRate) && Objects.equals(this.url, bankTransaction.url) && Objects.equals((Object)this.status, (Object)bankTransaction.status) && Objects.equals((Object)this.lineAmountTypes, (Object)bankTransaction.lineAmountTypes) && Objects.equals(this.subTotal, bankTransaction.subTotal) && Objects.equals(this.totalTax, bankTransaction.totalTax) && Objects.equals(this.total, bankTransaction.total) && Objects.equals(this.bankTransactionID, bankTransaction.bankTransactionID) && Objects.equals(this.prepaymentID, bankTransaction.prepaymentID) && Objects.equals(this.overpaymentID, bankTransaction.overpaymentID) && Objects.equals(this.updatedDateUTC, bankTransaction.updatedDateUTC) && Objects.equals(this.hasAttachments, bankTransaction.hasAttachments) && Objects.equals(this.statusAttributeString, bankTransaction.statusAttributeString) && Objects.equals(this.validationErrors, bankTransaction.validationErrors);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.contact, this.lineItems, this.bankAccount, this.isReconciled, this.date, this.reference, this.currencyCode, this.currencyRate, this.url, this.status, this.lineAmountTypes, this.subTotal, this.totalTax, this.total, this.bankTransactionID, this.prepaymentID, this.overpaymentID, this.updatedDateUTC, this.hasAttachments, this.statusAttributeString, this.validationErrors});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BankTransaction {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    lineItems: ").append(this.toIndentedString(this.lineItems)).append("\n");
        sb.append("    bankAccount: ").append(this.toIndentedString(this.bankAccount)).append("\n");
        sb.append("    isReconciled: ").append(this.toIndentedString(this.isReconciled)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString((Object)this.currencyCode)).append("\n");
        sb.append("    currencyRate: ").append(this.toIndentedString(this.currencyRate)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    lineAmountTypes: ").append(this.toIndentedString((Object)this.lineAmountTypes)).append("\n");
        sb.append("    subTotal: ").append(this.toIndentedString(this.subTotal)).append("\n");
        sb.append("    totalTax: ").append(this.toIndentedString(this.totalTax)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("    bankTransactionID: ").append(this.toIndentedString(this.bankTransactionID)).append("\n");
        sb.append("    prepaymentID: ").append(this.toIndentedString(this.prepaymentID)).append("\n");
        sb.append("    overpaymentID: ").append(this.toIndentedString(this.overpaymentID)).append("\n");
        sb.append("    updatedDateUTC: ").append(this.toIndentedString(this.updatedDateUTC)).append("\n");
        sb.append("    hasAttachments: ").append(this.toIndentedString(this.hasAttachments)).append("\n");
        sb.append("    statusAttributeString: ").append(this.toIndentedString(this.statusAttributeString)).append("\n");
        sb.append("    validationErrors: ").append(this.toIndentedString(this.validationErrors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        RECEIVE("RECEIVE"),
        RECEIVE_OVERPAYMENT("RECEIVE-OVERPAYMENT"),
        RECEIVE_PREPAYMENT("RECEIVE-PREPAYMENT"),
        SPEND("SPEND"),
        SPEND_OVERPAYMENT("SPEND-OVERPAYMENT"),
        SPEND_PREPAYMENT("SPEND-PREPAYMENT"),
        RECEIVE_TRANSFER("RECEIVE-TRANSFER"),
        SPEND_TRANSFER("SPEND-TRANSFER");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum StatusEnum {
        AUTHORISED("AUTHORISED"),
        DELETED("DELETED"),
        VOIDED("VOIDED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

