/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import com.xero.models.accounting.Account;
import com.xero.models.accounting.ValidationError;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.ZoneId;

public class BankTransfer {
    StringUtil util = new StringUtil();
    @JsonProperty(value="FromBankAccount")
    private Account fromBankAccount;
    @JsonProperty(value="ToBankAccount")
    private Account toBankAccount;
    @JsonProperty(value="Amount")
    private Double amount;
    @JsonProperty(value="Date")
    private String date;
    @JsonProperty(value="BankTransferID")
    private UUID bankTransferID;
    @JsonProperty(value="CurrencyRate")
    private Double currencyRate;
    @JsonProperty(value="FromBankTransactionID")
    private UUID fromBankTransactionID;
    @JsonProperty(value="ToBankTransactionID")
    private UUID toBankTransactionID;
    @JsonProperty(value="FromIsReconciled")
    private Boolean fromIsReconciled = false;
    @JsonProperty(value="ToIsReconciled")
    private Boolean toIsReconciled = false;
    @JsonProperty(value="Reference")
    private String reference;
    @JsonProperty(value="HasAttachments")
    private Boolean hasAttachments = false;
    @JsonProperty(value="CreatedDateUTC")
    private String createdDateUTC;
    @JsonProperty(value="ValidationErrors")
    private List<ValidationError> validationErrors = new ArrayList<ValidationError>();

    public BankTransfer fromBankAccount(Account fromBankAccount) {
        this.fromBankAccount = fromBankAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Account getFromBankAccount() {
        return this.fromBankAccount;
    }

    public void setFromBankAccount(Account fromBankAccount) {
        this.fromBankAccount = fromBankAccount;
    }

    public BankTransfer toBankAccount(Account toBankAccount) {
        this.toBankAccount = toBankAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Account getToBankAccount() {
        return this.toBankAccount;
    }

    public void setToBankAccount(Account toBankAccount) {
        this.toBankAccount = toBankAccount;
    }

    public BankTransfer amount(Double amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="amount of the transaction")
    public Double getAmount() {
        return this.amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public BankTransfer date(String date) {
        this.date = date;
        return this;
    }

    @ApiModelProperty(value="The date of the Transfer YYYY-MM-DD")
    public String getDate() {
        return this.date;
    }

    public LocalDate getDateAsDate() {
        if (this.date != null) {
            try {
                return this.util.convertStringToDate(this.date);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public void setDate(LocalDate date) {
        Instant instant = date.atStartOfDay(ZoneId.of((String)"UTC").normalized()).toInstant();
        long timeInMillis = instant.toEpochMilli();
        this.date = "/Date(" + Long.toString(timeInMillis) + "+0000)/";
    }

    @ApiModelProperty(value="The identifier of the Bank Transfer")
    public UUID getBankTransferID() {
        return this.bankTransferID;
    }

    @ApiModelProperty(value="The currency rate")
    public Double getCurrencyRate() {
        return this.currencyRate;
    }

    @ApiModelProperty(value="The Bank Transaction ID for the source account")
    public UUID getFromBankTransactionID() {
        return this.fromBankTransactionID;
    }

    @ApiModelProperty(value="The Bank Transaction ID for the destination account")
    public UUID getToBankTransactionID() {
        return this.toBankTransactionID;
    }

    public BankTransfer fromIsReconciled(Boolean fromIsReconciled) {
        this.fromIsReconciled = fromIsReconciled;
        return this;
    }

    @ApiModelProperty(example="false", value="The Bank Transaction boolean to show if it is reconciled for the source account")
    public Boolean getFromIsReconciled() {
        return this.fromIsReconciled;
    }

    public void setFromIsReconciled(Boolean fromIsReconciled) {
        this.fromIsReconciled = fromIsReconciled;
    }

    public BankTransfer toIsReconciled(Boolean toIsReconciled) {
        this.toIsReconciled = toIsReconciled;
        return this;
    }

    @ApiModelProperty(example="false", value="The Bank Transaction boolean to show if it is reconciled for the destination account")
    public Boolean getToIsReconciled() {
        return this.toIsReconciled;
    }

    public void setToIsReconciled(Boolean toIsReconciled) {
        this.toIsReconciled = toIsReconciled;
    }

    public BankTransfer reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Reference for the transactions.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    @ApiModelProperty(example="false", value="Boolean to indicate if a Bank Transfer has an attachment")
    public Boolean getHasAttachments() {
        return this.hasAttachments;
    }

    @ApiModelProperty(example="/Date(1573755038314)/", value="UTC timestamp of creation date of bank transfer")
    public String getCreatedDateUTC() {
        return this.createdDateUTC;
    }

    public OffsetDateTime getCreatedDateUTCAsDate() {
        if (this.createdDateUTC != null) {
            try {
                return this.util.convertStringToOffsetDateTime(this.createdDateUTC);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public BankTransfer validationErrors(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
        return this;
    }

    public BankTransfer addValidationErrorsItem(ValidationError validationErrorsItem) {
        if (this.validationErrors == null) {
            this.validationErrors = new ArrayList<ValidationError>();
        }
        this.validationErrors.add(validationErrorsItem);
        return this;
    }

    @ApiModelProperty(value="Displays array of validation error messages from the API")
    public List<ValidationError> getValidationErrors() {
        return this.validationErrors;
    }

    public void setValidationErrors(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankTransfer bankTransfer = (BankTransfer)o;
        return Objects.equals(this.fromBankAccount, bankTransfer.fromBankAccount) && Objects.equals(this.toBankAccount, bankTransfer.toBankAccount) && Objects.equals(this.amount, bankTransfer.amount) && Objects.equals(this.date, bankTransfer.date) && Objects.equals(this.bankTransferID, bankTransfer.bankTransferID) && Objects.equals(this.currencyRate, bankTransfer.currencyRate) && Objects.equals(this.fromBankTransactionID, bankTransfer.fromBankTransactionID) && Objects.equals(this.toBankTransactionID, bankTransfer.toBankTransactionID) && Objects.equals(this.fromIsReconciled, bankTransfer.fromIsReconciled) && Objects.equals(this.toIsReconciled, bankTransfer.toIsReconciled) && Objects.equals(this.reference, bankTransfer.reference) && Objects.equals(this.hasAttachments, bankTransfer.hasAttachments) && Objects.equals(this.createdDateUTC, bankTransfer.createdDateUTC) && Objects.equals(this.validationErrors, bankTransfer.validationErrors);
    }

    public int hashCode() {
        return Objects.hash(this.fromBankAccount, this.toBankAccount, this.amount, this.date, this.bankTransferID, this.currencyRate, this.fromBankTransactionID, this.toBankTransactionID, this.fromIsReconciled, this.toIsReconciled, this.reference, this.hasAttachments, this.createdDateUTC, this.validationErrors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BankTransfer {\n");
        sb.append("    fromBankAccount: ").append(this.toIndentedString(this.fromBankAccount)).append("\n");
        sb.append("    toBankAccount: ").append(this.toIndentedString(this.toBankAccount)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    bankTransferID: ").append(this.toIndentedString(this.bankTransferID)).append("\n");
        sb.append("    currencyRate: ").append(this.toIndentedString(this.currencyRate)).append("\n");
        sb.append("    fromBankTransactionID: ").append(this.toIndentedString(this.fromBankTransactionID)).append("\n");
        sb.append("    toBankTransactionID: ").append(this.toIndentedString(this.toBankTransactionID)).append("\n");
        sb.append("    fromIsReconciled: ").append(this.toIndentedString(this.fromIsReconciled)).append("\n");
        sb.append("    toIsReconciled: ").append(this.toIndentedString(this.toIsReconciled)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    hasAttachments: ").append(this.toIndentedString(this.hasAttachments)).append("\n");
        sb.append("    createdDateUTC: ").append(this.toIndentedString(this.createdDateUTC)).append("\n");
        sb.append("    validationErrors: ").append(this.toIndentedString(this.validationErrors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

