/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

public class HistoryRecord {
    StringUtil util = new StringUtil();
    @JsonProperty(value="Details")
    private String details;
    @JsonProperty(value="Changes")
    private String changes;
    @JsonProperty(value="User")
    private String user;
    @JsonProperty(value="DateUTC")
    private String dateUTC;

    public HistoryRecord details(String details) {
        this.details = details;
        return this;
    }

    @ApiModelProperty(value="details")
    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public HistoryRecord changes(String changes) {
        this.changes = changes;
        return this;
    }

    @ApiModelProperty(value="Name of branding theme")
    public String getChanges() {
        return this.changes;
    }

    public void setChanges(String changes) {
        this.changes = changes;
    }

    public HistoryRecord user(String user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(value="has a value of 0")
    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    @ApiModelProperty(example="/Date(1573755038314)/", value="UTC timestamp of creation date of branding theme")
    public String getDateUTC() {
        return this.dateUTC;
    }

    public OffsetDateTime getDateUTCAsDate() {
        if (this.dateUTC != null) {
            try {
                return this.util.convertStringToOffsetDateTime(this.dateUTC);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoryRecord historyRecord = (HistoryRecord)o;
        return Objects.equals(this.details, historyRecord.details) && Objects.equals(this.changes, historyRecord.changes) && Objects.equals(this.user, historyRecord.user) && Objects.equals(this.dateUTC, historyRecord.dateUTC);
    }

    public int hashCode() {
        return Objects.hash(this.details, this.changes, this.user, this.dateUTC);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HistoryRecord {\n");
        sb.append("    details: ").append(this.toIndentedString(this.details)).append("\n");
        sb.append("    changes: ").append(this.toIndentedString(this.changes)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    dateUTC: ").append(this.toIndentedString(this.dateUTC)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

