/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import com.xero.models.accounting.Attachment;
import com.xero.models.accounting.Contact;
import com.xero.models.accounting.CreditNote;
import com.xero.models.accounting.CurrencyCode;
import com.xero.models.accounting.InvoiceAddress;
import com.xero.models.accounting.LineAmountTypes;
import com.xero.models.accounting.LineItem;
import com.xero.models.accounting.Overpayment;
import com.xero.models.accounting.Payment;
import com.xero.models.accounting.Prepayment;
import com.xero.models.accounting.ValidationError;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.ZoneId;

public class Invoice {
    StringUtil util = new StringUtil();
    @JsonProperty(value="Type")
    private TypeEnum type;
    @JsonProperty(value="Contact")
    private Contact contact;
    @JsonProperty(value="LineItems")
    private List<LineItem> lineItems = new ArrayList<LineItem>();
    @JsonProperty(value="Date")
    private String date;
    @JsonProperty(value="DueDate")
    private String dueDate;
    @JsonProperty(value="LineAmountTypes")
    private LineAmountTypes lineAmountTypes;
    @JsonProperty(value="InvoiceNumber")
    private String invoiceNumber;
    @JsonProperty(value="Reference")
    private String reference;
    @JsonProperty(value="BrandingThemeID")
    private UUID brandingThemeID;
    @JsonProperty(value="Url")
    private String url;
    @JsonProperty(value="CurrencyCode")
    private CurrencyCode currencyCode;
    @JsonProperty(value="CurrencyRate")
    private Double currencyRate;
    @JsonProperty(value="Status")
    private StatusEnum status;
    @JsonProperty(value="SentToContact")
    private Boolean sentToContact;
    @JsonProperty(value="ExpectedPaymentDate")
    private String expectedPaymentDate;
    @JsonProperty(value="PlannedPaymentDate")
    private String plannedPaymentDate;
    @JsonProperty(value="CISDeduction")
    private Double ciSDeduction;
    @JsonProperty(value="CISRate")
    private Double ciSRate;
    @JsonProperty(value="SubTotal")
    private Double subTotal;
    @JsonProperty(value="TotalTax")
    private Double totalTax;
    @JsonProperty(value="Total")
    private Double total;
    @JsonProperty(value="TotalDiscount")
    private Double totalDiscount;
    @JsonProperty(value="InvoiceID")
    private UUID invoiceID;
    @JsonProperty(value="RepeatingInvoiceID")
    private UUID repeatingInvoiceID;
    @JsonProperty(value="HasAttachments")
    private Boolean hasAttachments = false;
    @JsonProperty(value="IsDiscounted")
    private Boolean isDiscounted;
    @JsonProperty(value="Payments")
    private List<Payment> payments = new ArrayList<Payment>();
    @JsonProperty(value="Prepayments")
    private List<Prepayment> prepayments = new ArrayList<Prepayment>();
    @JsonProperty(value="Overpayments")
    private List<Overpayment> overpayments = new ArrayList<Overpayment>();
    @JsonProperty(value="AmountDue")
    private Double amountDue;
    @JsonProperty(value="AmountPaid")
    private Double amountPaid;
    @JsonProperty(value="FullyPaidOnDate")
    private String fullyPaidOnDate;
    @JsonProperty(value="AmountCredited")
    private Double amountCredited;
    @JsonProperty(value="UpdatedDateUTC")
    private String updatedDateUTC;
    @JsonProperty(value="CreditNotes")
    private List<CreditNote> creditNotes = new ArrayList<CreditNote>();
    @JsonProperty(value="Attachments")
    private List<Attachment> attachments = new ArrayList<Attachment>();
    @JsonProperty(value="HasErrors")
    private Boolean hasErrors = false;
    @JsonProperty(value="StatusAttributeString")
    private String statusAttributeString;
    @JsonProperty(value="ValidationErrors")
    private List<ValidationError> validationErrors = new ArrayList<ValidationError>();
    @JsonProperty(value="Warnings")
    private List<ValidationError> warnings = new ArrayList<ValidationError>();
    @JsonProperty(value="InvoiceAddresses")
    private List<InvoiceAddress> invoiceAddresses = new ArrayList<InvoiceAddress>();

    public Invoice type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="See Invoice Types")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Invoice contact(Contact contact) {
        this.contact = contact;
        return this;
    }

    @ApiModelProperty(value="")
    public Contact getContact() {
        return this.contact;
    }

    public void setContact(Contact contact) {
        this.contact = contact;
    }

    public Invoice lineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
        return this;
    }

    public Invoice addLineItemsItem(LineItem lineItemsItem) {
        if (this.lineItems == null) {
            this.lineItems = new ArrayList<LineItem>();
        }
        this.lineItems.add(lineItemsItem);
        return this;
    }

    @ApiModelProperty(value="See LineItems")
    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    public void setLineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
    }

    public Invoice date(String date) {
        this.date = date;
        return this;
    }

    @ApiModelProperty(value="Date invoice was issued \u2013 YYYY-MM-DD. If the Date element is not specified it will default to the current date based on the timezone setting of the organisation")
    public String getDate() {
        return this.date;
    }

    public LocalDate getDateAsDate() {
        if (this.date != null) {
            try {
                return this.util.convertStringToDate(this.date);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public void setDate(LocalDate date) {
        Instant instant = date.atStartOfDay(ZoneId.of((String)"UTC").normalized()).toInstant();
        long timeInMillis = instant.toEpochMilli();
        this.date = "/Date(" + Long.toString(timeInMillis) + "+0000)/";
    }

    public Invoice dueDate(String dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    @ApiModelProperty(value="Date invoice is due \u2013 YYYY-MM-DD")
    public String getDueDate() {
        return this.dueDate;
    }

    public LocalDate getDueDateAsDate() {
        if (this.dueDate != null) {
            try {
                return this.util.convertStringToDate(this.dueDate);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setDueDate(String dueDate) {
        this.dueDate = dueDate;
    }

    public void setDueDate(LocalDate dueDate) {
        Instant instant = dueDate.atStartOfDay(ZoneId.of((String)"UTC").normalized()).toInstant();
        long timeInMillis = instant.toEpochMilli();
        this.dueDate = "/Date(" + Long.toString(timeInMillis) + "+0000)/";
    }

    public Invoice lineAmountTypes(LineAmountTypes lineAmountTypes) {
        this.lineAmountTypes = lineAmountTypes;
        return this;
    }

    @ApiModelProperty(value="")
    public LineAmountTypes getLineAmountTypes() {
        return this.lineAmountTypes;
    }

    public void setLineAmountTypes(LineAmountTypes lineAmountTypes) {
        this.lineAmountTypes = lineAmountTypes;
    }

    public Invoice invoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
        return this;
    }

    @ApiModelProperty(value="ACCREC \u2013 Unique alpha numeric code identifying invoice (when missing will auto-generate from your Organisation Invoice Settings) (max length = 255)")
    public String getInvoiceNumber() {
        return this.invoiceNumber;
    }

    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }

    public Invoice reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="ACCREC only \u2013 additional reference number")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public Invoice brandingThemeID(UUID brandingThemeID) {
        this.brandingThemeID = brandingThemeID;
        return this;
    }

    @ApiModelProperty(value="See BrandingThemes")
    public UUID getBrandingThemeID() {
        return this.brandingThemeID;
    }

    public void setBrandingThemeID(UUID brandingThemeID) {
        this.brandingThemeID = brandingThemeID;
    }

    public Invoice url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(value="URL link to a source document \u2013 shown as \u201cGo to [appName]\u201d in the Xero app")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Invoice currencyCode(CurrencyCode currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @ApiModelProperty(value="")
    public CurrencyCode getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(CurrencyCode currencyCode) {
        this.currencyCode = currencyCode;
    }

    public Invoice currencyRate(Double currencyRate) {
        this.currencyRate = currencyRate;
        return this;
    }

    @ApiModelProperty(value="The currency rate for a multicurrency invoice. If no rate is specified, the XE.com day rate is used. (max length = [18].[6])")
    public Double getCurrencyRate() {
        return this.currencyRate;
    }

    public void setCurrencyRate(Double currencyRate) {
        this.currencyRate = currencyRate;
    }

    public Invoice status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="See Invoice Status Codes")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Invoice sentToContact(Boolean sentToContact) {
        this.sentToContact = sentToContact;
        return this;
    }

    @ApiModelProperty(value="Boolean to set whether the invoice in the Xero app should be marked as \u201csent\u201d. This can be set only on invoices that have been approved")
    public Boolean getSentToContact() {
        return this.sentToContact;
    }

    public void setSentToContact(Boolean sentToContact) {
        this.sentToContact = sentToContact;
    }

    public Invoice expectedPaymentDate(String expectedPaymentDate) {
        this.expectedPaymentDate = expectedPaymentDate;
        return this;
    }

    @ApiModelProperty(value="Shown on sales invoices (Accounts Receivable) when this has been set")
    public String getExpectedPaymentDate() {
        return this.expectedPaymentDate;
    }

    public LocalDate getExpectedPaymentDateAsDate() {
        if (this.expectedPaymentDate != null) {
            try {
                return this.util.convertStringToDate(this.expectedPaymentDate);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setExpectedPaymentDate(String expectedPaymentDate) {
        this.expectedPaymentDate = expectedPaymentDate;
    }

    public void setExpectedPaymentDate(LocalDate expectedPaymentDate) {
        Instant instant = expectedPaymentDate.atStartOfDay(ZoneId.of((String)"UTC").normalized()).toInstant();
        long timeInMillis = instant.toEpochMilli();
        this.expectedPaymentDate = "/Date(" + Long.toString(timeInMillis) + "+0000)/";
    }

    public Invoice plannedPaymentDate(String plannedPaymentDate) {
        this.plannedPaymentDate = plannedPaymentDate;
        return this;
    }

    @ApiModelProperty(value="Shown on bills (Accounts Payable) when this has been set")
    public String getPlannedPaymentDate() {
        return this.plannedPaymentDate;
    }

    public LocalDate getPlannedPaymentDateAsDate() {
        if (this.plannedPaymentDate != null) {
            try {
                return this.util.convertStringToDate(this.plannedPaymentDate);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setPlannedPaymentDate(String plannedPaymentDate) {
        this.plannedPaymentDate = plannedPaymentDate;
    }

    public void setPlannedPaymentDate(LocalDate plannedPaymentDate) {
        Instant instant = plannedPaymentDate.atStartOfDay(ZoneId.of((String)"UTC").normalized()).toInstant();
        long timeInMillis = instant.toEpochMilli();
        this.plannedPaymentDate = "/Date(" + Long.toString(timeInMillis) + "+0000)/";
    }

    @ApiModelProperty(value="CIS deduction for UK contractors")
    public Double getCiSDeduction() {
        return this.ciSDeduction;
    }

    @ApiModelProperty(value="CIS Deduction rate for the organisation")
    public Double getCiSRate() {
        return this.ciSRate;
    }

    @ApiModelProperty(value="Total of invoice excluding taxes")
    public Double getSubTotal() {
        return this.subTotal;
    }

    @ApiModelProperty(value="Total tax on invoice")
    public Double getTotalTax() {
        return this.totalTax;
    }

    @ApiModelProperty(value="Total of Invoice tax inclusive (i.e. SubTotal + TotalTax). This will be ignored if it doesn\u2019t equal the sum of the LineAmounts")
    public Double getTotal() {
        return this.total;
    }

    @ApiModelProperty(value="Total of discounts applied on the invoice line items")
    public Double getTotalDiscount() {
        return this.totalDiscount;
    }

    public Invoice invoiceID(UUID invoiceID) {
        this.invoiceID = invoiceID;
        return this;
    }

    @ApiModelProperty(value="Xero generated unique identifier for invoice")
    public UUID getInvoiceID() {
        return this.invoiceID;
    }

    public void setInvoiceID(UUID invoiceID) {
        this.invoiceID = invoiceID;
    }

    public Invoice repeatingInvoiceID(UUID repeatingInvoiceID) {
        this.repeatingInvoiceID = repeatingInvoiceID;
        return this;
    }

    @ApiModelProperty(value="Xero generated unique identifier for repeating invoices")
    public UUID getRepeatingInvoiceID() {
        return this.repeatingInvoiceID;
    }

    public void setRepeatingInvoiceID(UUID repeatingInvoiceID) {
        this.repeatingInvoiceID = repeatingInvoiceID;
    }

    @ApiModelProperty(example="false", value="boolean to indicate if an invoice has an attachment")
    public Boolean getHasAttachments() {
        return this.hasAttachments;
    }

    @ApiModelProperty(value="boolean to indicate if an invoice has a discount")
    public Boolean getIsDiscounted() {
        return this.isDiscounted;
    }

    @ApiModelProperty(value="See Payments")
    public List<Payment> getPayments() {
        return this.payments;
    }

    @ApiModelProperty(value="See Prepayments")
    public List<Prepayment> getPrepayments() {
        return this.prepayments;
    }

    @ApiModelProperty(value="See Overpayments")
    public List<Overpayment> getOverpayments() {
        return this.overpayments;
    }

    @ApiModelProperty(value="Amount remaining to be paid on invoice")
    public Double getAmountDue() {
        return this.amountDue;
    }

    @ApiModelProperty(value="Sum of payments received for invoice")
    public Double getAmountPaid() {
        return this.amountPaid;
    }

    @ApiModelProperty(value="The date the invoice was fully paid. Only returned on fully paid invoices")
    public String getFullyPaidOnDate() {
        return this.fullyPaidOnDate;
    }

    public LocalDate getFullyPaidOnDateAsDate() {
        if (this.fullyPaidOnDate != null) {
            try {
                return this.util.convertStringToDate(this.fullyPaidOnDate);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @ApiModelProperty(value="Sum of all credit notes, over-payments and pre-payments applied to invoice")
    public Double getAmountCredited() {
        return this.amountCredited;
    }

    @ApiModelProperty(example="/Date(1573755038314)/", value="Last modified date UTC format")
    public String getUpdatedDateUTC() {
        return this.updatedDateUTC;
    }

    public OffsetDateTime getUpdatedDateUTCAsDate() {
        if (this.updatedDateUTC != null) {
            try {
                return this.util.convertStringToOffsetDateTime(this.updatedDateUTC);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @ApiModelProperty(value="Details of credit notes that have been applied to an invoice")
    public List<CreditNote> getCreditNotes() {
        return this.creditNotes;
    }

    public Invoice attachments(List<Attachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    public Invoice addAttachmentsItem(Attachment attachmentsItem) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<Attachment>();
        }
        this.attachments.add(attachmentsItem);
        return this;
    }

    @ApiModelProperty(value="Displays array of attachments from the API")
    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public Invoice hasErrors(Boolean hasErrors) {
        this.hasErrors = hasErrors;
        return this;
    }

    @ApiModelProperty(example="false", value="A boolean to indicate if a invoice has an validation errors")
    public Boolean getHasErrors() {
        return this.hasErrors;
    }

    public void setHasErrors(Boolean hasErrors) {
        this.hasErrors = hasErrors;
    }

    public Invoice statusAttributeString(String statusAttributeString) {
        this.statusAttributeString = statusAttributeString;
        return this;
    }

    @ApiModelProperty(value="A string to indicate if a invoice status")
    public String getStatusAttributeString() {
        return this.statusAttributeString;
    }

    public void setStatusAttributeString(String statusAttributeString) {
        this.statusAttributeString = statusAttributeString;
    }

    public Invoice validationErrors(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
        return this;
    }

    public Invoice addValidationErrorsItem(ValidationError validationErrorsItem) {
        if (this.validationErrors == null) {
            this.validationErrors = new ArrayList<ValidationError>();
        }
        this.validationErrors.add(validationErrorsItem);
        return this;
    }

    @ApiModelProperty(value="Displays array of validation error messages from the API")
    public List<ValidationError> getValidationErrors() {
        return this.validationErrors;
    }

    public void setValidationErrors(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
    }

    public Invoice warnings(List<ValidationError> warnings) {
        this.warnings = warnings;
        return this;
    }

    public Invoice addWarningsItem(ValidationError warningsItem) {
        if (this.warnings == null) {
            this.warnings = new ArrayList<ValidationError>();
        }
        this.warnings.add(warningsItem);
        return this;
    }

    @ApiModelProperty(value="Displays array of warning messages from the API")
    public List<ValidationError> getWarnings() {
        return this.warnings;
    }

    public void setWarnings(List<ValidationError> warnings) {
        this.warnings = warnings;
    }

    public Invoice invoiceAddresses(List<InvoiceAddress> invoiceAddresses) {
        this.invoiceAddresses = invoiceAddresses;
        return this;
    }

    public Invoice addInvoiceAddressesItem(InvoiceAddress invoiceAddressesItem) {
        if (this.invoiceAddresses == null) {
            this.invoiceAddresses = new ArrayList<InvoiceAddress>();
        }
        this.invoiceAddresses.add(invoiceAddressesItem);
        return this;
    }

    @ApiModelProperty(value="An array of addresses used to auto calculate sales tax")
    public List<InvoiceAddress> getInvoiceAddresses() {
        return this.invoiceAddresses;
    }

    public void setInvoiceAddresses(List<InvoiceAddress> invoiceAddresses) {
        this.invoiceAddresses = invoiceAddresses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Invoice invoice = (Invoice)o;
        return Objects.equals((Object)this.type, (Object)invoice.type) && Objects.equals(this.contact, invoice.contact) && Objects.equals(this.lineItems, invoice.lineItems) && Objects.equals(this.date, invoice.date) && Objects.equals(this.dueDate, invoice.dueDate) && Objects.equals((Object)this.lineAmountTypes, (Object)invoice.lineAmountTypes) && Objects.equals(this.invoiceNumber, invoice.invoiceNumber) && Objects.equals(this.reference, invoice.reference) && Objects.equals(this.brandingThemeID, invoice.brandingThemeID) && Objects.equals(this.url, invoice.url) && Objects.equals((Object)this.currencyCode, (Object)invoice.currencyCode) && Objects.equals(this.currencyRate, invoice.currencyRate) && Objects.equals((Object)this.status, (Object)invoice.status) && Objects.equals(this.sentToContact, invoice.sentToContact) && Objects.equals(this.expectedPaymentDate, invoice.expectedPaymentDate) && Objects.equals(this.plannedPaymentDate, invoice.plannedPaymentDate) && Objects.equals(this.ciSDeduction, invoice.ciSDeduction) && Objects.equals(this.ciSRate, invoice.ciSRate) && Objects.equals(this.subTotal, invoice.subTotal) && Objects.equals(this.totalTax, invoice.totalTax) && Objects.equals(this.total, invoice.total) && Objects.equals(this.totalDiscount, invoice.totalDiscount) && Objects.equals(this.invoiceID, invoice.invoiceID) && Objects.equals(this.repeatingInvoiceID, invoice.repeatingInvoiceID) && Objects.equals(this.hasAttachments, invoice.hasAttachments) && Objects.equals(this.isDiscounted, invoice.isDiscounted) && Objects.equals(this.payments, invoice.payments) && Objects.equals(this.prepayments, invoice.prepayments) && Objects.equals(this.overpayments, invoice.overpayments) && Objects.equals(this.amountDue, invoice.amountDue) && Objects.equals(this.amountPaid, invoice.amountPaid) && Objects.equals(this.fullyPaidOnDate, invoice.fullyPaidOnDate) && Objects.equals(this.amountCredited, invoice.amountCredited) && Objects.equals(this.updatedDateUTC, invoice.updatedDateUTC) && Objects.equals(this.creditNotes, invoice.creditNotes) && Objects.equals(this.attachments, invoice.attachments) && Objects.equals(this.hasErrors, invoice.hasErrors) && Objects.equals(this.statusAttributeString, invoice.statusAttributeString) && Objects.equals(this.validationErrors, invoice.validationErrors) && Objects.equals(this.warnings, invoice.warnings) && Objects.equals(this.invoiceAddresses, invoice.invoiceAddresses);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.contact, this.lineItems, this.date, this.dueDate, this.lineAmountTypes, this.invoiceNumber, this.reference, this.brandingThemeID, this.url, this.currencyCode, this.currencyRate, this.status, this.sentToContact, this.expectedPaymentDate, this.plannedPaymentDate, this.ciSDeduction, this.ciSRate, this.subTotal, this.totalTax, this.total, this.totalDiscount, this.invoiceID, this.repeatingInvoiceID, this.hasAttachments, this.isDiscounted, this.payments, this.prepayments, this.overpayments, this.amountDue, this.amountPaid, this.fullyPaidOnDate, this.amountCredited, this.updatedDateUTC, this.creditNotes, this.attachments, this.hasErrors, this.statusAttributeString, this.validationErrors, this.warnings, this.invoiceAddresses});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Invoice {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    lineItems: ").append(this.toIndentedString(this.lineItems)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    dueDate: ").append(this.toIndentedString(this.dueDate)).append("\n");
        sb.append("    lineAmountTypes: ").append(this.toIndentedString((Object)this.lineAmountTypes)).append("\n");
        sb.append("    invoiceNumber: ").append(this.toIndentedString(this.invoiceNumber)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    brandingThemeID: ").append(this.toIndentedString(this.brandingThemeID)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString((Object)this.currencyCode)).append("\n");
        sb.append("    currencyRate: ").append(this.toIndentedString(this.currencyRate)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    sentToContact: ").append(this.toIndentedString(this.sentToContact)).append("\n");
        sb.append("    expectedPaymentDate: ").append(this.toIndentedString(this.expectedPaymentDate)).append("\n");
        sb.append("    plannedPaymentDate: ").append(this.toIndentedString(this.plannedPaymentDate)).append("\n");
        sb.append("    ciSDeduction: ").append(this.toIndentedString(this.ciSDeduction)).append("\n");
        sb.append("    ciSRate: ").append(this.toIndentedString(this.ciSRate)).append("\n");
        sb.append("    subTotal: ").append(this.toIndentedString(this.subTotal)).append("\n");
        sb.append("    totalTax: ").append(this.toIndentedString(this.totalTax)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("    totalDiscount: ").append(this.toIndentedString(this.totalDiscount)).append("\n");
        sb.append("    invoiceID: ").append(this.toIndentedString(this.invoiceID)).append("\n");
        sb.append("    repeatingInvoiceID: ").append(this.toIndentedString(this.repeatingInvoiceID)).append("\n");
        sb.append("    hasAttachments: ").append(this.toIndentedString(this.hasAttachments)).append("\n");
        sb.append("    isDiscounted: ").append(this.toIndentedString(this.isDiscounted)).append("\n");
        sb.append("    payments: ").append(this.toIndentedString(this.payments)).append("\n");
        sb.append("    prepayments: ").append(this.toIndentedString(this.prepayments)).append("\n");
        sb.append("    overpayments: ").append(this.toIndentedString(this.overpayments)).append("\n");
        sb.append("    amountDue: ").append(this.toIndentedString(this.amountDue)).append("\n");
        sb.append("    amountPaid: ").append(this.toIndentedString(this.amountPaid)).append("\n");
        sb.append("    fullyPaidOnDate: ").append(this.toIndentedString(this.fullyPaidOnDate)).append("\n");
        sb.append("    amountCredited: ").append(this.toIndentedString(this.amountCredited)).append("\n");
        sb.append("    updatedDateUTC: ").append(this.toIndentedString(this.updatedDateUTC)).append("\n");
        sb.append("    creditNotes: ").append(this.toIndentedString(this.creditNotes)).append("\n");
        sb.append("    attachments: ").append(this.toIndentedString(this.attachments)).append("\n");
        sb.append("    hasErrors: ").append(this.toIndentedString(this.hasErrors)).append("\n");
        sb.append("    statusAttributeString: ").append(this.toIndentedString(this.statusAttributeString)).append("\n");
        sb.append("    validationErrors: ").append(this.toIndentedString(this.validationErrors)).append("\n");
        sb.append("    warnings: ").append(this.toIndentedString(this.warnings)).append("\n");
        sb.append("    invoiceAddresses: ").append(this.toIndentedString(this.invoiceAddresses)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        ACCPAY("ACCPAY"),
        ACCPAYCREDIT("ACCPAYCREDIT"),
        APOVERPAYMENT("APOVERPAYMENT"),
        APPREPAYMENT("APPREPAYMENT"),
        ACCREC("ACCREC"),
        ACCRECCREDIT("ACCRECCREDIT"),
        AROVERPAYMENT("AROVERPAYMENT"),
        ARPREPAYMENT("ARPREPAYMENT");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum StatusEnum {
        DRAFT("DRAFT"),
        SUBMITTED("SUBMITTED"),
        DELETED("DELETED"),
        AUTHORISED("AUTHORISED"),
        PAID("PAID"),
        VOIDED("VOIDED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

