/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import com.xero.models.accounting.JournalLine;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.ZoneId;

public class Journal {
    StringUtil util = new StringUtil();
    @JsonProperty(value="JournalID")
    private UUID journalID;
    @JsonProperty(value="JournalDate")
    private String journalDate;
    @JsonProperty(value="JournalNumber")
    private Integer journalNumber;
    @JsonProperty(value="CreatedDateUTC")
    private String createdDateUTC;
    @JsonProperty(value="Reference")
    private String reference;
    @JsonProperty(value="SourceID")
    private UUID sourceID;
    @JsonProperty(value="SourceType")
    private SourceTypeEnum sourceType;
    @JsonProperty(value="JournalLines")
    private List<JournalLine> journalLines = new ArrayList<JournalLine>();

    public Journal journalID(UUID journalID) {
        this.journalID = journalID;
        return this;
    }

    @ApiModelProperty(value="Xero identifier")
    public UUID getJournalID() {
        return this.journalID;
    }

    public void setJournalID(UUID journalID) {
        this.journalID = journalID;
    }

    public Journal journalDate(String journalDate) {
        this.journalDate = journalDate;
        return this;
    }

    @ApiModelProperty(value="Date the journal was posted")
    public String getJournalDate() {
        return this.journalDate;
    }

    public LocalDate getJournalDateAsDate() {
        if (this.journalDate != null) {
            try {
                return this.util.convertStringToDate(this.journalDate);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setJournalDate(String journalDate) {
        this.journalDate = journalDate;
    }

    public void setJournalDate(LocalDate journalDate) {
        Instant instant = journalDate.atStartOfDay(ZoneId.of((String)"UTC").normalized()).toInstant();
        long timeInMillis = instant.toEpochMilli();
        this.journalDate = "/Date(" + Long.toString(timeInMillis) + "+0000)/";
    }

    public Journal journalNumber(Integer journalNumber) {
        this.journalNumber = journalNumber;
        return this;
    }

    @ApiModelProperty(value="Xero generated journal number")
    public Integer getJournalNumber() {
        return this.journalNumber;
    }

    public void setJournalNumber(Integer journalNumber) {
        this.journalNumber = journalNumber;
    }

    @ApiModelProperty(example="/Date(1573755038314)/", value="Created date UTC format")
    public String getCreatedDateUTC() {
        return this.createdDateUTC;
    }

    public OffsetDateTime getCreatedDateUTCAsDate() {
        if (this.createdDateUTC != null) {
            try {
                return this.util.convertStringToOffsetDateTime(this.createdDateUTC);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Journal reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="reference field for additional indetifying information")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public Journal sourceID(UUID sourceID) {
        this.sourceID = sourceID;
        return this;
    }

    @ApiModelProperty(value="The identifier for the source transaction (e.g. InvoiceID)")
    public UUID getSourceID() {
        return this.sourceID;
    }

    public void setSourceID(UUID sourceID) {
        this.sourceID = sourceID;
    }

    public Journal sourceType(SourceTypeEnum sourceType) {
        this.sourceType = sourceType;
        return this;
    }

    @ApiModelProperty(value="The journal source type. The type of transaction that created the journal")
    public SourceTypeEnum getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(SourceTypeEnum sourceType) {
        this.sourceType = sourceType;
    }

    public Journal journalLines(List<JournalLine> journalLines) {
        this.journalLines = journalLines;
        return this;
    }

    public Journal addJournalLinesItem(JournalLine journalLinesItem) {
        if (this.journalLines == null) {
            this.journalLines = new ArrayList<JournalLine>();
        }
        this.journalLines.add(journalLinesItem);
        return this;
    }

    @ApiModelProperty(value="See JournalLines")
    public List<JournalLine> getJournalLines() {
        return this.journalLines;
    }

    public void setJournalLines(List<JournalLine> journalLines) {
        this.journalLines = journalLines;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Journal journal = (Journal)o;
        return Objects.equals(this.journalID, journal.journalID) && Objects.equals(this.journalDate, journal.journalDate) && Objects.equals(this.journalNumber, journal.journalNumber) && Objects.equals(this.createdDateUTC, journal.createdDateUTC) && Objects.equals(this.reference, journal.reference) && Objects.equals(this.sourceID, journal.sourceID) && Objects.equals((Object)this.sourceType, (Object)journal.sourceType) && Objects.equals(this.journalLines, journal.journalLines);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.journalID, this.journalDate, this.journalNumber, this.createdDateUTC, this.reference, this.sourceID, this.sourceType, this.journalLines});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Journal {\n");
        sb.append("    journalID: ").append(this.toIndentedString(this.journalID)).append("\n");
        sb.append("    journalDate: ").append(this.toIndentedString(this.journalDate)).append("\n");
        sb.append("    journalNumber: ").append(this.toIndentedString(this.journalNumber)).append("\n");
        sb.append("    createdDateUTC: ").append(this.toIndentedString(this.createdDateUTC)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    sourceID: ").append(this.toIndentedString(this.sourceID)).append("\n");
        sb.append("    sourceType: ").append(this.toIndentedString((Object)this.sourceType)).append("\n");
        sb.append("    journalLines: ").append(this.toIndentedString(this.journalLines)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SourceTypeEnum {
        ACCREC("ACCREC"),
        ACCPAY("ACCPAY"),
        ACCRECCREDIT("ACCRECCREDIT"),
        ACCPAYCREDIT("ACCPAYCREDIT"),
        ACCRECPAYMENT("ACCRECPAYMENT"),
        ACCPAYPAYMENT("ACCPAYPAYMENT"),
        ARCREDITPAYMENT("ARCREDITPAYMENT"),
        APCREDITPAYMENT("APCREDITPAYMENT"),
        CASHREC("CASHREC"),
        CASHPAID("CASHPAID"),
        TRANSFER("TRANSFER"),
        ARPREPAYMENT("ARPREPAYMENT"),
        APPREPAYMENT("APPREPAYMENT"),
        AROVERPAYMENT("AROVERPAYMENT"),
        APOVERPAYMENT("APOVERPAYMENT"),
        EXPCLAIM("EXPCLAIM"),
        EXPPAYMENT("EXPPAYMENT"),
        MANJOURNAL("MANJOURNAL"),
        PAYSLIP("PAYSLIP"),
        WAGEPAYABLE("WAGEPAYABLE"),
        INTEGRATEDPAYROLLPE("INTEGRATEDPAYROLLPE"),
        INTEGRATEDPAYROLLPT("INTEGRATEDPAYROLLPT"),
        EXTERNALSPENDMONEY("EXTERNALSPENDMONEY"),
        INTEGRATEDPAYROLLPTPAYMENT("INTEGRATEDPAYROLLPTPAYMENT"),
        INTEGRATEDPAYROLLCN("INTEGRATEDPAYROLLCN");

        private String value;

        private SourceTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SourceTypeEnum fromValue(String value) {
            for (SourceTypeEnum b : SourceTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

