/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import com.xero.models.accounting.ValidationError;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.OffsetDateTime;

public class LinkedTransaction {
    StringUtil util = new StringUtil();
    @JsonProperty(value="SourceTransactionID")
    private UUID sourceTransactionID;
    @JsonProperty(value="SourceLineItemID")
    private UUID sourceLineItemID;
    @JsonProperty(value="ContactID")
    private UUID contactID;
    @JsonProperty(value="TargetTransactionID")
    private UUID targetTransactionID;
    @JsonProperty(value="TargetLineItemID")
    private UUID targetLineItemID;
    @JsonProperty(value="LinkedTransactionID")
    private UUID linkedTransactionID;
    @JsonProperty(value="Status")
    private StatusEnum status;
    @JsonProperty(value="Type")
    private TypeEnum type;
    @JsonProperty(value="UpdatedDateUTC")
    private String updatedDateUTC;
    @JsonProperty(value="SourceTransactionTypeCode")
    private SourceTransactionTypeCodeEnum sourceTransactionTypeCode;
    @JsonProperty(value="ValidationErrors")
    private List<ValidationError> validationErrors = new ArrayList<ValidationError>();

    public LinkedTransaction sourceTransactionID(UUID sourceTransactionID) {
        this.sourceTransactionID = sourceTransactionID;
        return this;
    }

    @ApiModelProperty(value="Filter by the SourceTransactionID. Get all the linked transactions created from a particular ACCPAY invoice")
    public UUID getSourceTransactionID() {
        return this.sourceTransactionID;
    }

    public void setSourceTransactionID(UUID sourceTransactionID) {
        this.sourceTransactionID = sourceTransactionID;
    }

    public LinkedTransaction sourceLineItemID(UUID sourceLineItemID) {
        this.sourceLineItemID = sourceLineItemID;
        return this;
    }

    @ApiModelProperty(value="The line item identifier from the source transaction.")
    public UUID getSourceLineItemID() {
        return this.sourceLineItemID;
    }

    public void setSourceLineItemID(UUID sourceLineItemID) {
        this.sourceLineItemID = sourceLineItemID;
    }

    public LinkedTransaction contactID(UUID contactID) {
        this.contactID = contactID;
        return this;
    }

    @ApiModelProperty(value="Filter by the combination of ContactID and Status. Get all the linked transactions that have been assigned to a particular customer and have a particular status e.g. GET /LinkedTransactions?ContactID=4bb34b03-3378-4bb2-a0ed-6345abf3224e&Status=APPROVED.")
    public UUID getContactID() {
        return this.contactID;
    }

    public void setContactID(UUID contactID) {
        this.contactID = contactID;
    }

    public LinkedTransaction targetTransactionID(UUID targetTransactionID) {
        this.targetTransactionID = targetTransactionID;
        return this;
    }

    @ApiModelProperty(value="Filter by the TargetTransactionID. Get all the linked transactions  allocated to a particular ACCREC invoice")
    public UUID getTargetTransactionID() {
        return this.targetTransactionID;
    }

    public void setTargetTransactionID(UUID targetTransactionID) {
        this.targetTransactionID = targetTransactionID;
    }

    public LinkedTransaction targetLineItemID(UUID targetLineItemID) {
        this.targetLineItemID = targetLineItemID;
        return this;
    }

    @ApiModelProperty(value="The line item identifier from the target transaction. It is possible  to link multiple billable expenses to the same TargetLineItemID.")
    public UUID getTargetLineItemID() {
        return this.targetLineItemID;
    }

    public void setTargetLineItemID(UUID targetLineItemID) {
        this.targetLineItemID = targetLineItemID;
    }

    public LinkedTransaction linkedTransactionID(UUID linkedTransactionID) {
        this.linkedTransactionID = linkedTransactionID;
        return this;
    }

    @ApiModelProperty(value="The Xero identifier for an Linked Transaction e.g./LinkedTransactions/297c2dc5-cc47-4afd-8ec8-74990b8761e9")
    public UUID getLinkedTransactionID() {
        return this.linkedTransactionID;
    }

    public void setLinkedTransactionID(UUID linkedTransactionID) {
        this.linkedTransactionID = linkedTransactionID;
    }

    public LinkedTransaction status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="Filter by the combination of ContactID and Status. Get all the linked transactions that have been assigned to a particular customer and have a particular status e.g. GET /LinkedTransactions?ContactID=4bb34b03-3378-4bb2-a0ed-6345abf3224e&Status=APPROVED.")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public LinkedTransaction type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="This will always be BILLABLEEXPENSE. More types may be added in future.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    @ApiModelProperty(example="/Date(1573755038314)/", value="The last modified date in UTC format")
    public String getUpdatedDateUTC() {
        return this.updatedDateUTC;
    }

    public OffsetDateTime getUpdatedDateUTCAsDate() {
        if (this.updatedDateUTC != null) {
            try {
                return this.util.convertStringToOffsetDateTime(this.updatedDateUTC);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public LinkedTransaction sourceTransactionTypeCode(SourceTransactionTypeCodeEnum sourceTransactionTypeCode) {
        this.sourceTransactionTypeCode = sourceTransactionTypeCode;
        return this;
    }

    @ApiModelProperty(value="The Type of the source tranasction. This will be ACCPAY if the linked transaction was created from an invoice and SPEND if it was created from a bank transaction.")
    public SourceTransactionTypeCodeEnum getSourceTransactionTypeCode() {
        return this.sourceTransactionTypeCode;
    }

    public void setSourceTransactionTypeCode(SourceTransactionTypeCodeEnum sourceTransactionTypeCode) {
        this.sourceTransactionTypeCode = sourceTransactionTypeCode;
    }

    public LinkedTransaction validationErrors(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
        return this;
    }

    public LinkedTransaction addValidationErrorsItem(ValidationError validationErrorsItem) {
        if (this.validationErrors == null) {
            this.validationErrors = new ArrayList<ValidationError>();
        }
        this.validationErrors.add(validationErrorsItem);
        return this;
    }

    @ApiModelProperty(value="Displays array of validation error messages from the API")
    public List<ValidationError> getValidationErrors() {
        return this.validationErrors;
    }

    public void setValidationErrors(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkedTransaction linkedTransaction = (LinkedTransaction)o;
        return Objects.equals(this.sourceTransactionID, linkedTransaction.sourceTransactionID) && Objects.equals(this.sourceLineItemID, linkedTransaction.sourceLineItemID) && Objects.equals(this.contactID, linkedTransaction.contactID) && Objects.equals(this.targetTransactionID, linkedTransaction.targetTransactionID) && Objects.equals(this.targetLineItemID, linkedTransaction.targetLineItemID) && Objects.equals(this.linkedTransactionID, linkedTransaction.linkedTransactionID) && Objects.equals((Object)this.status, (Object)linkedTransaction.status) && Objects.equals((Object)this.type, (Object)linkedTransaction.type) && Objects.equals(this.updatedDateUTC, linkedTransaction.updatedDateUTC) && Objects.equals((Object)this.sourceTransactionTypeCode, (Object)linkedTransaction.sourceTransactionTypeCode) && Objects.equals(this.validationErrors, linkedTransaction.validationErrors);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sourceTransactionID, this.sourceLineItemID, this.contactID, this.targetTransactionID, this.targetLineItemID, this.linkedTransactionID, this.status, this.type, this.updatedDateUTC, this.sourceTransactionTypeCode, this.validationErrors});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinkedTransaction {\n");
        sb.append("    sourceTransactionID: ").append(this.toIndentedString(this.sourceTransactionID)).append("\n");
        sb.append("    sourceLineItemID: ").append(this.toIndentedString(this.sourceLineItemID)).append("\n");
        sb.append("    contactID: ").append(this.toIndentedString(this.contactID)).append("\n");
        sb.append("    targetTransactionID: ").append(this.toIndentedString(this.targetTransactionID)).append("\n");
        sb.append("    targetLineItemID: ").append(this.toIndentedString(this.targetLineItemID)).append("\n");
        sb.append("    linkedTransactionID: ").append(this.toIndentedString(this.linkedTransactionID)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    updatedDateUTC: ").append(this.toIndentedString(this.updatedDateUTC)).append("\n");
        sb.append("    sourceTransactionTypeCode: ").append(this.toIndentedString((Object)this.sourceTransactionTypeCode)).append("\n");
        sb.append("    validationErrors: ").append(this.toIndentedString(this.validationErrors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        APPROVED("APPROVED"),
        DRAFT("DRAFT"),
        ONDRAFT("ONDRAFT"),
        BILLED("BILLED"),
        VOIDED("VOIDED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        BILLABLEEXPENSE("BILLABLEEXPENSE");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum SourceTransactionTypeCodeEnum {
        ACCPAY("ACCPAY"),
        SPEND("SPEND");

        private String value;

        private SourceTransactionTypeCodeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SourceTransactionTypeCodeEnum fromValue(String value) {
            for (SourceTransactionTypeCodeEnum b : SourceTransactionTypeCodeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

