/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import com.xero.models.accounting.ValidationError;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class PaymentService {
    StringUtil util = new StringUtil();
    @JsonProperty(value="PaymentServiceID")
    private UUID paymentServiceID;
    @JsonProperty(value="PaymentServiceName")
    private String paymentServiceName;
    @JsonProperty(value="PaymentServiceUrl")
    private String paymentServiceUrl;
    @JsonProperty(value="PayNowText")
    private String payNowText;
    @JsonProperty(value="PaymentServiceType")
    private String paymentServiceType;
    @JsonProperty(value="ValidationErrors")
    private List<ValidationError> validationErrors = new ArrayList<ValidationError>();

    public PaymentService paymentServiceID(UUID paymentServiceID) {
        this.paymentServiceID = paymentServiceID;
        return this;
    }

    @ApiModelProperty(value="Xero identifier")
    public UUID getPaymentServiceID() {
        return this.paymentServiceID;
    }

    public void setPaymentServiceID(UUID paymentServiceID) {
        this.paymentServiceID = paymentServiceID;
    }

    public PaymentService paymentServiceName(String paymentServiceName) {
        this.paymentServiceName = paymentServiceName;
        return this;
    }

    @ApiModelProperty(value="Name of payment service")
    public String getPaymentServiceName() {
        return this.paymentServiceName;
    }

    public void setPaymentServiceName(String paymentServiceName) {
        this.paymentServiceName = paymentServiceName;
    }

    public PaymentService paymentServiceUrl(String paymentServiceUrl) {
        this.paymentServiceUrl = paymentServiceUrl;
        return this;
    }

    @ApiModelProperty(value="The custom payment URL")
    public String getPaymentServiceUrl() {
        return this.paymentServiceUrl;
    }

    public void setPaymentServiceUrl(String paymentServiceUrl) {
        this.paymentServiceUrl = paymentServiceUrl;
    }

    public PaymentService payNowText(String payNowText) {
        this.payNowText = payNowText;
        return this;
    }

    @ApiModelProperty(value="The text displayed on the Pay Now button in Xero Online Invoicing. If this is not set it will default to Pay by credit card")
    public String getPayNowText() {
        return this.payNowText;
    }

    public void setPayNowText(String payNowText) {
        this.payNowText = payNowText;
    }

    public PaymentService paymentServiceType(String paymentServiceType) {
        this.paymentServiceType = paymentServiceType;
        return this;
    }

    @ApiModelProperty(value="This will always be CUSTOM for payment services created via the API.")
    public String getPaymentServiceType() {
        return this.paymentServiceType;
    }

    public void setPaymentServiceType(String paymentServiceType) {
        this.paymentServiceType = paymentServiceType;
    }

    public PaymentService validationErrors(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
        return this;
    }

    public PaymentService addValidationErrorsItem(ValidationError validationErrorsItem) {
        if (this.validationErrors == null) {
            this.validationErrors = new ArrayList<ValidationError>();
        }
        this.validationErrors.add(validationErrorsItem);
        return this;
    }

    @ApiModelProperty(value="Displays array of validation error messages from the API")
    public List<ValidationError> getValidationErrors() {
        return this.validationErrors;
    }

    public void setValidationErrors(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentService paymentService = (PaymentService)o;
        return Objects.equals(this.paymentServiceID, paymentService.paymentServiceID) && Objects.equals(this.paymentServiceName, paymentService.paymentServiceName) && Objects.equals(this.paymentServiceUrl, paymentService.paymentServiceUrl) && Objects.equals(this.payNowText, paymentService.payNowText) && Objects.equals(this.paymentServiceType, paymentService.paymentServiceType) && Objects.equals(this.validationErrors, paymentService.validationErrors);
    }

    public int hashCode() {
        return Objects.hash(this.paymentServiceID, this.paymentServiceName, this.paymentServiceUrl, this.payNowText, this.paymentServiceType, this.validationErrors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentService {\n");
        sb.append("    paymentServiceID: ").append(this.toIndentedString(this.paymentServiceID)).append("\n");
        sb.append("    paymentServiceName: ").append(this.toIndentedString(this.paymentServiceName)).append("\n");
        sb.append("    paymentServiceUrl: ").append(this.toIndentedString(this.paymentServiceUrl)).append("\n");
        sb.append("    payNowText: ").append(this.toIndentedString(this.payNowText)).append("\n");
        sb.append("    paymentServiceType: ").append(this.toIndentedString(this.paymentServiceType)).append("\n");
        sb.append("    validationErrors: ").append(this.toIndentedString(this.validationErrors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

