/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import com.xero.models.accounting.Attachment;
import com.xero.models.accounting.Contact;
import com.xero.models.accounting.CurrencyCode;
import com.xero.models.accounting.LineAmountTypes;
import com.xero.models.accounting.LineItem;
import com.xero.models.accounting.Schedule;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class RepeatingInvoice {
    StringUtil util = new StringUtil();
    @JsonProperty(value="Type")
    private TypeEnum type;
    @JsonProperty(value="Contact")
    private Contact contact;
    @JsonProperty(value="Schedule")
    private Schedule schedule;
    @JsonProperty(value="LineItems")
    private List<LineItem> lineItems = new ArrayList<LineItem>();
    @JsonProperty(value="LineAmountTypes")
    private LineAmountTypes lineAmountTypes;
    @JsonProperty(value="Reference")
    private String reference;
    @JsonProperty(value="BrandingThemeID")
    private UUID brandingThemeID;
    @JsonProperty(value="CurrencyCode")
    private CurrencyCode currencyCode;
    @JsonProperty(value="Status")
    private StatusEnum status;
    @JsonProperty(value="SubTotal")
    private Double subTotal;
    @JsonProperty(value="TotalTax")
    private Double totalTax;
    @JsonProperty(value="Total")
    private Double total;
    @JsonProperty(value="RepeatingInvoiceID")
    private UUID repeatingInvoiceID;
    @JsonProperty(value="ID")
    private UUID ID;
    @JsonProperty(value="HasAttachments")
    private Boolean hasAttachments = false;
    @JsonProperty(value="Attachments")
    private List<Attachment> attachments = new ArrayList<Attachment>();
    @JsonProperty(value="ApprovedForSending")
    private Boolean approvedForSending = false;
    @JsonProperty(value="SendCopy")
    private Boolean sendCopy = false;
    @JsonProperty(value="MarkAsSent")
    private Boolean markAsSent = false;
    @JsonProperty(value="IncludePDF")
    private Boolean includePDF = false;

    public RepeatingInvoice type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="See Invoice Types")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public RepeatingInvoice contact(Contact contact) {
        this.contact = contact;
        return this;
    }

    @ApiModelProperty(value="")
    public Contact getContact() {
        return this.contact;
    }

    public void setContact(Contact contact) {
        this.contact = contact;
    }

    public RepeatingInvoice schedule(Schedule schedule) {
        this.schedule = schedule;
        return this;
    }

    @ApiModelProperty(value="")
    public Schedule getSchedule() {
        return this.schedule;
    }

    public void setSchedule(Schedule schedule) {
        this.schedule = schedule;
    }

    public RepeatingInvoice lineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
        return this;
    }

    public RepeatingInvoice addLineItemsItem(LineItem lineItemsItem) {
        if (this.lineItems == null) {
            this.lineItems = new ArrayList<LineItem>();
        }
        this.lineItems.add(lineItemsItem);
        return this;
    }

    @ApiModelProperty(value="See LineItems")
    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    public void setLineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
    }

    public RepeatingInvoice lineAmountTypes(LineAmountTypes lineAmountTypes) {
        this.lineAmountTypes = lineAmountTypes;
        return this;
    }

    @ApiModelProperty(value="")
    public LineAmountTypes getLineAmountTypes() {
        return this.lineAmountTypes;
    }

    public void setLineAmountTypes(LineAmountTypes lineAmountTypes) {
        this.lineAmountTypes = lineAmountTypes;
    }

    public RepeatingInvoice reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="ACCREC only \u2013 additional reference number")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public RepeatingInvoice brandingThemeID(UUID brandingThemeID) {
        this.brandingThemeID = brandingThemeID;
        return this;
    }

    @ApiModelProperty(value="See BrandingThemes")
    public UUID getBrandingThemeID() {
        return this.brandingThemeID;
    }

    public void setBrandingThemeID(UUID brandingThemeID) {
        this.brandingThemeID = brandingThemeID;
    }

    public RepeatingInvoice currencyCode(CurrencyCode currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @ApiModelProperty(value="")
    public CurrencyCode getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(CurrencyCode currencyCode) {
        this.currencyCode = currencyCode;
    }

    public RepeatingInvoice status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="One of the following - DRAFT or AUTHORISED \u2013 See Invoice Status Codes")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public RepeatingInvoice subTotal(Double subTotal) {
        this.subTotal = subTotal;
        return this;
    }

    @ApiModelProperty(value="Total of invoice excluding taxes")
    public Double getSubTotal() {
        return this.subTotal;
    }

    public void setSubTotal(Double subTotal) {
        this.subTotal = subTotal;
    }

    public RepeatingInvoice totalTax(Double totalTax) {
        this.totalTax = totalTax;
        return this;
    }

    @ApiModelProperty(value="Total tax on invoice")
    public Double getTotalTax() {
        return this.totalTax;
    }

    public void setTotalTax(Double totalTax) {
        this.totalTax = totalTax;
    }

    public RepeatingInvoice total(Double total) {
        this.total = total;
        return this;
    }

    @ApiModelProperty(value="Total of Invoice tax inclusive (i.e. SubTotal + TotalTax)")
    public Double getTotal() {
        return this.total;
    }

    public void setTotal(Double total) {
        this.total = total;
    }

    public RepeatingInvoice repeatingInvoiceID(UUID repeatingInvoiceID) {
        this.repeatingInvoiceID = repeatingInvoiceID;
        return this;
    }

    @ApiModelProperty(value="Xero generated unique identifier for repeating invoice template")
    public UUID getRepeatingInvoiceID() {
        return this.repeatingInvoiceID;
    }

    public void setRepeatingInvoiceID(UUID repeatingInvoiceID) {
        this.repeatingInvoiceID = repeatingInvoiceID;
    }

    public RepeatingInvoice ID(UUID ID) {
        this.ID = ID;
        return this;
    }

    @ApiModelProperty(value="Xero generated unique identifier for repeating invoice template")
    public UUID getID() {
        return this.ID;
    }

    public void setID(UUID ID) {
        this.ID = ID;
    }

    @ApiModelProperty(example="false", value="Boolean to indicate if an invoice has an attachment")
    public Boolean getHasAttachments() {
        return this.hasAttachments;
    }

    public RepeatingInvoice attachments(List<Attachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    public RepeatingInvoice addAttachmentsItem(Attachment attachmentsItem) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<Attachment>();
        }
        this.attachments.add(attachmentsItem);
        return this;
    }

    @ApiModelProperty(value="Displays array of attachments from the API")
    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public RepeatingInvoice approvedForSending(Boolean approvedForSending) {
        this.approvedForSending = approvedForSending;
        return this;
    }

    @ApiModelProperty(example="false", value="Boolean to indicate whether the invoice has been approved for sending")
    public Boolean getApprovedForSending() {
        return this.approvedForSending;
    }

    public void setApprovedForSending(Boolean approvedForSending) {
        this.approvedForSending = approvedForSending;
    }

    public RepeatingInvoice sendCopy(Boolean sendCopy) {
        this.sendCopy = sendCopy;
        return this;
    }

    @ApiModelProperty(example="false", value="Boolean to indicate whether a copy is sent to sender's email")
    public Boolean getSendCopy() {
        return this.sendCopy;
    }

    public void setSendCopy(Boolean sendCopy) {
        this.sendCopy = sendCopy;
    }

    public RepeatingInvoice markAsSent(Boolean markAsSent) {
        this.markAsSent = markAsSent;
        return this;
    }

    @ApiModelProperty(example="false", value="Boolean to indicate whether the invoice in the Xero app displays as \"sent\"")
    public Boolean getMarkAsSent() {
        return this.markAsSent;
    }

    public void setMarkAsSent(Boolean markAsSent) {
        this.markAsSent = markAsSent;
    }

    public RepeatingInvoice includePDF(Boolean includePDF) {
        this.includePDF = includePDF;
        return this;
    }

    @ApiModelProperty(example="false", value="Boolean to indicate whether to include PDF attachment")
    public Boolean getIncludePDF() {
        return this.includePDF;
    }

    public void setIncludePDF(Boolean includePDF) {
        this.includePDF = includePDF;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepeatingInvoice repeatingInvoice = (RepeatingInvoice)o;
        return Objects.equals((Object)this.type, (Object)repeatingInvoice.type) && Objects.equals(this.contact, repeatingInvoice.contact) && Objects.equals(this.schedule, repeatingInvoice.schedule) && Objects.equals(this.lineItems, repeatingInvoice.lineItems) && Objects.equals((Object)this.lineAmountTypes, (Object)repeatingInvoice.lineAmountTypes) && Objects.equals(this.reference, repeatingInvoice.reference) && Objects.equals(this.brandingThemeID, repeatingInvoice.brandingThemeID) && Objects.equals((Object)this.currencyCode, (Object)repeatingInvoice.currencyCode) && Objects.equals((Object)this.status, (Object)repeatingInvoice.status) && Objects.equals(this.subTotal, repeatingInvoice.subTotal) && Objects.equals(this.totalTax, repeatingInvoice.totalTax) && Objects.equals(this.total, repeatingInvoice.total) && Objects.equals(this.repeatingInvoiceID, repeatingInvoice.repeatingInvoiceID) && Objects.equals(this.ID, repeatingInvoice.ID) && Objects.equals(this.hasAttachments, repeatingInvoice.hasAttachments) && Objects.equals(this.attachments, repeatingInvoice.attachments) && Objects.equals(this.approvedForSending, repeatingInvoice.approvedForSending) && Objects.equals(this.sendCopy, repeatingInvoice.sendCopy) && Objects.equals(this.markAsSent, repeatingInvoice.markAsSent) && Objects.equals(this.includePDF, repeatingInvoice.includePDF);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.contact, this.schedule, this.lineItems, this.lineAmountTypes, this.reference, this.brandingThemeID, this.currencyCode, this.status, this.subTotal, this.totalTax, this.total, this.repeatingInvoiceID, this.ID, this.hasAttachments, this.attachments, this.approvedForSending, this.sendCopy, this.markAsSent, this.includePDF});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RepeatingInvoice {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    schedule: ").append(this.toIndentedString(this.schedule)).append("\n");
        sb.append("    lineItems: ").append(this.toIndentedString(this.lineItems)).append("\n");
        sb.append("    lineAmountTypes: ").append(this.toIndentedString((Object)this.lineAmountTypes)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    brandingThemeID: ").append(this.toIndentedString(this.brandingThemeID)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString((Object)this.currencyCode)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    subTotal: ").append(this.toIndentedString(this.subTotal)).append("\n");
        sb.append("    totalTax: ").append(this.toIndentedString(this.totalTax)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("    repeatingInvoiceID: ").append(this.toIndentedString(this.repeatingInvoiceID)).append("\n");
        sb.append("    ID: ").append(this.toIndentedString(this.ID)).append("\n");
        sb.append("    hasAttachments: ").append(this.toIndentedString(this.hasAttachments)).append("\n");
        sb.append("    attachments: ").append(this.toIndentedString(this.attachments)).append("\n");
        sb.append("    approvedForSending: ").append(this.toIndentedString(this.approvedForSending)).append("\n");
        sb.append("    sendCopy: ").append(this.toIndentedString(this.sendCopy)).append("\n");
        sb.append("    markAsSent: ").append(this.toIndentedString(this.markAsSent)).append("\n");
        sb.append("    includePDF: ").append(this.toIndentedString(this.includePDF)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        ACCPAY("ACCPAY"),
        ACCREC("ACCREC");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum StatusEnum {
        DRAFT("DRAFT"),
        AUTHORISED("AUTHORISED"),
        DELETED("DELETED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

