/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.UUID;

public class TaxBreakdownComponent {
    StringUtil util = new StringUtil();
    @JsonProperty(value="TaxComponentId")
    private UUID taxComponentId;
    @JsonProperty(value="Type")
    private TypeEnum type;
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="TaxPercentage")
    private BigDecimal taxPercentage;
    @JsonProperty(value="TaxAmount")
    private BigDecimal taxAmount;
    @JsonProperty(value="TaxableAmount")
    private BigDecimal taxableAmount;
    @JsonProperty(value="NonTaxableAmount")
    private BigDecimal nonTaxableAmount;
    @JsonProperty(value="ExemptAmount")
    private BigDecimal exemptAmount;
    @JsonProperty(value="StateAssignedNo")
    private String stateAssignedNo;
    @JsonProperty(value="JurisdictionRegion")
    private String jurisdictionRegion;

    public TaxBreakdownComponent taxComponentId(UUID taxComponentId) {
        this.taxComponentId = taxComponentId;
        return this;
    }

    @ApiModelProperty(value="The unique ID number of this component")
    public UUID getTaxComponentId() {
        return this.taxComponentId;
    }

    public void setTaxComponentId(UUID taxComponentId) {
        this.taxComponentId = taxComponentId;
    }

    public TaxBreakdownComponent type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of the jurisdiction")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public TaxBreakdownComponent name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the jurisdiction")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TaxBreakdownComponent taxPercentage(BigDecimal taxPercentage) {
        this.taxPercentage = taxPercentage;
        return this;
    }

    @ApiModelProperty(value="The percentage of the tax")
    public BigDecimal getTaxPercentage() {
        return this.taxPercentage;
    }

    public void setTaxPercentage(BigDecimal taxPercentage) {
        this.taxPercentage = taxPercentage;
    }

    public TaxBreakdownComponent taxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
        return this;
    }

    @ApiModelProperty(value="The amount of the tax")
    public BigDecimal getTaxAmount() {
        return this.taxAmount;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    public TaxBreakdownComponent taxableAmount(BigDecimal taxableAmount) {
        this.taxableAmount = taxableAmount;
        return this;
    }

    @ApiModelProperty(value="The amount that is taxable")
    public BigDecimal getTaxableAmount() {
        return this.taxableAmount;
    }

    public void setTaxableAmount(BigDecimal taxableAmount) {
        this.taxableAmount = taxableAmount;
    }

    public TaxBreakdownComponent nonTaxableAmount(BigDecimal nonTaxableAmount) {
        this.nonTaxableAmount = nonTaxableAmount;
        return this;
    }

    @ApiModelProperty(value="The amount that is not taxable")
    public BigDecimal getNonTaxableAmount() {
        return this.nonTaxableAmount;
    }

    public void setNonTaxableAmount(BigDecimal nonTaxableAmount) {
        this.nonTaxableAmount = nonTaxableAmount;
    }

    public TaxBreakdownComponent exemptAmount(BigDecimal exemptAmount) {
        this.exemptAmount = exemptAmount;
        return this;
    }

    @ApiModelProperty(value="The amount that is exempt")
    public BigDecimal getExemptAmount() {
        return this.exemptAmount;
    }

    public void setExemptAmount(BigDecimal exemptAmount) {
        this.exemptAmount = exemptAmount;
    }

    public TaxBreakdownComponent stateAssignedNo(String stateAssignedNo) {
        this.stateAssignedNo = stateAssignedNo;
        return this;
    }

    @ApiModelProperty(value="The state assigned number of the jurisdiction")
    public String getStateAssignedNo() {
        return this.stateAssignedNo;
    }

    public void setStateAssignedNo(String stateAssignedNo) {
        this.stateAssignedNo = stateAssignedNo;
    }

    public TaxBreakdownComponent jurisdictionRegion(String jurisdictionRegion) {
        this.jurisdictionRegion = jurisdictionRegion;
        return this;
    }

    @ApiModelProperty(value="Name identifying the region within the country")
    public String getJurisdictionRegion() {
        return this.jurisdictionRegion;
    }

    public void setJurisdictionRegion(String jurisdictionRegion) {
        this.jurisdictionRegion = jurisdictionRegion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaxBreakdownComponent taxBreakdownComponent = (TaxBreakdownComponent)o;
        return Objects.equals(this.taxComponentId, taxBreakdownComponent.taxComponentId) && Objects.equals((Object)this.type, (Object)taxBreakdownComponent.type) && Objects.equals(this.name, taxBreakdownComponent.name) && Objects.equals(this.taxPercentage, taxBreakdownComponent.taxPercentage) && Objects.equals(this.taxAmount, taxBreakdownComponent.taxAmount) && Objects.equals(this.taxableAmount, taxBreakdownComponent.taxableAmount) && Objects.equals(this.nonTaxableAmount, taxBreakdownComponent.nonTaxableAmount) && Objects.equals(this.exemptAmount, taxBreakdownComponent.exemptAmount) && Objects.equals(this.stateAssignedNo, taxBreakdownComponent.stateAssignedNo) && Objects.equals(this.jurisdictionRegion, taxBreakdownComponent.jurisdictionRegion);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.taxComponentId, this.type, this.name, this.taxPercentage, this.taxAmount, this.taxableAmount, this.nonTaxableAmount, this.exemptAmount, this.stateAssignedNo, this.jurisdictionRegion});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaxBreakdownComponent {\n");
        sb.append("    taxComponentId: ").append(this.toIndentedString(this.taxComponentId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    taxPercentage: ").append(this.toIndentedString(this.taxPercentage)).append("\n");
        sb.append("    taxAmount: ").append(this.toIndentedString(this.taxAmount)).append("\n");
        sb.append("    taxableAmount: ").append(this.toIndentedString(this.taxableAmount)).append("\n");
        sb.append("    nonTaxableAmount: ").append(this.toIndentedString(this.nonTaxableAmount)).append("\n");
        sb.append("    exemptAmount: ").append(this.toIndentedString(this.exemptAmount)).append("\n");
        sb.append("    stateAssignedNo: ").append(this.toIndentedString(this.stateAssignedNo)).append("\n");
        sb.append("    jurisdictionRegion: ").append(this.toIndentedString(this.jurisdictionRegion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        USCOUNTRY("SYSGST/USCOUNTRY"),
        USSTATE("SYSGST/USSTATE"),
        USCOUNTY("SYSGST/USCOUNTY"),
        USCITY("SYSGST/USCITY"),
        USSPECIAL("SYSGST/USSPECIAL");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

