/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class TaxComponent {
    StringUtil util = new StringUtil();
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="Rate")
    private Double rate;
    @JsonProperty(value="IsCompound")
    private Boolean isCompound;
    @JsonProperty(value="IsNonRecoverable")
    private Boolean isNonRecoverable;

    public TaxComponent name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Name of Tax Component")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TaxComponent rate(Double rate) {
        this.rate = rate;
        return this;
    }

    @ApiModelProperty(value="Tax Rate (up to 4dp)")
    public Double getRate() {
        return this.rate;
    }

    public void setRate(Double rate) {
        this.rate = rate;
    }

    public TaxComponent isCompound(Boolean isCompound) {
        this.isCompound = isCompound;
        return this;
    }

    @ApiModelProperty(value="Boolean to describe if Tax rate is compounded.")
    public Boolean getIsCompound() {
        return this.isCompound;
    }

    public void setIsCompound(Boolean isCompound) {
        this.isCompound = isCompound;
    }

    public TaxComponent isNonRecoverable(Boolean isNonRecoverable) {
        this.isNonRecoverable = isNonRecoverable;
        return this;
    }

    @ApiModelProperty(value="Boolean to describe if tax rate is non-recoverable. Non-recoverable rates are only applicable to Canadian organisations")
    public Boolean getIsNonRecoverable() {
        return this.isNonRecoverable;
    }

    public void setIsNonRecoverable(Boolean isNonRecoverable) {
        this.isNonRecoverable = isNonRecoverable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaxComponent taxComponent = (TaxComponent)o;
        return Objects.equals(this.name, taxComponent.name) && Objects.equals(this.rate, taxComponent.rate) && Objects.equals(this.isCompound, taxComponent.isCompound) && Objects.equals(this.isNonRecoverable, taxComponent.isNonRecoverable);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.rate, this.isCompound, this.isNonRecoverable);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaxComponent {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    rate: ").append(this.toIndentedString(this.rate)).append("\n");
        sb.append("    isCompound: ").append(this.toIndentedString(this.isCompound)).append("\n");
        sb.append("    isNonRecoverable: ").append(this.toIndentedString(this.isNonRecoverable)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

