/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.assets;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import com.xero.models.assets.AssetStatus;
import com.xero.models.assets.BookDepreciationDetail;
import com.xero.models.assets.BookDepreciationSetting;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.LocalDate;

public class Asset {
    StringUtil util = new StringUtil();
    @JsonProperty(value="assetId")
    private UUID assetId;
    @JsonProperty(value="assetName")
    private String assetName;
    @JsonProperty(value="assetTypeId")
    private UUID assetTypeId;
    @JsonProperty(value="assetNumber")
    private String assetNumber;
    @JsonProperty(value="purchaseDate")
    private LocalDate purchaseDate;
    @JsonProperty(value="purchasePrice")
    private Double purchasePrice;
    @JsonProperty(value="disposalDate")
    private LocalDate disposalDate;
    @JsonProperty(value="disposalPrice")
    private Double disposalPrice;
    @JsonProperty(value="assetStatus")
    private AssetStatus assetStatus;
    @JsonProperty(value="warrantyExpiryDate")
    private String warrantyExpiryDate;
    @JsonProperty(value="serialNumber")
    private String serialNumber;
    @JsonProperty(value="bookDepreciationSetting")
    private BookDepreciationSetting bookDepreciationSetting;
    @JsonProperty(value="bookDepreciationDetail")
    private BookDepreciationDetail bookDepreciationDetail;
    @JsonProperty(value="canRollback")
    private Boolean canRollback;
    @JsonProperty(value="accountingBookValue")
    private Double accountingBookValue;
    @JsonProperty(value="isDeleteEnabledForDate")
    private Boolean isDeleteEnabledForDate;

    public Asset assetId(UUID assetId) {
        this.assetId = assetId;
        return this;
    }

    @ApiModelProperty(example="3b5b3a38-5649-495f-87a1-14a4e5918634", value="The Xero-generated Id for the asset")
    public UUID getAssetId() {
        return this.assetId;
    }

    public void setAssetId(UUID assetId) {
        this.assetId = assetId;
    }

    public Asset assetName(String assetName) {
        this.assetName = assetName;
        return this;
    }

    @ApiModelProperty(example="Awesome Truck 3", required=true, value="The name of the asset")
    public String getAssetName() {
        return this.assetName;
    }

    public void setAssetName(String assetName) {
        this.assetName = assetName;
    }

    public Asset assetTypeId(UUID assetTypeId) {
        this.assetTypeId = assetTypeId;
        return this;
    }

    @ApiModelProperty(example="3b5b3a38-5649-495f-87a1-14a4e5918634", value="The Xero-generated Id for the asset type")
    public UUID getAssetTypeId() {
        return this.assetTypeId;
    }

    public void setAssetTypeId(UUID assetTypeId) {
        this.assetTypeId = assetTypeId;
    }

    public Asset assetNumber(String assetNumber) {
        this.assetNumber = assetNumber;
        return this;
    }

    @ApiModelProperty(example="FA-0013", value="Must be unique.")
    public String getAssetNumber() {
        return this.assetNumber;
    }

    public void setAssetNumber(String assetNumber) {
        this.assetNumber = assetNumber;
    }

    public Asset purchaseDate(LocalDate purchaseDate) {
        this.purchaseDate = purchaseDate;
        return this;
    }

    @ApiModelProperty(value="The date the asset was purchased YYYY-MM-DD")
    public LocalDate getPurchaseDate() {
        return this.purchaseDate;
    }

    public void setPurchaseDate(LocalDate purchaseDate) {
        this.purchaseDate = purchaseDate;
    }

    public Asset purchasePrice(Double purchasePrice) {
        this.purchasePrice = purchasePrice;
        return this;
    }

    @ApiModelProperty(example="1000.0000", value="The purchase price of the asset")
    public Double getPurchasePrice() {
        return this.purchasePrice;
    }

    public void setPurchasePrice(Double purchasePrice) {
        this.purchasePrice = purchasePrice;
    }

    public Asset disposalDate(LocalDate disposalDate) {
        this.disposalDate = disposalDate;
        return this;
    }

    @ApiModelProperty(value="The date the asset was disposed")
    public LocalDate getDisposalDate() {
        return this.disposalDate;
    }

    public void setDisposalDate(LocalDate disposalDate) {
        this.disposalDate = disposalDate;
    }

    public Asset disposalPrice(Double disposalPrice) {
        this.disposalPrice = disposalPrice;
        return this;
    }

    @ApiModelProperty(example="1.0000", value="The price the asset was disposed at")
    public Double getDisposalPrice() {
        return this.disposalPrice;
    }

    public void setDisposalPrice(Double disposalPrice) {
        this.disposalPrice = disposalPrice;
    }

    public Asset assetStatus(AssetStatus assetStatus) {
        this.assetStatus = assetStatus;
        return this;
    }

    @ApiModelProperty(value="")
    public AssetStatus getAssetStatus() {
        return this.assetStatus;
    }

    public void setAssetStatus(AssetStatus assetStatus) {
        this.assetStatus = assetStatus;
    }

    public Asset warrantyExpiryDate(String warrantyExpiryDate) {
        this.warrantyExpiryDate = warrantyExpiryDate;
        return this;
    }

    @ApiModelProperty(example="ca4c6b39-4f4f-43e8-98da-5e1f350a6694", value="The date the asset\u2019s warranty expires (if needed) YYYY-MM-DD")
    public String getWarrantyExpiryDate() {
        return this.warrantyExpiryDate;
    }

    public void setWarrantyExpiryDate(String warrantyExpiryDate) {
        this.warrantyExpiryDate = warrantyExpiryDate;
    }

    public Asset serialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
        return this;
    }

    @ApiModelProperty(example="ca4c6b39-4f4f-43e8-98da-5e1f350a6694", value="The asset's serial number")
    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public Asset bookDepreciationSetting(BookDepreciationSetting bookDepreciationSetting) {
        this.bookDepreciationSetting = bookDepreciationSetting;
        return this;
    }

    @ApiModelProperty(value="")
    public BookDepreciationSetting getBookDepreciationSetting() {
        return this.bookDepreciationSetting;
    }

    public void setBookDepreciationSetting(BookDepreciationSetting bookDepreciationSetting) {
        this.bookDepreciationSetting = bookDepreciationSetting;
    }

    public Asset bookDepreciationDetail(BookDepreciationDetail bookDepreciationDetail) {
        this.bookDepreciationDetail = bookDepreciationDetail;
        return this;
    }

    @ApiModelProperty(value="")
    public BookDepreciationDetail getBookDepreciationDetail() {
        return this.bookDepreciationDetail;
    }

    public void setBookDepreciationDetail(BookDepreciationDetail bookDepreciationDetail) {
        this.bookDepreciationDetail = bookDepreciationDetail;
    }

    public Asset canRollback(Boolean canRollback) {
        this.canRollback = canRollback;
        return this;
    }

    @ApiModelProperty(example="true", value="Boolean to indicate whether depreciation can be rolled back for this asset individually. This is true if it doesn't have 'legacy' journal entries and if there is no lock period that would prevent this asset from rolling back.")
    public Boolean getCanRollback() {
        return this.canRollback;
    }

    public void setCanRollback(Boolean canRollback) {
        this.canRollback = canRollback;
    }

    public Asset accountingBookValue(Double accountingBookValue) {
        this.accountingBookValue = accountingBookValue;
        return this;
    }

    @ApiModelProperty(example="0", value="The accounting value of the asset")
    public Double getAccountingBookValue() {
        return this.accountingBookValue;
    }

    public void setAccountingBookValue(Double accountingBookValue) {
        this.accountingBookValue = accountingBookValue;
    }

    public Asset isDeleteEnabledForDate(Boolean isDeleteEnabledForDate) {
        this.isDeleteEnabledForDate = isDeleteEnabledForDate;
        return this;
    }

    @ApiModelProperty(example="true", value="Boolean to indicate whether delete is enabled")
    public Boolean getIsDeleteEnabledForDate() {
        return this.isDeleteEnabledForDate;
    }

    public void setIsDeleteEnabledForDate(Boolean isDeleteEnabledForDate) {
        this.isDeleteEnabledForDate = isDeleteEnabledForDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Asset asset = (Asset)o;
        return Objects.equals(this.assetId, asset.assetId) && Objects.equals(this.assetName, asset.assetName) && Objects.equals(this.assetTypeId, asset.assetTypeId) && Objects.equals(this.assetNumber, asset.assetNumber) && Objects.equals(this.purchaseDate, asset.purchaseDate) && Objects.equals(this.purchasePrice, asset.purchasePrice) && Objects.equals(this.disposalDate, asset.disposalDate) && Objects.equals(this.disposalPrice, asset.disposalPrice) && Objects.equals((Object)this.assetStatus, (Object)asset.assetStatus) && Objects.equals(this.warrantyExpiryDate, asset.warrantyExpiryDate) && Objects.equals(this.serialNumber, asset.serialNumber) && Objects.equals(this.bookDepreciationSetting, asset.bookDepreciationSetting) && Objects.equals(this.bookDepreciationDetail, asset.bookDepreciationDetail) && Objects.equals(this.canRollback, asset.canRollback) && Objects.equals(this.accountingBookValue, asset.accountingBookValue) && Objects.equals(this.isDeleteEnabledForDate, asset.isDeleteEnabledForDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.assetId, this.assetName, this.assetTypeId, this.assetNumber, this.purchaseDate, this.purchasePrice, this.disposalDate, this.disposalPrice, this.assetStatus, this.warrantyExpiryDate, this.serialNumber, this.bookDepreciationSetting, this.bookDepreciationDetail, this.canRollback, this.accountingBookValue, this.isDeleteEnabledForDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Asset {\n");
        sb.append("    assetId: ").append(this.toIndentedString(this.assetId)).append("\n");
        sb.append("    assetName: ").append(this.toIndentedString(this.assetName)).append("\n");
        sb.append("    assetTypeId: ").append(this.toIndentedString(this.assetTypeId)).append("\n");
        sb.append("    assetNumber: ").append(this.toIndentedString(this.assetNumber)).append("\n");
        sb.append("    purchaseDate: ").append(this.toIndentedString(this.purchaseDate)).append("\n");
        sb.append("    purchasePrice: ").append(this.toIndentedString(this.purchasePrice)).append("\n");
        sb.append("    disposalDate: ").append(this.toIndentedString(this.disposalDate)).append("\n");
        sb.append("    disposalPrice: ").append(this.toIndentedString(this.disposalPrice)).append("\n");
        sb.append("    assetStatus: ").append(this.toIndentedString((Object)this.assetStatus)).append("\n");
        sb.append("    warrantyExpiryDate: ").append(this.toIndentedString(this.warrantyExpiryDate)).append("\n");
        sb.append("    serialNumber: ").append(this.toIndentedString(this.serialNumber)).append("\n");
        sb.append("    bookDepreciationSetting: ").append(this.toIndentedString(this.bookDepreciationSetting)).append("\n");
        sb.append("    bookDepreciationDetail: ").append(this.toIndentedString(this.bookDepreciationDetail)).append("\n");
        sb.append("    canRollback: ").append(this.toIndentedString(this.canRollback)).append("\n");
        sb.append("    accountingBookValue: ").append(this.toIndentedString(this.accountingBookValue)).append("\n");
        sb.append("    isDeleteEnabledForDate: ").append(this.toIndentedString(this.isDeleteEnabledForDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

