/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.assets;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;

public class BookDepreciationSetting {
    StringUtil util = new StringUtil();
    @JsonProperty(value="depreciationMethod")
    private DepreciationMethodEnum depreciationMethod;
    @JsonProperty(value="averagingMethod")
    private AveragingMethodEnum averagingMethod;
    @JsonProperty(value="depreciationRate")
    private Double depreciationRate;
    @JsonProperty(value="effectiveLifeYears")
    private Integer effectiveLifeYears;
    @JsonProperty(value="depreciationCalculationMethod")
    private DepreciationCalculationMethodEnum depreciationCalculationMethod;
    @JsonProperty(value="depreciableObjectId")
    private UUID depreciableObjectId;
    @JsonProperty(value="depreciableObjectType")
    private String depreciableObjectType;
    @JsonProperty(value="bookEffectiveDateOfChangeId")
    private UUID bookEffectiveDateOfChangeId;

    public BookDepreciationSetting depreciationMethod(DepreciationMethodEnum depreciationMethod) {
        this.depreciationMethod = depreciationMethod;
        return this;
    }

    @ApiModelProperty(example="StraightLine", value="The method of depreciation applied to this asset. See Depreciation Methods")
    public DepreciationMethodEnum getDepreciationMethod() {
        return this.depreciationMethod;
    }

    public void setDepreciationMethod(DepreciationMethodEnum depreciationMethod) {
        this.depreciationMethod = depreciationMethod;
    }

    public BookDepreciationSetting averagingMethod(AveragingMethodEnum averagingMethod) {
        this.averagingMethod = averagingMethod;
        return this;
    }

    @ApiModelProperty(example="ActualDays", value="The method of averaging applied to this asset. See Averaging Methods")
    public AveragingMethodEnum getAveragingMethod() {
        return this.averagingMethod;
    }

    public void setAveragingMethod(AveragingMethodEnum averagingMethod) {
        this.averagingMethod = averagingMethod;
    }

    public BookDepreciationSetting depreciationRate(Double depreciationRate) {
        this.depreciationRate = depreciationRate;
        return this;
    }

    @ApiModelProperty(example="0.05", value="The rate of depreciation (e.g. 0.05)")
    public Double getDepreciationRate() {
        return this.depreciationRate;
    }

    public void setDepreciationRate(Double depreciationRate) {
        this.depreciationRate = depreciationRate;
    }

    public BookDepreciationSetting effectiveLifeYears(Integer effectiveLifeYears) {
        this.effectiveLifeYears = effectiveLifeYears;
        return this;
    }

    @ApiModelProperty(example="5", value="Effective life of the asset in years (e.g. 5)")
    public Integer getEffectiveLifeYears() {
        return this.effectiveLifeYears;
    }

    public void setEffectiveLifeYears(Integer effectiveLifeYears) {
        this.effectiveLifeYears = effectiveLifeYears;
    }

    public BookDepreciationSetting depreciationCalculationMethod(DepreciationCalculationMethodEnum depreciationCalculationMethod) {
        this.depreciationCalculationMethod = depreciationCalculationMethod;
        return this;
    }

    @ApiModelProperty(example="None", value="See Depreciation Calculation Methods")
    public DepreciationCalculationMethodEnum getDepreciationCalculationMethod() {
        return this.depreciationCalculationMethod;
    }

    public void setDepreciationCalculationMethod(DepreciationCalculationMethodEnum depreciationCalculationMethod) {
        this.depreciationCalculationMethod = depreciationCalculationMethod;
    }

    public BookDepreciationSetting depreciableObjectId(UUID depreciableObjectId) {
        this.depreciableObjectId = depreciableObjectId;
        return this;
    }

    @ApiModelProperty(example="68f17094-af97-4f1b-b36b-013b45b6ad3c", value="Unique Xero identifier for the depreciable object")
    public UUID getDepreciableObjectId() {
        return this.depreciableObjectId;
    }

    public void setDepreciableObjectId(UUID depreciableObjectId) {
        this.depreciableObjectId = depreciableObjectId;
    }

    public BookDepreciationSetting depreciableObjectType(String depreciableObjectType) {
        this.depreciableObjectType = depreciableObjectType;
        return this;
    }

    @ApiModelProperty(example="Asset", value="The type of asset object")
    public String getDepreciableObjectType() {
        return this.depreciableObjectType;
    }

    public void setDepreciableObjectType(String depreciableObjectType) {
        this.depreciableObjectType = depreciableObjectType;
    }

    public BookDepreciationSetting bookEffectiveDateOfChangeId(UUID bookEffectiveDateOfChangeId) {
        this.bookEffectiveDateOfChangeId = bookEffectiveDateOfChangeId;
        return this;
    }

    @ApiModelProperty(example="68f17094-af97-4f1b-b36b-013b45b6ad3c", value="Unique Xero identifier for the effective date change")
    public UUID getBookEffectiveDateOfChangeId() {
        return this.bookEffectiveDateOfChangeId;
    }

    public void setBookEffectiveDateOfChangeId(UUID bookEffectiveDateOfChangeId) {
        this.bookEffectiveDateOfChangeId = bookEffectiveDateOfChangeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BookDepreciationSetting bookDepreciationSetting = (BookDepreciationSetting)o;
        return Objects.equals((Object)this.depreciationMethod, (Object)bookDepreciationSetting.depreciationMethod) && Objects.equals((Object)this.averagingMethod, (Object)bookDepreciationSetting.averagingMethod) && Objects.equals(this.depreciationRate, bookDepreciationSetting.depreciationRate) && Objects.equals(this.effectiveLifeYears, bookDepreciationSetting.effectiveLifeYears) && Objects.equals((Object)this.depreciationCalculationMethod, (Object)bookDepreciationSetting.depreciationCalculationMethod) && Objects.equals(this.depreciableObjectId, bookDepreciationSetting.depreciableObjectId) && Objects.equals(this.depreciableObjectType, bookDepreciationSetting.depreciableObjectType) && Objects.equals(this.bookEffectiveDateOfChangeId, bookDepreciationSetting.bookEffectiveDateOfChangeId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.depreciationMethod, this.averagingMethod, this.depreciationRate, this.effectiveLifeYears, this.depreciationCalculationMethod, this.depreciableObjectId, this.depreciableObjectType, this.bookEffectiveDateOfChangeId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BookDepreciationSetting {\n");
        sb.append("    depreciationMethod: ").append(this.toIndentedString((Object)this.depreciationMethod)).append("\n");
        sb.append("    averagingMethod: ").append(this.toIndentedString((Object)this.averagingMethod)).append("\n");
        sb.append("    depreciationRate: ").append(this.toIndentedString(this.depreciationRate)).append("\n");
        sb.append("    effectiveLifeYears: ").append(this.toIndentedString(this.effectiveLifeYears)).append("\n");
        sb.append("    depreciationCalculationMethod: ").append(this.toIndentedString((Object)this.depreciationCalculationMethod)).append("\n");
        sb.append("    depreciableObjectId: ").append(this.toIndentedString(this.depreciableObjectId)).append("\n");
        sb.append("    depreciableObjectType: ").append(this.toIndentedString(this.depreciableObjectType)).append("\n");
        sb.append("    bookEffectiveDateOfChangeId: ").append(this.toIndentedString(this.bookEffectiveDateOfChangeId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum DepreciationMethodEnum {
        NODEPRECIATION("NoDepreciation"),
        STRAIGHTLINE("StraightLine"),
        DIMINISHINGVALUE100("DiminishingValue100"),
        DIMINISHINGVALUE150("DiminishingValue150"),
        DIMINISHINGVALUE200("DiminishingValue200"),
        FULLDEPRECIATION("FullDepreciation");

        private String value;

        private DepreciationMethodEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DepreciationMethodEnum fromValue(String value) {
            for (DepreciationMethodEnum b : DepreciationMethodEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum AveragingMethodEnum {
        FULLMONTH("FullMonth"),
        ACTUALDAYS("ActualDays");

        private String value;

        private AveragingMethodEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AveragingMethodEnum fromValue(String value) {
            for (AveragingMethodEnum b : AveragingMethodEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum DepreciationCalculationMethodEnum {
        RATE("Rate"),
        LIFE("Life"),
        NONE("None");

        private String value;

        private DepreciationCalculationMethodEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DepreciationCalculationMethodEnum fromValue(String value) {
            for (DepreciationCalculationMethodEnum b : DepreciationCalculationMethodEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

