/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.bankfeeds;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import com.xero.models.bankfeeds.CountryCode;
import com.xero.models.bankfeeds.CurrencyCode;
import com.xero.models.bankfeeds.Error;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;

public class FeedConnection {
    StringUtil util = new StringUtil();
    @JsonProperty(value="id")
    private UUID id;
    @JsonProperty(value="accountToken")
    private String accountToken;
    @JsonProperty(value="accountNumber")
    private String accountNumber;
    @JsonProperty(value="accountName")
    private String accountName;
    @JsonProperty(value="accountId")
    private UUID accountId;
    @JsonProperty(value="accountType")
    private AccountTypeEnum accountType;
    @JsonProperty(value="currency")
    private CurrencyCode currency;
    @JsonProperty(value="country")
    private CountryCode country;
    @JsonProperty(value="status")
    private StatusEnum status;
    @JsonProperty(value="error")
    private Error error;

    public FeedConnection id(UUID id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="00d3cf8d-95dc-4466-8dc0-47e6d1197e28", value="GUID used to identify the Account.")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public FeedConnection accountToken(String accountToken) {
        this.accountToken = accountToken;
        return this;
    }

    @ApiModelProperty(example="10000123", value="This account identifier is generated by the financial institute (FI). This must be unique for your financial institute.")
    public String getAccountToken() {
        return this.accountToken;
    }

    public void setAccountToken(String accountToken) {
        this.accountToken = accountToken;
    }

    public FeedConnection accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @ApiModelProperty(example="3809087654321500", value="String(40) when AccountType is BANK String(4) when AccountType is CREDITCARD The Account Number is used to match the feed to a Xero Bank Account. The API will create a new Xero Bank Account if a match to an existing Xero Bank Account is not found. Only the last 4 digits must be supplied for Credit Card numbers. Must be included if AccountId is not specified.")
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public FeedConnection accountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    @ApiModelProperty(example="Joe's Savings Account", value="The Account Name will be used for the creation of a new Xero Bank Account if a matching Xero Bank Account is not found.")
    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public FeedConnection accountId(UUID accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(example="079a88ea-276d-41fb-a1f1-366ef3e22921", value="Xero identifier for a bank account in Xero. Must be included if AccountNumber is not specified.")
    public UUID getAccountId() {
        return this.accountId;
    }

    public void setAccountId(UUID accountId) {
        this.accountId = accountId;
    }

    public FeedConnection accountType(AccountTypeEnum accountType) {
        this.accountType = accountType;
        return this;
    }

    @ApiModelProperty(example="BANK", value="High level bank account type - BANK CREDITCARD BANK encompasses all bank account types other than credit cards.")
    public AccountTypeEnum getAccountType() {
        return this.accountType;
    }

    public void setAccountType(AccountTypeEnum accountType) {
        this.accountType = accountType;
    }

    public FeedConnection currency(CurrencyCode currency) {
        this.currency = currency;
        return this;
    }

    @ApiModelProperty(value="")
    public CurrencyCode getCurrency() {
        return this.currency;
    }

    public void setCurrency(CurrencyCode currency) {
        this.currency = currency;
    }

    public FeedConnection country(CountryCode country) {
        this.country = country;
        return this;
    }

    @ApiModelProperty(value="")
    public CountryCode getCountry() {
        return this.country;
    }

    public void setCountry(CountryCode country) {
        this.country = country;
    }

    public FeedConnection status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="REJECTED", value="the current status of the feed connection")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public FeedConnection error(Error error) {
        this.error = error;
        return this;
    }

    @ApiModelProperty(value="")
    public Error getError() {
        return this.error;
    }

    public void setError(Error error) {
        this.error = error;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeedConnection feedConnection = (FeedConnection)o;
        return Objects.equals(this.id, feedConnection.id) && Objects.equals(this.accountToken, feedConnection.accountToken) && Objects.equals(this.accountNumber, feedConnection.accountNumber) && Objects.equals(this.accountName, feedConnection.accountName) && Objects.equals(this.accountId, feedConnection.accountId) && Objects.equals((Object)this.accountType, (Object)feedConnection.accountType) && Objects.equals((Object)this.currency, (Object)feedConnection.currency) && Objects.equals((Object)this.country, (Object)feedConnection.country) && Objects.equals((Object)this.status, (Object)feedConnection.status) && Objects.equals(this.error, feedConnection.error);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.accountToken, this.accountNumber, this.accountName, this.accountId, this.accountType, this.currency, this.country, this.status, this.error});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FeedConnection {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    accountToken: ").append(this.toIndentedString(this.accountToken)).append("\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    accountName: ").append(this.toIndentedString(this.accountName)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    accountType: ").append(this.toIndentedString((Object)this.accountType)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString((Object)this.currency)).append("\n");
        sb.append("    country: ").append(this.toIndentedString((Object)this.country)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AccountTypeEnum {
        BANK("BANK"),
        CREDITCARD("CREDITCARD");

        private String value;

        private AccountTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AccountTypeEnum fromValue(String value) {
            for (AccountTypeEnum b : AccountTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum StatusEnum {
        PENDING("PENDING"),
        REJECTED("REJECTED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

