/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.bankfeeds;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import com.xero.models.bankfeeds.EndBalance;
import com.xero.models.bankfeeds.Error;
import com.xero.models.bankfeeds.StartBalance;
import com.xero.models.bankfeeds.StatementLine;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.LocalDate;

public class Statement {
    StringUtil util = new StringUtil();
    @JsonProperty(value="id")
    private UUID id;
    @JsonProperty(value="feedConnectionId")
    private UUID feedConnectionId;
    @JsonProperty(value="status")
    private StatusEnum status;
    @JsonProperty(value="startDate")
    private LocalDate startDate;
    @JsonProperty(value="endDate")
    private LocalDate endDate;
    @JsonProperty(value="startBalance")
    private StartBalance startBalance;
    @JsonProperty(value="endBalance")
    private EndBalance endBalance;
    @JsonProperty(value="statementLines")
    private List<StatementLine> statementLines = new ArrayList<StatementLine>();
    @JsonProperty(value="errors")
    private List<Error> errors = new ArrayList<Error>();
    @JsonProperty(value="statementLineCount")
    private Integer statementLineCount;

    public Statement id(UUID id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="ba4f3127-5e46-427d-80ea-dea2fcd26afe", value="GUID used to identify the Statement.")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public Statement feedConnectionId(UUID feedConnectionId) {
        this.feedConnectionId = feedConnectionId;
        return this;
    }

    @ApiModelProperty(example="87cb0dc8-fa32-409c-b622-19f8de8dcc83", value="The Xero generated feed connection Id that identifies the Xero Bank Account Container into which the statement should be delivered. This is obtained by calling GET FeedConnections.")
    public UUID getFeedConnectionId() {
        return this.feedConnectionId;
    }

    public void setFeedConnectionId(UUID feedConnectionId) {
        this.feedConnectionId = feedConnectionId;
    }

    public Statement status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="PENDING", value="Current status of statements")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Statement startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(example="Fri Jul 27 00:00:00 UTC 2018", value="Opening balance date (can be no older than one year from the current date) ISO-8601 YYYY-MM-DD")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public Statement endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @ApiModelProperty(example="Fri Jul 27 00:00:00 UTC 2018", value="Closing balance date ISO-8601 YYYY-MM-DD")
    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public Statement startBalance(StartBalance startBalance) {
        this.startBalance = startBalance;
        return this;
    }

    @ApiModelProperty(value="")
    public StartBalance getStartBalance() {
        return this.startBalance;
    }

    public void setStartBalance(StartBalance startBalance) {
        this.startBalance = startBalance;
    }

    public Statement endBalance(EndBalance endBalance) {
        this.endBalance = endBalance;
        return this;
    }

    @ApiModelProperty(value="")
    public EndBalance getEndBalance() {
        return this.endBalance;
    }

    public void setEndBalance(EndBalance endBalance) {
        this.endBalance = endBalance;
    }

    public Statement statementLines(List<StatementLine> statementLines) {
        this.statementLines = statementLines;
        return this;
    }

    public Statement addStatementLinesItem(StatementLine statementLinesItem) {
        if (this.statementLines == null) {
            this.statementLines = new ArrayList<StatementLine>();
        }
        this.statementLines.add(statementLinesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<StatementLine> getStatementLines() {
        return this.statementLines;
    }

    public void setStatementLines(List<StatementLine> statementLines) {
        this.statementLines = statementLines;
    }

    public Statement errors(List<Error> errors) {
        this.errors = errors;
        return this;
    }

    public Statement addErrorsItem(Error errorsItem) {
        if (this.errors == null) {
            this.errors = new ArrayList<Error>();
        }
        this.errors.add(errorsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<Error> getErrors() {
        return this.errors;
    }

    public void setErrors(List<Error> errors) {
        this.errors = errors;
    }

    public Statement statementLineCount(Integer statementLineCount) {
        this.statementLineCount = statementLineCount;
        return this;
    }

    @ApiModelProperty(example="1", value="")
    public Integer getStatementLineCount() {
        return this.statementLineCount;
    }

    public void setStatementLineCount(Integer statementLineCount) {
        this.statementLineCount = statementLineCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Statement statement = (Statement)o;
        return Objects.equals(this.id, statement.id) && Objects.equals(this.feedConnectionId, statement.feedConnectionId) && Objects.equals((Object)this.status, (Object)statement.status) && Objects.equals(this.startDate, statement.startDate) && Objects.equals(this.endDate, statement.endDate) && Objects.equals(this.startBalance, statement.startBalance) && Objects.equals(this.endBalance, statement.endBalance) && Objects.equals(this.statementLines, statement.statementLines) && Objects.equals(this.errors, statement.errors) && Objects.equals(this.statementLineCount, statement.statementLineCount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.feedConnectionId, this.status, this.startDate, this.endDate, this.startBalance, this.endBalance, this.statementLines, this.errors, this.statementLineCount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Statement {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    feedConnectionId: ").append(this.toIndentedString(this.feedConnectionId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    startBalance: ").append(this.toIndentedString(this.startBalance)).append("\n");
        sb.append("    endBalance: ").append(this.toIndentedString(this.endBalance)).append("\n");
        sb.append("    statementLines: ").append(this.toIndentedString(this.statementLines)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("    statementLineCount: ").append(this.toIndentedString(this.statementLineCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        PENDING("PENDING"),
        REJECTED("REJECTED"),
        DELIVERED("DELIVERED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

