/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.file;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import com.xero.models.file.ObjectGroup;
import com.xero.models.file.ObjectType;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;

public class Association {
    StringUtil util = new StringUtil();
    @JsonProperty(value="SendWithObject")
    private Boolean sendWithObject;
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="Size")
    private Integer size;
    @JsonProperty(value="FileId")
    private UUID fileId;
    @JsonProperty(value="ObjectId")
    private UUID objectId;
    @JsonProperty(value="ObjectGroup")
    private ObjectGroup objectGroup;
    @JsonProperty(value="ObjectType")
    private ObjectType objectType;

    public Association sendWithObject(Boolean sendWithObject) {
        this.sendWithObject = sendWithObject;
        return this;
    }

    @ApiModelProperty(example="true", value="Boolean flag to determines whether the file is sent with the document it is attached to on client facing communications. Note- The SendWithObject element is only returned when using /Associations/{ObjectId} endpoint.")
    public Boolean getSendWithObject() {
        return this.sendWithObject;
    }

    public void setSendWithObject(Boolean sendWithObject) {
        this.sendWithObject = sendWithObject;
    }

    public Association name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="Test.pdf", value="The name of the associated file. Note- The Name element is only returned when using /Associations/{ObjectId} endpoint.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Association size(Integer size) {
        this.size = size;
        return this;
    }

    @ApiModelProperty(example="12357", value="The size of the associated file in bytes. Note- The Size element is only returned when using /Associations/{ObjectId} endpoint.")
    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public Association fileId(UUID fileId) {
        this.fileId = fileId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the file")
    public UUID getFileId() {
        return this.fileId;
    }

    public void setFileId(UUID fileId) {
        this.fileId = fileId;
    }

    public Association objectId(UUID objectId) {
        this.objectId = objectId;
        return this;
    }

    @ApiModelProperty(value="The identifier of the object that the file is being associated with (e.g. InvoiceID, BankTransactionID, ContactID)")
    public UUID getObjectId() {
        return this.objectId;
    }

    public void setObjectId(UUID objectId) {
        this.objectId = objectId;
    }

    public Association objectGroup(ObjectGroup objectGroup) {
        this.objectGroup = objectGroup;
        return this;
    }

    @ApiModelProperty(value="")
    public ObjectGroup getObjectGroup() {
        return this.objectGroup;
    }

    public void setObjectGroup(ObjectGroup objectGroup) {
        this.objectGroup = objectGroup;
    }

    public Association objectType(ObjectType objectType) {
        this.objectType = objectType;
        return this;
    }

    @ApiModelProperty(value="")
    public ObjectType getObjectType() {
        return this.objectType;
    }

    public void setObjectType(ObjectType objectType) {
        this.objectType = objectType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Association association = (Association)o;
        return Objects.equals(this.sendWithObject, association.sendWithObject) && Objects.equals(this.name, association.name) && Objects.equals(this.size, association.size) && Objects.equals(this.fileId, association.fileId) && Objects.equals(this.objectId, association.objectId) && Objects.equals((Object)this.objectGroup, (Object)association.objectGroup) && Objects.equals((Object)this.objectType, (Object)association.objectType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sendWithObject, this.name, this.size, this.fileId, this.objectId, this.objectGroup, this.objectType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Association {\n");
        sb.append("    sendWithObject: ").append(this.toIndentedString(this.sendWithObject)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    fileId: ").append(this.toIndentedString(this.fileId)).append("\n");
        sb.append("    objectId: ").append(this.toIndentedString(this.objectId)).append("\n");
        sb.append("    objectGroup: ").append(this.toIndentedString((Object)this.objectGroup)).append("\n");
        sb.append("    objectType: ").append(this.toIndentedString((Object)this.objectType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

