/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.file;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import com.xero.models.file.User;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;

public class FileObject {
    StringUtil util = new StringUtil();
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="MimeType")
    private String mimeType;
    @JsonProperty(value="Size")
    private Integer size;
    @JsonProperty(value="CreatedDateUtc")
    private String createdDateUtc;
    @JsonProperty(value="UpdatedDateUtc")
    private String updatedDateUtc;
    @JsonProperty(value="User")
    private User user;
    @JsonProperty(value="Id")
    private UUID id;
    @JsonProperty(value="FolderId")
    private UUID folderId;

    public FileObject name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="File2.jpg", value="File Name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FileObject mimeType(String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    @ApiModelProperty(example="image/jpeg", value="MimeType of the file (image/png, image/jpeg, application/pdf, etc..)")
    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public FileObject size(Integer size) {
        this.size = size;
        return this;
    }

    @ApiModelProperty(example="3615", value="Numeric value in bytes")
    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public FileObject createdDateUtc(String createdDateUtc) {
        this.createdDateUtc = createdDateUtc;
        return this;
    }

    @ApiModelProperty(example="2020-12-03T19:04:58.6970000", value="Created date in UTC")
    public String getCreatedDateUtc() {
        return this.createdDateUtc;
    }

    public void setCreatedDateUtc(String createdDateUtc) {
        this.createdDateUtc = createdDateUtc;
    }

    public FileObject updatedDateUtc(String updatedDateUtc) {
        this.updatedDateUtc = updatedDateUtc;
        return this;
    }

    @ApiModelProperty(example="2020-12-03T19:04:58.6970000", value="Updated date in UTC")
    public String getUpdatedDateUtc() {
        return this.updatedDateUtc;
    }

    public void setUpdatedDateUtc(String updatedDateUtc) {
        this.updatedDateUtc = updatedDateUtc;
    }

    public FileObject user(User user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(value="")
    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public FileObject id(UUID id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="d290f1ee-6c54-4b01-90e6-d701748f0851", value="File object's UUID")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public FileObject folderId(UUID folderId) {
        this.folderId = folderId;
        return this;
    }

    @ApiModelProperty(example="0f8ccf21-7267-4268-9167-a1e2c40c84c8", value="Folder relation object's UUID")
    public UUID getFolderId() {
        return this.folderId;
    }

    public void setFolderId(UUID folderId) {
        this.folderId = folderId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileObject fileObject = (FileObject)o;
        return Objects.equals(this.name, fileObject.name) && Objects.equals(this.mimeType, fileObject.mimeType) && Objects.equals(this.size, fileObject.size) && Objects.equals(this.createdDateUtc, fileObject.createdDateUtc) && Objects.equals(this.updatedDateUtc, fileObject.updatedDateUtc) && Objects.equals(this.user, fileObject.user) && Objects.equals(this.id, fileObject.id) && Objects.equals(this.folderId, fileObject.folderId);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.mimeType, this.size, this.createdDateUtc, this.updatedDateUtc, this.user, this.id, this.folderId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FileObject {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    mimeType: ").append(this.toIndentedString(this.mimeType)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    createdDateUtc: ").append(this.toIndentedString(this.createdDateUtc)).append("\n");
        sb.append("    updatedDateUtc: ").append(this.toIndentedString(this.updatedDateUtc)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    folderId: ").append(this.toIndentedString(this.folderId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

