/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.finance;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import com.xero.models.finance.StatementResponse;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class BankStatementAccountingResponse {
    StringUtil util = new StringUtil();
    @JsonProperty(value="bankAccountId")
    private UUID bankAccountId;
    @JsonProperty(value="bankAccountName")
    private String bankAccountName;
    @JsonProperty(value="bankAccountCurrencyCode")
    private String bankAccountCurrencyCode;
    @JsonProperty(value="statements")
    private List<StatementResponse> statements = new ArrayList<StatementResponse>();

    public BankStatementAccountingResponse bankAccountId(UUID bankAccountId) {
        this.bankAccountId = bankAccountId;
        return this;
    }

    @ApiModelProperty(value="Xero Identifier of bank account")
    public UUID getBankAccountId() {
        return this.bankAccountId;
    }

    public void setBankAccountId(UUID bankAccountId) {
        this.bankAccountId = bankAccountId;
    }

    public BankStatementAccountingResponse bankAccountName(String bankAccountName) {
        this.bankAccountName = bankAccountName;
        return this;
    }

    @ApiModelProperty(value="Name of bank account")
    public String getBankAccountName() {
        return this.bankAccountName;
    }

    public void setBankAccountName(String bankAccountName) {
        this.bankAccountName = bankAccountName;
    }

    public BankStatementAccountingResponse bankAccountCurrencyCode(String bankAccountCurrencyCode) {
        this.bankAccountCurrencyCode = bankAccountCurrencyCode;
        return this;
    }

    @ApiModelProperty(value="Currency code of the bank account")
    public String getBankAccountCurrencyCode() {
        return this.bankAccountCurrencyCode;
    }

    public void setBankAccountCurrencyCode(String bankAccountCurrencyCode) {
        this.bankAccountCurrencyCode = bankAccountCurrencyCode;
    }

    public BankStatementAccountingResponse statements(List<StatementResponse> statements) {
        this.statements = statements;
        return this;
    }

    public BankStatementAccountingResponse addStatementsItem(StatementResponse statementsItem) {
        if (this.statements == null) {
            this.statements = new ArrayList<StatementResponse>();
        }
        this.statements.add(statementsItem);
        return this;
    }

    @ApiModelProperty(value="List of bank statements and linked accounting data for the requested period")
    public List<StatementResponse> getStatements() {
        return this.statements;
    }

    public void setStatements(List<StatementResponse> statements) {
        this.statements = statements;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankStatementAccountingResponse bankStatementAccountingResponse = (BankStatementAccountingResponse)o;
        return Objects.equals(this.bankAccountId, bankStatementAccountingResponse.bankAccountId) && Objects.equals(this.bankAccountName, bankStatementAccountingResponse.bankAccountName) && Objects.equals(this.bankAccountCurrencyCode, bankStatementAccountingResponse.bankAccountCurrencyCode) && Objects.equals(this.statements, bankStatementAccountingResponse.statements);
    }

    public int hashCode() {
        return Objects.hash(this.bankAccountId, this.bankAccountName, this.bankAccountCurrencyCode, this.statements);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BankStatementAccountingResponse {\n");
        sb.append("    bankAccountId: ").append(this.toIndentedString(this.bankAccountId)).append("\n");
        sb.append("    bankAccountName: ").append(this.toIndentedString(this.bankAccountName)).append("\n");
        sb.append("    bankAccountCurrencyCode: ").append(this.toIndentedString(this.bankAccountCurrencyCode)).append("\n");
        sb.append("    statements: ").append(this.toIndentedString(this.statements)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

