/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.finance;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import com.xero.models.finance.ContactTotalDetail;
import com.xero.models.finance.ContactTotalOther;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class ContactDetail {
    StringUtil util = new StringUtil();
    @JsonProperty(value="contactId")
    private UUID contactId;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="total")
    private Double total;
    @JsonProperty(value="totalDetail")
    private ContactTotalDetail totalDetail;
    @JsonProperty(value="totalOther")
    private ContactTotalOther totalOther;
    @JsonProperty(value="accountCodes")
    private List<String> accountCodes = new ArrayList<String>();

    public ContactDetail contactId(UUID contactId) {
        this.contactId = contactId;
        return this;
    }

    @ApiModelProperty(value="ID of the contact associated with the transactions.    Transactions with no contact will be grouped under the special ID: 86793108-198C-46D8-90A3-43C1D12686CE.    Transactions that are receive or spend bank transfers will be grouped under the special ID: 207322B3-6A58-4BE7-80F1-430123914AD6")
    public UUID getContactId() {
        return this.contactId;
    }

    public void setContactId(UUID contactId) {
        this.contactId = contactId;
    }

    public ContactDetail name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Name of the contact associated with the transactions.    If no contact is associated with the transactions this will appear as \u201cNone Provided\u201d,    For receive or spend bank transfer transactions, this will appear as \u201cBank Transfer\u201d.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ContactDetail total(Double total) {
        this.total = total;
        return this;
    }

    @ApiModelProperty(value="Total value for the contact")
    public Double getTotal() {
        return this.total;
    }

    public void setTotal(Double total) {
        this.total = total;
    }

    public ContactDetail totalDetail(ContactTotalDetail totalDetail) {
        this.totalDetail = totalDetail;
        return this;
    }

    @ApiModelProperty(value="")
    public ContactTotalDetail getTotalDetail() {
        return this.totalDetail;
    }

    public void setTotalDetail(ContactTotalDetail totalDetail) {
        this.totalDetail = totalDetail;
    }

    public ContactDetail totalOther(ContactTotalOther totalOther) {
        this.totalOther = totalOther;
        return this;
    }

    @ApiModelProperty(value="")
    public ContactTotalOther getTotalOther() {
        return this.totalOther;
    }

    public void setTotalOther(ContactTotalOther totalOther) {
        this.totalOther = totalOther;
    }

    public ContactDetail accountCodes(List<String> accountCodes) {
        this.accountCodes = accountCodes;
        return this;
    }

    public ContactDetail addAccountCodesItem(String accountCodesItem) {
        if (this.accountCodes == null) {
            this.accountCodes = new ArrayList<String>();
        }
        this.accountCodes.add(accountCodesItem);
        return this;
    }

    @ApiModelProperty(value="A list of account codes involved in transactions.")
    public List<String> getAccountCodes() {
        return this.accountCodes;
    }

    public void setAccountCodes(List<String> accountCodes) {
        this.accountCodes = accountCodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContactDetail contactDetail = (ContactDetail)o;
        return Objects.equals(this.contactId, contactDetail.contactId) && Objects.equals(this.name, contactDetail.name) && Objects.equals(this.total, contactDetail.total) && Objects.equals(this.totalDetail, contactDetail.totalDetail) && Objects.equals(this.totalOther, contactDetail.totalOther) && Objects.equals(this.accountCodes, contactDetail.accountCodes);
    }

    public int hashCode() {
        return Objects.hash(this.contactId, this.name, this.total, this.totalDetail, this.totalOther, this.accountCodes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContactDetail {\n");
        sb.append("    contactId: ").append(this.toIndentedString(this.contactId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("    totalDetail: ").append(this.toIndentedString(this.totalDetail)).append("\n");
        sb.append("    totalOther: ").append(this.toIndentedString(this.totalOther)).append("\n");
        sb.append("    accountCodes: ").append(this.toIndentedString(this.accountCodes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

