/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.finance;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import com.xero.models.finance.PnlAccount;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class PnlAccountType {
    StringUtil util = new StringUtil();
    @JsonProperty(value="total")
    private Double total;
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="accounts")
    private List<PnlAccount> accounts = new ArrayList<PnlAccount>();

    public PnlAccountType total(Double total) {
        this.total = total;
        return this;
    }

    @ApiModelProperty(value="Total movement on this account type")
    public Double getTotal() {
        return this.total;
    }

    public void setTotal(Double total) {
        this.total = total;
    }

    public PnlAccountType title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(value="Name of this account type, it will be either Trading Income or Other Income for Revenue section / Direct Cost or Operating Expenses for Expense section")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public PnlAccountType accounts(List<PnlAccount> accounts) {
        this.accounts = accounts;
        return this;
    }

    public PnlAccountType addAccountsItem(PnlAccount accountsItem) {
        if (this.accounts == null) {
            this.accounts = new ArrayList<PnlAccount>();
        }
        this.accounts.add(accountsItem);
        return this;
    }

    @ApiModelProperty(value="A list of the movement on each account detail during the query period. Refer to the account detail element below")
    public List<PnlAccount> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(List<PnlAccount> accounts) {
        this.accounts = accounts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PnlAccountType pnlAccountType = (PnlAccountType)o;
        return Objects.equals(this.total, pnlAccountType.total) && Objects.equals(this.title, pnlAccountType.title) && Objects.equals(this.accounts, pnlAccountType.accounts);
    }

    public int hashCode() {
        return Objects.hash(this.total, this.title, this.accounts);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PnlAccountType {\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    accounts: ").append(this.toIndentedString(this.accounts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

