/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.finance;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import com.xero.models.finance.StatementLineResponse;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

public class StatementResponse {
    StringUtil util = new StringUtil();
    @JsonProperty(value="statementId")
    private UUID statementId;
    @JsonProperty(value="startDate")
    private LocalDate startDate;
    @JsonProperty(value="endDate")
    private LocalDate endDate;
    @JsonProperty(value="importedDateTimeUtc")
    private OffsetDateTime importedDateTimeUtc;
    @JsonProperty(value="importSource")
    private String importSource;
    @JsonProperty(value="startBalance")
    private Double startBalance;
    @JsonProperty(value="endBalance")
    private Double endBalance;
    @JsonProperty(value="indicativeStartBalance")
    private Double indicativeStartBalance;
    @JsonProperty(value="indicativeEndBalance")
    private Double indicativeEndBalance;
    @JsonProperty(value="statementLines")
    private List<StatementLineResponse> statementLines = new ArrayList<StatementLineResponse>();

    public StatementResponse statementId(UUID statementId) {
        this.statementId = statementId;
        return this;
    }

    @ApiModelProperty(value="Xero Identifier of statement")
    public UUID getStatementId() {
        return this.statementId;
    }

    public void setStatementId(UUID statementId) {
        this.statementId = statementId;
    }

    public StatementResponse startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(value="Start date of statement")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public StatementResponse endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @ApiModelProperty(value="End date of statement")
    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public StatementResponse importedDateTimeUtc(OffsetDateTime importedDateTimeUtc) {
        this.importedDateTimeUtc = importedDateTimeUtc;
        return this;
    }

    @ApiModelProperty(value="Utc date time of when the statement was imported in Xero")
    public OffsetDateTime getImportedDateTimeUtc() {
        return this.importedDateTimeUtc;
    }

    public void setImportedDateTimeUtc(OffsetDateTime importedDateTimeUtc) {
        this.importedDateTimeUtc = importedDateTimeUtc;
    }

    public StatementResponse importSource(String importSource) {
        this.importSource = importSource;
        return this;
    }

    @ApiModelProperty(value="Identifies where the statement data in Xero was sourced, 1) direct bank feed, automatically loaded from the bank (eg STMTIMPORTSRC/CBAFEED); 2) indirect bank feed, automatically loaded from a 3rd party provider (eg STMTIMPORTSRC/YODLEE); 3) manually uploaded bank feed (eg STMTIMPORTSRC/CSV) or 4) manually entered statement data (STMTIMPORTSRC/MANUAL).")
    public String getImportSource() {
        return this.importSource;
    }

    public void setImportSource(String importSource) {
        this.importSource = importSource;
    }

    public StatementResponse startBalance(Double startBalance) {
        this.startBalance = startBalance;
        return this;
    }

    @ApiModelProperty(value="Opening balance sourced from imported bank statements (if supplied). Note, for manually uploaded statements, this balance is also manual and usually not supplied. Where not supplied, the value will be 0.")
    public Double getStartBalance() {
        return this.startBalance;
    }

    public void setStartBalance(Double startBalance) {
        this.startBalance = startBalance;
    }

    public StatementResponse endBalance(Double endBalance) {
        this.endBalance = endBalance;
        return this;
    }

    @ApiModelProperty(value="Closing balance sourced from imported bank statements (if supplied). Note, for manually uploaded statements, this balance is also manual and usually not supplied. Where not supplied, the value will be 0.")
    public Double getEndBalance() {
        return this.endBalance;
    }

    public void setEndBalance(Double endBalance) {
        this.endBalance = endBalance;
    }

    public StatementResponse indicativeStartBalance(Double indicativeStartBalance) {
        this.indicativeStartBalance = indicativeStartBalance;
        return this;
    }

    @ApiModelProperty(value="Opening statement balance calculated in Xero (= bank account conversion balance plus sum of imported bank statement lines). Note: If indicative statement balance doesn't match imported statement balance for the same date, either the conversion (opening at inception) balance in Xero is wrong or there's an error in the bank statement lines in Xero. Ref: https://central.xero.com/s/article/Compare-the-statement-balance-in-Xero-to-your-actual-bank-balance?userregion=true ")
    public Double getIndicativeStartBalance() {
        return this.indicativeStartBalance;
    }

    public void setIndicativeStartBalance(Double indicativeStartBalance) {
        this.indicativeStartBalance = indicativeStartBalance;
    }

    public StatementResponse indicativeEndBalance(Double indicativeEndBalance) {
        this.indicativeEndBalance = indicativeEndBalance;
        return this;
    }

    @ApiModelProperty(value="Closing statement balance calculated in Xero (= bank account conversion balance plus sum of imported bank statement lines). Note: If indicative statement balance doesn't match imported statement balance for the same date, either the conversion (opening at inception) balance in Xero is wrong or there's an error in the bank statement lines in Xero. Ref: https://central.xero.com/s/article/Compare-the-statement-balance-in-Xero-to-your-actual-bank-balance?userregion=true  ")
    public Double getIndicativeEndBalance() {
        return this.indicativeEndBalance;
    }

    public void setIndicativeEndBalance(Double indicativeEndBalance) {
        this.indicativeEndBalance = indicativeEndBalance;
    }

    public StatementResponse statementLines(List<StatementLineResponse> statementLines) {
        this.statementLines = statementLines;
        return this;
    }

    public StatementResponse addStatementLinesItem(StatementLineResponse statementLinesItem) {
        if (this.statementLines == null) {
            this.statementLines = new ArrayList<StatementLineResponse>();
        }
        this.statementLines.add(statementLinesItem);
        return this;
    }

    @ApiModelProperty(value="List of statement lines")
    public List<StatementLineResponse> getStatementLines() {
        return this.statementLines;
    }

    public void setStatementLines(List<StatementLineResponse> statementLines) {
        this.statementLines = statementLines;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatementResponse statementResponse = (StatementResponse)o;
        return Objects.equals(this.statementId, statementResponse.statementId) && Objects.equals(this.startDate, statementResponse.startDate) && Objects.equals(this.endDate, statementResponse.endDate) && Objects.equals(this.importedDateTimeUtc, statementResponse.importedDateTimeUtc) && Objects.equals(this.importSource, statementResponse.importSource) && Objects.equals(this.startBalance, statementResponse.startBalance) && Objects.equals(this.endBalance, statementResponse.endBalance) && Objects.equals(this.indicativeStartBalance, statementResponse.indicativeStartBalance) && Objects.equals(this.indicativeEndBalance, statementResponse.indicativeEndBalance) && Objects.equals(this.statementLines, statementResponse.statementLines);
    }

    public int hashCode() {
        return Objects.hash(this.statementId, this.startDate, this.endDate, this.importedDateTimeUtc, this.importSource, this.startBalance, this.endBalance, this.indicativeStartBalance, this.indicativeEndBalance, this.statementLines);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StatementResponse {\n");
        sb.append("    statementId: ").append(this.toIndentedString(this.statementId)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    importedDateTimeUtc: ").append(this.toIndentedString(this.importedDateTimeUtc)).append("\n");
        sb.append("    importSource: ").append(this.toIndentedString(this.importSource)).append("\n");
        sb.append("    startBalance: ").append(this.toIndentedString(this.startBalance)).append("\n");
        sb.append("    endBalance: ").append(this.toIndentedString(this.endBalance)).append("\n");
        sb.append("    indicativeStartBalance: ").append(this.toIndentedString(this.indicativeStartBalance)).append("\n");
        sb.append("    indicativeEndBalance: ").append(this.toIndentedString(this.indicativeEndBalance)).append("\n");
        sb.append("    statementLines: ").append(this.toIndentedString(this.statementLines)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

