/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.finance;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import com.xero.models.finance.HistoryRecordResponse;
import com.xero.models.finance.PracticeResponse;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.OffsetDateTime;

public class UserResponse {
    StringUtil util = new StringUtil();
    @JsonProperty(value="userId")
    private UUID userId;
    @JsonProperty(value="userCreatedDateUtc")
    private OffsetDateTime userCreatedDateUtc;
    @JsonProperty(value="lastLoginDateUtc")
    private OffsetDateTime lastLoginDateUtc;
    @JsonProperty(value="isExternalPartner")
    private Boolean isExternalPartner;
    @JsonProperty(value="hasAccountantRole")
    private Boolean hasAccountantRole;
    @JsonProperty(value="monthPeriod")
    private String monthPeriod;
    @JsonProperty(value="numberOfLogins")
    private Integer numberOfLogins;
    @JsonProperty(value="numberOfDocumentsCreated")
    private Integer numberOfDocumentsCreated;
    @JsonProperty(value="netValueDocumentsCreated")
    private Double netValueDocumentsCreated;
    @JsonProperty(value="absoluteValueDocumentsCreated")
    private Double absoluteValueDocumentsCreated;
    @JsonProperty(value="attachedPractices")
    private List<PracticeResponse> attachedPractices = new ArrayList<PracticeResponse>();
    @JsonProperty(value="historyRecords")
    private List<HistoryRecordResponse> historyRecords = new ArrayList<HistoryRecordResponse>();

    public UserResponse userId(UUID userId) {
        this.userId = userId;
        return this;
    }

    @ApiModelProperty(value="The Xero identifier for the user")
    public UUID getUserId() {
        return this.userId;
    }

    public void setUserId(UUID userId) {
        this.userId = userId;
    }

    public UserResponse userCreatedDateUtc(OffsetDateTime userCreatedDateUtc) {
        this.userCreatedDateUtc = userCreatedDateUtc;
        return this;
    }

    @ApiModelProperty(value="Timestamp of user creation.")
    public OffsetDateTime getUserCreatedDateUtc() {
        return this.userCreatedDateUtc;
    }

    public void setUserCreatedDateUtc(OffsetDateTime userCreatedDateUtc) {
        this.userCreatedDateUtc = userCreatedDateUtc;
    }

    public UserResponse lastLoginDateUtc(OffsetDateTime lastLoginDateUtc) {
        this.lastLoginDateUtc = lastLoginDateUtc;
        return this;
    }

    @ApiModelProperty(value="Timestamp of user last login")
    public OffsetDateTime getLastLoginDateUtc() {
        return this.lastLoginDateUtc;
    }

    public void setLastLoginDateUtc(OffsetDateTime lastLoginDateUtc) {
        this.lastLoginDateUtc = lastLoginDateUtc;
    }

    public UserResponse isExternalPartner(Boolean isExternalPartner) {
        this.isExternalPartner = isExternalPartner;
        return this;
    }

    @ApiModelProperty(value="User is external partner.")
    public Boolean getIsExternalPartner() {
        return this.isExternalPartner;
    }

    public void setIsExternalPartner(Boolean isExternalPartner) {
        this.isExternalPartner = isExternalPartner;
    }

    public UserResponse hasAccountantRole(Boolean hasAccountantRole) {
        this.hasAccountantRole = hasAccountantRole;
        return this;
    }

    @ApiModelProperty(value="User has Accountant role.")
    public Boolean getHasAccountantRole() {
        return this.hasAccountantRole;
    }

    public void setHasAccountantRole(Boolean hasAccountantRole) {
        this.hasAccountantRole = hasAccountantRole;
    }

    public UserResponse monthPeriod(String monthPeriod) {
        this.monthPeriod = monthPeriod;
        return this;
    }

    @ApiModelProperty(value="Month period in format  yyyy-MM.")
    public String getMonthPeriod() {
        return this.monthPeriod;
    }

    public void setMonthPeriod(String monthPeriod) {
        this.monthPeriod = monthPeriod;
    }

    public UserResponse numberOfLogins(Integer numberOfLogins) {
        this.numberOfLogins = numberOfLogins;
        return this;
    }

    @ApiModelProperty(value="Number of times the user has logged in.")
    public Integer getNumberOfLogins() {
        return this.numberOfLogins;
    }

    public void setNumberOfLogins(Integer numberOfLogins) {
        this.numberOfLogins = numberOfLogins;
    }

    public UserResponse numberOfDocumentsCreated(Integer numberOfDocumentsCreated) {
        this.numberOfDocumentsCreated = numberOfDocumentsCreated;
        return this;
    }

    @ApiModelProperty(value="Number of documents created.")
    public Integer getNumberOfDocumentsCreated() {
        return this.numberOfDocumentsCreated;
    }

    public void setNumberOfDocumentsCreated(Integer numberOfDocumentsCreated) {
        this.numberOfDocumentsCreated = numberOfDocumentsCreated;
    }

    public UserResponse netValueDocumentsCreated(Double netValueDocumentsCreated) {
        this.netValueDocumentsCreated = netValueDocumentsCreated;
        return this;
    }

    @ApiModelProperty(value="Net value of documents created.")
    public Double getNetValueDocumentsCreated() {
        return this.netValueDocumentsCreated;
    }

    public void setNetValueDocumentsCreated(Double netValueDocumentsCreated) {
        this.netValueDocumentsCreated = netValueDocumentsCreated;
    }

    public UserResponse absoluteValueDocumentsCreated(Double absoluteValueDocumentsCreated) {
        this.absoluteValueDocumentsCreated = absoluteValueDocumentsCreated;
        return this;
    }

    @ApiModelProperty(value="Absolute value of documents created.")
    public Double getAbsoluteValueDocumentsCreated() {
        return this.absoluteValueDocumentsCreated;
    }

    public void setAbsoluteValueDocumentsCreated(Double absoluteValueDocumentsCreated) {
        this.absoluteValueDocumentsCreated = absoluteValueDocumentsCreated;
    }

    public UserResponse attachedPractices(List<PracticeResponse> attachedPractices) {
        this.attachedPractices = attachedPractices;
        return this;
    }

    public UserResponse addAttachedPracticesItem(PracticeResponse attachedPracticesItem) {
        if (this.attachedPractices == null) {
            this.attachedPractices = new ArrayList<PracticeResponse>();
        }
        this.attachedPractices.add(attachedPracticesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<PracticeResponse> getAttachedPractices() {
        return this.attachedPractices;
    }

    public void setAttachedPractices(List<PracticeResponse> attachedPractices) {
        this.attachedPractices = attachedPractices;
    }

    public UserResponse historyRecords(List<HistoryRecordResponse> historyRecords) {
        this.historyRecords = historyRecords;
        return this;
    }

    public UserResponse addHistoryRecordsItem(HistoryRecordResponse historyRecordsItem) {
        if (this.historyRecords == null) {
            this.historyRecords = new ArrayList<HistoryRecordResponse>();
        }
        this.historyRecords.add(historyRecordsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<HistoryRecordResponse> getHistoryRecords() {
        return this.historyRecords;
    }

    public void setHistoryRecords(List<HistoryRecordResponse> historyRecords) {
        this.historyRecords = historyRecords;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserResponse userResponse = (UserResponse)o;
        return Objects.equals(this.userId, userResponse.userId) && Objects.equals(this.userCreatedDateUtc, userResponse.userCreatedDateUtc) && Objects.equals(this.lastLoginDateUtc, userResponse.lastLoginDateUtc) && Objects.equals(this.isExternalPartner, userResponse.isExternalPartner) && Objects.equals(this.hasAccountantRole, userResponse.hasAccountantRole) && Objects.equals(this.monthPeriod, userResponse.monthPeriod) && Objects.equals(this.numberOfLogins, userResponse.numberOfLogins) && Objects.equals(this.numberOfDocumentsCreated, userResponse.numberOfDocumentsCreated) && Objects.equals(this.netValueDocumentsCreated, userResponse.netValueDocumentsCreated) && Objects.equals(this.absoluteValueDocumentsCreated, userResponse.absoluteValueDocumentsCreated) && Objects.equals(this.attachedPractices, userResponse.attachedPractices) && Objects.equals(this.historyRecords, userResponse.historyRecords);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.userCreatedDateUtc, this.lastLoginDateUtc, this.isExternalPartner, this.hasAccountantRole, this.monthPeriod, this.numberOfLogins, this.numberOfDocumentsCreated, this.netValueDocumentsCreated, this.absoluteValueDocumentsCreated, this.attachedPractices, this.historyRecords);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserResponse {\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    userCreatedDateUtc: ").append(this.toIndentedString(this.userCreatedDateUtc)).append("\n");
        sb.append("    lastLoginDateUtc: ").append(this.toIndentedString(this.lastLoginDateUtc)).append("\n");
        sb.append("    isExternalPartner: ").append(this.toIndentedString(this.isExternalPartner)).append("\n");
        sb.append("    hasAccountantRole: ").append(this.toIndentedString(this.hasAccountantRole)).append("\n");
        sb.append("    monthPeriod: ").append(this.toIndentedString(this.monthPeriod)).append("\n");
        sb.append("    numberOfLogins: ").append(this.toIndentedString(this.numberOfLogins)).append("\n");
        sb.append("    numberOfDocumentsCreated: ").append(this.toIndentedString(this.numberOfDocumentsCreated)).append("\n");
        sb.append("    netValueDocumentsCreated: ").append(this.toIndentedString(this.netValueDocumentsCreated)).append("\n");
        sb.append("    absoluteValueDocumentsCreated: ").append(this.toIndentedString(this.absoluteValueDocumentsCreated)).append("\n");
        sb.append("    attachedPractices: ").append(this.toIndentedString(this.attachedPractices)).append("\n");
        sb.append("    historyRecords: ").append(this.toIndentedString(this.historyRecords)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

