/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrollau;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.OffsetDateTime;

public class DeductionType {
    StringUtil util = new StringUtil();
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="AccountCode")
    private String accountCode;
    @JsonProperty(value="ReducesTax")
    private Boolean reducesTax;
    @JsonProperty(value="ReducesSuper")
    private Boolean reducesSuper;
    @JsonProperty(value="IsExemptFromW1")
    private Boolean isExemptFromW1;
    @JsonProperty(value="DeductionTypeID")
    private UUID deductionTypeID;
    @JsonProperty(value="UpdatedDateUTC")
    private String updatedDateUTC;
    @JsonProperty(value="DeductionCategory")
    private DeductionCategoryEnum deductionCategory;
    @JsonProperty(value="CurrentRecord")
    private Boolean currentRecord;

    public DeductionType name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="PTO", value="Name of the earnings rate (max length = 100)")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DeductionType accountCode(String accountCode) {
        this.accountCode = accountCode;
        return this;
    }

    @ApiModelProperty(example="720", value="See Accounts")
    public String getAccountCode() {
        return this.accountCode;
    }

    public void setAccountCode(String accountCode) {
        this.accountCode = accountCode;
    }

    public DeductionType reducesTax(Boolean reducesTax) {
        this.reducesTax = reducesTax;
        return this;
    }

    @ApiModelProperty(example="false", value="Indicates that this is a pre-tax deduction that will reduce the amount of tax you withhold from an employee.")
    public Boolean getReducesTax() {
        return this.reducesTax;
    }

    public void setReducesTax(Boolean reducesTax) {
        this.reducesTax = reducesTax;
    }

    public DeductionType reducesSuper(Boolean reducesSuper) {
        this.reducesSuper = reducesSuper;
        return this;
    }

    @ApiModelProperty(example="false", value="Most deductions don\u2019t reduce your superannuation guarantee contribution liability, so typically you will not set any value for this.")
    public Boolean getReducesSuper() {
        return this.reducesSuper;
    }

    public void setReducesSuper(Boolean reducesSuper) {
        this.reducesSuper = reducesSuper;
    }

    public DeductionType isExemptFromW1(Boolean isExemptFromW1) {
        this.isExemptFromW1 = isExemptFromW1;
        return this;
    }

    @ApiModelProperty(example="false", value="Boolean to determine if the deduction type is reportable or exempt from W1")
    public Boolean getIsExemptFromW1() {
        return this.isExemptFromW1;
    }

    public void setIsExemptFromW1(Boolean isExemptFromW1) {
        this.isExemptFromW1 = isExemptFromW1;
    }

    public DeductionType deductionTypeID(UUID deductionTypeID) {
        this.deductionTypeID = deductionTypeID;
        return this;
    }

    @ApiModelProperty(example="e0eb6747-7c17-4075-b804-989f8d4e5d39", value="Xero identifier")
    public UUID getDeductionTypeID() {
        return this.deductionTypeID;
    }

    public void setDeductionTypeID(UUID deductionTypeID) {
        this.deductionTypeID = deductionTypeID;
    }

    @ApiModelProperty(example="/Date(1583967733054+0000)/", value="Last modified timestamp")
    public String getUpdatedDateUTC() {
        return this.updatedDateUTC;
    }

    public OffsetDateTime getUpdatedDateUTCAsDate() {
        if (this.updatedDateUTC != null) {
            try {
                return this.util.convertStringToOffsetDateTime(this.updatedDateUTC);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public DeductionType deductionCategory(DeductionCategoryEnum deductionCategory) {
        this.deductionCategory = deductionCategory;
        return this;
    }

    @ApiModelProperty(value="")
    public DeductionCategoryEnum getDeductionCategory() {
        return this.deductionCategory;
    }

    public void setDeductionCategory(DeductionCategoryEnum deductionCategory) {
        this.deductionCategory = deductionCategory;
    }

    public DeductionType currentRecord(Boolean currentRecord) {
        this.currentRecord = currentRecord;
        return this;
    }

    @ApiModelProperty(example="true", value="Is the current record")
    public Boolean getCurrentRecord() {
        return this.currentRecord;
    }

    public void setCurrentRecord(Boolean currentRecord) {
        this.currentRecord = currentRecord;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeductionType deductionType = (DeductionType)o;
        return Objects.equals(this.name, deductionType.name) && Objects.equals(this.accountCode, deductionType.accountCode) && Objects.equals(this.reducesTax, deductionType.reducesTax) && Objects.equals(this.reducesSuper, deductionType.reducesSuper) && Objects.equals(this.isExemptFromW1, deductionType.isExemptFromW1) && Objects.equals(this.deductionTypeID, deductionType.deductionTypeID) && Objects.equals(this.updatedDateUTC, deductionType.updatedDateUTC) && Objects.equals((Object)this.deductionCategory, (Object)deductionType.deductionCategory) && Objects.equals(this.currentRecord, deductionType.currentRecord);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.accountCode, this.reducesTax, this.reducesSuper, this.isExemptFromW1, this.deductionTypeID, this.updatedDateUTC, this.deductionCategory, this.currentRecord});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeductionType {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    accountCode: ").append(this.toIndentedString(this.accountCode)).append("\n");
        sb.append("    reducesTax: ").append(this.toIndentedString(this.reducesTax)).append("\n");
        sb.append("    reducesSuper: ").append(this.toIndentedString(this.reducesSuper)).append("\n");
        sb.append("    isExemptFromW1: ").append(this.toIndentedString(this.isExemptFromW1)).append("\n");
        sb.append("    deductionTypeID: ").append(this.toIndentedString(this.deductionTypeID)).append("\n");
        sb.append("    updatedDateUTC: ").append(this.toIndentedString(this.updatedDateUTC)).append("\n");
        sb.append("    deductionCategory: ").append(this.toIndentedString((Object)this.deductionCategory)).append("\n");
        sb.append("    currentRecord: ").append(this.toIndentedString(this.currentRecord)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum DeductionCategoryEnum {
        NONE("NONE"),
        UNIONFEES("UNIONFEES"),
        WORKPLACEGIVING("WORKPLACEGIVING");

        private String value;

        private DeductionCategoryEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DeductionCategoryEnum fromValue(String value) {
            for (DeductionCategoryEnum b : DeductionCategoryEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

